/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.Zero2EmptyStrCellDisplayParser;
import com.kingdee.eas.fm.nt.NTReportRcvResultInfo;
import com.kingdee.eas.fm.nt.NTRptRcvBillFilterParam;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class NTRptRcvHandler {
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.nt.NTRptResource";
    public static final String Company = "Company";
    public static final String Term = "Term";
    private static final String NTType = "NTType";
    private static final String TermStart_Book = "TermStart_Book";
    private static final String TermStart_Trustee = "TermStart_Trustee";
    private static final String TermStart_Pledge = "TermStart_Pledge";
    private static final String TermStart_Total = "TermStart_Total";
    private static final String Balance_Papers = "balancepapers";
    private static final String CAnalyse_Total = "canalyseTotal";
    private static final String CAnalyse_EndorseAmt = "canalyseEndorseAmt";
    private static final String CAnalyse_DiscountAmt = "canalyseDiscountAmt";
    private static final String CAnalyse_GatherAmt = "canalyseGatherAmt";
    private static final String CAnalyse_DiscountInterest = "canalyseDiscountInterest";
    private static final String CAnalyse_ReturnAmt = "canalyseReturnAmt";
    private static final String TermEnd_Book = "TermEnd_Book";
    private static final String TermEnd_Trustee = "TermEnd_Trustee";
    private static final String TermEnd_Pledge = "TermEnd_Pledge";
    private static final String TermEnd_Total = "TermEnd_Total";
    private static final String Debit_Amount = "debitamount";
    private static final String Debit_Papers = "debitpapers";
    private static final String Credit_Amount = "creditamount";
    private static final String Credit_Papers = "creditpapers";
    private static final String Direct = "direct";
    public static final String resCompany = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"company");
    public static final String resTerm = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"term");
    public static final String resNTType = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"nttype");
    public static final String resTo = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"to");
    public static final String resYear = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"year");
    public static final String resMonth = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"month");
    public static final String resSubtotal4Company = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"subtotal_company");
    public static final String resSubtotal4Stock = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"subtotal_company");
    public static final String resTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"total");
    private static final String resYearbalance = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"yearbalance");
    public static final String resTermbalance = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"termbalance");
    private static final String resTermamount = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"termamount");
    private static final String resYearamount = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"yearamount");
    private static final String resTermendbalance = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"termendbalance");
    private static final String resDebit = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"debit");
    private static final String resCredit = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"credit");
    private static final String resAmount = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"amount");
    private static final String resPapers = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"papernumber");
    private static final String resDirect = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"direct");
    private static final String resBalance = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"balance");
    private static final String resCreditAnalyse = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"creditanalyse");
    public static final String resSubTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"subtotal");
    private static final String resEndorseAmt = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"endorseamt");
    private static final String resDiscountAmt = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"discountamt");
    private static final String resGatherAmt = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"gatheramt");
    private static final String resDiscountInterest = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"DiscountInterest");
    private static final String resReturnAmt = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"ReturnAmount");
    public static final String resBook = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"book");
    public static final String resTrustee = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"trustee");
    public static final String resPledge = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"pledge");
    public static final String resTermin = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"termin");
    public static final String resTermout = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"termout");
    private static NTRptRcvHandler instance;

    public static NTRptRcvHandler getInstatnce() throws Exception {
        if (instance == null) {
            instance = new NTRptRcvHandler();
        }
        return instance;
    }

    public static void initRecMainTable(KDTable table, FilterParam param) throws Exception {
        FMClientHelper.clearTable((KDTable)table);
        table.checkParsed(true);
        table.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        table.getScriptManager().setDiv0DefaultValue("");
        IRow header0 = table.getHeadRow(0);
        IRow header1 = table.getHeadRow(1);
        table.addColumn().setKey(Term);
        header0.getCell(Term).setValue((Object)resTerm);
        header1.getCell(Term).setValue((Object)resTerm);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(Term).getColumnIndex(), 1, header0.getCell(Term).getColumnIndex());
        NTRptRcvBillFilterParam para = (NTRptRcvBillFilterParam)param;
        if (!para.isIs4Term()) {
            table.getColumn(Term).getStyleAttributes().setHided(true);
        }
        table.addColumn().setKey(NTType);
        header0.getCell(NTType).setValue((Object)resNTType);
        header1.getCell(NTType).setValue((Object)resNTType);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(NTType).getColumnIndex(), 1, header0.getCell(NTType).getColumnIndex());
        table.addColumn().setKey(Company);
        table.getColumn(Company).setWidth(180);
        header0.getCell(Company).setValue((Object)resCompany);
        header1.getCell(Company).setValue((Object)resCompany);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(Company).getColumnIndex(), 1, header0.getCell(Company).getColumnIndex());
        table.addColumn().setKey(TermStart_Book);
        header0.getCell(TermStart_Book).setValue((Object)resTermbalance);
        header1.getCell(TermStart_Book).setValue((Object)resBook);
        table.addColumn().setKey(TermStart_Trustee);
        header0.getCell(TermStart_Trustee).setValue((Object)resTermbalance);
        header1.getCell(TermStart_Trustee).setValue((Object)resTrustee);
        table.addColumn().setKey(TermStart_Pledge);
        header0.getCell(TermStart_Pledge).setValue((Object)resTermbalance);
        header1.getCell(TermStart_Pledge).setValue((Object)resPledge);
        table.addColumn().setKey(TermStart_Total);
        header0.getCell(TermStart_Total).setValue((Object)resTermbalance);
        header1.getCell(TermStart_Total).setValue((Object)resSubTotal);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(TermStart_Book).getColumnIndex(), 0, header0.getCell(TermStart_Total).getColumnIndex());
        table.addColumn().setKey(Debit_Amount);
        header0.getCell(Debit_Amount).setValue((Object)resTermin);
        header1.getCell(Debit_Amount).setValue((Object)resDebit);
        table.addColumn().setKey(CAnalyse_EndorseAmt);
        header0.getCell(CAnalyse_EndorseAmt).setValue((Object)resTermout);
        header1.getCell(CAnalyse_EndorseAmt).setValue((Object)resEndorseAmt);
        table.addColumn().setKey(CAnalyse_DiscountAmt);
        header0.getCell(CAnalyse_DiscountAmt).setValue((Object)resTermout);
        header1.getCell(CAnalyse_DiscountAmt).setValue((Object)resDiscountAmt);
        table.addColumn().setKey(CAnalyse_DiscountInterest);
        header0.getCell(CAnalyse_DiscountInterest).setValue((Object)resTermout);
        header1.getCell(CAnalyse_DiscountInterest).setValue((Object)resDiscountInterest);
        table.addColumn().setKey(CAnalyse_GatherAmt);
        header0.getCell(CAnalyse_GatherAmt).setValue((Object)resTermout);
        header1.getCell(CAnalyse_GatherAmt).setValue((Object)resGatherAmt);
        table.addColumn().setKey(CAnalyse_ReturnAmt);
        header0.getCell(CAnalyse_ReturnAmt).setValue((Object)resTermout);
        header1.getCell(CAnalyse_ReturnAmt).setValue((Object)resReturnAmt);
        table.addColumn().setKey(Credit_Amount);
        header0.getCell(Credit_Amount).setValue((Object)resTermamount);
        header1.getCell(Credit_Amount).setValue((Object)resSubTotal);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(CAnalyse_EndorseAmt).getColumnIndex(), 0, header0.getCell(Credit_Amount).getColumnIndex());
        table.addColumn().setKey(TermEnd_Book);
        header0.getCell(TermEnd_Book).setValue((Object)resTermendbalance);
        header1.getCell(TermEnd_Book).setValue((Object)resBook);
        table.addColumn().setKey(TermEnd_Trustee);
        header0.getCell(TermEnd_Trustee).setValue((Object)resTermendbalance);
        header1.getCell(TermEnd_Trustee).setValue((Object)resTrustee);
        table.addColumn().setKey(TermEnd_Pledge);
        header0.getCell(TermEnd_Pledge).setValue((Object)resTermendbalance);
        header1.getCell(TermEnd_Pledge).setValue((Object)resPledge);
        table.addColumn().setKey(TermEnd_Total);
        header0.getCell(TermEnd_Total).setValue((Object)resTermendbalance);
        header1.getCell(TermEnd_Total).setValue((Object)resSubTotal);
        table.getHeadMergeManager().mergeBlock(0, header0.getCell(TermEnd_Book).getColumnIndex(), 0, header0.getCell(TermEnd_Total).getColumnIndex());
        table.setUserCellDisplayParser((IUserCellDisplayParser)new Zero2EmptyStrCellDisplayParser());
        table.getSelectManager().setSelectMode(2);
        table.setEditable(false);
    }

    public static void fillRecMainData(KDTable table, FilterParam param) throws Exception {
        NTRptRcvBillFilterParam para = (NTRptRcvBillFilterParam)param;
        String[] companyIds = para.getCompanyIds();
        if (companyIds == null) {
            return;
        }
        List lstSection = NTRptRcvHandler.getTermSection(param);
        int termRowIndex = 0;
        List lstReport = ReceivableBillFactory.getRemoteInstance().getReceivableBillMain(param, lstSection);
        BOSUuid currencyUuid = BOSUuid.read((String)((NTRptRcvBillFilterParam)param).getCurrencyId());
        for (int i = 0; i < lstSection.size(); ++i) {
            NTRptRcvBillFilterParam termSection = (NTRptRcvBillFilterParam)lstSection.get(i);
            para.setBeginDate(termSection.getBeginDate());
            para.setEndDate(termSection.getEndDate());
            String termname = "";
            termname = !para.isIs4Term() ? new java.sql.Date(termSection.getBeginDate().getTime()) + resTo + new java.sql.Date(termSection.getEndDate().getTime()) : termSection.getBeginDate().getYear() + 1900 + resYear + (termSection.getBeginDate().getMonth() + 1) + resMonth;
            NTRptRcvHandler.fillOneTermData(table, para, termname, termRowIndex, termSection.getBeginDate(), lstReport, currencyUuid);
            termRowIndex = table.getRowCount() - 1;
        }
        table.setUserCellDisplayParser((IUserCellDisplayParser)new Zero2EmptyStrCellDisplayParser());
    }

    private static List getTermSection(FilterParam param) {
        NTRptRcvBillFilterParam para = (NTRptRcvBillFilterParam)param;
        ArrayList<NTRptRcvBillFilterParam> result = new ArrayList<NTRptRcvBillFilterParam>();
        if (!para.isIs4Term()) {
            NTRptRcvBillFilterParam termSection = new NTRptRcvBillFilterParam();
            termSection.setBeginDate(para.getBeginDate());
            termSection.setEndDate(para.getEndDate());
            result.add(termSection);
        } else {
            Date beginDate = NTRptRcvHandler.getFirstDateOfMonth(para.getBeginYear(), para.getBeginMonth() - 1);
            Date endDate = NTRptRcvHandler.getLastDateOfMonth(para.getBeginYear(), para.getBeginMonth() - 1);
            Date nextBeginDate = NTRptRcvHandler.getNextMonthBeginDate(beginDate);
            Date nextEndDate = NTRptRcvHandler.getNextMonthLastDate(endDate);
            while (NTRptRcvHandler.beforeEndDate(para, nextBeginDate)) {
                NTRptRcvBillFilterParam termSection = new NTRptRcvBillFilterParam();
                termSection.setBeginDate(nextBeginDate);
                termSection.setEndDate(nextEndDate);
                result.add(termSection);
                nextBeginDate = NTRptRcvHandler.getNextMonthBeginDate(nextBeginDate);
                nextEndDate = NTRptRcvHandler.getNextMonthLastDate(nextEndDate);
            }
        }
        return result;
    }

    private static boolean beforeEndDate(NTRptRcvBillFilterParam param, Date currentDate) {
        Date endDate = NTRptRcvHandler.getFirstDateOfMonth(param.getEndYear(), param.getEndMonth());
        return !currentDate.after(endDate);
    }

    private static Date getNextMonthBeginDate(Date currentDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(currentDate);
        c.add(2, 1);
        c.set(5, 1);
        return c.getTime();
    }

    private static Date getNextMonthLastDate(Date currentDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(currentDate);
        c.add(2, 2);
        c.set(5, 1);
        c.add(5, -1);
        return c.getTime();
    }

    private static Date getFirstDateOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, 1);
        return c.getTime();
    }

    private static Date getLastDateOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, 1);
        c.add(5, -1);
        return c.getTime();
    }

    private static void fillOneTermData(KDTable table, FilterParam param, String termname, int rowIndex, Date begainDate, List LstReport, BOSUuid currencyUuid) throws Exception {
        IRow row;
        if (LstReport.size() == 0) {
            return;
        }
        int ibank = 0;
        int iComm = 0;
        int iTermIndex = 0;
        for (NTReportRcvResultInfo reportInfo : LstReport) {
            if (!reportInfo.getTermname().equals(termname)) continue;
            row = table.addRow();
            row.getCell(Company).setValue((Object)reportInfo.getCompanyname());
            row.getCell(Company).setUserObject((Object)reportInfo.getCompanyid());
            row.getCell(Term).setValue((Object)termname);
            row.getCell(Term).setUserObject((Object)begainDate);
            row.getCell(NTType).setValue((Object)reportInfo.getNttypename());
            row.getCell(TermStart_Total).setValue((Object)reportInfo.getStartTermBalance());
            row.getCell(TermStart_Trustee).setValue((Object)reportInfo.getTermStartTrustee());
            row.getCell(TermStart_Pledge).setValue((Object)reportInfo.getTermStartPledge());
            row.getCell(Debit_Amount).setValue((Object)reportInfo.getTermDebitAmt());
            row.getCell(Credit_Amount).setValue((Object)reportInfo.getTermCreditAmt());
            row.getCell(CAnalyse_EndorseAmt).setValue((Object)reportInfo.getTermEndorseAmt());
            row.getCell(CAnalyse_DiscountAmt).setValue((Object)reportInfo.getTermDiscountAmt());
            row.getCell(CAnalyse_GatherAmt).setValue((Object)reportInfo.getTermGatherAmt());
            row.getCell(CAnalyse_DiscountInterest).setValue((Object)reportInfo.getTermDiscountInt());
            row.getCell(CAnalyse_ReturnAmt).setValue((Object)reportInfo.getTermReturnAmt());
            String exp = TableToolkit.xy2range((int)table.getColumnIndex(TermStart_Total), (int)row.getRowIndex()) + "+" + TableToolkit.xy2range((int)table.getColumnIndex(Debit_Amount), (int)row.getRowIndex()) + "-" + TableToolkit.xy2range((int)table.getColumnIndex(Credit_Amount), (int)row.getRowIndex());
            table.getCell(row.getRowIndex(), table.getColumnIndex(TermEnd_Total)).setExpressions("=" + exp);
            row.getCell(TermEnd_Trustee).setValue((Object)reportInfo.getTermEndTrustee());
            row.getCell(TermEnd_Pledge).setValue((Object)reportInfo.getTermEndPledge());
            exp = TableToolkit.xy2range((int)table.getColumnIndex(TermStart_Total), (int)row.getRowIndex()) + "-" + TableToolkit.xy2range((int)table.getColumnIndex(TermStart_Trustee), (int)row.getRowIndex()) + "-" + TableToolkit.xy2range((int)table.getColumnIndex(TermStart_Pledge), (int)row.getRowIndex());
            table.getCell(row.getRowIndex(), table.getColumnIndex(TermStart_Book)).setExpressions("=" + exp);
            exp = TableToolkit.xy2range((int)table.getColumnIndex(TermEnd_Total), (int)row.getRowIndex()) + "-" + TableToolkit.xy2range((int)table.getColumnIndex(TermEnd_Trustee), (int)row.getRowIndex()) + "-" + TableToolkit.xy2range((int)table.getColumnIndex(TermEnd_Pledge), (int)row.getRowIndex());
            table.getCell(row.getRowIndex(), table.getColumnIndex(TermEnd_Book)).setExpressions("=" + exp);
            if (reportInfo.getNttypeid().toString().equals("33333333-3333-3333-3333-3333333333331C9A9013")) {
                ++ibank;
                continue;
            }
            ++iComm;
        }
        iTermIndex = rowIndex == 0 ? rowIndex : rowIndex + 1;
        IRow rowSub = table.addRow(iTermIndex + ibank);
        rowSub.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        rowSub.getCell(Company).setValue((Object)resSubTotal);
        NTRptRcvHandler.setTotalRow(table, rowSub, iTermIndex, iTermIndex + ibank - 1);
        NTRptRcvBillFilterParam para = (NTRptRcvBillFilterParam)param;
        if (para.isShowCom()) {
            rowSub = table.addRow(iTermIndex + ibank + iComm + 1);
            rowSub.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            rowSub.getCell(Company).setValue((Object)resSubTotal);
            NTRptRcvHandler.setTotalRow(table, rowSub, iTermIndex + ibank + 1, iTermIndex + ibank + iComm);
        }
        table.getMergeManager().mergeBlock(iTermIndex, table.getColumnIndex(Term), table.getRowCount() - 1, table.getColumnIndex(Term));
        table.getMergeManager().mergeBlock(iTermIndex, table.getColumnIndex(NTType), iTermIndex + ibank - 1, table.getColumnIndex(NTType));
        table.getMergeManager().mergeBlock(iTermIndex + ibank + 1, table.getColumnIndex(NTType), iTermIndex + ibank + iComm, table.getColumnIndex(NTType));
        row = table.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell(Company).setValue((Object)resTotal);
        NTRptRcvHandler.setAddRow(table, row, iTermIndex + ibank, table.getRowCount() - 2);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermStart_Book);
        NTRptRcvHandler.formatAmt(table, currencyUuid, Debit_Amount);
        NTRptRcvHandler.formatAmt(table, currencyUuid, Credit_Amount);
        NTRptRcvHandler.formatAmt(table, currencyUuid, CAnalyse_EndorseAmt);
        NTRptRcvHandler.formatAmt(table, currencyUuid, CAnalyse_DiscountAmt);
        NTRptRcvHandler.formatAmt(table, currencyUuid, CAnalyse_GatherAmt);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermEnd_Book);
        NTRptRcvHandler.formatAmt(table, currencyUuid, CAnalyse_DiscountInterest);
        NTRptRcvHandler.formatAmt(table, currencyUuid, CAnalyse_ReturnAmt);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermStart_Trustee);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermStart_Pledge);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermStart_Total);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermEnd_Trustee);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermEnd_Pledge);
        NTRptRcvHandler.formatAmt(table, currencyUuid, TermEnd_Total);
    }

    private static void setTotalRow(KDTable table, IRow row, int iStart, int iEnd) {
        NTRptRcvHandler.setSumExpressions(table, row, TermStart_Book, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, Debit_Amount, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, Credit_Amount, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, CAnalyse_EndorseAmt, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, CAnalyse_DiscountAmt, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, CAnalyse_GatherAmt, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermEnd_Book, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, CAnalyse_DiscountInterest, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, CAnalyse_ReturnAmt, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermStart_Trustee, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermStart_Pledge, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermStart_Total, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermEnd_Trustee, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermEnd_Pledge, iStart, iEnd);
        NTRptRcvHandler.setSumExpressions(table, row, TermEnd_Total, iStart, iEnd);
    }

    private static void setAddRow(KDTable table, IRow row, int iStart, int iEnd) {
        NTRptRcvHandler.setAddExpressions(table, row, TermStart_Book, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, Debit_Amount, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, Credit_Amount, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, CAnalyse_EndorseAmt, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, CAnalyse_DiscountAmt, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, CAnalyse_GatherAmt, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermEnd_Book, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, CAnalyse_DiscountInterest, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, CAnalyse_ReturnAmt, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermStart_Trustee, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermStart_Pledge, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermStart_Total, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermEnd_Trustee, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermEnd_Pledge, iStart, iEnd);
        NTRptRcvHandler.setAddExpressions(table, row, TermEnd_Total, iStart, iEnd);
    }

    private static void formatAmt(KDTable table, BOSUuid currencyUuid, String colName) {
        IColumn col = table.getColumn(table.getColumnIndex(colName));
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (IColumn)col);
    }

    private static void setSumExpressions(KDTable table, IRow row, String colName, int startRows, int endRows) {
        row.getCell(colName).setExpressions("=sum(" + TableToolkit.xy2range((int)table.getColumnIndex(colName), (int)startRows) + ":" + TableToolkit.xy2range((int)table.getColumnIndex(colName), (int)endRows) + ")");
    }

    private static void setAddExpressions(KDTable table, IRow row, String colName, int startRows, int endRows) {
        if (startRows != endRows) {
            row.getCell(colName).setExpressions("=sum(" + TableToolkit.xy2range((int)table.getColumnIndex(colName), (int)startRows) + "," + TableToolkit.xy2range((int)table.getColumnIndex(colName), (int)endRows) + ")");
        } else {
            row.getCell(colName).setExpressions("=sum(" + TableToolkit.xy2range((int)table.getColumnIndex(colName), (int)startRows) + ")");
        }
    }
}

