/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.EndorseStateEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractOutEndorsementBillEditUI;
import com.kingdee.eas.fm.nt.client.CSF7Selector;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class OutEndorsementBillEditUI
extends AbstractOutEndorsementBillEditUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAttachment.setVisible(false);
        CurrencyInfo currency = (CurrencyInfo)this.prmtcurrency.getValue();
        this.txtendorseAmt.setPrecision(currency.getPrecision());
        this.txtendorseAmt.setRemoveingZeroInDispaly(false);
        this.txtendorseAmt.setHorizontalAlignment(4);
        this.txtendorseAmt.setMinimumValue((Comparable)Constants.ZERO);
        CSF7Selector arg0 = new CSF7Selector((IUIObject)this, this.prmtendorsedSupp);
        this.prmtendorsedSupp.setSelector((KDPromptSelector)arg0);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EndorsementBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        EndorsementBillInfo info = new EndorsementBillInfo();
        info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        info.setEndorseDate(DateUtil.getDayBegin());
        info.setBillType(EndorsementTypeEnum.OUT);
        info.setState(EndorseStateEnum.Save);
        info.setCreateTime(DateUtil.getTimeStampDayBegin());
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        return info;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setEndorsedSupplier(this.getSupplier(this.prmtendorsedSupp.getData()));
        this.editData.setEndorsedCustomer(this.getCustomer(this.prmtendorsedSupp.getData()));
        this.editData.setEndorsee(this.prmtendorsedSupp.getText());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getEndorsedSupplier() != null) {
            this.prmtendorsedSupp.setData((Object)this.editData.getEndorsedSupplier());
        } else if (this.editData.getEndorsedCustomer() != null) {
            this.prmtendorsedSupp.setData((Object)this.editData.getEndorsedCustomer());
        }
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    private CustomerInfo getCustomer(Object obj) {
        if (obj instanceof CustomerInfo) {
            return (CustomerInfo)obj;
        }
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkendorseDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtendorsedSupp);
    }

    public static void createNewOutEndorseBill(Object owner, String noteBillId, BigDecimal amount, String currencyId, String linkNoteBillId) throws EASBizException, BOSException {
        ReceivableBillInfo recvInfo = (ReceivableBillInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(noteBillId);
        EndorsementBillInfo billInfo = new EndorsementBillInfo();
        billInfo.setNoteBillId(noteBillId);
        billInfo.setNoteBillNumber(recvInfo.getNumber());
        billInfo.setEndorseAmt(amount);
        billInfo.setEndorseDate(DateUtil.getDayBegin());
        billInfo.setBillType(EndorsementTypeEnum.OUT);
        billInfo.setFromCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        billInfo.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)));
        billInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        billInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        billInfo.setExRate(recvInfo.getExchangeRate());
        billInfo.setLocalAmount(recvInfo.getNaturalAmt());
        billInfo.setDeliver(recvInfo.getDeliver());
        billInfo.setLinkbillId(linkNoteBillId);
        billInfo.getReceivableEntrys().add(recvInfo);
        UIContext uiCtx = new UIContext(owner);
        uiCtx.put((Object)"InitDataObject", (Object)billInfo);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OutEndorsementBillEditUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        editUI.show();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("CU.id");
        return sic;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    public boolean isModify() {
        return false;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getEndorseDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

