/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.BankStateEnum;
import com.kingdee.eas.fm.nt.IPayableApplyBill;
import com.kingdee.eas.fm.nt.PayableApplyBillCollection;
import com.kingdee.eas.fm.nt.PayableApplyBillFactory;
import com.kingdee.eas.fm.nt.PayableApplyBillInfo;
import com.kingdee.eas.fm.nt.PayableApplyBillStateEnum;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.client.AbstractPayableApplyBillListUI;
import com.kingdee.eas.fm.nt.client.PayableApplyBillDataProvider;
import com.kingdee.eas.fm.nt.client.PayableApplyBillEditUI;
import com.kingdee.eas.fm.nt.client.PayableApplyBillFilterUI;
import com.kingdee.eas.fm.nt.client.ReturnPayableBillListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PayableApplyBillListUI
extends AbstractPayableApplyBillListUI {
    public static final String RESOURCE = "com.kingdee.eas.fm.nt.NtResource";
    private static final Logger logger = CoreUIObject.getLogger(ReturnPayableBillListUI.class);
    PayableApplyBillFilterUI filterUI;
    FillListener fillListener = new FillListener();
    private static final String tdTemplateFile = "/FM/NT/PAYABLEAPPLYBILL";

    protected String getEditUIName() {
        return PayableApplyBillEditUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion();
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.btnViewBdgBalance.setVisible(true);
        this.btnViewBdgBalance.setEnabled(true);
        this.btnReverseAudit.setEnabled(true);
        this.tblMain.getColumn("provideCoAccount.name").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("receiveCoAccount.name").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("makedCount").getStyleAttributes().setNumberFormat("@");
        this.actionAssureAmount.setEnabled(false);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
    }

    protected void execQuery() {
        String targetBillType = "";
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            targetBillType = (String)btpeditparameter.get("TargetBillType");
        }
        try {
            FilterInfo filter;
            if (this.isBotp() && targetBillType.equals("PayableBill")) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
                filter.getFilterItems().add(new FilterItemInfo("provideCo.id", (Object)this.currentCompanyCommon.getId().toString()));
                FilterItemInfo iteminfo = new FilterItemInfo("usedAmount", (Object)"applyAmount", CompareType.LESS);
                iteminfo.setCompareValueIsProperty(true);
                filter.getFilterItems().add(iteminfo);
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            } else if (this.isBotp() && targetBillType.equals("AssureAmount")) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("isGenePayBill", (Object)new Integer(0), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        super.execQuery();
        this.appendFootRow();
    }

    @Override
    public void passAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        ((IPayableApplyBill)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(billId));
        this.setMessageText(EASResource.getString((String)RESOURCE, (String)"approvedSuc"));
        this.showMessage();
        this.refreshList();
    }

    @Override
    public void reverseAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        PayableApplyBillInfo info = ((IPayableApplyBill)this.getBizInterface()).getPayableApplyBillInfo((IObjectPK)new ObjectUuidPK(billId));
        if (info != null && info.getBankState() == BankStateEnum.SUBMITSUCCESS) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"292_PayableApplyBillListUI"));
            SysUtil.abort();
        }
        ((IPayableApplyBill)this.getBizInterface()).reverseAudit((IObjectPK)new ObjectUuidPK(billId));
        this.setMessageText(EASResource.getString((String)RESOURCE, (String)"reverseApprovedSuc"));
        this.showMessage();
        this.refreshList();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        String numberFormat = "%r-[ ]0.2n";
        try {
            row.getCell("applyAmount").getStyleAttributes().setNumberFormat(numberFormat);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return row;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void initWorkButton() {
        this.passAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.reverseAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        super.initWorkButton();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.initWorkButton();
        super.tblMain_tableClicked(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayableApplyBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.reverseAudit.setEnabled(true);
        String pk = this.getSelectedKeyValue();
        PayableApplyBillInfo payableApplyBillInfo = null;
        if (pk != null) {
            payableApplyBillInfo = PayableApplyBillFactory.getRemoteInstance().getPayableApplyBillInfo((IObjectPK)new ObjectUuidPK(pk));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)pk));
            if (payableApplyBillInfo.getState().equals((Object)PayableApplyBillStateEnum.approve) && payableApplyBillInfo.getSourceBillId() == null && !payableApplyBillInfo.isIsGenePayBill() && !PayableBillFactory.getRemoteInstance().exists(filter)) {
                this.actionAssureAmount.setEnabled(true);
            } else {
                this.actionAssureAmount.setEnabled(false);
            }
            if (payableApplyBillInfo.isIsGenePayBill()) {
                this.reverseAudit.setEnabled(false);
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableApplyBillFilterUI();
        }
        return this.filterUI;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() <= 0) {
            return;
        }
        String editID = (String)ids.get(ids.size() - 1);
        PayableApplyBillInfo info = (PayableApplyBillInfo)PayableApplyBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(editID));
        if (!this.currentCompanyCommon.getId().equals((Object)info.getApplayCompany().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"iscurrentCompanyNotEdite"));
            SysUtil.abort();
        }
        if (PayableApplyBillStateEnum.approve.equals((Object)info.getState()) && this.isRalation(editID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isApprovedNotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() <= 0) {
            return;
        }
        String editID = (String)ids.get(ids.size() - 1);
        PayableApplyBillInfo info = (PayableApplyBillInfo)PayableApplyBillFactory.getRemoteInstance().getBillBaseInfo((IObjectPK)new ObjectUuidPK(editID));
        if (!this.currentCompanyCommon.getId().equals((Object)info.getApplayCompany().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"iscurrentCompany.notdelete"));
            SysUtil.abort();
        }
        if (PayableApplyBillStateEnum.approve.equals((Object)info.getState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isApprovedNotdelete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean isBotpFromCreditLimit() {
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx == null) {
            return false;
        }
        String createFrom = (String)botpCtx.get("isFromCreditApply");
        return "fromCreditApply".equals(createFrom);
    }

    public SelectorItemCollection getBOTPSelectors() {
        return super.getBOTPSelectors();
    }

    private boolean isRalation(String id) throws BOSException {
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        ArrayList destList = iBotRelation.getDestObjIdByDestType(id, null);
        return destList.size() > 0;
    }

    private boolean isBotp() {
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        int status = (Integer)this.getUIContext().get("BOTPViewStatus");
        return status == 1;
    }

    @Override
    public void actionAssureAmount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new PayableApplyBillInfo().getBOSType().toString(), (String)new AssureAmountInfo().getBOSType().toString(), (String)id);
        this.refresh(e);
    }

    @Override
    public void actionSubmitBank_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        PayableApplyBillCollection pabC = this.getPayableApplyBillCollection(idSet);
        IPayableApplyBill payableApplyBill = PayableApplyBillFactory.getRemoteInstance();
        PayableApplyBillInfo info = null;
        int size = pabC.size();
        for (i = 0; i < size; ++i) {
            info = pabC.get(i);
            if (info.getState() == PayableApplyBillStateEnum.approve && (info.getBankState() == BankStateEnum.NOSUBMIT || info.getBankState() == BankStateEnum.SUBMITFAIL)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"293_PayableApplyBillListUI"));
            return;
        }
        size = pabC.size();
        for (i = 0; i < size; ++i) {
            info = pabC.get(i);
            try {
                payableApplyBill.submitBank((IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            catch (Exception ep) {
                MsgBox.showWarning((String)ep.getMessage());
                SysUtil.abort();
            }
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"294_PayableApplyBillListUI"));
        this.refresh(e);
    }

    private PayableApplyBillCollection getPayableApplyBillCollection(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        return PayableApplyBillFactory.getRemoteInstance().getPayableApplyBillCollection(evi);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        PayableApplyBillInfo info = (PayableApplyBillInfo)((IPayableApplyBill)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id), this.getSelectorsForView());
        info.setCompany(this.currentCompanyCommon);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.PayableApplyBill", null, (IObjectValue)info);
    }

    public SelectorItemCollection getSelectorsForView() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("applyQuomodo"));
        sic.add(new SelectorItemInfo("makeType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("applyAmount"));
        sic.add(new SelectorItemInfo("pactNumber"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("usePayableCo.*"));
        sic.add(new SelectorItemInfo("provideCoAccount.*"));
        sic.add(new SelectorItemInfo("payBank.*"));
        sic.add(new SelectorItemInfo("receiverSp.*"));
        sic.add(new SelectorItemInfo("receiverName"));
        sic.add(new SelectorItemInfo("receiveCoAccount.*"));
        sic.add(new SelectorItemInfo("applayCompany.*"));
        sic.add(new SelectorItemInfo("noteType.*"));
        sic.add(new SelectorItemInfo("use"));
        sic.add(new SelectorItemInfo("provideCo.*"));
        sic.add(new SelectorItemInfo("impawnNumber"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("receiverCp.*"));
        sic.add(new SelectorItemInfo("receiveAccountName"));
        sic.add(new SelectorItemInfo("receiveCoBank.*"));
        sic.add(new SelectorItemInfo("receiveBankName"));
        sic.add(new SelectorItemInfo("payableCount"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add("bgItemID");
        sic.add("bgItemNumber");
        sic.add("bgItemName");
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        return sic;
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        String targetBillType = "";
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            targetBillType = (String)btpeditparameter.get("TargetBillType");
        }
        String owner = this.getUIContext().get("Owner").toString();
        if (targetBillType.equals("PayableBill")) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("provideCo.id", (Object)this.currentCompanyCommon.getId().toString()));
            if (owner.contains("PayableBill4ElecEditUI")) {
                filter.getFilterItems().add(new FilterItemInfo("applyQuomodo", (Object)0));
            }
            FilterItemInfo iteminfo = new FilterItemInfo("usedAmount", (Object)"applyAmount", CompareType.LESS);
            iteminfo.setCompareValueIsProperty(true);
            filter.getFilterItems().add(iteminfo);
        } else if (targetBillType.equals("AssureAmount")) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isGenePayBill", (Object)new Integer(0), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        }
        if (owner.contains("PayableBill4ElecEditUI")) {
            filter.getFilterItems().add(new FilterItemInfo("billMedium", (Object)new Integer(2)));
        }
        return filter;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        PayableApplyBillDataProvider data = new PayableApplyBillDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.PayableApplyBillTDQuery");
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(PayableApplyBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                IRow row = tblMain.getRow(i);
                StyleAttributes styleAttributes = row.getCell("applyAmount").getStyleAttributes();
                String currencyId = row.getCell("currency.id").getValue().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"applyAmount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"usedAmount", (String)currencyId);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

