/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.NtRpcCacheInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.PayableQueryTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractPayableBillFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.PayableBillFilterParam;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayableBillFilterUI
extends AbstractPayableBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableBillFilterUI.class);
    private NtRpcCacheInfo rpcCacheInfo;
    private BillSourceEnum billSource;

    public PayableBillFilterUI(BillSourceEnum billSource) throws Exception {
        this.combobillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboBillType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.billSource = billSource;
        if (this.billSource == BillSourceEnum.BYECDS) {
            this.combobillState.removeItem((Object)PayableBillStateEnum.Abandoned);
            this.combobillState.removeItem((Object)PayableBillStateEnum.TranLoan);
            this.combobillState.removeItem((Object)PayableBillStateEnum.ABANDON);
            this.combobillState.removeItem((Object)PayableBillStateEnum.Discount);
            this.combobillState.removeItem((Object)PayableBillStateEnum.InTransfer);
            this.combobillState.removeItem((Object)PayableBillStateEnum.OutTransfer);
        }
    }

    public PayableBillFilterUI() throws Exception {
        this.combobillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboBillType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public Object getParam() {
        Set gtSet;
        Set fpSet;
        PayableBillFilterParam filterParam = new PayableBillFilterParam();
        if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrencyId(null);
        }
        if (!(this.comboBillType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setNtTypeId(((NTTypeInfo)this.comboBillType.getSelectedItem()).getId().toString());
        } else {
            filterParam.setNtTypeId(null);
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.dpBeginDate.getSqlDate() != null) {
            filterParam.setBeginDate(DateTimeUtils.truncateDate((Date)this.dpBeginDate.getSqlDate()));
        }
        if (this.dpEndDate.getSqlDate() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((Date)this.dpEndDate.getSqlDate()));
        }
        filterParam.setQueryState((PayableQueryTypeEnum)((Object)this.comboqueryType.getSelectedItem()));
        if (!(this.combobillState.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setBillstate((PayableBillStateEnum)((Object)this.combobillState.getSelectedItem()));
        } else {
            filterParam.setBillstate(null);
        }
        if (this.billSource != null) {
            filterParam.setSource(this.billSource.getValue());
        }
        if ((fpSet = this.getIdSetFromF7(this.prmtFinProduct)) != null && fpSet.size() > 0) {
            filterParam.setFinProductSet(fpSet);
        }
        if ((gtSet = this.getIdSetFromF7(this.prmtGuaranteeType)) != null && gtSet.size() > 0) {
            filterParam.setGuaranteeTypeSet(gtSet);
        }
        filterParam.setCreateOrgID(this.currentCompany.getId().toString());
        return filterParam;
    }

    protected Class getParamClass() {
        return PayableBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        PayableBillFilterParam filterParam;
        block13: {
            if (param == null) {
                return;
            }
            filterParam = (PayableBillFilterParam)((Object)param);
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            if (filterParam.getCurrencyId() != null) {
                try {
                    if (filterParam.getCurrencyId() != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
                        break block13;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.kDComboBoxCurrency.setSelectedIndex(this.kDComboBoxCurrency.getItemCount() - 1);
            }
        }
        this.dpBeginDate.setValue((Object)filterParam.getBeginDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            this.prmtFinProduct.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinProductSet()));
            this.prmtGuaranteeType.setData((Object)this.getBaseInfoFromIdSet(filterParam.getGuaranteeTypeSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboqueryType, (Object)((Object)filterParam.getQueryState()));
        if (filterParam.getBillstate() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)((Object)filterParam.getBillstate()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (filterParam.getNtTypeId() != null) {
            NTTypeInfo ntTypeInfo = new NTTypeInfo();
            ntTypeInfo.setId(BOSUuid.read((String)filterParam.getNtTypeId()));
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)ntTypeInfo);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    @Override
    protected void comboqueryType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboqueryType_itemStateChanged(e);
        if (!this.comboqueryType.getSelectedItem().equals((Object)PayableQueryTypeEnum.selfBill)) {
            FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)((Object)PayableBillStateEnum.Audit));
        }
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initCompanyState() {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && !this.rpcCacheInfo.isClearingHouse()) {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void init() throws Exception {
        super.init();
        this.initCurrency();
        FinUtils.setFinProductF7((KDBizPromptBox)this.prmtFinProduct, (FinancingBillTypeEnum)FinancingBillTypeEnum.CommercialDraft);
        this.prmtGuaranteeType.setEnabledMultiSelection(true);
        this.prmtGuaranteeType.setData(null);
        if (this.billSource == BillSourceEnum.BYECDS) {
            this.dpBeginDate.setValue(null);
            this.dpEndDate.setValue(null);
            this.comboqueryType.setEnabled(false);
        } else {
            this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
            this.dpEndDate.setValue((Object)DateUtil.getEndDayOfCurMonth());
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboqueryType, (Object)((Object)PayableQueryTypeEnum.selfBill));
        FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)((Object)PayableBillStateEnum.SUBMIT));
        if (this.comboBillType.getItemCount() <= 1) {
            Iterator iter = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.PAYABLE).iterator();
            while (iter.hasNext()) {
                NTTypeInfo element = (NTTypeInfo)iter.next();
                this.comboBillType.addItem((Object)element);
            }
        }
    }

    private void initCurrency() throws Exception {
        CurrencyCollection currencyCollection = this.rpcCacheInfo.getAllCurrencyColl();
        FMHelper.sortCollection((AbstractObjectCollection)currencyCollection, (String[])new String[]{"number"});
        this.kDComboBoxCurrency.removeAllItems();
        this.kDComboBoxCurrency.addItems(currencyCollection.toArray());
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.rpcCacheInfo.getCurrentCurrency());
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public void onLoad() throws Exception {
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        this.rpcCacheInfo = (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
        super.onLoad();
    }

    public boolean verify() {
        if (BillSourceEnum.BYHAND == this.billSource) {
            NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.dpBeginDate.getValue(), (Date)this.dpEndDate.getValue());
        }
        return super.verify();
    }

    public void setCustomerParams(CustomerParams cp) {
        Object param = this.getFilterParamFromCP(cp);
        PayableBillFilterParam para = (PayableBillFilterParam)((Object)param);
        if (!this.currentCompany.getId().toString().equals(para.getCreateOrgID()) && param != null && param instanceof FMFilterParamBase) {
            FMFilterParamBase paramBase = (FMFilterParamBase)param;
            paramBase.setCompanyIdSet(this.getCompanyIdSet());
        }
        this.setParam(param);
    }
}

