/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.fpl.FpItemInfo;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;

public class PayableBillHandler {
    private final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    public FpItemInfo getFpItem(Object obj) {
        if (obj instanceof FpItemInfo) {
            return (FpItemInfo)obj;
        }
        return null;
    }

    public CustomerInfo getCustomer(Object obj) {
        if (obj instanceof CustomerInfo) {
            return (CustomerInfo)obj;
        }
        return null;
    }

    public String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public AccountBankInfo getBankAccount(Object obj) {
        if (obj instanceof AccountBankInfo) {
            return (AccountBankInfo)obj;
        }
        return null;
    }

    public String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    public void setEditPrmt(KDBizPromptBox prmt, boolean flag) {
        ExtendParser parser = new ExtendParser(prmt);
        if (flag) {
            prmt.setCommitParser((IParser)parser);
        } else {
            prmt.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmt));
        }
    }

    public void verifyInput(CoreUIObject ui, PayableBillInfo payable) throws EASBizException, BOSException {
        Date dateAccept = DateTimeUtils.truncateDate((Date)payable.getAcceptDate());
        Date dateBegin = DateTimeUtils.truncateDate((Date)payable.getIssueDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)payable.getExpiredDate());
        if (dateBegin == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"308_PayableBillHandler"));
            SysUtil.abort();
        }
        if (dateEnd == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"309_PayableBillHandler"));
            SysUtil.abort();
        }
        if (dateAccept != null && (dateEnd != null && dateEnd.before(dateAccept) || dateBegin != null && dateBegin.after(dateAccept))) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"295_PayableBillAcceptUI"));
            SysUtil.abort();
        }
        if (!dateEnd.after(dateBegin)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"298_PayableBillEditUI"));
            SysUtil.abort();
        }
        FMVerifyHelper.checkBlank(null, (IObjectValue)payable, (String)"Horizon");
        FMVerifyHelper.checkBlank(null, (IObjectValue)payable, (String)"LocalCurExRate");
        FMVerifyHelper.checkMustMoreThanZero(null, (IObjectValue)payable, (String)"Amount");
        if (payable.getAmount() != null && payable.getAssureAmount().compareTo(payable.getAmount()) > 0) {
            MsgBox.showWarning((Component)ui, (String)this.getResString("AmountBiggerThanAssureAmount"));
            SysUtil.abort();
        }
        Boolean billMedium = payable.getBillMedium().equals((Object)BillMediumEnum.PAPERY);
        if (this.isOver6MonthNew(payable.getIssueDate(), payable.getExpiredDate(), billMedium)) {
            if (billMedium.booleanValue()) {
                if (MsgBox.showConfirm2New((Component)ui, (String)this.getResString("CheckPayableHorizon")) == 1) {
                    SysUtil.abort();
                }
            } else if (MsgBox.showConfirm2New((Component)ui, (String)this.getResString("CheckPayableTimeHorizon")) == 1) {
                SysUtil.abort();
            }
        }
        FmMbgHelper.checkBizUnitInfo(null, (IObjectValue)payable);
    }

    private boolean isOver6MonthNew(Date issueDate, Date expireDate, Boolean billMedium) {
        Calendar cal1 = Calendar.getInstance();
        if (billMedium.booleanValue()) {
            cal1.setTime(issueDate);
            cal1.set(10, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            cal1.add(2, 6);
        } else {
            cal1.setTime(issueDate);
            cal1.set(10, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            cal1.add(2, 12);
        }
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(expireDate);
        cal2.set(10, 0);
        cal2.set(12, 0);
        cal2.set(13, 0);
        cal2.set(14, 0);
        return cal1.getTimeInMillis() - cal2.getTimeInMillis() < 0L;
    }
}

