/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.client.RepaymentEditUI;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractPayableCashBillListUI;
import com.kingdee.eas.fm.nt.client.PayableCashBillFilterUI;
import com.kingdee.eas.fm.nt.client.RepaymentBatEditUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableCashBillListUI
extends AbstractPayableCashBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableCashBillListUI.class);
    protected PayableCashBillFilterUI filterUI;
    public static final String NT_RESOURCE = "com.kingdee.eas.fm.nt.NtResource";

    public PayableCashBillListUI() throws Exception {
        this.actionAddNew.setVisible(false);
        this.actionWorkFlowG.setVisible(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionEdit.setVisible(false);
        this.tblMain.getColumn("startDate").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("endDate").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("days").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isPerformanced").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("intRateExp").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("rateLoan").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("sourceCurrency").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("sourceCurExRate").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("InterestAcct").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("Amount").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("Remark").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("company.name").getStyleAttributes().setHided(false);
        this.actionAddNew.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRemove.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_delete"));
        this.actionViewBgBalance.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_check"));
        this.actionConfirmNoWF.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionViewBgBalance.setEnabled(true);
    }

    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("SourceType", (Object)new Integer(2)));
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.execQuery();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        return sic;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableCashBillFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        RepaymentInfo sourceBill = ((IRepayment)this.getBizInterface()).getRepaymentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        boolean bCurCompany = currentCompany.getId().toString().equals(sourceBill.getCompany().getId().toString());
        boolean bWillConfirmed = currentCompany.getId().toString().equals(sourceBill.getApplyUnit().getId().toString());
        this.actionConfirmNoWF.setEnabled(bWillConfirmed && sourceBill.getConfirmer() == null && !bCurCompany);
        this.actionAudit.setEnabled(sourceBill.getStatusExtEnum() == StatusExtEnum.SUBMIT);
        this.actionAntiAudit.setEnabled(sourceBill.getConfirmer() == null && sourceBill.getStatusExtEnum().equals((Object)StatusExtEnum.AUDIT));
        this.actionViewBgBalance.setEnabled(bCurCompany);
        this.actionTraceUp.setEnabled(bCurCompany);
        this.actionTraceDown.setEnabled(bCurCompany);
        this.actionBook.setEnabled(bCurCompany && sourceBill.getCashier() == null);
        this.actionCancelBook.setEnabled(bCurCompany && sourceBill.getCashier() != null);
        this.actionVoucher.setEnabled(!sourceBill.isIsGenPayBill());
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RepaymentInfo info = ((IRepayment)this.getBizInterface()).getRepaymentInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.Repayment", null, (IObjectValue)info);
    }

    @Override
    public void actionConfirmNoWF_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 1) {
            String id = this.getSelectedKeyValue();
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"isFromWorkflow", (Object)new Boolean(true));
            uiCtx.put((Object)"ID", (Object)id);
            IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RepaymentEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
            editUI.show();
            this.refresh(e);
        }
        if (idList.size() > 1) {
            ArrayList idlist = this.getSelectedIdValues();
            HashSet idSet = new HashSet(idlist);
            ArrayList<String> payableIds = new ArrayList<String>();
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            view1.setFilter(filter1);
            filter1.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            RepaymentCollection repaymentColl = RepaymentFactory.getRemoteInstance().getRepaymentCollection(view1);
            Date bizDate = null;
            for (int i = 0; i < repaymentColl.size(); ++i) {
                RepaymentInfo repaymentInfo = repaymentColl.get(i);
                payableIds.add(repaymentInfo.getSourceBillId());
                if (i > 0 && repaymentInfo.getBizDate().compareTo(bizDate) != 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)NT_RESOURCE, (String)"client_batchCash_goIn"));
                    SysUtil.abort();
                }
                bizDate = repaymentInfo.getBizDate();
            }
            HashSet payabelIdSet = new HashSet(payableIds);
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            view2.setFilter(filter2);
            filter2.getFilterItems().add(new FilterItemInfo("id", payabelIdSet, CompareType.INCLUDE));
            PayableBillCollection payableBillCollection = PayableBillFactory.getRemoteInstance().getPayableBillCollection(view2);
            PayableBillCollection entrustPayCol = new PayableBillCollection();
            boolean flag = true;
            String result = null;
            StringBuffer failInfo = new StringBuffer();
            for (int i = 0; i < payableBillCollection.size(); ++i) {
                CompanyOrgUnitInfo company;
                PayableBillInfo payableBillInfo = payableBillCollection.get(i);
                String draftNumber = payableBillInfo.getDraftNumber();
                PayableBillInfo entrustPayInfo = this.getEntrustPayInfo(draftNumber, (company = payableBillInfo.getApplyUnit()).getId().toString());
                if (entrustPayInfo == null) continue;
                PersonInfo confirmer = entrustPayInfo.getConfirmer();
                boolean isFromEntrust = entrustPayInfo.isIsFromEntrust();
                if (confirmer == null && isFromEntrust) {
                    flag = false;
                    String BATCHCASH_NOCONFIRM = EASResource.getString((String)NT_RESOURCE, (String)"client_batchCash_noConfirm");
                    failInfo.append(MessageFormat.format(BATCHCASH_NOCONFIRM, company.getName(), draftNumber));
                    continue;
                }
                entrustPayCol.add(entrustPayInfo);
            }
            if (!flag) {
                result = EASResource.getString((String)NT_RESOURCE, (String)"client_batchCash_goIn1");
                MsgBox.showDetailAndOK(null, (String)result, (String)failInfo.toString(), (int)1);
            }
            if (entrustPayCol.size() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"PayableColl", (Object)entrustPayCol);
                uiContext.put((Object)"bizDate", (Object)bizDate);
                uiContext.put((Object)"flag", (Object)"CONFIRM");
                uiContext.put((Object)"isFromWorkflow", (Object)new Boolean(true));
                IUIWindow uiWindow = null;
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RepaymentBatEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                this.refreshList();
            }
        }
    }

    private PayableBillInfo getEntrustPayInfo(String draftNumber, String companyId) throws NTException, BOSException {
        if (companyId == null || draftNumber == null) {
            throw new NTException(NTException.SELECTENTRUSTEX1);
        }
        PayableBillInfo entrustPayInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        fi.getFilterItems().add(new FilterItemInfo("makeType", (Object)"2"));
        evi.setFilter(fi);
        SelectorItemCollection selector = this.getPayableBillSelectors();
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        PayableBillCollection entrustPayCol = PayableBillFactory.getRemoteInstance().getPayableBillCollection(evi);
        if (entrustPayCol.size() > 1) {
            throw new NTException(NTException.SELECTENTRUSTEX2);
        }
        if (entrustPayCol.size() == 0) {
            throw new NTException(NTException.SELECTENTRUSTEX3);
        }
        entrustPayInfo = entrustPayCol.get(0);
        return entrustPayInfo;
    }

    public SelectorItemCollection getPayableBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add("*");
        sic.add("ntType.*");
        sic.add("Institution.*");
        sic.add("Currency.*");
        sic.add("company.*");
        sic.add("ApplyUnit.*");
        return sic;
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected String[] getQueryShowField() {
        return new String[]{"company.name", "number", "bizDate", "SourceType", "sourceAmount", "Currency", "SourceBillNum", "payee.Name", "creator", "Confirmer", "ApplyCompany", "LocalCurExRate", "LocalAmount", "InnerAccount.Name", "accountant.name", "description", "BankAcct.name", "LoanAcct.name", "CTLCancel", "isGenPayBill", "ntType"};
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row == null) {
            return null;
        }
        int columnCount = this.tblMain.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            ICell cell = row.getCell(c);
            cell.getStyleAttributes().setNumberFormat("###,##0.##########");
        }
        return row;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSubmit", "actionAntiAudit", "actionAudit"};
    }

    protected String[] getWhiteList() {
        return new String[]{"actionAudit", "actionAntiAudit"};
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "Interest", "Payment", "LocalAmount", "sourceAmount", "sourceCurExRate"};
    }
}

