/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.fm.nt.client.AbstractPayableDiscountBillListUI;
import com.kingdee.eas.fm.nt.client.PayDiscountBillBatchEditUI;
import com.kingdee.eas.fm.nt.client.PayableDiscountBillFilterUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableDiscountBillListUI
extends AbstractPayableDiscountBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableDiscountBillListUI.class);

    public PayableDiscountBillListUI() throws Exception {
        this.tblMain.checkParsed(true);
    }

    @Override
    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payablebill.id", null, CompareType.NOTEQUALS));
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.execQuery1();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (null != this.tblMain.getColumn("rpbillid")) {
            this.tblMain.getColumn("rpbillid").getStyleAttributes().setHided(true);
        }
        if (null != this.tblMain.getColumn("type")) {
            this.tblMain.getColumn("type").getStyleAttributes().setHided(true);
        }
        if (null != this.tblMain.getColumn("auditDate")) {
            this.tblMain.getColumn("auditDate").getStyleAttributes().setHided(true);
        }
        if (null != this.tblMain.getColumn("auditor")) {
            this.tblMain.getColumn("auditor").getStyleAttributes().setHided(true);
        }
        this.actionAuditTie.setVisible(false);
        this.actionAntiAuditTie.setVisible(false);
        this.actionConfirmTie.setVisible(false);
        this.actionAntiConfirmTie.setVisible(false);
        this.actionGather.setVisible(false);
        this.menuWorkFlow.setVisible(false);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        boolean bCurCompany;
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        DiscountBillInfo sourceBill = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        boolean isAcceptBill = false;
        if (sourceBill.getDiscountBank() != null && sourceBill.getDiscountBank().getRelatedCompany() != null) {
            isAcceptBill = this.currentCompany.getId().toString().equals(sourceBill.getDiscountBank().getRelatedCompany().getId().toString());
        }
        this.actionBook.setEnabled((bCurCompany = sourceBill.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) && sourceBill.getCashier() == null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !isAcceptBill);
        this.actionCancelBook.setEnabled(bCurCompany && sourceBill.getCashier() != null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !isAcceptBill);
        this.actionVoucher.setEnabled(!sourceBill.isFivouchered());
        this.actionDelVoucher.setEnabled(sourceBill.isFivouchered());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.payableBill.*"));
        return sic;
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableDiscountBillFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayDiscountBillBatchEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        editUI.show();
    }
}

