/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.FMBillClientUtil;
import com.kingdee.eas.fm.nt.IPayableTransferBill;
import com.kingdee.eas.fm.nt.PayableTransferBillFactory;
import com.kingdee.eas.fm.nt.PayableTransferBillInfo;
import com.kingdee.eas.fm.nt.TransferBillTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractPayableTransferListUI;
import com.kingdee.eas.fm.nt.client.PayableTransferEditUI;
import com.kingdee.eas.fm.nt.client.PayableTransferFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableTransferListUI
extends AbstractPayableTransferListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableTransferListUI.class);
    PayableTransferFilterUI filterUI;
    CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public PayableTransferListUI() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableTransferFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayableTransferBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("oppAccount.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableTransferEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        PayableTransferBillInfo billInfo = ((IPayableTransferBill)this.getBizInterface()).getPayableTransferBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        boolean bCurCompany = this.currentCompany.getId().toString().equals(billInfo.getCompany().getId().toString());
        this.actionRemove.setEnabled(!billInfo.isFivouchered() && bCurCompany && billInfo.getConfirmer() == null);
        if (billInfo.getTransferTpye() == TransferBillTypeEnum.In) {
            this.actionVoucher.setEnabled(!billInfo.isFivouchered() && bCurCompany && billInfo.getConfirmer() != null);
        } else {
            this.actionVoucher.setEnabled(!billInfo.isFivouchered() && bCurCompany);
        }
        this.actionDelVoucher.setEnabled(billInfo.isFivouchered() && bCurCompany);
        this.actionEdit.setEnabled(!billInfo.isFivouchered() && bCurCompany);
        boolean isAppCompany = this.currentCompany.getName().equals(billInfo.getApplyName()) && !this.currentCompany.getId().toString().equals(billInfo.getCompany().getId().toString());
        this.actionConfirm.setEnabled(isAppCompany && billInfo.getConfirmer() == null && billInfo.getTransferTpye() == TransferBillTypeEnum.In);
        this.actionCancelConfirm.setEnabled(isAppCompany && billInfo.getConfirmer() != null && billInfo.getTransferTpye() == TransferBillTypeEnum.In);
        this.actionViewBgBalance.setEnabled(bCurCompany);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableTransferEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        editUI.show();
    }

    private void onshows() {
    }

    protected void execQuery() {
        super.execQuery();
        this.onshows();
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionCancelConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    protected String[] getPrecColName() {
        return new String[]{"amount"};
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell("CurrencyID").getValue();
            if (currencyId == null) continue;
            String[] formatCol = this.getPrecColName();
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
        tblMain.getColumn("CurrencyID").getStyleAttributes().setHided(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        uiCtx.put((Object)"isFromConfirm", (Object)new Boolean(true));
        uiCtx.put((Object)"payableBillId", (Object)BOSUuid.read((String)id));
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableTransferEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refreshList();
    }

    @Override
    public void actionCancelConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelConfirm_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ((IPayableTransferBill)this.getBizInterface()).cancelConfirm(id);
        this.refreshList();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("oppAccount.*"));
        sic.add(new SelectorItemInfo("payableEntrys.billAccount.*"));
        sic.add(new SelectorItemInfo("payableEntrys.oppAccount.*"));
        return sic;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.refreshList();
    }

    public void onLoad() throws Exception {
        FMBillClientUtil.showMessage((String)this.currentCompany.getName());
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.actionLocate.setVisible(false);
        this.tblMain.getColumn("srcBillNumber").getStyleAttributes().setWrapText(true);
        this.onshows();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return PayableTransferEditUI.class.getName();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            if (!this.tblMain.getColumn(i).isGroup()) continue;
            list.add(this.tblMain.getColumn(i).getKey());
        }
        String[] keys = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            keys[i] = (String)list.get(i);
        }
        return keys;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "transferDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionCancelConfirm"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            PayableTransferListUI.this.setListUITable(PayableTransferListUI.this.tblMain, e);
        }
    }
}

