/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.nt.IPledgeRevokeBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryCollection;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryInfo;
import com.kingdee.eas.fm.nt.PledgeRevokeBillFactory;
import com.kingdee.eas.fm.nt.PledgeRevokeBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractPledgeRevokeBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class PledgeRevokeBillEditUI
extends AbstractPledgeRevokeBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PledgeRevokeBillEditUI.class);
    private CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private Boolean successFlag = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            // empty if block
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected void f7OppAcct_willCommit(CommitEvent e) throws Exception {
        this.setAccountViewEvi(this.prmtOppAcct);
    }

    @Override
    protected void f7OppAcct_willShow(SelectorEvent e) throws Exception {
        this.setAccountViewEvi(this.prmtOppAcct);
    }

    private void setAccountViewEvi(KDBizPromptBox prmt) throws EASBizException, BOSException {
        CurrencyInfo currInfo = (CurrencyInfo)this.prmtCurrency.getData();
        prmt.setDisplayFormat("$number$ $name$");
        prmt.setCommitFormat("$number$");
        prmt.setEditFormat("$number$");
        NTHelper.setF7AccountEvi((IUIObject)this, currInfo.getId().toString(), this.curCompany, prmt);
    }

    protected IObjectValue createNewData() {
        PledgeRevokeBillInfo info = new PledgeRevokeBillInfo();
        info.setCompany(this.curCompany);
        PledgeRevokeBillEntryCollection entryCollection = new PledgeRevokeBillEntryCollection();
        CurrencyInfo currency = null;
        info.setApplyDate(new Date());
        BigDecimal billTotalAmount = BigDecimal.ZERO;
        StringBuffer billNumbers = new StringBuffer();
        if (this.getUIContext().get("receivableColl") != null) {
            ReceivableBillCollection receivableColl = (ReceivableBillCollection)((Object)this.getUIContext().get("receivableColl"));
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo recInfo = receivableColl.get(i);
                billTotalAmount = billTotalAmount.add(recInfo.getBillAmt());
                PledgeRevokeBillEntryInfo entry = new PledgeRevokeBillEntryInfo();
                entry.setSeq(i + 1);
                entry.setReceivableBill(recInfo);
                entryCollection.add(entry);
                info.getEntrys().add(entry);
                billNumbers.append(recInfo.getDraftNumber() + ";");
            }
            info.setTotalBillAmount(billTotalAmount);
            info.setAmount(billTotalAmount);
            info.setLocalAmount(billTotalAmount);
            if (billNumbers.length() > 500) {
                info.setBillNumbers(billNumbers.substring(0, 496) + "...");
            } else {
                info.setBillNumbers(billNumbers.toString());
            }
            if (billNumbers.length() > 60) {
                info.setNumber(billNumbers.substring(0, 60) + "_" + String.valueOf(System.currentTimeMillis()));
            } else {
                info.setNumber(billNumbers.toString() + "_" + String.valueOf(System.currentTimeMillis()));
            }
            info.setBillMediumEnum(receivableColl.get(0).getBillMedium());
            currency = receivableColl.get(0).getCurrency();
        }
        info.setCurrency(currency);
        info.setBillStatus(FinBillStatusEnum.SAVE);
        if (this.getUIContext().get("pledger") != null) {
            info.setInstitution((BankInfo)this.getUIContext().get("pledger"));
        }
        if (this.getUIContext().get("wageIDs") != null) {
            // empty if block
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PledgeRevokeBillFactory.getRemoteInstance();
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        super.doAfterSave(pk);
        if (this.getUIContext().get("wageIDs") != null) {
            ((IPledgeRevokeBill)this.getBizInterface()).addSrcRelations((Set)this.getUIContext().get("wageIDs"), pk.toString());
        }
        this.successFlag = true;
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        if (this.getUIContext().get("wageIDs") != null) {
            ((IPledgeRevokeBill)this.getBizInterface()).addSrcRelations((Set)this.getUIContext().get("wageIDs"), pk.toString());
        }
        this.successFlag = true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fillTable();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSave.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"623_PledgeRevokeBillEditUI"));
        this.btnSubmit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"562_PledgeRevokeBillControllerBean"));
    }

    private void fillTable() throws BOSException, UuidException {
        int i;
        ReceivableBillCollection coll = null;
        PledgeRevokeBillEntryCollection entryColl = null;
        if (this.getUIContext().get("receivableColl") != null) {
            coll = (ReceivableBillCollection)((Object)this.getUIContext().get("receivableColl"));
        } else if (this.editData != null && this.editData.getEntrys() != null) {
            coll = new ReceivableBillCollection();
            entryColl = this.editData.getEntrys();
            for (i = 0; i < this.editData.getEntrys().size(); ++i) {
                PledgeRevokeBillEntryInfo entryInfo = this.editData.getEntrys().get(i);
                coll.add(entryInfo.getReceivableBill());
            }
        }
        if (EmptyUtil.isEmpty(coll)) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        for (i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            ReceivableBillInfo vo = coll.get(i);
            row.getCell("draftnumber").setValue((Object)vo.getDraftNumber());
            row.getCell("nttype").setValue((Object)vo.getNtType().getDisplayName());
            row.getCell("currency").setValue((Object)vo.getCurrency().getName());
            row.getCell("amount").setValue((Object)vo.getBillAmt());
            row.getCell("duedate").setValue((Object)vo.getExpiredDate());
            row.getCell("displedge").setValue((Object)vo.isIsDisPledge());
            row.getCell("pledge").setValue((Object)vo.isIsDisPledge());
            row.getCell("status").setValue((Object)vo.getBillState());
            row.getCell("closed").setValue((Object)vo.isClose());
            row.getCell("billmedium").setValue((Object)vo.getBillMedium());
            if (EmptyUtil.isEmpty((AbstractObjectCollection)entryColl)) continue;
            row.getCell("elecstatus").setValue((Object)entryColl.get(i).getElecBillStatus());
            row.getCell("bankreturnstatus").setValue((Object)entryColl.get(i).getBankReturnStatus());
            row.getCell("bankreturnmsg").setValue((Object)entryColl.get(i).getBankReturnMsg());
            row.getCell("canclerevoke").setValue((Object)entryColl.get(i).isRevokeCancel());
            row.getCell("canclesucceed").setValue((Object)entryColl.get(i).isRevokeCancelSucceed());
        }
    }

    public Boolean getSuccessFlag() {
        return this.successFlag;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("billNumbers"));
        sic.add(new SelectorItemInfo("billMediumEnum"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("digest"));
        sic.add(new SelectorItemInfo("totalBillAmount"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.draftNumber"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.ntType.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.billAmt"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.expiredDate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.isDisPledge"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.isPledge"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.currency.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.billMedium"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.billState"));
        sic.add(new SelectorItemInfo("institution.*"));
        sic.add(new SelectorItemInfo("institution.id"));
        sic.add(new SelectorItemInfo("institution.number"));
        sic.add(new SelectorItemInfo("institution.name"));
        sic.add(new SelectorItemInfo("oppAccountView.*"));
        return sic;
    }

    protected void showSubmitSuccess() {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"624_PledgeRevokeBillEditUI"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (DateTimeUtils.truncateDate((Date)this.dpApplyDate.getSqlDate()).before(DateUtil.getDayBegin())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"625_PledgeRevokeBillEditUI"));
            SysUtil.abort();
        }
    }
}

