/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IPledgeRevokeBill;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.PledgeRevokeBillCollection;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryCollection;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryFactory;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryInfo;
import com.kingdee.eas.fm.nt.PledgeRevokeBillFactory;
import com.kingdee.eas.fm.nt.PledgeRevokeBillInfo;
import com.kingdee.eas.fm.nt.PledgeRevokeParam;
import com.kingdee.eas.fm.nt.client.AbstractPledgeRevokeBillListUI;
import com.kingdee.eas.fm.nt.client.DraftUpdateStatusListUI;
import com.kingdee.eas.fm.nt.client.PledgeRevokeBillEditUI;
import com.kingdee.eas.fm.nt.client.PledgeRevokeFilterUI;
import com.kingdee.eas.fm.nt.client.util.FMToolTipUtil;
import com.kingdee.eas.fm.nt.vo.FMToolTipInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PledgeRevokeBillListUI
extends AbstractPledgeRevokeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(PledgeRevokeBillListUI.class);
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    protected PledgeRevokeFilterUI filterUI;
    protected boolean isShowEntry = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionCommitBE.setEnabled(true);
        this.actionSyncStatus.setEnabled(true);
        this.actionRevokeCancel.setEnabled(true);
    }

    public ArrayList getSelectedIDs() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("id");
            if (cell == null || cell.getValue() == null || list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    private boolean isbankProcessing(PledgeRevokeBillInfo info) throws BOSException {
        boolean flg = false;
        PledgeRevokeBillEntryCollection billEntrys = info.getEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntry = billEntrys.get(i);
            if (pledgeRevokeBillEntry.getBankReturnStatus() == null || pledgeRevokeBillEntry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION && pledgeRevokeBillEntry.getBankReturnStatus() != BankReturnStatusEnum.BANK_PROCESSING && pledgeRevokeBillEntry.getBankReturnStatus() != BankReturnStatusEnum.EB_PROCESSING) continue;
            return true;
        }
        return flg;
    }

    public boolean getAuditStatus() {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            boolean submitStatus;
            IRow row = this.tblMain.getRow(indexs[i]);
            BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("billStatus").getValue();
            if (status == null) {
                return false;
            }
            boolean bl = submitStatus = status.getInt() == 1;
            if (!submitStatus) continue;
            return true;
        }
        return false;
    }

    private boolean isBankReturnStatus(PledgeRevokeBillInfo info, boolean rejected) throws BOSException {
        boolean flg = true;
        PledgeRevokeBillEntryCollection billEntrys = info.getEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = billEntrys.get(i);
            if (pledgeRevokeBillEntryInfo.getBankReturnStatus() != null) {
                if (rejected) {
                    if (pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    private boolean existBEException(PledgeRevokeBillInfo sourceBill) {
        boolean exist = false;
        PledgeRevokeBillEntryCollection billEntrys = sourceBill.getEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntry = billEntrys.get(i);
            if (pledgeRevokeBillEntry.getBankReturnStatus() == null || pledgeRevokeBillEntry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            exist = true;
            break;
        }
        return exist;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        PledgeRevokeBillInfo sourceBill;
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        if (BOSUuid.isValid((String)id, (boolean)true)) {
            sourceBill = ((IPledgeRevokeBill)this.getBizInterface()).getPledgeRevokeBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            this.actionCommitBE.setEnabled(sourceBill.getBillStatus() == FinBillStatusEnum.AUDITED && !sourceBill.isCommitedToBE());
            this.actionSyncStatus.setEnabled(sourceBill.isCommitedToBE() && this.isbankProcessing(sourceBill));
            this.actionEdit.setEnabled(!sourceBill.isCommitedToBE());
            if (this.getAuditStatus()) {
                this.actionAudit.setEnabled(true);
                this.actionAntiAudit.setEnabled(false);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(true);
            }
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionTraceUp.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            return;
        }
        this.actionRemove.setEnabled(!sourceBill.isCommitedToBE() || sourceBill.isCommitedToBE() && this.isBankReturnStatus(sourceBill, true));
        this.actionChangeStatus.setEnabled(sourceBill.isCommitedToBE() && this.existBEException(sourceBill));
        this.actionAntiAudit.setEnabled(!sourceBill.isCommitedToBE());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        Map messageMap = ((IPledgeRevokeBill)this.getBizInterface()).submit(idSet);
        this.showMsg(messageMap);
        this.refreshList();
    }

    private void showMsg(Map messageMap) throws Exception {
        if ((Integer)messageMap.get("errorCode") == 0) {
            MsgBox.showInfo((String)messageMap.get("messageHeader").toString());
        } else if ((Integer)messageMap.get("errorCode") == 1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)messageMap.get("messageHeader").toString(), (String)messageMap.get("errMessage").toString(), (int)2);
        } else if ((Integer)messageMap.get("errorCode") == 2) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)messageMap.get("messageHeader").toString(), (String)messageMap.get("errMessage").toString(), (int)0);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        Map messageMap = ((IPledgeRevokeBill)this.getBizInterface()).audit(idSet);
        this.showMsg(messageMap);
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        Map messageMap = ((IPledgeRevokeBill)this.getBizInterface()).antiAudit(idSet);
        this.showMsg(messageMap);
        this.refreshList();
    }

    private PledgeRevokeBillInfo getPledgeRevokeBillInfo(String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        PledgeRevokeBillInfo info = PledgeRevokeBillFactory.getRemoteInstance().getPledgeRevokeBillInfo((IObjectPK)new ObjectUuidPK(id), selector);
        return info;
    }

    private boolean existBankReturnStatus(PledgeRevokeBillInfo info) throws BOSException {
        boolean exist = false;
        PledgeRevokeBillEntryCollection billEntrys = info.getEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            PledgeRevokeBillEntryInfo entry = billEntrys.get(i);
            if (entry.getBankReturnStatus() != null && !BankReturnStatusEnum.EB_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)entry.getBankReturnStatus())) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private List getSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                rows.add(row);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCommitBE_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap<Object, Object> numberMap = new HashMap<Object, Object>();
        List rows = this.getSelectedRows();
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            String id = (String)row.getCell("id").getValue();
            numberMap.put(row.getCell(this.getKeyFieldName()).getValue(), row.getCell("receivableBill.draftNumber").getValue());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        HashSet idSet = new HashSet();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            ArrayList<BankPayResult> resultLockList = new ArrayList<BankPayResult>();
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    BankPayResult resultInfo = new BankPayResult();
                    resultInfo.setId(idList.get(i).toString());
                    resultInfo.setNumber((String)numberMap.get(idList.get(i)));
                    resultInfo.setErrorDetail("\u5355\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01");
                    resultLockList.add(resultInfo);
                    continue;
                }
                idSet.add(idList.get(i));
            }
            if (idSet.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"602_EndorsementBillListUI"));
                SysUtil.abort();
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            evi.setSelector(this.getSelectors());
            PledgeRevokeBillCollection pledgeRevokeBillColl = PledgeRevokeBillFactory.getRemoteInstance().getPledgeRevokeBillCollection(evi);
            HashSet<String> canCommitIdSet = new HashSet<String>();
            int count = pledgeRevokeBillColl.size();
            for (int i = 0; i < count; ++i) {
                BankPayResult resultInfo;
                PledgeRevokeBillInfo pledgeRevokeBillInfo = pledgeRevokeBillColl.get(i);
                if (pledgeRevokeBillInfo.getBillMediumEnum() != BillMediumEnum.ELECTRONIC) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(pledgeRevokeBillInfo.getId().toString());
                    resultInfo.setNumber(pledgeRevokeBillInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u7535\u7968\u624d\u53ef\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (pledgeRevokeBillInfo.getBillStatus() != FinBillStatusEnum.AUDITED) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(pledgeRevokeBillInfo.getId().toString());
                    resultInfo.setNumber(pledgeRevokeBillInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u5ba1\u6279\u72b6\u6001\u7684\u8d28\u62bc\u5355\u624d\u53ef\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (pledgeRevokeBillInfo.isCommitedToBE() && this.existBankReturnStatus(pledgeRevokeBillInfo)) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(pledgeRevokeBillInfo.getId().toString());
                    resultInfo.setNumber(pledgeRevokeBillInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (pledgeRevokeBillInfo.isCommitedToBE()) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(pledgeRevokeBillInfo.getId().toString());
                    resultInfo.setNumber(pledgeRevokeBillInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u5df2\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                canCommitIdSet.add(pledgeRevokeBillInfo.getId().toString());
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            ArrayList commitResult = PledgeRevokeBillFactory.getRemoteInstance().commitToBE(canCommitIdSet, "");
            commitResult.addAll(resultLockList);
            if (commitResult.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
            } else {
                StringBuffer errorDetail = new StringBuffer();
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"629_PledgeRevokeBillListUI"));
                for (int j = 0; j < commitResult.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)commitResult.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    errorDetail.append(resultInfo.getNumber()).append(":  ");
                    errorDetail.append(resultInfo.getErrorDetail());
                    errorDetail.append("\n");
                }
                int all = idList.size();
                int error = commitResult.size();
                BigDecimal succ = new BigDecimal(all).subtract(new BigDecimal(error));
                MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"607_EndorsementBillListUI") + succ + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"630_PledgeRevokeBillListUI") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"631_PledgeRevokeBillListUI")), (String)errorDetail.toString(), (int)0);
            }
        }
        finally {
            ArrayList list = new ArrayList(idSet);
            iMutex.batchReleaseObjIDForUpdate(list);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSyncStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IPledgeRevokeBill iPledgeRevokeBill = PledgeRevokeBillFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("CommitedToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            PledgeRevokeBillCollection coll = iPledgeRevokeBill.getPledgeRevokeBillCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                PledgeRevokeBillInfo info = coll.get(i);
                if (info.isCommitedToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iPledgeRevokeBill.syncStatus(idSet, "");
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }

    private List<Map<String, Object>> getBEExceptionColl(PledgeRevokeBillEntryCollection coll) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = coll.get(i);
            if (pledgeRevokeBillEntryInfo.getBankReturnStatus() == null || pledgeRevokeBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", pledgeRevokeBillEntryInfo.getReceivableBill().getId().toString());
            map.put("draftNumber", pledgeRevokeBillEntryInfo.getReceivableBill().getDraftNumber());
            list.add(map);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionChangeStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add(new SelectorItemInfo("entrys.*"));
                sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
                PledgeRevokeBillInfo info = ((IPledgeRevokeBill)this.getBizInterface()).getPledgeRevokeBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), sic);
                if (!this.existBEException(info)) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"054_CANNOT_EIDTSTATUS"));
                    SysUtil.abort();
                }
                int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
                boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
                if (EBSstatus != 1 || !isContain) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                    SysUtil.abort();
                }
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"InitDataObject", this.getBEExceptionColl(info.getEntrys()));
                String uiName = DraftUpdateStatusListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                List<Map<String, Object>> statusList = ((DraftUpdateStatusListUI)uiWindow.getUIObject()).getStatusList();
                if (statusList == null) {
                    return;
                }
                PledgeRevokeBillFactory.getRemoteInstance().editStatus(statusList);
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"063_EDITBESTATUS_SUCCESS"));
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    protected ArrayList getSelectedEntryIdValues() {
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
            this.tblMain.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getEntriesPKName(), selectList, selectKeyIdFields);
    }

    public String getEntriesPKName() {
        return "entryID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevokeCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIDs = this.getSelectedIdValues();
        if (selectedIDs.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        }
        String id = selectedIDs.get(0).toString();
        ArrayList idList = this.getSelectedEntryIdValues();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map imutexMap = iMutex.batchRequestObjIDForUpdate((List)idList);
            PledgeRevokeBillEntryCollection billEntrys = this.getPledgeRevokeBillEntryColl(idList);
            int count = billEntrys.size();
            for (int i = 0; i < count; ++i) {
                PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = billEntrys.get(i);
                Boolean boolResult = (Boolean)imutexMap.get(pledgeRevokeBillEntryInfo.getId().toString());
                if (!boolResult.booleanValue()) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if (pledgeRevokeBillEntryInfo.isRevokeCancel()) {
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"632_PledgeRevokeBillListUI") + pledgeRevokeBillEntryInfo.getReceivableBill().getDraftNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"633_PledgeRevokeBillListUI")));
                    SysUtil.abort();
                }
                if (!pledgeRevokeBillEntryInfo.getParent().isCommitedToBE()) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"wageNoteCancle"));
                    SysUtil.abort();
                }
                if (!ElecBillStatusEnum.NT190006.equals((Object)pledgeRevokeBillEntryInfo.getElecBillStatus())) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"632_PledgeRevokeBillListUI") + pledgeRevokeBillEntryInfo.getReceivableBill().getDraftNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"634_PledgeRevokeBillListUI")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            try {
                ((IPledgeRevokeBill)this.getBizInterface()).noteCancels((IObjectPK)new ObjectUuidPK(id), new HashSet(idList));
            }
            catch (BOSException ex) {
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            catch (EASBizException ex) {
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"155_NoteCancle"));
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate((List)idList);
        }
    }

    protected PledgeRevokeBillEntryCollection getPledgeRevokeBillEntryColl(ArrayList idList) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("parent.CommitedToBE"));
        sic.add(new SelectorItemInfo("parent.institution.*"));
        view.setSelector(sic);
        PledgeRevokeBillEntryCollection coll = new PledgeRevokeBillEntryCollection();
        try {
            coll = PledgeRevokeBillEntryFactory.getRemoteInstance().getPledgeRevokeBillEntryCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return coll;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PledgeRevokeFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PledgeRevokeBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PledgeRevokeBillEditUI.class.getName();
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "company.name", "billMediumEnum", "billStatus", "applyDate", "currency.name", "amount", "totalBillAmount", "instution", "fivouchered", "voucherNumber", "digest", "commitBE", "localAmount"};
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IPledgeRevokeBill factory = PledgeRevokeBillFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set ids = FMHelper.list2Set((List)this.getSelectedIdValues());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(this.getSelectors());
        PledgeRevokeBillCollection coll = factory.getPledgeRevokeBillCollection(ev);
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            if (info.getBillStatus() != FinBillStatusEnum.AUDITED) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"635_PledgeRevokeBillListUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IPledgeRevokeBill factory = PledgeRevokeBillFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Set ids = FMHelper.list2Set((List)this.getSelectedIdValues());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(this.getSelectors());
        PledgeRevokeBillCollection coll = factory.getPledgeRevokeBillCollection(ev);
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            if (info.getBillStatus() != FinBillStatusEnum.AUDITED) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"636_PledgeRevokeBillListUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.wageId.*"));
        return sic;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.isShowEntry = ((PledgeRevokeParam)param).isIsShowEntry();
        super.executeQuery(param);
    }

    protected void refreshEntry() {
        String[] hideEntryRows = new String[]{"receivableBill.draftNumber", "receivableBill.billMedium", "receivableBill.billAmt", "receivableBill.takeDate", "receivableBill.deliverName", "receivableBill.issuesDate", "receivableBill.expiredDate", "receivableBill.drawerName", "entrys.elecBillStatus", "entrys.bankReturnStatus", "entrys.bankReturnMsg", "entrys.revokeCancel", "entrys.revokeCancelSucceed", "noteStatus", "cirStatus"};
        int n = hideEntryRows.length;
        for (int i = 0; i < n; ++i) {
            if (this.tblMain.getColumn(hideEntryRows[i]) == null) continue;
            this.tblMain.getColumn(hideEntryRows[i]).getStyleAttributes().setHided(!this.isShowEntry);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refreshEntry();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshEntry();
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnRemove, new FMToolTipInfo("btnRemove", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"PledgeRevokeBillListUI_btnRemove"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnRevokeCancel, new FMToolTipInfo("btnRevokeCancel", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"PledgeRevokeBillListUI_btnRevokeCancel"), ""));
    }
}

