/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFmMbgUsed;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FundBgF7TableManager;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeBatchBookUI;
import com.kingdee.eas.fm.nt.client.RecChequeTDDelegate;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class RecChequeBatchBookUI
extends AbstractRecChequeBatchBookUI {
    private final CompanyOrgUnitInfo currentCompany;
    private final CurrencyInfo currency;
    private final NTTypeInfo nttype;
    private RecChequeCollection editDatas = new RecChequeCollection();
    private RecChequeCollection recordeditDatas = new RecChequeCollection();
    private TableBindHandler tableHandler = new TableBindHandler();
    private static final Color normal = new Color(0xF9F9F9);
    private static final Color must = new Color(0xF6F6BF);
    private static final Color disable = new Color(0xE8E8E3);
    private FundBgF7TableManager fundBgTable = new FundBgF7TableManager();

    public RecChequeBatchBookUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.currency = this.currentCompany.getBaseCurrency().getId() != null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId())) : null;
        this.nttype = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)new ObjectUuidPK("OQePRQEZEADgAgQrwKg9FByakBM="));
    }

    public void onLoad() throws Exception {
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.initTable();
        super.onLoad();
        IRow row = this.tblMain.addRow();
        this.tableHandler.loadLineFields(this.tblMain, row, (IObjectValue)this.editData);
        this.editDatas.add(this.editData);
        this.initRowState(row);
        this.storeFields();
        this.setBizActionState(false);
        this.MenuItemView.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.bgViewBg.setVisible(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.initFpOrBgF7Item((boolean)false, (IColumn)this.tblMain.getColumn("project"), (IColumn)this.tblMain.getColumn("bgItem"));
    }

    @Override
    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.editData.setCompany(this.currentCompany);
        FMClientHelper.viewBgBalance((Component)((Object)this), (IObjectValue)this.editData);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(true);
        this.actionEdit.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.actionViewBdgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCopyRow.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
    }

    protected IObjectValue createNewData() {
        RecChequeInfo objectValue = new RecChequeInfo();
        objectValue.setCompany(this.currentCompany);
        objectValue.setCurrency(this.currency);
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = DateTimeUtils.truncateDate((Date)new Date());
        objectValue.setReceiveDate(date);
        objectValue.setIssueDate(date);
        objectValue.setExpiredDate(DateTimeUtils.addDay((Date)date, (long)10L));
        objectValue.setIsQuota(false);
        objectValue.setReceipt(false);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecChequeFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
            RecChequeInfo info = this.editDatas.get(j);
            FMClientHelper.loadFieldsBgItem((ICell)this.tblMain.getRow(j).getCell("bgItem"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        }
        this.fundBgTable.initFundBgF7((CoreUI)this, this.currentCompany.getId().toString(), this.tblMain, "bgItem", "fundFlowItem", "extendItem", FundFlowDirection.IN);
        this.fundBgTable.loadFields((IObjectCollection)this.editDatas);
        this.tableHandler.bindDataToTable(this.tblMain, (IObjectCollection)this.editDatas);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("isReceipt").setValue((Object)this.editDatas.get(i).isReceipt());
            this.tblMain.getRow(i).getCell("payer").setValue(this.getPayer(i));
            this.tblMain.getRow(i).getCell("remitter").setValue(this.getRemitter(i));
            this.initRowState(this.tblMain.getRow(i));
        }
    }

    @Override
    public void storeFields() {
        RecChequeInfo info;
        int j;
        for (j = 0; j < this.tblMain.getRowCount(); ++j) {
            info = this.editDatas.get(j);
            if (info == null) continue;
            FMClientHelper.storeFieldsBgItem((ICell)this.tblMain.getRow(j).getCell("bgItem"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        }
        this.fundBgTable.storeFields((IFmMbgUsed)this.editData, (IObjectCollection)this.editDatas);
        super.storeFields();
        this.tableHandler.bindTableToData(this.tblMain, (IObjectCollection)this.editDatas, RecChequeInfo.class.getName());
        for (int i = 0; i < this.editDatas.size(); ++i) {
            this.editDatas.get(i).setReceipt(this.editDatas.get(i).getBoolean("receipt"));
            this.setPayer(this.tblMain.getRow(i), i);
            this.setRemitter(this.tblMain.getRow(i), i);
        }
        for (j = 0; j < this.tblMain.getRowCount(); ++j) {
            info = this.editDatas.get(j);
            if (info == null) continue;
            FMClientHelper.storeFieldsBgItem((ICell)this.tblMain.getRow(j).getCell("bgItem"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        super.verifyInput(e);
        int rowCount = this.tblMain.getRowCount();
        int colCount = this.tblMain.getColumnCount();
        if (rowCount <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"315_RecChequeBatchBookUI"));
            SysUtil.abort();
        }
        IRow headRow = this.tblMain.getHeadRow(0);
        for (i = 0; i < rowCount; ++i) {
            this.checkFinalCheckout((Date)this.tblMain.getRow(i).getCell("receiptDate").getValue());
            for (int j = 0; j < colCount; ++j) {
                Object v;
                ICell cell = this.tblMain.getRow(i).getCell(j);
                if (!cell.getStyleAttributes().getBackground().equals(must) || (v = cell.getValue()) != null) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"316_RecChequeBatchBookUI");
                msg = MessageFormat.format(msg, i + 1, headRow.getCell(j).getValue().toString());
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
        }
        for (i = 0; i < this.editDatas.size(); ++i) {
            String msg;
            CurrencyInfo currencyInfo;
            RecChequeInfo info = this.editDatas.get(i);
            if (info.getIssueDate().compareTo(info.getExpiredDate()) > 0) {
                String msg2 = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"318_RecChequeBatchBookUI");
                msg2 = MessageFormat.format(msg2, i + 1);
                MsgBox.showInfo((String)msg2);
                SysUtil.abort();
            }
            if (!info.isReceipt()) continue;
            BankInfo bank = this.editData.getPayeeBank();
            AccountBankInfo acct = this.editData.getPayeeBankAcct();
            if (acct != null && bank != null && acct.getBank() != null && !acct.getBank().getId().equals((Object)bank.getId())) {
                throw new NTException(NTException.BANKNOTMATCH);
            }
            CurrencyInfo cur = info.getCurrency();
            if (acct != null && cur != null && (currencyInfo = acct.getCurrency()) instanceof CurrencyInfo && !currencyInfo.getId().equals((Object)cur.getId())) {
                String msg3 = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"319_RecChequeBatchBookUI");
                msg3 = MessageFormat.format(msg3, i + 1);
                MsgBox.showInfo((String)msg3);
                SysUtil.abort();
            }
            if (info.getReceiveDate().compareTo(info.getReceiptDate()) > 0) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"320_RecChequeBatchBookUI");
                msg = MessageFormat.format(msg, i + 1);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (info.getReceiptDate().compareTo(info.getExpiredDate()) > 0) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"321_RecChequeBatchBookUI");
                msg = MessageFormat.format(msg, i + 1);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (!info.isIsQuota() || Constants.ZERO.compareTo(info.getReceiptAmount()) < 0 && info.getReceiptAmount().compareTo(info.getCeiling()) <= 0) continue;
            msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"322_RecChequeBatchBookUI");
            msg = MessageFormat.format(msg, i + 1);
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.checkFinalCheckout((Date)this.tblMain.getRow(i).getCell("receiptDate").getValue());
        }
        super.actionAddNew_actionPerformed(e);
        this.tblMain.removeRows();
        IRow row = this.tblMain.addRow();
        this.tableHandler.loadLineFields(this.tblMain, row, this.createNewData());
        this.initRowState(row);
        this.setBizActionState(false);
        this.tblMain.setEditable(true);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.storeFields();
        this.verifyInput(e);
        this.recordeditDatas = RecChequeFactory.getRemoteInstance().book(this.editDatas);
        this.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
        this.setBizActionState(true);
        this.tblMain.setEditable(false);
        this.storeFields();
        this.initOldData(this.getDataObject());
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < this.recordeditDatas.size(); ++i) {
            if (!this.recordeditDatas.get(i).isReceipt()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"323_RecChequeBatchBookUI"));
                SysUtil.abort();
            }
            if (this.recordeditDatas.get(i).getId() == null) continue;
            idSet.add(this.recordeditDatas.get(i).getId().toString());
        }
        IRecCheque recCheque = RecChequeFactory.getRemoteInstance();
        recCheque.record(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"324_RecChequeBatchBookUI"));
        this.actionRecord.setEnabled(false);
        super.actionRecord_actionPerformed(e);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        IRow row = this.tblMain.addRow();
        this.tableHandler.loadLineFields(this.tblMain, row, this.createNewData());
        this.initRowState(row);
    }

    @Override
    public void actionCopyRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyRow_actionPerformed(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"325_RecChequeBatchBookUI"));
            SysUtil.abort();
        }
        IObjectValue info = this.createNewData();
        int top = this.tblMain.getSelectManager().get().getTop();
        IRow row = this.tblMain.getRow(top);
        this.tableHandler.storeLineFields(this.tblMain, row, info);
        this.setCopyFieldsNull(info);
        row = this.tblMain.addRow();
        this.tableHandler.loadLineFields(this.tblMain, row, info);
        this.initRowState(row);
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelRow_actionPerformed(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"325_RecChequeBatchBookUI"));
            SysUtil.abort();
        }
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        this.tblMain.removeRow(index);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertRow_actionPerformed(e);
        IRow row = null;
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            row = this.tblMain.addRow(top);
        } else {
            row = this.tblMain.addRow();
        }
        this.tableHandler.loadLineFields(this.tblMain, row, this.createNewData());
        this.initRowState(row);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editDatas == null || this.editDatas.size() <= 0) {
            return;
        }
        if (this.editDatas.get(0).getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"326_RecChequeBatchBookUI"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.editDatas.size(); ++i) {
            idList.add(this.editDatas.get(i).getId().toString());
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, true);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editDatas == null || this.editDatas.size() <= 0) {
            return;
        }
        if (this.editDatas.get(0).getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"326_RecChequeBatchBookUI"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.editDatas.size(); ++i) {
            idList.add(this.editDatas.get(i).getId().toString());
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, false);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        super.tblMain_editStarting(e);
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (e.getColIndex() == this.tblMain.getColumnIndex("oppAcct")) {
            this.prmtOppAcct_willShow(row);
        } else if (e.getColIndex() == this.tblMain.getColumnIndex("receiptAcct")) {
            this.prmtReceiptAcct_willShow(row);
        } else if (e.getColIndex() == this.tblMain.getColumnIndex("payeeBankAcct")) {
            this.prmtPayeeBankAcct_willShow(row);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.getValue() == null) {
            return;
        }
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("isReceipt")) {
            this.chkIsReceipt_selectChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("isQuota")) {
            this.chkIsQuota_selectChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("payeeBankAcct")) {
            this.prmtBankAcct_dataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("currency")) {
            CurrencyInfo info = this.getCurrency(row);
            this.comboCurrency_itemStateChanged(row, info);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("ntType")) {
            this.comboNtType_dataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("amount")) {
            this.txtAmount_dataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("issueDate")) {
            this.pkIssueDate_dataChanged(row);
        } else if (this.tblMain.getColumnKey(e.getColIndex()).equals("payer")) {
            this.prmtPayer_dateChanged(row);
        }
    }

    private void initTable() throws Exception {
        this.tblMain.putBindContents("editData", this.getTableBindingFields());
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.setActiveCellStatus(1);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                IRow row = RecChequeBatchBookUI.this.tblMain.getRow(RecChequeBatchBookUI.this.tblMain.getSelectManager().getActiveRowIndex() + 1);
                RecChequeBatchBookUI.this.tableHandler.loadLineFields(RecChequeBatchBookUI.this.tblMain, row, RecChequeBatchBookUI.this.createNewData());
                RecChequeBatchBookUI.this.initRowState(row);
            }
        });
        int pre = this.currency.getPrecision();
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "receiptAmount", pre);
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isReceipt");
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isQuota");
        this.initTableComboField();
        this.initTableDateField();
        this.initTableF7Field();
        String[] fields = this.getRequiedFieldName();
        for (int i = 0; i < fields.length; ++i) {
            this.tblMain.getColumn(fields[i]).getStyleAttributes().setBackground(must);
        }
    }

    private void initTableDateField() {
        RecChequeUtil.initDateCell(this.tblMain, "receiveDate");
        RecChequeUtil.initDateCell(this.tblMain, "issueDate");
        RecChequeUtil.initDateCell(this.tblMain, "expireDate");
        RecChequeUtil.initDateCell(this.tblMain, "receiptDate");
    }

    private void initTableComboField() throws BOSException, EASBizException {
        KDComboBox comboNtType = RecChequeUtil.initComboBoxCell(this.tblMain, "ntType");
        KDComboBox comboCurrency = RecChequeUtil.initComboBoxCell(this.tblMain, "currency");
        RecChequeUtil.initComboNtType(comboNtType);
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency);
    }

    private void initTableF7Field() throws Exception {
        KDBizPromptBox prmtRemitter = RecChequeUtil.initF7Cell(this.tblMain, "remitter");
        KDBizPromptBox prmtPayeeBank = RecChequeUtil.initF7Cell(this.tblMain, "payeeBank");
        KDBizPromptBox prmtPayeeBankAcct = RecChequeUtil.initF7Cell(this.tblMain, "payeeBankAcct");
        KDBizPromptBox prmtPayer = RecChequeUtil.initF7Cell(this.tblMain, "payer");
        KDBizPromptBox prmtDealer = RecChequeUtil.initF7Cell(this.tblMain, "dealer");
        KDBizPromptBox prmtDepartment = RecChequeUtil.initF7Cell(this.tblMain, "department");
        KDBizPromptBox prmtOppAcct = RecChequeUtil.initF7Cell(this.tblMain, "oppAcct");
        KDBizPromptBox prmtProject = RecChequeUtil.initF7Cell(this.tblMain, "Pproject");
        KDBizPromptBox prmtBgItem = RecChequeUtil.initF7Cell(this.tblMain, "bgItem");
        KDBizPromptBox prmtReceiptAcct = RecChequeUtil.initF7Cell(this.tblMain, "receiptAcct");
        RecChequeUtil.initPrmtSupplierCustomer((IUIObject)this, prmtPayer, this.currentCompany);
        RecChequeUtil.initPrmtAdminOrg((IUIObject)this, prmtDepartment);
        RecChequeUtil.initPrmtPerson((IUIObject)this, prmtDealer);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)prmtPayeeBank);
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, prmtPayeeBankAcct, this.currentCompany, null, null);
        RecChequeUtil.initPrmtSupplierCustomer((IUIObject)this, prmtRemitter, this.currentCompany);
        RecChequeUtil.initPrmtAcctView((IUIObject)this, prmtOppAcct, this.currentCompany, this.currency.getId().toString(), false);
        RecChequeUtil.initPrmtAcctView((IUIObject)this, prmtReceiptAcct, this.currentCompany, this.currency.getId().toString(), true);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
    }

    private String[] getRequiedFieldName() {
        return new String[]{"ntType", "number", "currency", "issueDate", "receiveDate", "expireDate", "payerBank", "remitter", "amount"};
    }

    private String[] getTableBindingFields() {
        return new String[]{"receiveDate", "payer", "payerBankAcct", "remitter", "payerBank", "ntType", "number", "issueDate", "expiredDate", "currency", "isQuota", "ceiling", "amount", "usage", "department", "dealer", "receipt", "receiptAmount", "receiptDate", "payeeBankAcct", "payeeBank", "receiptAcct", "oppAcct", "bgItem", "Pproject", "description", "id"};
    }

    private void setBizActionState(boolean isSaved) {
        if (isSaved) {
            this.actionSubmit.setEnabled(false);
            this.actionAddRow.setEnabled(false);
            this.actionInsertRow.setEnabled(false);
            this.actionCopyRow.setEnabled(false);
            this.actionDelRow.setEnabled(false);
            this.actionRecord.setEnabled(true);
            this.tblMain.getStyleAttributes().setLocked(true);
            this.tblMain.getSelectManager().setSelectMode(2);
        } else {
            this.tblMain.getStyleAttributes().setLocked(false);
            this.tblMain.getSelectManager().setSelectMode(1);
            this.actionSubmit.setEnabled(true);
            this.actionAddRow.setEnabled(true);
            this.actionInsertRow.setEnabled(true);
            this.actionCopyRow.setEnabled(true);
            this.actionDelRow.setEnabled(true);
            this.actionRecord.setEnabled(false);
        }
        this.actionTDPrint.setVisible(false);
        this.actionTDPrintPreview.setVisible(false);
    }

    private void chkIsReceipt_selectChanged(IRow row) {
        boolean isQuota = this.getIsQuota(row);
        boolean isCash = this.getIsCash(row);
        boolean isReceipt = this.getIsReceipt(row);
        BigDecimal amount = this.getAmount(row);
        this.updateReceiptFieldState(row, isReceipt, isCash, isQuota, amount);
    }

    private void chkIsQuota_selectChanged(IRow row) {
        ICell cAmount = row.getCell("amount");
        ICell cCeiling = row.getCell("ceiling");
        boolean isQuota = this.getIsQuota(row);
        if (isQuota) {
            cAmount.setValue(null);
            cAmount.getStyleAttributes().setBackground(disable);
            cAmount.getStyleAttributes().setLocked(true);
            cCeiling.getStyleAttributes().setBackground(must);
            cCeiling.getStyleAttributes().setLocked(false);
        } else {
            cAmount.getStyleAttributes().setBackground(must);
            cAmount.getStyleAttributes().setLocked(false);
            cCeiling.setValue(null);
            cCeiling.getStyleAttributes().setBackground(disable);
            cCeiling.getStyleAttributes().setLocked(true);
        }
        boolean isReceipt = this.getIsReceipt(row);
        boolean isCash = this.getIsCash(row);
        BigDecimal amount = this.getAmount(row);
        this.updateReceiptFieldState(row, isReceipt, isCash, isQuota, amount);
    }

    private void txtAmount_dataChanged(IRow row) {
        ICell cAmount = row.getCell("amount");
        ICell cReceiptAmount = row.getCell("receiptAmount");
        boolean isReceipt = this.getIsReceipt(row);
        if (isReceipt && !cAmount.getStyleAttributes().isLocked() && cReceiptAmount.getStyleAttributes().isLocked()) {
            cReceiptAmount.setValue(cAmount.getValue());
        }
    }

    private void comboCurrency_itemStateChanged(IRow row, CurrencyInfo info) {
        if (info != null) {
            int precision = info.getPrecision();
            String currencyFormat = RecChequeUtil.getKDTCurrencyFormat(precision);
            String[] fields = new String[]{"amount", "ceiling", "receiptAmount"};
            for (int i = 0; i < fields.length; ++i) {
                KDTDefaultCellEditor editor = (KDTDefaultCellEditor)this.tblMain.getColumn(fields[i]).getEditor();
                KDFormattedTextField txt = (KDFormattedTextField)editor.getComponent();
                txt.setPrecision(precision);
                ICell cAmount = row.getCell(fields[i]);
                cAmount.getStyleAttributes().setNumberFormat(currencyFormat);
            }
        }
    }

    private void pkIssueDate_dataChanged(IRow row) {
        Date date = this.getDate(row, "issueDate");
        if (date != null) {
            row.getCell("expireDate").setValue((Object)DateTimeUtils.addDay((Date)date, (long)10L));
        }
    }

    private void prmtBankAcct_dataChanged(IRow row) throws EASBizException, BOSException {
        AccountBankInfo info = this.getBankAcct(row);
        boolean isCash = this.getIsCash(row);
        if (info == null) {
            return;
        }
        if (info.getBank().getId() != null) {
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(info.getBank().getId()));
            row.getCell("payeeBank").setValue((Object)bank);
        }
        if (!isCash && info.getAccount().getId() != null) {
            AccountViewInfo acctView = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccount().getId()));
            row.getCell("receiptAcct").setValue((Object)acctView);
        }
    }

    private void comboNtType_dataChanged(IRow row) {
        BigDecimal amount = this.getAmount(row);
        boolean isQuota = this.getIsQuota(row);
        boolean isReceipt = this.getIsReceipt(row);
        boolean isCash = this.getIsCash(row);
        this.updateReceiptFieldState(row, isReceipt, isCash, isQuota, amount);
    }

    private void prmtPayer_dateChanged(IRow row) throws EASBizException, BOSException {
        ICell cPayer = row.getCell("payer");
        ICell cRemitter = row.getCell("remitter");
        ICell cPayerBank = row.getCell("payerBank");
        ICell cPayerBankAcct = row.getCell("payerBankAcct");
        Object c = cPayer.getValue();
        if (c instanceof SupplierInfo) {
            SupplierInfo info = (SupplierInfo)c;
            cRemitter.setValue((Object)info);
            CSBankInfo cs = FMHelper.getCSBankInfo(null, (Object)info, (String)this.currentCompany.getId().toString());
            cPayerBank.setValue((Object)cs.getBank());
            cPayerBankAcct.setValue((Object)cs.getBankAccount());
        } else if (c instanceof CustomerInfo) {
            CustomerInfo info = (CustomerInfo)c;
            cRemitter.setValue((Object)info);
            CSBankInfo cs = FMHelper.getCSBankInfo(null, (Object)info, (String)this.currentCompany.getId().toString());
            cPayerBank.setValue((Object)cs.getBank());
            cPayerBankAcct.setValue((Object)cs.getBankAccount());
        } else if (c instanceof String) {
            cRemitter.setValue(c);
        }
    }

    private void prmtPayeeBankAcct_willShow(IRow row) throws Exception {
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        BankInfo bank = this.getBank(row);
        CurrencyInfo currency = this.getCurrency(row);
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, box, this.currentCompany, bank, currency);
    }

    private void prmtOppAcct_willShow(IRow row) throws EASBizException, BOSException {
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        CurrencyInfo info = this.getCurrency(row);
        String currencyId = info == null ? this.currency.getId().toString() : info.getId().toString();
        RecChequeUtil.initPrmtAcctView((IUIObject)this, box, this.currentCompany, currencyId, false);
    }

    private void prmtReceiptAcct_willShow(IRow row) throws EASBizException, BOSException {
        KDBizPromptBox box = (KDBizPromptBox)this.tblMain.getEditManager().getEditorComponent();
        CurrencyInfo info = this.getCurrency(row);
        String currencyId = info == null ? this.currency.getId().toString() : info.getId().toString();
        RecChequeUtil.initPrmtAcctView((IUIObject)this, box, this.currentCompany, currencyId, true);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.checkFinalCheckout((Date)this.tblMain.getRow(i).getCell("receiptDate").getValue());
        }
        super.actionSave_actionPerformed(e);
        this.tblMain.setEditable(false);
    }

    private void initRowState(IRow row) {
        this.chkIsQuota_selectChanged(row);
        this.chkIsReceipt_selectChanged(row);
        CurrencyInfo currencyInfo = (CurrencyInfo)row.getCell("currency").getValue();
        NTTypeInfo nttypeInfo = (NTTypeInfo)row.getCell("ntType").getValue();
        if (row.getCell("number").getValue() == null) {
            this.initNumber(row.getCell("number"), null);
        }
        if (currencyInfo == null) {
            row.getCell("currency").setValue((Object)this.currency);
            currencyInfo = this.currency;
        }
        if (nttypeInfo == null) {
            row.getCell("ntType").setValue((Object)this.nttype);
        }
        this.comboCurrency_itemStateChanged(row, currencyInfo);
    }

    private void updateReceiptFieldState(IRow row, boolean isReceipt, boolean isCash, boolean isQuato, BigDecimal amount) {
        if (isReceipt) {
            this.setReceiptFieldEnable(row, isCash, isQuato, amount);
        } else {
            this.setReceiptFieldDisable(row, true);
        }
    }

    private void setReceiptFieldEnable(IRow row, boolean isCash, boolean isQuato, BigDecimal amount) {
        ICell cReceiptDate = row.getCell("receiptDate");
        ICell cReceiptAmount = row.getCell("receiptAmount");
        ICell cPayeeBankAcct = row.getCell("payeeBankAcct");
        ICell cPayeeBank = row.getCell("payeeBank");
        ICell cReceiptAcct = row.getCell("receiptAcct");
        ICell cOppAcct = row.getCell("oppAcct");
        ICell cProject = row.getCell("Pproject");
        ICell cBgItem = row.getCell("bgItem");
        ICell cDescription = row.getCell("description");
        if (isCash) {
            cReceiptDate.getStyleAttributes().setLocked(false);
            cReceiptDate.getStyleAttributes().setBackground(must);
            cReceiptAmount.getStyleAttributes().setLocked(false);
            cReceiptAmount.getStyleAttributes().setBackground(must);
            cPayeeBankAcct.getStyleAttributes().setLocked(true);
            cPayeeBankAcct.getStyleAttributes().setBackground(disable);
            cPayeeBank.getStyleAttributes().setLocked(true);
            cPayeeBank.getStyleAttributes().setBackground(disable);
            cReceiptAcct.getStyleAttributes().setLocked(false);
            cReceiptAcct.getStyleAttributes().setBackground(must);
            cOppAcct.getStyleAttributes().setLocked(false);
            cOppAcct.getStyleAttributes().setBackground(normal);
            cProject.getStyleAttributes().setLocked(false);
            cProject.getStyleAttributes().setBackground(normal);
            cBgItem.getStyleAttributes().setLocked(false);
            cBgItem.getStyleAttributes().setBackground(normal);
            cDescription.getStyleAttributes().setLocked(false);
            cDescription.getStyleAttributes().setBackground(normal);
        } else {
            cReceiptDate.getStyleAttributes().setLocked(false);
            cReceiptDate.getStyleAttributes().setBackground(must);
            cReceiptAmount.getStyleAttributes().setLocked(false);
            cReceiptAmount.getStyleAttributes().setBackground(must);
            cPayeeBankAcct.getStyleAttributes().setLocked(false);
            cPayeeBankAcct.getStyleAttributes().setBackground(must);
            cPayeeBank.getStyleAttributes().setLocked(false);
            cPayeeBank.getStyleAttributes().setBackground(must);
            cReceiptAcct.getStyleAttributes().setLocked(true);
            cReceiptAcct.getStyleAttributes().setBackground(disable);
            cOppAcct.getStyleAttributes().setLocked(false);
            cOppAcct.getStyleAttributes().setBackground(normal);
            cProject.getStyleAttributes().setLocked(false);
            cProject.getStyleAttributes().setBackground(normal);
            cBgItem.getStyleAttributes().setLocked(false);
            cBgItem.getStyleAttributes().setBackground(normal);
            cDescription.getStyleAttributes().setLocked(false);
            cDescription.getStyleAttributes().setBackground(normal);
        }
        if (amount != null && !isQuato) {
            cReceiptAmount.setValue((Object)amount);
            cReceiptAmount.getStyleAttributes().setLocked(true);
            cReceiptAmount.getStyleAttributes().setBackground(disable);
        } else if (amount == null && !isQuato) {
            cReceiptAmount.setValue((Object)Constants.ZERO);
            cReceiptAmount.getStyleAttributes().setLocked(true);
            cReceiptAmount.getStyleAttributes().setBackground(disable);
        }
    }

    private void setReceiptFieldDisable(IRow row, boolean setNull) {
        ICell cReceiptDate = row.getCell("receiptDate");
        ICell cReceiptAmount = row.getCell("receiptAmount");
        ICell cPayeeBankAcct = row.getCell("payeeBankAcct");
        ICell cPayeeBank = row.getCell("payeeBank");
        ICell cReceiptAcct = row.getCell("receiptAcct");
        ICell cOppAcct = row.getCell("oppAcct");
        ICell cBgItem = row.getCell("bgItem");
        ICell cProject = row.getCell("Pproject");
        ICell cDescription = row.getCell("description");
        cReceiptDate.getStyleAttributes().setLocked(true);
        cReceiptAmount.getStyleAttributes().setLocked(true);
        cPayeeBankAcct.getStyleAttributes().setLocked(true);
        cPayeeBank.getStyleAttributes().setLocked(true);
        cReceiptAcct.getStyleAttributes().setLocked(true);
        cOppAcct.getStyleAttributes().setLocked(true);
        cBgItem.getStyleAttributes().setLocked(true);
        cProject.getStyleAttributes().setLocked(true);
        cDescription.getStyleAttributes().setLocked(true);
        cReceiptDate.getStyleAttributes().setBackground(disable);
        cReceiptAmount.getStyleAttributes().setBackground(disable);
        cPayeeBankAcct.getStyleAttributes().setBackground(disable);
        cPayeeBank.getStyleAttributes().setBackground(disable);
        cReceiptAcct.getStyleAttributes().setBackground(disable);
        cOppAcct.getStyleAttributes().setBackground(disable);
        cBgItem.getStyleAttributes().setBackground(disable);
        cProject.getStyleAttributes().setBackground(disable);
        cDescription.getStyleAttributes().setBackground(disable);
        if (setNull) {
            cReceiptDate.setValue(null);
            cReceiptAmount.setValue(null);
            cPayeeBankAcct.setValue(null);
            cPayeeBank.setValue(null);
            cReceiptAcct.setValue(null);
            cOppAcct.setValue(null);
            cBgItem.setValue(null);
            cProject.setValue(null);
            cDescription.setValue(null);
        }
    }

    private boolean getIsCash(IRow row) {
        boolean isCash = true;
        Object c = row.getCell("ntType").getValue();
        if (c instanceof NTTypeInfo) {
            NTTypeInfo nt = (NTTypeInfo)c;
            isCash = nt.isIsCash();
        }
        return isCash;
    }

    private boolean getIsQuota(IRow row) {
        boolean isQuota = false;
        Object value = row.getCell("isQuota").getValue();
        if (value instanceof Boolean) {
            isQuota = (Boolean)value;
        } else if (value instanceof Integer) {
            isQuota = new Integer(0).compareTo((Integer)value) != 0;
        }
        return isQuota;
    }

    private BigDecimal getAmount(IRow row) {
        BigDecimal amount = null;
        Object c = row.getCell("amount").getValue();
        if (c instanceof BigDecimal) {
            amount = (BigDecimal)c;
        }
        return amount;
    }

    private boolean getIsReceipt(IRow row) {
        boolean isReceipt = false;
        Object value = row.getCell("isReceipt").getValue();
        if (value instanceof Boolean) {
            isReceipt = (Boolean)value;
        } else if (value instanceof Integer) {
            isReceipt = new Integer(0).compareTo((Integer)value) != 0;
        }
        return isReceipt;
    }

    private CurrencyInfo getCurrency(IRow row) {
        CurrencyInfo info = null;
        Object c = row.getCell("currency").getValue();
        if (c instanceof CurrencyInfo) {
            info = (CurrencyInfo)c;
        }
        return info;
    }

    private AccountBankInfo getBankAcct(IRow row) {
        AccountBankInfo info = null;
        Object c = row.getCell("payeeBankAcct").getValue();
        if (c instanceof AccountBankInfo) {
            info = (AccountBankInfo)c;
        }
        return info;
    }

    private BankInfo getBank(IRow row) {
        BankInfo info = null;
        Object c = row.getCell("payeeBank").getValue();
        if (c instanceof BankInfo) {
            info = (BankInfo)c;
        }
        return info;
    }

    private Date getDate(IRow row, String name) {
        Date date = null;
        Object c = row.getCell(name).getValue();
        if (c instanceof Date) {
            date = (Date)c;
        }
        return date;
    }

    private Object getPayer() {
        String c = null;
        if (this.editData.getPayer() != null) {
            c = this.editData.getPayer();
        } else if (this.editData.getPayerS() != null) {
            c = this.editData.getPayerS();
        } else if (this.editData.getPayerC() != null) {
            c = this.editData.getPayerC();
        }
        return c;
    }

    private Object getRemitter(int i) {
        String c = null;
        if (this.editDatas.get(i).getRemitter() != null) {
            c = this.editDatas.get(i).getRemitter();
        } else if (this.editDatas.get(i).getRemitterS() != null) {
            c = this.editDatas.get(i).getRemitterS();
        } else if (this.editDatas.get(i).getRemitterC() != null) {
            c = this.editDatas.get(i).getRemitterC();
        }
        return c;
    }

    private Object getPayer(int i) {
        String c = null;
        if (this.editDatas.get(i).getPayer() != null) {
            c = this.editDatas.get(i).getPayer();
        } else if (this.editDatas.get(i).getPayerS() != null) {
            c = this.editDatas.get(i).getPayerS();
        } else if (this.editDatas.get(i).getPayerC() != null) {
            c = this.editDatas.get(i).getPayerC();
        }
        return c;
    }

    private void setRemitter(IRow row, int i) {
        Object payer = row.getCell("remitter").getValue();
        if (payer instanceof SupplierInfo) {
            this.editDatas.get(i).setRemitterS((SupplierInfo)payer);
            this.editDatas.get(i).setRemitterC(null);
            this.editDatas.get(i).setRemitter(null);
        } else if (payer instanceof CustomerInfo) {
            this.editDatas.get(i).setRemitterC((CustomerInfo)payer);
            this.editDatas.get(i).setRemitterS(null);
            this.editDatas.get(i).setRemitter(null);
        } else if (payer instanceof String) {
            this.editDatas.get(i).setRemitter((String)payer);
            this.editDatas.get(i).setRemitterC(null);
            this.editDatas.get(i).setRemitterS(null);
        }
    }

    private void setPayer(IRow row, int i) {
        Object payer = row.getCell("payer").getValue();
        if (payer instanceof SupplierInfo) {
            this.editDatas.get(i).setPayerS((SupplierInfo)payer);
            this.editDatas.get(i).setPayerC(null);
            this.editDatas.get(i).setPayer(null);
        } else if (payer instanceof CustomerInfo) {
            this.editDatas.get(i).setPayerC((CustomerInfo)payer);
            this.editDatas.get(i).setPayerS(null);
            this.editDatas.get(i).setPayer(null);
        } else if (payer instanceof String) {
            this.editDatas.get(i).setPayer((String)payer);
            this.editDatas.get(i).setPayerC(null);
            this.editDatas.get(i).setPayerS(null);
        }
    }

    private void setCopyFieldsNull(IObjectValue newData) {
        newData.setNull("number");
        newData.setNull("state");
        newData.setNull("endorseDate");
        newData.setNull("endorser");
        newData.setNull("endorserS");
        newData.setNull("endorserC");
        newData.setNull("abandonDate");
        newData.setNull("abandonReason");
        newData.setNull("abandonState");
        newData.setNull("jouranl");
        newData.setBoolean("fivouchered", false);
    }

    private void initNumber(ICell cell, String orgType) {
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                    cell.setValue((Object)iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                }
                cell.getStyleAttributes().setLocked(true);
                cell.getStyleAttributes().setBackground(disable);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            this.oldData = this.editData;
            SysUtil.abort();
        }
    }

    private void checkFinalCheckout(Date receiptDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)receiptDate);
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

