/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.RecChequeStatueEnum;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeFilterUI;
import com.kingdee.eas.fm.nt.client.RecChequeFilterParam;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RecChequeFilterUI
extends AbstractRecChequeFilterUI {
    protected void init() throws Exception {
        super.init();
        this.dpDateFrom.setSupportedEmpty(false);
        this.dpDateTo.setSupportedEmpty(false);
        RecChequeUtil.initPrmtNTType(this.prmtNtType);
        List stateList = RecChequeStatueEnum.getEnumList();
        Iterator it = stateList.iterator();
        while (it.hasNext()) {
            this.comboState.addItem(it.next());
        }
        this.comboState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected void initCompanyState() {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.dpDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpDateTo.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.prmtNtType.setValue(null);
        this.comboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpDateFrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpDateTo);
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.dpDateFrom, (KDDatePicker)this.dpDateTo);
        return super.verify();
    }

    public Object getParam() {
        RecChequeFilterParam param = new RecChequeFilterParam();
        param.setDateFrom(this.dpDateFrom.getSqlDate());
        param.setDateTo(this.dpDateTo.getSqlDate());
        if (FMSysDefinedEnum.SELECT_ALL.equals(this.comboState.getSelectedItem())) {
            param.setState(null);
        } else {
            param.setState((RecChequeStatueEnum)((Object)this.comboState.getSelectedItem()));
        }
        String[] ids = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtNtType);
        if (ids != null && ids.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            param.setNtTypeIds(idSet);
        } else {
            param.setNtTypeIds(null);
        }
        param.setCompanyIdSet(this.getCompanyIdSet());
        return param;
    }

    public void setParam(Object param) {
        if (param instanceof RecChequeFilterParam) {
            RecChequeFilterParam p = (RecChequeFilterParam)((Object)param);
            this.dpDateFrom.setValue((Object)p.getDateFrom());
            this.dpDateTo.setValue((Object)p.getDateTo());
            if (p.getState() == null) {
                this.comboState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)((Object)p.getState()));
            }
            Set ntTypeIds = p.getNtTypeIds();
            if (ntTypeIds != null && ntTypeIds.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)ntTypeIds, CompareType.INCLUDE));
                evi.setFilter(filter);
                try {
                    NTTypeCollection coll = NTTypeFactory.getRemoteInstance().getNTTypeCollection(evi);
                    this.prmtNtType.setValue((Object)coll.toArray());
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            this.setCompanyIdSet(p.getCompanyIdSet());
        }
    }

    public void clear() {
        super.clear();
        try {
            super.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected Class getParamClass() {
        return RecChequeFilterParam.class;
    }
}

