/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeHelper;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.RecChequeStatueEnum;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeListUI;
import com.kingdee.eas.fm.nt.client.RecChequeAbandonUI;
import com.kingdee.eas.fm.nt.client.RecChequeBatchBookUI;
import com.kingdee.eas.fm.nt.client.RecChequeBookInUI;
import com.kingdee.eas.fm.nt.client.RecChequeEndorseUI;
import com.kingdee.eas.fm.nt.client.RecChequeFilterUI;
import com.kingdee.eas.fm.nt.client.RecChequeReceiptUI;
import com.kingdee.eas.fm.nt.client.RecChequeTDDelegate;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class RecChequeListUI
extends AbstractRecChequeListUI {
    private RecChequeFilterUI filterUI;
    private boolean isCenter;

    public RecChequeListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"amount", "ceiling", "receiptAmount"});
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.isCenter = RecChequeHelper.isClearinghourseCompany(this.currentCompanyCommon);
        this.initTable();
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            this.setBizActionState(false);
        } else {
            this.setBizActionState(true);
        }
        this.btnViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.menuViewBdg.setVisible(true);
        this.onshows();
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionEndorse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_writeatbackin"));
        this.actionAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
        this.actionCancelAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fblankout"));
        this.actionRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionCancelRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionAddBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_newbatch"));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RecChequeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        RecChequeInfo objectValue = new RecChequeInfo();
        return objectValue;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row != null && this.getBOTPViewStatus() == 0) {
            for (int i = 0; i < this.getPrecColName().length; ++i) {
                String curID = this.currentCompanyCommon.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)this.getPrecColName()[i], (String)curID);
            }
        }
        return row;
    }

    protected String[] getPrecColName() {
        return new String[]{"amount"};
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    private void onshows() {
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RecChequeFilterUI();
        }
        return this.filterUI;
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected void execQuery() {
        if (this.currentCompanyCommon.isIsBizUnit() && !this.isCenter) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId()));
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.onshows();
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ntType.*");
        sic.add("currency.*");
        sic.add("Pproject.name");
        sic.add("Pproject.number");
        sic.add("project.number");
        sic.add("project.name");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        return sic;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        return this.getSelectors();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IRecCheque recCheque = (IRecCheque)this.getBizInterface();
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(BOSUuid.read((String)id));
        RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)objectUuidPK);
        this.checkCompany(info);
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionReceipt_actionPerformed(ActionEvent e) throws Exception {
        super.actionReceipt_actionPerformed(e);
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        RecChequeCollection coll = RecChequeFactory.getRemoteInstance().getRecChequeCollection(evi);
        this.checkCompany(coll);
        if (!RecChequeHelper.isCanReceipt(coll)) {
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"RECCHEQUEIDS", (Object)list);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(RecChequeReceiptUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionCancelReceipt_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelReceipt_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IRecCheque recCheque = (IRecCheque)this.getBizInterface();
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(BOSUuid.read((String)id));
        RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)objectUuidPK);
        this.checkCompany(info);
        if (RecChequeHelper.isCanCancelReceipt(info)) {
            recCheque.cancelReceipt((IObjectPK)objectUuidPK);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"337_RecChequeListUI"));
        }
    }

    @Override
    public void actionEndorse_actionPerformed(ActionEvent e) throws Exception {
        super.actionEndorse_actionPerformed(e);
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        RecChequeCollection coll = RecChequeFactory.getRemoteInstance().getRecChequeCollection(evi);
        this.checkCompany(coll);
        if (!RecChequeHelper.isCanEndorse(coll)) {
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"RECCHEQUEIDS", (Object)list);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(RecChequeEndorseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionCancelEndorse_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelEndorse_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IRecCheque recCheque = (IRecCheque)this.getBizInterface();
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(BOSUuid.read((String)id));
        RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)objectUuidPK);
        this.checkCompany(info);
        if (RecChequeHelper.isCanCancelEndorse(info)) {
            recCheque.cancelEndorse((IObjectPK)objectUuidPK);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"337_RecChequeListUI"));
        }
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionRecord_actionPerformed(e);
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        HashSet idSet = new HashSet(list);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        IRecCheque recCheque = RecChequeFactory.getRemoteInstance();
        RecChequeCollection coll = recCheque.getRecChequeCollection(evi);
        this.checkCompany(coll);
        for (int i = 0; i < coll.size(); ++i) {
            if (RecChequeHelper.isCanRecord(coll.get(i))) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"338_RecChequeListUI"));
            SysUtil.abort();
        }
        recCheque.record(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"339_RecChequeListUI"));
        this.refreshList();
    }

    @Override
    public void actionCancelRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelRecord_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IRecCheque recCheque = (IRecCheque)this.getBizInterface();
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(BOSUuid.read((String)id));
        RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)objectUuidPK);
        this.checkCompany(info);
        if (RecChequeHelper.isCanCancelRecord(info)) {
            recCheque.cancelRecord((IObjectPK)objectUuidPK);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"340_RecChequeListUI"));
        }
    }

    @Override
    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbandon_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RecChequeInfo info = ((IRecCheque)this.getBizInterface()).getRecChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.checkCompany(info);
        if (RecChequeHelper.isCanAbandon(info)) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RecChequeAbandonUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"341_RecChequeListUI"));
        }
    }

    @Override
    public void actionCancelAbandon_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAbandon_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        IRecCheque recCheque = (IRecCheque)this.getBizInterface();
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(BOSUuid.read((String)id));
        RecChequeInfo info = recCheque.getRecChequeInfo((IObjectPK)objectUuidPK);
        this.checkCompany(info);
        if (RecChequeHelper.isCanCancelAbandon(info)) {
            recCheque.cancelAbandon((IObjectPK)objectUuidPK);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"342_RecChequeListUI"));
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RecChequeInfo info = ((IRecCheque)this.getBizInterface()).getRecChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.checkCompany(info);
        if (RecChequeHelper.isCanVoucher(info)) {
            super.actionVoucher_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"343_RecChequeListUI"));
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RecChequeInfo info = ((IRecCheque)this.getBizInterface()).getRecChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.checkCompany(info);
        if (RecChequeHelper.isCanCancelVoucher(info)) {
            super.actionDelVoucher_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"344_RecChequeListUI"));
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RecChequeInfo info = ((IRecCheque)this.getBizInterface()).getRecChequeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.checkCompany(info);
        if (RecChequeHelper.isCanRemove(info)) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"345_RecChequeListUI"));
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, true);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, false);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"RECCHEQUEID", (Object)id);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RecChequeBookInUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBatch_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RecChequeBatchBookUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            this.setBizActionState(false);
            return;
        }
        String selectedKeyValue = this.getSelectedKeyValue();
        if (selectedKeyValue == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectedKeyValue));
        RecChequeInfo info = RecChequeFactory.getRemoteInstance().getRecChequeInfo((IObjectPK)pk);
        this.actionEdit.setEnabled(!RecChequeHelper.isAlreadyGenBill(info) && !RecChequeHelper.isCanCancelAbandon(info));
        this.actionRemove.setEnabled(RecChequeHelper.isCanRemove(info));
        this.actionReceipt.setEnabled(RecChequeHelper.isCanReceipt(info));
        this.actionCancelReceipt.setEnabled(RecChequeHelper.isCanCancelReceipt(info));
        this.actionEndorse.setEnabled(RecChequeHelper.isCanEndorse(info));
        this.actionCancelEndorse.setEnabled(RecChequeHelper.isCanCancelEndorse(info));
        this.actionRecord.setEnabled(RecChequeHelper.isCanRecord(info));
        this.actionCancelRecord.setEnabled(RecChequeHelper.isCanCancelRecord(info));
        this.actionVoucher.setEnabled(RecChequeHelper.isCanVoucher(info));
        this.actionDelVoucher.setEnabled(RecChequeHelper.isCanCancelVoucher(info));
        this.actionAbandon.setEnabled(RecChequeHelper.isCanAbandon(info));
        this.actionCancelAbandon.setEnabled(RecChequeHelper.isCanCancelAbandon(info));
        this.actionTDPrint.setEnabled(RecChequeHelper.isCanTDPrint(info));
        this.actionTDPrintPreview.setEnabled(RecChequeHelper.isCanTDPrint(info));
    }

    private void initTable() {
        this.tblMain.getColumn("issueDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("expiredDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("receiveDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("receiptDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("endorseDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("abandonDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("number").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("payerBank").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("payeeBankAcct").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("payeeBank").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("remitter").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("payer").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("department").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("dealer").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("Pproject").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("bgItem").getStyleAttributes().setNumberFormat("@");
    }

    private void setBizActionState(boolean state) {
        Action[] actions = new Action[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionReceipt, this.actionCancelReceipt, this.actionEndorse, this.actionCancelEndorse, this.actionRecord, this.actionCancelRecord, this.actionVoucher, this.actionDelVoucher, this.actionAbandon, this.actionCancelAbandon};
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setEnabled(state);
        }
    }

    private void checkCompany(RecChequeInfo info) {
        if (this.isCenter && !RecChequeHelper.isOwnCompany(info, this.currentCompanyCommon)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"346_RecChequeListUI");
            msg = MessageFormat.format(msg, info.getNumber());
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    private void checkCompany(RecChequeCollection coll) {
        if (coll == null || coll.size() <= 0) {
            return;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this.checkCompany(coll.get(i));
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        String df = null;
        if (this.getSelectedFieldValues("state").size() != 0) {
            df = RecChequeStatueEnum.ENDORSE.equals(this.getSelectedFieldValues("state").get(0)) ? "endorsedate" : "receiptDate";
        }
        return df;
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove"};
    }
}

