/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.message.util.DateUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecChequeTDDelegate
implements BOSQueryDelegate {
    private static final Logger logger = CoreUIObject.getLogger(RecChequeTDDelegate.class);
    public static final IMetaDataPK pk = new MetaDataPK("com.kingdee.eas.fm.nt.app.RecChequeTDQuery");
    private final Set ids;
    private final boolean isShowInfo;

    public RecChequeTDDelegate(Set id, boolean isShowInfo) {
        this.ids = id;
        this.isShowInfo = isShowInfo;
    }

    public RecChequeTDDelegate(List id, boolean isShowInfo) {
        this.ids = new HashSet(id);
        this.isShowInfo = isShowInfo;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            ArrayList param = ds.getParams();
            FMHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            logger.info((Object)exec.getSQL());
            iRowSet = exec.executeQuery();
            if (this.isShowInfo) {
                this.showInfo(iRowSet);
            }
            BigDecimal amountSum = Constants.ZERO;
            BigDecimal receiptSum = Constants.ZERO;
            int counter = 0;
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                BigDecimal amount = iRowSet.getBigDecimal("amount");
                BigDecimal receiptAmount = iRowSet.getBigDecimal("receiptAmount");
                if (amount != null) {
                    amountSum = amountSum.add(amount);
                }
                if (receiptAmount != null) {
                    receiptSum = receiptSum.add(receiptAmount);
                }
                ++counter;
            }
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("amountSum", amountSum.setScale(precision, 4));
                iRowSet.updateBigDecimal("receiptAmountSum", receiptSum.setScale(precision, 4));
                iRowSet.updateInt("counter", counter);
                this.formatDateField(iRowSet);
                this.genCapField(iRowSet, "amount");
                this.genCapField(iRowSet, "amountSum");
                this.genCapField(iRowSet, "receiptAmount");
                this.genCapField(iRowSet, "receiptAmountSum");
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }

    private void formatDateField(IRowSet iRowSet) throws SQLException {
        this.formatOneDateField(iRowSet, "issueDate");
        this.formatOneDateField(iRowSet, "expiredDate");
        this.formatOneDateField(iRowSet, "receiptDate");
        this.formatOneDateField(iRowSet, "endorseDate");
    }

    private void formatOneDateField(IRowSet iRowSet, String field) throws SQLException {
        Date date = iRowSet.getDate(field);
        if (date != null) {
            DateUtil.getYear((java.util.Date)date);
            String year = String.valueOf(DateUtil.getYear((java.util.Date)date));
            String month = String.valueOf(DateUtil.getMonth((java.util.Date)date));
            String day = String.valueOf(DateUtil.getDay((java.util.Date)date));
            iRowSet.updateString(field + "Year", year);
            iRowSet.updateString(field + "Month", month);
            iRowSet.updateString(field + "Day", day);
        }
    }

    private void genCapField(IRowSet iRowSet, String src) throws SQLException {
        int precision = iRowSet.getInt("currency.precision");
        String isoCode = iRowSet.getString("currency.isoCode");
        BigDecimal amount = iRowSet.getBigDecimal(src);
        if (amount != null) {
            if (amount.compareTo(Constants.ZERO) == 0) {
                iRowSet.updateNull(src);
            } else {
                iRowSet.updateBigDecimal(src, amount.setScale(precision, 4));
                NTNumberFormat f = NTNumberFormat.getInstance(isoCode);
                iRowSet.updateString(src + "Cap", f.format(amount));
            }
        }
    }

    private void showInfo(IRowSet iRowSet) throws Exception {
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<Object> amounts = new ArrayList<Object>();
        BigDecimal sum = Constants.ZERO;
        DecimalFormat format = new DecimalFormat("#.###");
        iRowSet.beforeFirst();
        while (iRowSet.next()) {
            numbers.add(iRowSet.getString("number"));
            BigDecimal amount = iRowSet.getBigDecimal("receiptAmount");
            if (amount != null) {
                amounts.add(format.parse(amount.toString()));
                sum = sum.add(amount);
                continue;
            }
            amounts.add("0");
        }
        StringBuffer msg = new StringBuffer();
        int size = numbers.size();
        msg.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"354_RecChequeTDDelegate"));
        msg.append(size);
        msg.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"355_RecChequeTDDelegate"));
        for (int i = 0; i < size; ++i) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"356_RecChequeTDDelegate"));
            msg.append(numbers.get(i).toString());
            msg.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"357_RecChequeTDDelegate"));
            msg.append(amounts.get(i)).append(" ;");
        }
        msg.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"358_RecChequeTDDelegate"));
        msg.append(format.parse(sum.toString()));
        int option = MsgBox.showConfirm2((String)msg.toString());
        if (2 == option) {
            SysUtil.abort();
        }
    }

    public static void main(String[] args) throws BOSException {
        FMClientHelper.printTDMetaDataField((String)pk.getFullName());
    }
}

