/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.nt.IReceiptBill;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NoteKindEnum;
import com.kingdee.eas.fm.nt.ReceiptBillFactory;
import com.kingdee.eas.fm.nt.ReceiptBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceiptBillListUI;
import com.kingdee.eas.fm.nt.client.ReceipBillTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.ReceiptBillEditUI;
import com.kingdee.eas.fm.nt.client.ReceiptBillFilterParam;
import com.kingdee.eas.fm.nt.client.ReceiptBillFilterUI;
import com.kingdee.eas.fm.nt.client.RemitBillEditUI;
import com.kingdee.eas.fm.nt.client.TeleOrderTDDelegate;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReceiptBillListUI
extends AbstractReceiptBillListUI {
    private static String RECEIPTBILL = "/FM/NT/Receipt";
    private static String TELEORDER = "/FM/NT/TeleOrder";
    private static final String resourcePath = "com.kingdee.eas.fm.nt.ReceiptBill";
    private static final String TeleOrder = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"TeleOrder");
    private static final String ReceiptBill = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"ReceiptBill");
    private static final String OutBill = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"OutBill");
    private static final String InBill = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"InBill");
    private static final String BillTD = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"BillTD");
    private NTTypeGroupEnum ntType = null;
    ReceiptBillFilterUI filterUI = null;

    public void onLoad() throws Exception {
        FillListeners fillListener = new FillListeners(this.tblMain);
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)fillListener);
        this.kDTreeView1.setShowButton(false);
        super.onLoad();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        this.actionNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.treeOutLine.setModel(this.getTreeModel());
        this.treeOutLine.setCollapsePathDisabled(false);
        this.treeOutLine.setRootVisible(false);
        this.treeOutLine.setShowsRootHandles(true);
        FMClientHelper.goLeaf((KDTree)this.treeOutLine);
        this.tblMain.getColumn("Capitalization").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("ntTypeGroup").getStyleAttributes().setHided(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
    }

    @Override
    protected String getEditUIName() {
        if (this.ntType == NTTypeGroupEnum.TELE_ORDER) {
            return RemitBillEditUI.class.getName();
        }
        return ReceiptBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceiptBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceiptBillFilterUI();
        }
        this.filterUI.setListUI((IUIObject)this);
        return this.filterUI;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int numbber = 0;
        ArrayList<ObjectUuidPK> idlist = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow derow = this.tblMain.getRow(i);
            if (derow.getCell("check").getValue() != Boolean.TRUE || derow.getCell("id").getValue() == null) continue;
            String id = (String)derow.getCell("id").getValue();
            MutexUtils.setMutex((CoreUI)this, (String)id);
            ObjectUuidPK ids = new ObjectUuidPK(id);
            idlist.add(ids);
            ++numbber;
        }
        if (numbber <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"errmasg"));
            return;
        }
        IReceiptBill forde = ReceiptBillFactory.getRemoteInstance();
        ObjectUuidPK ids = null;
        for (int i = 0; i < idlist.size(); ++i) {
            ids = (ObjectUuidPK)idlist.get(i);
            forde.delete((IObjectPK)ids);
        }
        this.tblMain.refresh();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValue() != null) {
            super.actionEdit_actionPerformed(e);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        if (this.getSelectedKeyValue() != null) {
            ArrayList idList = this.getSelectedIdValues();
            if (idList == null || idList.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)resourcePath, (String)"errmasg"));
                return;
            }
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("*");
            select.add("ntType.*");
            if (this.getSelectedKeyValue() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
                ReceiptBillInfo info = (ReceiptBillInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
                KDNoteHelper appHlp = new KDNoteHelper();
                Object data = null;
                if (info.getNtType() != null && info.getNtType().getGroup() == NTTypeGroupEnum.TELE_ORDER) {
                    data = new TeleOrderTDDelegate(idList);
                    appHlp.print(TELEORDER, data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
                } else {
                    data = new ReceipBillTDQueryDelegate(idList);
                    appHlp.print(RECEIPTBILL, data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
                }
            }
        }
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrintPreview_actionPerformed(e);
        if (this.getSelectedKeyValue() != null) {
            ArrayList idList = this.getSelectedIdValues();
            Set set = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
            int index = -1;
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                index = (Integer)iter.next();
            }
            if (this.tblMain.getRow(index).getCell("ntTypeGroup").getValue() != null) {
                String billType = this.tblMain.getRow(index).getCell("ntTypeGroup").getValue().toString();
                Iterator iter2 = set.iterator();
                while (iter2.hasNext()) {
                    index = (Integer)iter2.next();
                    if (this.tblMain.getRow(index).getCell("ntTypeGroup").getValue() == null || this.tblMain.getRow(index).getCell("ntTypeGroup").getValue().toString().equals(billType)) continue;
                    MsgBox.showError((String)resourcePath, (String)"BillTypeDiff");
                    return;
                }
            }
            KDNoteHelper appHlp = new KDNoteHelper();
            Object data = null;
            if (this.ntType == NTTypeGroupEnum.TELE_ORDER) {
                data = new TeleOrderTDDelegate(idList);
                appHlp.printPreview(TELEORDER, data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            } else {
                data = new ReceipBillTDQueryDelegate(idList);
                appHlp.printPreview(RECEIPTBILL, data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.getSelectedKeyValue() != null) {
            super.tblMain_tableSelectChanged(e);
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            if (this.getSelectedKeyValue() != null) {
                actView.actionPerformed(evt);
            }
        }
    }

    @Override
    protected void treeOutLine_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOutLine_valueChanged(e);
        if (e == null) {
            return;
        }
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        int pathCount = path.getPathCount();
        String nodeName = node.getText();
        if (pathCount == 3) {
            if (nodeName.equals(TeleOrder)) {
                this.ntType = NTTypeGroupEnum.TELE_ORDER;
                this.buildTeleOrderHeader();
            } else if (nodeName.equals(ReceiptBill)) {
                this.ntType = NTTypeGroupEnum.CHEQUE;
                this.buildChequeHeader();
            }
        } else if (pathCount == 2) {
            if (nodeName.equals(OutBill)) {
                this.ntType = NTTypeGroupEnum.TELE_ORDER;
                this.buildTeleOrderHeader();
            } else if (nodeName.equals(InBill)) {
                this.ntType = NTTypeGroupEnum.CHEQUE;
                this.buildChequeHeader();
            }
        }
        this.executeQuery(this.getFilterParam());
    }

    private void buildTeleOrderHeader() {
        IRow headRow = this.tblMain.getHeadRow(0);
        headRow.getCell("PayerName").setValue((Object)this.getResString("PAYEENAME"));
        headRow.getCell("PayerBank").setValue((Object)this.getResString("PAYEEBANK"));
        headRow.getCell("PayerBankAcct").setValue((Object)this.getResString("PAYEEBANKACCT"));
        headRow.getCell("PayeeName").setValue((Object)this.getResString("PAYERNAME"));
        headRow.getCell("PayeeBank").setValue((Object)this.getResString("PAYERBANK"));
        headRow.getCell("PayeeBankAcct").setValue((Object)this.getResString("PAYERBANKACCT"));
    }

    private void buildChequeHeader() {
        IRow headRow = this.tblMain.getHeadRow(0);
        headRow.getCell("PayerName").setValue((Object)this.getResString("PAYERNAME"));
        headRow.getCell("PayerBank").setValue((Object)this.getResString("PAYERBANK"));
        headRow.getCell("PayerBankAcct").setValue((Object)this.getResString("PAYERBANKACCT"));
        headRow.getCell("PayeeName").setValue((Object)this.getResString("PAYEENAME"));
        headRow.getCell("PayeeBank").setValue((Object)this.getResString("PAYEEBANK"));
        headRow.getCell("PayeeBankAcct").setValue((Object)this.getResString("PAYEEBANKACCT"));
    }

    public void executeQuery(FilterParam param) throws BOSException {
        if (param instanceof ReceiptBillFilterParam) {
            ReceiptBillFilterParam fp = (ReceiptBillFilterParam)param;
            this.filterUI.setDispTotal(fp.isIstotal());
        }
        if (this.ntType != null && this.ntType.equals((Object)NTTypeGroupEnum.CHEQUE)) {
            ((ReceiptBillFilterParam)param).setSelectNode(NoteKindEnum.receiptBill);
        }
        if (this.ntType != null && this.ntType.equals((Object)NTTypeGroupEnum.TELE_ORDER)) {
            ((ReceiptBillFilterParam)param).setSelectNode(NoteKindEnum.remitBill);
        }
        super.executeQuery(param);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    private TreeModel getTreeModel() throws BOSException, EASBizException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)BillTD);
        DefaultKingdeeTreeNode inRoot = new DefaultKingdeeTreeNode((Object)InBill);
        DefaultKingdeeTreeNode outRoot = new DefaultKingdeeTreeNode((Object)OutBill);
        DefaultKingdeeTreeNode receipt = new DefaultKingdeeTreeNode((Object)ReceiptBill);
        DefaultKingdeeTreeNode tele = new DefaultKingdeeTreeNode((Object)TeleOrder);
        root.add((MutableTreeNode)inRoot);
        root.add((MutableTreeNode)outRoot);
        inRoot.add((MutableTreeNode)receipt);
        outRoot.add((MutableTreeNode)tele);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        return model;
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "receiptDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove"};
    }

    class Cuinfo {
        String id;
        String name;
        BigDecimal sum;

        Cuinfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        public void addSum(BigDecimal amount) {
            this.sum = this.sum.add(amount);
        }
    }

    class FillListeners
    implements KDTDataFillListener {
        KDTable tblMain;

        public FillListeners(KDTable tblMains) {
            this.tblMain = tblMains;
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            int rowCount = this.tblMain.getRowCount3();
            IRow row = null;
            HashMap<String, Cuinfo> map = new HashMap<String, Cuinfo>();
            try {
                for (int i = 0; i < rowCount && (row = this.tblMain.getRow(i)) != null; ++i) {
                    Cuinfo cu;
                    Cuinfo in;
                    String currencyId = (String)row.getCell("currency.id").getValue();
                    if (currencyId != null) {
                        if (ReceiptBillListUI.this.filterUI.isDispTotal()) {
                            if (!map.containsKey(currencyId)) {
                                in = new Cuinfo();
                                in.setName(row.getCell("Currency").getValue().toString());
                                in.setSum(new BigDecimal(row.getCell("Amount").getValue().toString()));
                                in.setId(currencyId);
                                map.put(currencyId, in);
                            } else {
                                cu = (Cuinfo)map.get(currencyId);
                                cu.addSum(new BigDecimal(row.getCell("Amount").getValue().toString()));
                            }
                        }
                        FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
                    } else if (ReceiptBillListUI.this.filterUI.isDispTotal()) {
                        if (!map.containsKey("null")) {
                            in = new Cuinfo();
                            in.setName(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"359_ReceiptBillListUI"));
                            in.setSum(new BigDecimal(row.getCell("Amount").getValue().toString()));
                            in.setId("null");
                            map.put("null", in);
                        } else {
                            cu = (Cuinfo)map.get("null");
                            cu.addSum(new BigDecimal(row.getCell("Amount").getValue().toString()));
                        }
                        row.getCell("Amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                        row.getCell("Amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    row.getCell("check").setValue((Object)Boolean.FALSE);
                    row.getCell("check").getStyleAttributes().setLocked(false);
                }
                if (ReceiptBillListUI.this.filterUI.isDispTotal()) {
                    Iterator it = map.entrySet().iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        Map.Entry info = it.next();
                        Cuinfo cinfo = (Cuinfo)info.getValue();
                        IRow rows = this.tblMain.addRow();
                        sb.setLength(0);
                        sb.append(cinfo.getName()).append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
                        rows.getCell("number").setValue((Object)sb.toString());
                        rows.getCell("Amount").setValue((Object)cinfo.getSum());
                        rows.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                        if (!cinfo.getId().equals("null")) {
                            FMClientHelper.currencyFormat((BOSUuid)BOSUuid.read((String)cinfo.getId()), (ICell)rows.getCell("Amount"));
                            continue;
                        }
                        rows.getCell("Amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                        rows.getCell("Amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                }
            }
            catch (Exception ex) {
                MsgBox.showError((String)ex.getMessage());
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }
}

