/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.EndorseListingCollection;
import com.kingdee.eas.fm.nt.EndorseListingFactory;
import com.kingdee.eas.fm.nt.EndorseListingInfo;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.IEndorseListing;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.NtRpcCacheInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableBillEditUI;
import com.kingdee.eas.fm.nt.client.AdminCostCenterF7;
import com.kingdee.eas.fm.nt.client.EndorseListingUI;
import com.kingdee.eas.fm.nt.client.EndorseNoteBillApproveUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReceivableBillEditUI
extends AbstractReceivableBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableBillEditUI.class);
    public static final String HISTORY_BILL = "HISTORY";
    private boolean isCopy = false;
    public static final String RESOURCES = "com.kingdee.eas.fm.nt.ReceivableBill";
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo bassCurrency;
    private UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private static final BigDecimal DEFAULT_EXCHANGERATE = Constants.ONE;
    private boolean isBankAccept = true;
    private boolean isFromEndorsement = false;
    private boolean isFromPayablebill = false;
    boolean isNTAssociaWithRP = false;
    boolean isClearingHouse = false;
    private NtRpcCacheInfo rpcCacheInfo;
    IObjectPK pk;

    public ReceivableBillEditUI() throws Exception {
        this.bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        ReceivableBillInfo info = (ReceivableBillInfo)dataObject;
        if (info == null) {
            return;
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            info.setCreator(this.userInfo);
            info.setCompany(this.currentCompany);
            if (this.isBotp()) {
                info.setBillState(BillStateEnum.SAVED);
            } else {
                info.setBillState(BillStateEnum.TempSaved);
            }
            if (info.getNtType() == null) {
                NTTypeInfo ntTypeInfo = new NTTypeInfo();
                ntTypeInfo.setId(BOSUuid.read((String)"33333333-3333-3333-3333-3333333333331C9A9013"));
                info.setNtType(ntTypeInfo);
            }
            if (info.isIsNoUsed()) {
                info.setPayeeName(this.currentCompany.getName());
            }
            if (info.getBillMedium() == null) {
                info.setBillMedium(BillMediumEnum.PAPERY);
            }
            info.setSource(BillSourceEnum.BYHAND);
            info.setStandardBillAmt(new BigDecimal("0.01"));
            info.setOriginalBillAmt(info.getBillAmt());
            info.setOriginalNaturalAmt(info.getNaturalAmt());
            info.setLockAmt(BigDecimal.ZERO);
            info.setAvailableAmt(info.getBillAmt());
        }
        super.setDataObject((IObjectValue)info);
    }

    @Override
    public void loadFields() {
        int precision = FMHelper.getPrecOfCurrency(null, (String)this.editData.getCurrency().getId().toString());
        this.txtbillAmt.setPrecision(precision);
        this.txtnaturalAmt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
        this.txtOriginalBillAmt.setPrecision(precision);
        this.txtLockAmt.setPrecision(precision);
        this.txtAvailableAmt.setPrecision(precision);
        this.txtOriginalNaturalAmt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
        try {
            this.txtExchangeRate.setPrecision(FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)this.editData.getCurrency().getId().toString(), null, (Date)new Date()));
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        }
        if (!FMHelper.isEmpty((Object)this.editData.getId())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("head.id", (Object)this.editData.getId()));
            view.setFilter(filterInfo);
            view.getSorter().add(new SorterItemInfo("seq"));
            try {
                EndorseListingCollection coll = EndorseListingFactory.getRemoteInstance().getEndorseListingCollection(view);
                this.editData.setEndorseListColl(coll);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeComponentListeners((JComponent)this.prmtdrawer);
            if (this.editData.getDrawer() != null) {
                this.prmtdrawer.setData((Object)this.editData.getDrawer());
            } else if (this.editData.getDrawerSupp() != null) {
                this.prmtdrawer.setData((Object)this.editData.getDrawerSupp());
            } else {
                this.prmtdrawer.setValue((Object)this.editData.getDrawerName());
            }
            FMClientHelper.addComponentListeners((JComponent)this.prmtdrawer, (Map)listenerMap);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        if (this.editData.getDeliver() != null) {
            this.prmtdeliver.setData((Object)this.editData.getDeliver());
        } else if (this.editData.getDeliverSupp() != null) {
            this.prmtdeliver.setData((Object)this.editData.getDeliverSupp());
        } else {
            this.prmtdeliver.setValue((Object)this.editData.getDeliverName());
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData.getPayee() != null) {
            this.prmtpayee.setData((Object)this.editData.getPayee());
        } else if (this.editData.getPayeeSupp() != null) {
            this.prmtpayee.setData((Object)this.editData.getPayeeSupp());
        } else {
            this.prmtpayee.setValue((Object)this.editData.getPayeeName());
        }
        listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeComponentListeners((JComponent)this.prmtpayeeAccount);
            if (this.editData.getPayeeAccount() != null) {
                this.prmtpayeeAccount.setData((Object)this.editData.getPayeeAccount());
                if (this.editData.getPayeeAccount() instanceof AccountBankInfo) {
                    AccountBankInfo accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectStringPK(this.editData.getPayeeAccount().getId().toString()));
                    this.setCurr(accountBank);
                }
            } else {
                this.prmtpayeeAccount.setValue((Object)this.editData.getPayeeAccountName());
            }
            FMClientHelper.addComponentListeners((JComponent)this.prmtpayeeAccount, (Map)listenerMap);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.setCostCenterF7();
        if (this.editData.getAcceptanceCust() != null) {
            this.prmtdrawcer.setData((Object)this.editData.getAcceptanceCust());
        } else if (this.editData.getAcceptanceSupp() != null) {
            this.prmtdrawcer.setData((Object)this.editData.getAcceptanceSupp());
        } else {
            this.prmtdrawcer.setValue((Object)this.editData.getAcceptanceBankName());
        }
        this.prmtdrawerAccount.setData((Object)this.editData.getDrawerAccountName());
        this.prmtdrawerAccount.setText(this.editData.getDrawerAccountName());
        if (this.editData.getPayeeBank() != null) {
            this.prmtpayeeBank.setData((Object)this.editData.getPayeeBank());
        } else {
            this.prmtpayeeBank.setValue((Object)this.editData.getPayeeBankName());
        }
        if (this.editData.getDrawerBank() != null) {
            this.prmtdrawerBank.setData((Object)this.editData.getDrawerBank());
        } else {
            this.prmtdrawerBank.setValue((Object)this.editData.getDrawerBankName());
        }
        this.txtdrawerBankNum.setText(this.editData.getDrawerBankNum());
        this.txtpayeeBankNum.setText(this.editData.getPayeeBankNum());
        if (this.editData.getAcceptorBank() != null) {
            this.prmtacceptorBank.setData((Object)this.editData.getAcceptorBank());
        } else {
            this.prmtacceptorBank.setValue((Object)this.editData.getAcceptorBankName());
        }
        this.txtacceptorBankNum.setText(this.editData.getAcceptorBankNum());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)this.editData.getNtType());
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.prmtAcceptorName.setText(this.editData.getAcceptorName());
        } else {
            this.txtacceptorName.setText(this.editData.getAcceptorName());
        }
        this.txtacceptorAccountName.setText(this.editData.getAcceptorAccountName());
        if (OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getBillMedium().equals((Object)BillMediumEnum.ELECTRONIC)) {
            this.txtsubQuantity.setValue((Object)0);
            this.txtsubRegion.setText("0-0");
            this.txtsubStartNumber.setValue((Object)0);
            this.txtsubEndNumber.setValue((Object)0);
        }
        if (!EmptyUtil.isEmpty((Object)this.editData.getSubQuantity())) {
            this.txtsubQuantity.setValue((Object)this.editData.getSubQuantity());
        }
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        this.txtnaturalAmt.setValue((Object)this.editData.getNaturalAmt());
        this.txtOriginalBillAmt.setValue((Object)this.editData.getOriginalBillAmt());
        this.txtOriginalNaturalAmt.setValue((Object)this.editData.getOriginalNaturalAmt());
        this.txtAvailableAmt.setValue((Object)this.editData.getAvailableAmt());
        this.txtLockAmt.setValue((Object)this.editData.getLockAmt());
        this.txtDiscount.setValue((Object)this.editData.getDiscount());
        if (this.editData.getCurrency().equals((Object)this.bassCurrency)) {
            this.txtExchangeRate.setEnabled(false);
        }
        if (this.editData.getId() == null && !this.isCopy) {
            if (this.isHistoryBill()) {
                this.chkisHistory.setSelected(true);
            }
            this.chkisNoUsed.setSelected(true);
            try {
                this.chkisNoUsed_actionPerformed(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.isIsSplit()) {
            this.txtsubStartNumber.setRequired(true);
        } else {
            this.txtsubStartNumber.setRequired(false);
        }
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    private AccountBankInfo getAccountBankByAccountNumber(String acctNumber) {
        if (EmptyUtil.isEmpty((String)acctNumber)) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)acctNumber.trim()));
        try {
            AccountBankCollection banks = AccountBankFactory.getRemoteInstance().getAccountBankCollection(ev);
            if (banks != null && banks.size() > 0) {
                return banks.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public void storeFields() {
        NTTypeInfo nttypeInfo;
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        this.editData.setDrawer(this.getCustomer(this.prmtdrawer.getData()));
        this.editData.setDrawerSupp(this.getSupplier(this.prmtdrawer.getData()));
        this.editData.setDrawerName(this.getStringName(this.prmtdrawer.getValue()));
        this.editData.setDrawerAccountName(this.getStringName(this.prmtdrawerAccount.getText()));
        if (this.editData.getDrawerAccount() == null) {
            if (this.prmtdrawerAccount.getData() instanceof AccountBankInfo) {
                this.editData.setDrawerAccount((AccountBankInfo)this.prmtdrawerAccount.getData());
            } else if (this.prmtdrawerAccount.getData() instanceof String) {
                this.editData.setDrawerAccount(this.getAccountBankByAccountNumber(this.prmtdrawerAccount.getText()));
            }
        }
        if ((nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem()).getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_CommerceAccept)) {
            this.editData.setAcceptanceCust(this.getCustomer(this.prmtdrawcer.getData()));
            this.editData.setAcceptanceSupp(this.getSupplier(this.prmtdrawcer.getData()));
        } else if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.editData.setDrawerBank(this.prmtdrawerBank.getData() instanceof BEBankInfo ? (BEBankInfo)this.prmtdrawerBank.getData() : null);
            this.editData.setDrawerBankName(this.prmtdrawerBank.getText());
        }
        this.editData.setDeliver(this.getCustomer(this.prmtdeliver.getData()));
        this.editData.setDeliverSupp(this.getSupplier(this.prmtdeliver.getData()));
        this.editData.setDeliverName(this.getStringName(this.prmtdeliver.getValue()));
        this.editData.setPayee(this.getCustomer(this.prmtpayee.getData()));
        this.editData.setPayeeSupp(this.getSupplier(this.prmtpayee.getData()));
        this.editData.setPayeeName(this.getStringName(this.prmtpayee.getValue()));
        this.editData.setPayeeAccount(this.getAccountBank(this.prmtpayeeAccount.getData()));
        this.editData.setPayeeAccountName(this.prmtpayeeAccount.getText());
        this.editData.setPayeeBank(this.getBank(this.prmtpayeeBank.getData()));
        this.editData.setPayeeBankName(this.prmtpayeeBank.getText());
        this.editData.setAcceptorBank(this.prmtacceptorBank.getData() instanceof BEBankInfo ? (BEBankInfo)this.prmtacceptorBank.getData() : null);
        this.editData.setAcceptorBankName(this.prmtacceptorBank.getText());
        if (!EmptyUtil.isEmpty((String)this.editData.getAcceptorBankName())) {
            this.editData.setAcceptanceBankName(this.editData.getAcceptorBankName());
        } else if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            if (!EmptyUtil.isEmpty((String)this.editData.getDrawerBankName())) {
                this.editData.setAcceptanceBankName(this.editData.getDrawerBankName());
            }
        } else if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_CommerceAccept)) {
            if (!EmptyUtil.isEmpty((Object)this.prmtdrawcer.getValue())) {
                this.editData.setAcceptanceBankName(this.prmtdrawcer.getText());
            }
        } else if (!EmptyUtil.isEmpty((String)this.editData.getDrawerBankName())) {
            this.editData.setAcceptanceBankName(this.editData.getDrawerBankName());
        } else {
            this.editData.setAcceptanceBankName(this.editData.getDrawerName());
        }
        this.editData.setTakeDate(DateTimeUtils.truncateDate((Date)this.editData.getTakeDate()));
        this.editData.setExpiredDate(DateTimeUtils.truncateDate((Date)this.editData.getExpiredDate()));
        this.editData.setIssuesDate(DateTimeUtils.truncateDate((Date)this.editData.getIssuesDate()));
        this.editData.setAcceptanceDate(DateTimeUtils.truncateDate((Date)this.editData.getAcceptanceDate()));
        if (this.isHistoryBill() && this.editData.getBillMedium() == BillMediumEnum.ELECTRONIC) {
            this.editData.setElecBillStatus((ElecBillStatusEnum)((Object)this.comboElecBillStatus.getSelectedItem()));
        } else {
            this.editData.setElecBillStatus(null);
        }
        this.editData.setIsTransfer(true);
        if (this.editData.isIsSplit() && !EmptyUtil.isEmpty((String)this.editData.getDraftPackageNumber()) && !EmptyUtil.isEmpty((String)this.editData.getSubRegion())) {
            this.txtDraftNumber.setText(this.editData.getDraftPackageNumber() + "-" + this.editData.getSubRegion());
        } else {
            this.txtDraftNumber.setText(this.editData.getDraftPackageNumber());
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isHistory"));
        sic.add(new SelectorItemInfo("isVendeePayInt"));
        sic.add(new SelectorItemInfo("isNoUsed"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("digest"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("issuesDate"));
        sic.add(new SelectorItemInfo("billAmt"));
        sic.add(new SelectorItemInfo("expiredDate"));
        sic.add(new SelectorItemInfo("takeDate"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("naturalAmt"));
        sic.add(new SelectorItemInfo("bankAccount.id"));
        sic.add(new SelectorItemInfo("bankAccount.number"));
        sic.add(new SelectorItemInfo("bankAccount.name"));
        sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("department.id"));
        sic.add(new SelectorItemInfo("department.number"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("operator.id"));
        sic.add(new SelectorItemInfo("operator.number"));
        sic.add(new SelectorItemInfo("operator.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("innerAccount.id"));
        sic.add(new SelectorItemInfo("innerAccount.number"));
        sic.add(new SelectorItemInfo("innerAccount.name"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("billAccount.id"));
        sic.add(new SelectorItemInfo("billAccount.number"));
        sic.add(new SelectorItemInfo("billAccount.name"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("draftNumber"));
        sic.add(new SelectorItemInfo("drawerAccountName"));
        sic.add(new SelectorItemInfo("drawerBankNum"));
        sic.add(new SelectorItemInfo("drawerBank.id"));
        sic.add(new SelectorItemInfo("drawerBank.number"));
        sic.add(new SelectorItemInfo("drawerBank.name"));
        sic.add(new SelectorItemInfo("payeeBankNum"));
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("Fivouchered"));
        sic.add(new SelectorItemInfo("drawer.id"));
        sic.add(new SelectorItemInfo("drawer.name"));
        sic.add(new SelectorItemInfo("drawer.number"));
        sic.add(new SelectorItemInfo("drawerSupp.id"));
        sic.add(new SelectorItemInfo("drawerSupp.name"));
        sic.add(new SelectorItemInfo("drawername"));
        sic.add(new SelectorItemInfo("drawerBankName"));
        sic.add(new SelectorItemInfo("acceptanceBankName"));
        sic.add(new SelectorItemInfo("payee.id"));
        sic.add(new SelectorItemInfo("payee.name"));
        sic.add(new SelectorItemInfo("payeeSupp.id"));
        sic.add(new SelectorItemInfo("payeeSupp.name"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeAccount.id"));
        sic.add(new SelectorItemInfo("payeeAccount.number"));
        sic.add(new SelectorItemInfo("payeeAccount.name"));
        sic.add(new SelectorItemInfo("payeeAccount.bank"));
        sic.add(new SelectorItemInfo("payeeAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payeeAccountName"));
        sic.add(new SelectorItemInfo("payeeBank.id"));
        sic.add(new SelectorItemInfo("payeeBank.name"));
        sic.add(new SelectorItemInfo("payeeBank.number"));
        sic.add(new SelectorItemInfo("payeeBank.isBank"));
        sic.add(new SelectorItemInfo("payeeBankName"));
        sic.add(new SelectorItemInfo("deliver.id"));
        sic.add(new SelectorItemInfo("deliver.name"));
        sic.add(new SelectorItemInfo("deliver.number"));
        sic.add(new SelectorItemInfo("deliverSupp.id"));
        sic.add(new SelectorItemInfo("deliverSupp.name"));
        sic.add(new SelectorItemInfo("deliverName"));
        sic.add(new SelectorItemInfo("sourcebillid"));
        sic.add(new SelectorItemInfo("acceptanceCust.id"));
        sic.add(new SelectorItemInfo("acceptanceCust.number"));
        sic.add(new SelectorItemInfo("acceptanceCust.name"));
        sic.add(new SelectorItemInfo("acceptanceSupp.id"));
        sic.add(new SelectorItemInfo("acceptanceSupp.number"));
        sic.add(new SelectorItemInfo("acceptanceSupp.name"));
        sic.add(new SelectorItemInfo("transferId"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("isDisPledge"));
        sic.add(new SelectorItemInfo("isPledge"));
        sic.add(new SelectorItemInfo("isTrustee"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("deliver.internalCompany"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        sic.add(new SelectorItemInfo("drawerBank.id"));
        sic.add(new SelectorItemInfo("drawerBank.number"));
        sic.add(new SelectorItemInfo("drawerBank.name"));
        sic.add(new SelectorItemInfo("acceptorName"));
        sic.add(new SelectorItemInfo("acceptorBank.id"));
        sic.add(new SelectorItemInfo("acceptorBank.number"));
        sic.add(new SelectorItemInfo("acceptorBank.name"));
        sic.add(new SelectorItemInfo("acceptorBankName"));
        sic.add(new SelectorItemInfo("acceptorBankNum"));
        sic.add(new SelectorItemInfo("acceptanceDate"));
        sic.add(new SelectorItemInfo("acceptorAccountName"));
        sic.add(new SelectorItemInfo("acceptanceNo"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("batchNo"));
        sic.add(new SelectorItemInfo("invoiceNum"));
        sic.add(new SelectorItemInfo("contractNo"));
        sic.add(new SelectorItemInfo("elecBillStatus"));
        sic.add(new SelectorItemInfo("holder.id"));
        sic.add(new SelectorItemInfo("holder.name"));
        sic.add(new SelectorItemInfo("holder.number"));
        sic.add(new SelectorItemInfo("holderAccount.id"));
        sic.add(new SelectorItemInfo("holderAccount.name"));
        sic.add(new SelectorItemInfo("holderAccount.number"));
        sic.add(new SelectorItemInfo("holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("rpBillId"));
        sic.add(new SelectorItemInfo("endorseBill.id"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("isSplit"));
        sic.add(new SelectorItemInfo("draftPackageNumber"));
        sic.add(new SelectorItemInfo("standardBillAmt"));
        sic.add(new SelectorItemInfo("subRegion"));
        sic.add(new SelectorItemInfo("subQuantity"));
        sic.add(new SelectorItemInfo("subStartNumber"));
        sic.add(new SelectorItemInfo("subEndNumber"));
        sic.add(new SelectorItemInfo("originalBillAmt"));
        sic.add(new SelectorItemInfo("originalNaturalAmt"));
        sic.add(new SelectorItemInfo("lockAmt"));
        sic.add(new SelectorItemInfo("availableAmt"));
        return sic;
    }

    private String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    private BankInfo getBank(Object objBank) {
        if (objBank instanceof BankInfo) {
            return (BankInfo)objBank;
        }
        return null;
    }

    private AccountBankInfo getAccountBank(Object objAccountBank) {
        if (objAccountBank instanceof AccountBankInfo) {
            return (AccountBankInfo)objAccountBank;
        }
        return null;
    }

    @Override
    protected void txtbillAmt_dataChanged(DataChangeEvent e) throws Exception {
        this.setNaturalAmt();
        this.calcDiscount();
        if (!EmptyUtil.isEmpty((Object)this.txtbillAmt.getBigDecimalValue()) && this.chkisSplit.isSelected()) {
            this.txtsubQuantity.setValue((Object)this.txtbillAmt.getBigDecimalValue().divide(this.editData.getStandardBillAmt()).stripTrailingZeros());
            this.setTxtsubRegion();
        }
        this.txtOriginalBillAmt.setValue((Object)this.txtbillAmt.getBigDecimalValue());
        this.txtOriginalNaturalAmt.setValue((Object)this.txtnaturalAmt.getBigDecimalValue());
        this.txtAvailableAmt.setValue((Object)this.txtbillAmt.getBigDecimalValue());
        this.txtLockAmt.setValue((Object)BigDecimal.ZERO);
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.setNaturalAmt();
    }

    @Override
    public void txtnaturalAmt_focusLost(FocusEvent e) {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null && currency.equals((Object)this.bassCurrency)) {
            return;
        }
        if (this.txtnaturalAmt.getBigDecimalValue() == null || this.txtbillAmt.getBigDecimalValue() == null) {
            return;
        }
        this.txtExchangeRate.setValue((Object)((BigDecimal)this.txtnaturalAmt.getValue(BigDecimal.class)).divide((BigDecimal)this.txtbillAmt.getValue(BigDecimal.class), 4, 4));
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtbillAmt.setPrecision(currency.getPrecision());
        this.txtOriginalBillAmt.setPrecision(currency.getPrecision());
        this.txtAvailableAmt.setPrecision(currency.getPrecision());
        this.txtnaturalAmt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
        this.txtOriginalNaturalAmt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.bassCurrency.getId()));
        this.txtExchangeRate.setPrecision(FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)currency.getId().toString(), null, (Date)new Date()));
        if (currency.getId().toString().equals(this.bassCurrency.getId().toString())) {
            this.txtExchangeRate.setValue((Object)DEFAULT_EXCHANGERATE);
            this.txtExchangeRate.setEnabled(false);
        } else {
            ExchangeRateInfo exchangeRate = FMClientHelper.findExchangeRate((String)currency.getId().toString(), (String)this.bassCurrency.getId().toString());
            if (exchangeRate != null) {
                this.txtExchangeRate.setValue((Object)exchangeRate.getConvertRate());
            } else {
                this.txtExchangeRate.setValue((Object)DEFAULT_EXCHANGERATE);
            }
            this.txtExchangeRate.setEnabled(true);
        }
        this.setNaturalAmt();
    }

    private void setNaturalAmt() {
        if (this.txtExchangeRate.getBigDecimalValue() == null || this.txtbillAmt.getBigDecimalValue() == null) {
            return;
        }
        this.txtnaturalAmt.setValue((Object)((BigDecimal)this.txtExchangeRate.getValue(BigDecimal.class)).multiply((BigDecimal)this.txtbillAmt.getValue(BigDecimal.class)));
    }

    @Override
    public void comboBillType_itemStateChanged(ItemEvent e) {
        if (e != null && e.getStateChange() == 2) {
            return;
        }
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (nttypeInfo == null) {
            return;
        }
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.contdrawcer.setVisible(false);
            this.contdrawerBank.setVisible(true);
            this.prmtdrawcer.setRequired(false);
            this.prmtdrawerBank.setRequired(true);
            this.contPrmtAcceptorName.setVisible(true);
            this.setEditPrmt(this.prmtAcceptorName, true);
            this.contacceptorName.setVisible(false);
            if (this.billMedium.getSelectedItem() == BillMediumEnum.ELECTRONIC) {
                this.prmtAcceptorName.setRequired(true);
            } else {
                this.txtacceptorName.setRequired(false);
            }
            this.txtacceptorAccountName.setText("0");
            if (e != null) {
                this.prmtdrawcer.setData(null);
            }
        } else {
            this.contdrawcer.setVisible(true);
            this.contdrawerBank.setVisible(false);
            this.prmtdrawerBank.setRequired(false);
            this.prmtdrawcer.setRequired(true);
            this.contPrmtAcceptorName.setVisible(false);
            this.contacceptorName.setVisible(true);
            this.prmtAcceptorName.setRequired(false);
            if (this.billMedium.getSelectedItem() == BillMediumEnum.ELECTRONIC) {
                this.txtacceptorName.setRequired(true);
            } else {
                this.txtacceptorName.setRequired(false);
            }
            this.txtacceptorAccountName.setText("");
            if (e != null) {
                this.prmtdrawerBank.setData(null);
            }
        }
    }

    @Override
    protected void prmtAcceptorName_dataChanged(DataChangeEvent e) throws Exception {
        this.txtacceptorName.setText("");
        if (EmptyUtil.isEmpty((Object)this.prmtAcceptorName.getData())) {
            return;
        }
        if (this.prmtAcceptorName.getData() instanceof BEBankInfo) {
            BEBankInfo bankInfo = (BEBankInfo)this.prmtAcceptorName.getData();
            this.txtacceptorName.setText(bankInfo.getName());
        } else {
            this.txtacceptorName.setText(this.prmtAcceptorName.getText());
        }
    }

    @Override
    protected void chkisNoUsed_actionPerformed(ActionEvent e) throws Exception {
        this.setControlByIfBillIsUsed(this.chkisNoUsed.isSelected(), true);
    }

    private void setControlByIfBillIsUsed(boolean isNoUsed, boolean isModifyValue) {
        if (isNoUsed) {
            this.prmtpayee.setEnabled(false);
            this.prmtpayeeBank.setEnabled(false);
            this.prmtpayeeAccount.setEnabled(true);
            this.prmtdeliver.setEnabled(false);
            if (isModifyValue) {
                this.prmtpayee.setData((Object)this.currentCompany);
                if (this.currentCompany.getAccountBank() != null) {
                    this.prmtpayeeAccount.setData((Object)this.currentCompany.getAccountBank());
                    this.prmtpayeeBank.setText(this.currentCompany.getAccountBank().getBank().getName());
                } else {
                    this.prmtpayeeAccount.setData(null);
                    this.prmtpayeeBank.setData(null);
                }
                this.prmtdeliver.setValue(this.prmtdrawer.getValue());
                this.prmtdeliver.setData(this.prmtdrawer.getData());
            }
            this.setEditPrmt(this.prmtpayeeAccount, false);
            this.actionShowEndorseList.setEnabled(false);
            this.prmtdrawer.setRequired(true);
            this.prmtpayee.setRequired(true);
            this.prmtpayeeBank.setRequired(true);
            this.prmtpayeeAccount.setRequired(true);
        } else {
            if (isModifyValue) {
                this.prmtpayee.setData(null);
                this.prmtpayeeAccount.setData(null);
                this.prmtpayeeBank.setData(null);
                this.prmtdeliver.setData(null);
                this.prmtdeliver.setValue(null);
                this.txtpayeeBankNum.setText("");
            }
            this.prmtpayee.setEnabled(true);
            this.prmtpayeeAccount.setEnabled(true);
            this.prmtpayeeBank.setEnabled(true);
            this.prmtdeliver.setEnabled(true);
            this.comboCurrency.setEnabled(true);
            this.setEditPrmt(this.prmtpayeeAccount, true);
            this.actionShowEndorseList.setEnabled(true);
            this.prmtdrawer.setRequired(false);
            this.prmtpayee.setRequired(false);
            this.prmtpayeeBank.setRequired(false);
            this.prmtpayeeAccount.setRequired(false);
            this.prmtpayeeAccount.setEnabled(false);
            this.prmtpayeeAccount.getEditor().setEnabled(true);
            this.prmtpayeeBank.getEditor().setEnabled(true);
        }
    }

    @Override
    protected void prmtdrawer_dataChanged(DataChangeEvent e) throws Exception {
        CustomerInfo custInfo;
        CustomerCompanyInfoInfo customerCompanyInfo;
        NTTypeInfo nttypeInfo;
        Object drawer = this.prmtdrawer.getData();
        ObjectBaseInfo csInfo = null;
        if (drawer instanceof String && (csInfo = NTHelper.getCSInfoByNumber((String)drawer)) != null) {
            this.prmtdrawer.setData((Object)csInfo);
        }
        if (this.chkisNoUsed.isSelected()) {
            this.prmtdeliver.setData(drawer instanceof String ? csInfo : drawer);
            if (EmptyUtil.isEmpty((CoreBaseInfo)csInfo)) {
                this.prmtdeliver.setData(drawer);
            }
        }
        if ((nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem()).getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            boolean isInnerSupplierOrCustomer = false;
            CompanyOrgUnitInfo internalCom = null;
            if (drawer instanceof CustomerInfo) {
                isInnerSupplierOrCustomer = ((CustomerInfo)drawer).isIsInternalCompany();
                internalCom = ((CustomerInfo)drawer).getInternalCompany();
            } else if (drawer instanceof SupplierInfo) {
                isInnerSupplierOrCustomer = ((SupplierInfo)drawer).isIsInternalCompany();
                internalCom = ((SupplierInfo)drawer).getInternalCompany();
            }
            if (!isInnerSupplierOrCustomer) {
                CSBankInfo csbankInfo = FMHelper.getCSBankInfo(null, (Object)drawer, (String)this.currentCompany.getId().toString());
                this.prmtdrawerAccount.setData((Object)csbankInfo.getBankAccount());
                this.prmtdrawerAccount.setText(csbankInfo.getBankAccount());
                this.prmtdrawerBank.setData((Object)csbankInfo.getBank());
            } else if (internalCom != null) {
                String internalComName = internalCom.getName();
                SelectorItemCollection sel = null;
                if (internalComName == null) {
                    sel = new SelectorItemCollection();
                    sel.add("id");
                    sel.add("name");
                    sel.add("number");
                    internalComName = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(internalCom.getId().toString()), sel).getName();
                }
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)internalComName));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)internalComName));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)internalComName));
                filterName.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
                filterName.setMaskString("(#0 or #1 or #2) and #3");
                sel = new SelectorItemCollection();
                sel.add("id");
                sel.add("name");
                sel.add("number");
                sel.add("bankAccountNumber");
                sel.add("bank.id");
                sel.add("bank.name");
                sel.add("bank.number");
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("number"));
                evi.setSelector(sel);
                evi.setFilter(filterName);
                evi.setSorter(sort);
                AccountBankCollection col = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
                if (col.size() > 0) {
                    this.prmtdrawerAccount.setData((Object)col.get(0));
                    this.prmtdrawerAccount.setText(col.get(0).getBankAccountNumber());
                    this.prmtdrawerBank.setData((Object)col.get(0).getBank());
                } else {
                    this.prmtdrawerAccount.setData(null);
                    this.prmtdrawerAccount.setText(null);
                    this.prmtdrawerBank.setData(null);
                }
            }
        }
        if (this.chkisNoUsed.isSelected() && this.prmtdrawer.getData() instanceof CustomerInfo && (customerCompanyInfo = NTHelper.getCustomerCompanyByCustomer((custInfo = (CustomerInfo)this.prmtdrawer.getData()).getId().toString(), this.currentCompany.getId().toString())) != null) {
            if (customerCompanyInfo.getAdminOrgUnit() != null) {
                this.prmtdepartment.setData((Object)customerCompanyInfo.getAdminOrgUnit());
            }
            if (customerCompanyInfo.getOperationer() != null) {
                this.prmtoperator.setData((Object)customerCompanyInfo.getOperationer());
            }
        }
    }

    @Override
    public void prmtdrawcer_dataChanged(DataChangeEvent e) throws Exception {
        if (this.contdrawcer.isVisible()) {
            this.txtdrawerBankNum.setText("");
        }
        this.txtacceptorName.setText(this.prmtdrawcer.getText());
    }

    @Override
    protected void billMedium_itemStateChanged(ItemEvent e) throws Exception {
        if (this.billMedium.getSelectedItem() == null) {
            return;
        }
        BillMediumEnum mediumEnum = (BillMediumEnum)((Object)this.billMedium.getSelectedItem());
        boolean required = false;
        required = mediumEnum == BillMediumEnum.ELECTRONIC;
        if (required && this.isHistoryBill()) {
            this.comboElecBillStatus.setSelectedItem(this.comboElecBillStatus.getSelectedItem() != null ? this.comboElecBillStatus.getSelectedItem() : ElecBillStatusEnum.NT030006);
            this.contElecBillStatus.setVisible(true);
        } else {
            this.comboElecBillStatus.setSelectedItem(null);
            this.contElecBillStatus.setVisible(false);
        }
        this.txtdrawerBankNum.setRequired(required);
        if (required) {
            this.txtdrawerBankNum.setBackground(new Color(252, 251, 223));
        } else {
            this.txtdrawerBankNum.setBackground(new Color(255, 255, 255));
        }
        this.txtpayeeBankNum.setRequired(required);
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.prmtAcceptorName.setRequired(required);
        } else {
            this.txtacceptorName.setRequired(required);
        }
        this.txtacceptorAccountName.setRequired(required);
        this.txtacceptorBankNum.setRequired(required);
        this.pkacceptanceDate.setRequired(required);
        this.prmtholderAccount.setRequired(required);
        this.prmtpayeeBank.setRequired(required);
        if ("true".equals(this.getSysParam("NT024"))) {
            this.prmtholderAccount.setRequired(true);
        }
        if (!this.getOprtState().equals(OprtState.EDIT) || this.editData.getSource() != BillSourceEnum.BYECDS && this.editData.getSource() != BillSourceEnum.BYNEW) {
            if (mediumEnum.equals((Object)BillMediumEnum.ELECTRONIC)) {
                if (!EmptyUtil.isEmpty((Object)e)) {
                    this.txtsubQuantity.setValue((Object)0);
                    this.txtsubRegion.setText("0-0");
                    this.txtsubStartNumber.setValue((Object)0);
                    this.txtsubEndNumber.setValue((Object)0);
                }
                this.chkisSplit.setEnabled(true);
            } else {
                this.chkisSplit.setEnabled(false);
                this.chkisSplit.setSelected(false);
                this.txtsubStartNumber.setEnabled(false);
                this.txtsubQuantity.setValue(null);
                this.txtsubRegion.setText(null);
                this.txtsubStartNumber.setValue(null);
                this.txtsubEndNumber.setValue(null);
                this.txtsubStartNumber.setRequired(false);
            }
        }
    }

    @Override
    protected void prmtpayeeBank_dataChanged(DataChangeEvent e) throws Exception {
        this.txtpayeeBankNum.setText("");
        if (EmptyUtil.isEmpty((Object)this.prmtpayeeBank.getData())) {
            return;
        }
        if (this.prmtpayeeBank.getData() instanceof BankInfo) {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(((BankInfo)this.prmtpayeeBank.getData()).getId().toString()));
            boolean isBase = false;
            if (bankInfo.getAccountBank() != null) {
                if (BEBankFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                    BEBankInfo beInfo = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                    this.txtpayeeBankNum.setText(beInfo.getNumber());
                } else {
                    isBase = true;
                }
            } else {
                isBase = true;
            }
            if (isBase) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String name = bankInfo.getName();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
                view.setFilter(filter);
                BEBankCollection coll = BEBankFactory.getRemoteInstance().getBEBankCollection(view);
                if (coll.size() > 0) {
                    this.txtpayeeBankNum.setText(coll.get(0).getNumber());
                }
            }
        } else if (this.prmtpayeeBank.getData() instanceof String) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String name = (String)this.prmtpayeeBank.getData();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
            view.setFilter(filter);
            BEBankCollection coll = BEBankFactory.getRemoteInstance().getBEBankCollection(view);
            if (coll.size() > 0) {
                this.txtpayeeBankNum.setText(coll.get(0).getNumber());
            }
        }
    }

    @Override
    protected void prmtdrawerBank_dataChanged(DataChangeEvent e) throws Exception {
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (EmptyUtil.isEmpty((Object)this.prmtdrawerBank.getData())) {
            if (EmptyUtil.isEmpty((Object)this.prmtdrawcer.getData())) {
                this.txtdrawerBankNum.setText("");
                if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
                    this.prmtAcceptorName.setData(null);
                    this.prmtacceptorBank.setData(null);
                    this.txtacceptorBankNum.setText("");
                }
            }
            return;
        }
        if (this.prmtdrawerBank.getData() instanceof BEBankInfo) {
            BEBankInfo bankInfo = (BEBankInfo)this.prmtdrawerBank.getData();
            this.txtdrawerBankNum.setText(bankInfo.getNumber());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", this.prmtdrawerBank.getData(), CompareType.EQUALS));
            view.setFilter(filter);
            BEBankCollection coll = BEBankFactory.getRemoteInstance().getBEBankCollection(view);
            if (coll.size() > 0) {
                this.txtdrawerBankNum.setText(coll.get(0).getNumber());
            }
        }
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.prmtAcceptorName.setData(this.prmtdrawerBank.getData());
            this.prmtacceptorBank.setData(this.prmtdrawerBank.getData());
            this.txtacceptorBankNum.setText(this.txtdrawerBankNum.getText());
        }
    }

    @Override
    protected void txtdrawerBankNum_focusLost(FocusEvent e) throws Exception {
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            String drawerBankNum = this.txtdrawerBankNum.getText();
            this.txtacceptorBankNum.setText(drawerBankNum);
        }
    }

    @Override
    protected void prmtacceptorBank_dataChanged(DataChangeEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.prmtacceptorBank.getData())) {
            this.txtacceptorBankNum.setText("");
            return;
        }
        if (this.prmtacceptorBank.getData() instanceof BEBankInfo) {
            BEBankInfo bankInfo = (BEBankInfo)this.prmtacceptorBank.getData();
            this.txtacceptorBankNum.setText(bankInfo.getNumber());
        }
    }

    @Override
    public void actionShowEndorseList_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowEndorseList_actionPerformed(e);
        this.showEndorseListing();
    }

    public void showEndorseListing() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ReceivableBillInfo info = (ReceivableBillInfo)this.editData.clone();
        info.setTakeDate((Date)this.pktakeDate.getValue());
        info.setIssuesDate((Date)this.pkissuesDate.getValue());
        info.setDeliverName(this.getStringName(this.prmtdeliver.getValue()));
        info.setPayeeName(this.getStringName(this.prmtpayee.getValue()));
        uiContext.put((Object)"InitDataObject", (Object)info);
        IUIWindow uiWindow = null;
        String Oprt = "";
        Oprt = "FINDVIEW".equalsIgnoreCase(this.getOprtState()) || "VIEW".equalsIgnoreCase(this.getOprtState()) ? OprtState.VIEW : OprtState.EDIT;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EndorseListingUI.class.getName(), (Map)uiContext, null, Oprt);
        uiWindow.show();
        EndorseListingCollection endorseListColl = ((EndorseListingUI)uiWindow.getUIObject()).getResult();
        this.editData.setIsModifyEndorseListing(this.isModifyEndorseListing(this.editData.getEndorseListColl(), endorseListColl));
        this.editData.setEndorseListColl(endorseListColl);
    }

    private boolean isModifyEndorseListing(EndorseListingCollection oldColl, EndorseListingCollection newColl) {
        if (oldColl == null && newColl == null) {
            return false;
        }
        if (oldColl == null && newColl != null || oldColl != null && newColl == null) {
            return true;
        }
        if (oldColl.size() != newColl.size()) {
            return true;
        }
        EndorseListingInfo oldInfo = null;
        EndorseListingInfo newInfo = null;
        int size = oldColl.size();
        for (int i = 0; i < size; ++i) {
            oldInfo = oldColl.get(i);
            newInfo = newColl.get(i);
            if ((oldInfo.getEndorseDate() == null || newInfo.getEndorseDate() == null || DateTimeUtils.truncateDate((Date)oldInfo.getEndorseDate()).compareTo(DateTimeUtils.truncateDate((Date)newInfo.getEndorseDate())) == 0) && this.getStr(oldInfo.getEndorsee()).equals(this.getStr(newInfo.getEndorsee())) && this.getStr(oldInfo.getEndorser()).equals(this.getStr(newInfo.getEndorser()))) continue;
            return true;
        }
        return false;
    }

    private String getStr(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public boolean isModify() {
        boolean isModify = super.isModify();
        return isModify || this.editData.isIsModifyEndorseListing();
    }

    protected boolean isModifySave() {
        return false;
    }

    public void onLoad() throws Exception {
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        this.rpcCacheInfo = (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
        this.isClearingHouse = this.rpcCacheInfo.isClearingHouse();
        this.isNTAssociaWithRP = this.rpcCacheInfo.isAssociateRP();
        if (!(this.currentCompany.isIsBizUnit() || "VIEW".equalsIgnoreCase(this.getOprtState()) || "FINDVIEW".equalsIgnoreCase(this.getOprtState()))) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        super.onLoad();
        if (EmptyUtil.isEmpty((Object)this.editData.getId())) {
            this.editData.setId(BOSUuid.create((BOSObjectType)new ReceivableBillInfo().getBOSType()));
        }
        if (this.isInMultiApproveUI()) {
            this.showOnlyBillInfo();
        } else {
            this.actionAuditResult.setVisible(false);
            this.actionMultiapprove.setVisible(false);
            this.actionNextPerson.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            ReceivableBillInfo info = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)pk);
            if (info.isIsFormRediscount()) {
                this.txtNumber.setEnabled(false);
                this.comboCurrency.setEnabled(false);
                this.txtbillAmt.setEnabled(false);
                this.pkexpiredDate.setEnabled(false);
                this.txtExchangeRate.setEnabled(false);
                this.txtnaturalAmt.setEnabled(false);
            }
            if (info.isIsLockByBill() || info.isIsLockByManual()) {
                this.txtDraftNumber.setEnabled(false);
                this.txtbillAmt.setEnabled(false);
            }
            if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && BOSUuid.read((String)info.getSourceBillId().toString()).getType().equals((Object)new ReceivableBillInfo().getBOSType())) {
                this.actionViewBgBalance.setEnabled(false);
            }
        }
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.input}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        this.billMedium_itemStateChanged(null);
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        this.initCurrencyComboBox(this.comboCurrency);
        Iterator iter = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.RECEIVABLE).iterator();
        while (iter.hasNext()) {
            NTTypeInfo element = (NTTypeInfo)iter.next();
            this.comboBillType.addItem((Object)element);
        }
        if (this.isHistoryBill()) {
            if (BillMediumEnum.ELECTRONIC.equals(this.billMedium.getSelectedItem())) {
                this.contElecBillStatus.setVisible(true);
            }
            this.initElecBillStatus();
        }
        this.txtnaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtbillAmt.setRemoveingZeroInDispaly(false);
        this.txtbillAmt.setHorizontalAlignment(4);
        this.txtnaturalAmt.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtExchangeRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtbillAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtOriginalBillAmt.setHorizontalAlignment(4);
        this.txtOriginalNaturalAmt.setHorizontalAlignment(4);
        this.txtAvailableAmt.setHorizontalAlignment(4);
        this.txtLockAmt.setHorizontalAlignment(4);
        this.txtOriginalBillAmt.setRemoveingZeroInDispaly(false);
        this.txtOriginalNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtAvailableAmt.setRemoveingZeroInDispaly(false);
        this.txtLockAmt.setRemoveingZeroInDispaly(false);
        this.txtPeriod.setValue((Object)Constants.ZERO);
        this.txtPeriod.setPrecision(1);
        this.txtDiscountRate.setPrecision(5);
        this.txtDiscount.setPrecision(5);
        this.txtPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtPeriod.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtDiscount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscount.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtDiscountRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtDiscountRate.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtPeriod.setHorizontalAlignment(4);
        this.txtDiscount.setHorizontalAlignment(4);
        this.txtDiscountRate.setHorizontalAlignment(4);
        this.txtsubStartNumber.setMaximumValue((Comparable)new BigDecimal("999999999999"));
        this.txtDiscount.setSupportedEmpty(false);
        this.txtDiscountRate.setSupportedEmpty(false);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.setEditPrmt(this.prmtdrawerBank, true);
        this.setEditPrmt(this.prmtacceptorBank, true);
    }

    private void initElecBillStatus() {
        this.comboElecBillStatus.removeAllItems();
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT030006);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT100001);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT100006);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT110101);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT110106);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT180001);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT180006);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT180020);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT190001);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT190006);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT200001);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT000000);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT200312);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT200412);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT200512);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT210001);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT210312);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT210412);
        this.comboElecBillStatus.addItem((Object)ElecBillStatusEnum.NT220607);
        FMClientHelper.setSelectObject((KDComboBox)this.comboElecBillStatus, (Object)((Object)ElecBillStatusEnum.NT030006));
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if ("true".equals(this.getSysParam("NT024"))) {
            this.prmtholderAccount.setRequired(true);
        }
    }

    private void initCurrencyComboBox(KDComboBox comboCurrency) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            comboCurrency.removeItemListener(itemListener[i3]);
        }
        CurrencyCollection currencyCollection = this.rpcCacheInfo.getAllCurrencyColl();
        FMHelper.sortCollection((AbstractObjectCollection)currencyCollection, (String[])new String[]{"number"});
        comboCurrency.removeAllItems();
        comboCurrency.addItems(currencyCollection.toArray());
        FMClientHelper.setSelectObject((KDComboBox)comboCurrency, (Object)this.rpcCacheInfo.getCurrentCurrency());
        int n3 = l.length;
        for (i = 0; i < n3; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n3 = itemListener.length;
        for (i = 0; i < n3; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtpayeeBank, (Boolean)new Boolean(true));
        this.prmtpayeeBank.setDisplayFormat("$name$");
        this.prmtpayeeBank.setEditFormat("$name$");
        NTHelper.initAccountBankPromt(this.prmtpayeeAccount, 1);
        NTHelper.initAccountBankPromt(this.prmtbankAccount);
        NTHelper.initAccountBankPromt(this.prmtholderAccount, 1);
        this.prmtpayeeAccount.setDisplayFormat("$bankaccountnumber$");
        this.prmtpayeeAccount.setEditFormat("$bankaccountnumber$");
        this.setAdminAllCU((IUIObject)this, this.prmtdepartment, false, true, false);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtoperator);
        EntityViewInfo entityView = NTHelper.getCSF7ViewInfoStr();
        NTHelper.initCSF7((IUIObject)this, this.prmtdrawer, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign", null);
        NTHelper.initCSF7((IUIObject)this, this.prmtdrawcer, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign", entityView);
        NTHelper.initCSF7((IUIObject)this, this.prmtpayee, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign", entityView);
        NTHelper.initCSF7((IUIObject)this, this.prmtdeliver, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign", entityView);
        this.prmtdrawer.setMaxLength(80);
        this.prmtdepartment.setRequired(false);
        CurrencyInfo curCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtBillAccount);
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtOppAccount);
    }

    private void initAdminOrgUnit(IUIObject coreui, KDBizPromptBox prmtDepartment) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtDepartment.setVisible(true);
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        prmtDepartment.setRequired(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        prmtDepartment.setEntityViewInfo(view);
        AdminCostCenterF7 f7 = new AdminCostCenterF7(coreui);
        f7.disablePerm();
        prmtDepartment.setSelector((KDPromptSelector)f7);
    }

    protected void initDataStatus() {
        this.actionAttachment.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)true);
        this.chkisHistory.setEnabled(false);
        this.billState.setEnabled(false);
        this.bizPromptCreator.setEnabled(false);
        this.txtaccountant.setEnabled(false);
        this.txtnaturalAmt.setEnabled(false);
        this.prmtholder.setEnabled(false);
        this.txtOriginalBillAmt.setEnabled(false);
        this.txtOriginalNaturalAmt.setEnabled(false);
        this.txtLockAmt.setEnabled(false);
        this.txtAvailableAmt.setEnabled(false);
        this.menuSubmitOption.setVisible(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
        if (!this.isClearingHouse) {
            this.prmtinnerAccount.setEnabled(false);
        }
        super.initDataStatus();
        ReceivableBillInfo info = (ReceivableBillInfo)this.getDataObject();
        boolean isBankPostal = NTTypeGroupEnum.RECEIVABLE_BankAccept.equals((Object)info.getNtType().getGroup());
        if (this.getOprtState().equals(OprtState.EDIT) && info.getBillState() != BillStateEnum.TempSaved) {
            this.actionSave.setEnabled(false);
        }
        this.setControlByIfBillIsUsed(info.isIsNoUsed(), false);
        if (this.getOprtState().equals(OprtState.VIEW) || "FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            this.actionEdit.setEnabled(info.isCanEdit() && info.getEndorseBill() == null && info.getRpBillId() == null);
            this.chkisNoUsed.setEnabled(false);
            this.chkisVendeePayInt.setEnabled(false);
            if (info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
                this.actionCopy.setEnabled(true);
            } else {
                this.actionCopy.setEnabled(false);
            }
        } else {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(info.isCanEdit());
        }
        if (this.getOprtState().equals(OprtState.EDIT) && info.getBillState() != BillStateEnum.TempSaved) {
            this.actionSave.setEnabled(false);
        }
        if (info.getPayeeAccount() != null && info.getPayeeAccount().getCurrency() != null) {
            this.comboCurrency.setEnabled(false);
        } else {
            this.comboCurrency.setEnabled(true);
        }
        if (info.getId() != null && info.getSourceBillId() != null) {
            BOSObjectType bosType = BOSUuid.read((String)info.getSourceBillId().toString()).getType();
            if (bosType.equals((Object)new ReceivingBillInfo().getBOSType())) {
                this.comboCurrency.setEnabled(false);
                this.txtbillAmt.setEditable(false);
            }
            if (bosType.equals((Object)new EndorsementBillInfo().getBOSType()) || bosType.equals((Object)new DiscountBillInfo().getBOSType())) {
                FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
                IKDComponent[] enableComps = new IKDComponent[]{this.txtcontractNo, this.txtacceptanceNo, this.prmtBgItem, this.prmtOppAccount, this.prmtdepartment, this.prmtoperator, this.txtDescription, this.pktakeDate, this.prmtProject, this.prmtCostCenter, this.prmtholderAccount};
                FMClientHelper.setCompEnable((IKDComponent[])enableComps, (boolean)true);
                if (bosType.equals((Object)new EndorsementBillInfo().getBOSType()) && this.isClearingHouse) {
                    this.prmtbankAccount.setEnabled(true);
                }
                this.isFromEndorsement = true;
            }
        }
        if (this.isBotp()) {
            this.actionSave.setEnabled(false);
        }
        if (info.getTransferId() != null && !"".equals(info.getTransferId())) {
            this.isFromPayablebill = true;
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            IKDComponent[] enableComps = new IKDComponent[]{this.txtdigest, this.prmtBgItem, this.prmtOppAccount, this.prmtdepartment, this.prmtoperator, this.txtDescription, this.prmtProject, this.prmtCostCenter, this.prmtholder, this.prmtholderAccount, this.txtacceptorAccountName, this.txtacceptorBankNum, this.pkacceptanceDate};
            FMClientHelper.setCompEnable((IKDComponent[])enableComps, (boolean)true);
        } else {
            this.setEditPrmt(this.prmtpayeeBank, true);
        }
        this.prmtBillAccount.setEnabled(!info.isFivouchered());
        this.prmtOppAccount.setEnabled(!info.isFivouchered());
        if (info.getCurrency().getId().toString().equals(this.currentCompany.getBaseCurrency().getId().toString())) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
        if (info.getBillMedium().equals((Object)BillMediumEnum.PAPERY)) {
            this.chkisSplit.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (info.isIsFormRediscount()) {
                this.txtNumber.setEnabled(false);
                this.comboCurrency.setEnabled(false);
                this.txtbillAmt.setEnabled(false);
                this.pkexpiredDate.setEnabled(false);
                this.txtExchangeRate.setEnabled(false);
                this.txtnaturalAmt.setEnabled(false);
            }
            if (info.getSource() == BillSourceEnum.BYECDS || info.getSource() == BillSourceEnum.BYNEW) {
                this.actionAddNew.setEnabled(false);
                this.actionCopy.setEnabled(false);
                this.billMedium.setEnabled(false);
                this.txtDraftNumber.setEnabled(false);
                this.pkissuesDate.setEnabled(false);
                this.pkexpiredDate.setEnabled(false);
                this.prmtdrawer.setEnabled(false);
                this.prmtdrawerAccount.setEnabled(false);
                this.prmtdrawerBank.setEnabled(false);
                this.txtdrawerBankNum.setEnabled(false);
                this.prmtpayee.setEnabled(false);
                this.prmtpayeeAccount.setEnabled(false);
                this.prmtpayeeBank.setEnabled(false);
                this.txtpayeeBankNum.setEnabled(false);
                this.prmtAcceptorName.setEnabled(false);
                this.txtacceptorName.setEnabled(false);
                this.txtacceptorAccountName.setEnabled(false);
                this.prmtacceptorBank.setEnabled(false);
                this.txtacceptorBankNum.setEnabled(false);
                this.comboCurrency.setEnabled(false);
                this.txtbillAmt.setEnabled(false);
                this.comboBillType.setEnabled(false);
                this.chkisSplit.setEnabled(false);
                this.txtDraftPackageNumber.setEnabled(false);
                this.prmtdrawerBank.setEnabled(false);
                this.prmtdrawcer.setEnabled(false);
                this.txtDescription.setEnabled(false);
                this.pkacceptanceDate.setEnabled(false);
                this.txtbatchNo.setEnabled(false);
            }
        }
        ExtendParser prmtdrawerAccountParser = new ExtendParser(this.prmtdrawerAccount);
        this.prmtdrawerAccount.setCommitParser((IParser)prmtdrawerAccountParser);
        this.prmtdrawerAccount.setCommitFormat("$id$;$number$;$name$");
        this.prmtdrawerAccount.setDisplayFormat("$name$");
        this.prmtdrawerAccount.setEditFormat("$name$");
        this.setActionEnable(info);
        this.txtDraftNumber.setEnabled(false);
        this.txtsubRegion.setEnabled(false);
        this.txtsubQuantity.setEnabled(false);
        this.txtsubQuantity.setPrecision(0);
        if (info.getSource().equals((Object)BillSourceEnum.BYHAND) && info.isIsSplit()) {
            this.txtsubStartNumber.setEnabled(true);
        } else {
            this.txtsubStartNumber.setEnabled(false);
        }
        this.txtsubStartNumber.setPrecision(0);
        this.txtsubEndNumber.setEnabled(false);
        this.txtsubEndNumber.setPrecision(0);
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && BOSUuid.read((String)info.getSourceBillId().toString()).getType().equals((Object)new ReceivableBillInfo().getBOSType())) {
            this.actionEdit.setEnabled(false);
        }
        if (info.isIsSplit()) {
            this.txtsubStartNumber.setRequired(true);
        } else {
            this.txtsubStartNumber.setRequired(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW) && !EmptyUtil.isEmpty((Object)info.getLockAmt()) && info.getLockAmt().compareTo(BigDecimal.ZERO) != 0) {
            this.actionEdit.setEnabled(false);
            this.actionAudit.setEnabled(false);
        }
    }

    protected void setActionEnable(ReceivableBillInfo info) {
        if (BillStateEnum.SAVED.equals((Object)info.getBillState()) && info.getCompany() != null && info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
            this.actionAudit.setEnabled(true);
        } else {
            this.actionAudit.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT) || !this.rpcCacheInfo.isNeedAudit()) {
            this.actionAudit.setVisible(false);
        }
        this.menuBiz.setVisible(false);
    }

    private boolean isBotp() {
        return this.getUIContext().get("srcBillID") != null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionCancelAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.btnShowEndorseList.setIcon(EASResource.getIcon((String)"imgTtn_writeatback"));
        this.actionAttachment.setVisible(false);
        this.actionSave.setVisible(true);
        this.actionCopy.setVisible(true);
    }

    private void setCustF7(KDPromptBox promptBox) throws Exception {
        promptBox.setSelector((KDPromptSelector)new GeneralKDPromptSelectorAdaptor(promptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)this.ui, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQueryForAssign"));
    }

    private void showOnlyBillInfo() {
        this.conttakeDate.setVisible(false);
        this.contcontractNo.setVisible(false);
        this.contdeliver.setVisible(false);
        this.contdepartment.setVisible(false);
        this.contbankAccount.setVisible(false);
        this.continnerAccount.setVisible(false);
        this.contoperator.setVisible(false);
        this.contRemark.setVisible(false);
        this.contdigest.setVisible(false);
        this.contCreator.setVisible(false);
        this.contaccountant.setVisible(false);
        this.chkisHistory.setVisible(false);
        this.chkisVendeePayInt.setVisible(false);
        this.chkisNoUsed.setVisible(false);
    }

    private void setEditPrmt(KDBizPromptBox prompt, boolean flag) {
        if (flag) {
            ExtendParser parser = new ExtendParser(prompt);
            prompt.setCommitParser((IParser)parser);
        } else {
            prompt.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prompt));
        }
    }

    private boolean isHistoryBill() {
        Object objParam = this.getUIContext().get("UIClassParam");
        return objParam != null && ((String)objParam).equals(HISTORY_BILL) || this.editData != null && this.editData.isIsHistory();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.getBillState().equals((Object)BillStateEnum.SAVED) && !this.editData.getBillState().equals((Object)BillStateEnum.TempSaved)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"363_ReceivableBillEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        if (this.editData.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.prmtAcceptorName.setText(this.editData.getAcceptorName());
        } else {
            this.txtacceptorName.setText(this.editData.getAcceptorName());
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.setSelectObject((KDComboBox)this.billState, (Object)((Object)BillStateEnum.TempSaved));
        this.storeFields();
        this.verify();
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.pktakeDate.getValue()));
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        long startTime = System.currentTimeMillis();
        this.storeFields();
        this.pk = null;
        logger.info((Object)"**************************************************************");
        logger.info((Object)(System.currentTimeMillis() - startTime));
        this.verify();
        if (this.editData.getBillState() == null || this.editData.getBillState() == BillStateEnum.TempSaved) {
            FMClientHelper.setSelectObject((KDComboBox)this.billState, (Object)((Object)BillStateEnum.SAVED));
        }
        boolean isCreateReceiving = false;
        boolean isCreateFromReceivingBill = FMHelper.isInstanceof((String)this.editData.getSourceBillId(), ReceivingBillInfo.class);
        if (!this.isHistoryBill() && this.editData.getBillState() != null && FMHelper.isEmpty((String)this.editData.getRpBillId()) && this.isNTAssociaWithRP && !isCreateFromReceivingBill) {
            int msg = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isGenReceivingBill"));
            if (msg == 0) {
                isCreateReceiving = true;
            } else if (msg == 2) {
                SysUtil.abort();
            }
        }
        logger.info((Object)"*************************************************************");
        logger.info((Object)(System.currentTimeMillis() - startTime));
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.pktakeDate.getValue()));
        super.actionSubmit_actionPerformed(e);
        logger.info((Object)"*************************************************************");
        logger.info((Object)(System.currentTimeMillis() - startTime));
        if (this.pk != null) {
            String Msg;
            String billId = this.pk.toString();
            if (isCreateReceiving) {
                ReceivableBillInfo info = (ReceivableBillInfo)this.getValue(this.pk);
                info.setId(BOSUuid.read((String)billId));
                BOTMappingInfo botMappingInfo = FMClientHelper.getBotMappingInfoByBillID((String)ConvertUtils.IDSTR((Object)this.currentCompany), null, (String)new ReceivableBillInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (CoreBillBaseInfo)info);
                HashSet<String> ids = new HashSet<String>();
                ids.add(billId);
                Map map = ReceivableBillFactory.getRemoteInstance().genReceivingBill(ids, botMappingInfo);
            }
            if ((Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId)) != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk = super.runSubmit();
        return this.pk;
    }

    @Override
    protected String getEditUIName() {
        return ReceivableBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceivableBillFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        SupplierInfo info;
        super.verifyInput(e);
        if (this.prmtdrawer.getData() != null && this.prmtdrawer.getData() instanceof SupplierInfo) {
            info = (SupplierInfo)this.prmtdrawer.getData();
            SupplierInfo supplierInfo = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            if (supplierInfo != null && !UsedStatusEnum.APPROVED.equals((Object)supplierInfo.getUsedStatus())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"615_payableBillEdit"));
                this.prmtdrawer.requestFocus();
                SysUtil.abort();
            }
        }
        if (this.prmtdrawer.getData() != null && this.prmtdrawer.getData() instanceof CustomerInfo) {
            info = (CustomerInfo)this.prmtdrawer.getData();
            CustomerInfo customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            if (customerInfo != null && !UsedStatusEnum.APPROVED.equals((Object)customerInfo.getUsedStatus())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"616_payableBillEdit"));
                this.prmtdrawer.requestFocus();
                SysUtil.abort();
            }
        }
    }

    private void verify() throws Exception {
        if (this.prmtAcceptorName.isRequired() && this.prmtAcceptorName.getData() == null && this.prmtAcceptorName.getText() != null) {
            this.prmtAcceptorName.setData((Object)this.prmtAcceptorName.getText());
        }
        if (this.chkisNoUsed.isSelected()) {
            if (this.prmtdrawer.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"444_drawerEmpty"));
                SysUtil.abort();
            }
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtpayeeAccount);
        }
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        BigDecimal amount = this.txtbillAmt.getBigDecimalValue();
        BigDecimal zero = Constants.ZERO;
        if (amount != null && amount.compareTo(zero) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        if (((Date)this.pkexpiredDate.getValue()).before((Date)this.pkissuesDate.getValue()) || ((Date)this.pkexpiredDate.getValue()).equals((Date)this.pkissuesDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"77_ReceivableBillImportVerify"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)((Date)this.pktakeDate.getValue())).before(DateTimeUtils.truncateDate((Date)((Date)this.pkissuesDate.getValue())))) {
            throw new NTException(NTException.TAKEDATE_NOT_AFTER_ISSUESDATE);
        }
        if (!(this.chkisNoUsed.isSelected() || this.isFromEndorsement || this.isFromPayablebill)) {
            EndorseListingCollection coll = this.editData.getEndorseListColl();
            String endorserName = "";
            String endorseeName = "";
            Object var6_6 = null;
        }
        if (this.chkisSplit.isSelected() && this.txtsubStartNumber.getBigDecimalValue().compareTo(BigDecimal.ONE) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"638_ReceivableBillBatchInputUI"));
            SysUtil.abort();
        }
    }

    protected void afterSubmitAddNew() {
        this.editData.setId(BOSUuid.read((String)((String)this.getUIContext().get("ID"))));
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        try {
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.loadFields();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.comboCurrency.setEnabled(true);
        BigDecimal discountRate = this.txtDiscountRate.getBigDecimalValue();
        super.afterSubmitAddNew();
    }

    @Override
    protected IObjectValue createNewData() {
        ReceivableBillInfo objectValue = null;
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            try {
                ReceivableBillInfo oldInfo = (ReceivableBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                objectValue = oldInfo.copy();
                this.isCopy = true;
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            objectValue = new ReceivableBillInfo();
            Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
            objectValue.setTakeDate(currentDate);
            objectValue.setIssuesDate(currentDate);
            objectValue.setExpiredDate(currentDate);
            objectValue.setAcceptanceDate(currentDate);
            objectValue.setHolder(this.currentCompany);
            objectValue.setSource(BillSourceEnum.BYHAND);
            objectValue.setCurrency(this.bassCurrency);
            objectValue.setExchangeRate(DEFAULT_EXCHANGERATE);
            objectValue.setBillMedium(BillMediumEnum.ELECTRONIC);
            NTTypeInfo ntTypeInfo = new NTTypeInfo();
            ntTypeInfo.setId(BOSUuid.read((String)"33333333-3333-3333-3333-3333333333331C9A9013"));
            ntTypeInfo.setGroup(NTTypeGroupEnum.RECEIVABLE_BankAccept);
            objectValue.setNtType(ntTypeInfo);
            objectValue.setBillState(BillStateEnum.TempSaved);
            objectValue.setIsNoUsed(true);
            objectValue.setDiscount(Constants.ZERO);
            objectValue.setDiscountRate(Constants.ZERO);
            objectValue.setAcceptorAccountName("0");
            objectValue.setPeriod(Constants.ZERO);
            objectValue.setBankAccount(null);
            objectValue.setInnerAccount(null);
        }
        return objectValue;
    }

    private boolean isInMultiApproveUI() {
        Object object = this.getUIContext().get("Owner");
        if (object == null) {
            return false;
        }
        return object.getClass().equals(EndorseNoteBillApproveUI.class);
    }

    @Override
    protected void prmtdepartment_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    public void prmtoperator_willShow(SelectorEvent e) {
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtdepartment.getData();
        if (adminOrgUnitInfo != null) {
            PersonPromptBox select = (PersonPromptBox)this.prmtoperator.getSelector();
            if (select == null) {
                F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtoperator);
            }
            if (select != null) {
                select.setExpandAdmin(adminOrgUnitInfo.getId().toString());
                select.setCU(adminOrgUnitInfo.getCU().getId().toString());
            }
        }
    }

    @Override
    public void prmtoperator_willCommit(CommitEvent e) {
    }

    protected void prmtpayeeBank_willShow(SelectorEvent e) throws Exception {
        if (!this.chkisNoUsed.isSelected()) {
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void prmtpayee_dataChanged(DataChangeEvent e) throws Exception {
        ObjectBaseInfo csInfo;
        if (this.prmtpayee.getData() instanceof String && (csInfo = NTHelper.getCSInfoByNumber((String)this.prmtpayee.getData())) != null) {
            this.prmtpayee.setData((Object)csInfo);
        }
        CSBankInfo csbankInfo = FMHelper.getCSBankInfo(null, (Object)this.prmtpayee.getData(), (String)this.currentCompany.getId().toString());
        this.prmtpayeeAccount.setData((Object)csbankInfo.getBankAccount());
        this.prmtpayeeAccount.setText(csbankInfo.getBankAccount());
        this.prmtpayeeBank.setValue((Object)csbankInfo.getBank());
    }

    @Override
    protected void prmtpayeeAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof AccountBankInfo) {
            AccountBankInfo acctbank = (AccountBankInfo)e.getNewValue();
            this.setCurr(acctbank);
            if ((this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) && this.chkisNoUsed.isSelected()) {
                this.prmtholderAccount.setData((Object)acctbank);
            }
        } else if (e.getNewValue() == null) {
            this.prmtpayeeBank.setData(null);
        }
    }

    private void setCurr(AccountBankInfo acctbank) {
        if (acctbank.getBank() != null) {
            this.prmtpayeeBank.setData((Object)acctbank.getBank());
        }
        if (acctbank.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)acctbank.getCurrency());
            this.comboCurrency.setEnabled(false);
        } else {
            this.comboCurrency.setEnabled(true);
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency.getId().toString().equals(this.bassCurrency.getId().toString())) {
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEnabled(true);
        }
    }

    @Override
    protected String getTDFileName() {
        return "/FM/NT/AC";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.ReceivableBillTDQuery");
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo curCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtOppAccount);
    }

    @Override
    protected void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo curCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtOppAccount);
    }

    @Override
    protected void prmtBillAccount_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo curCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtBillAccount);
    }

    @Override
    protected void prmtBillAccount_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo curCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, curCurrency.getId().toString(), this.currentCompany, this.prmtBillAccount);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (this.editData.getId() != null) {
            ReceivableBillInfo receivableBillInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), this.getSelectors());
            FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.ReceivableBill", null, (IObjectValue)receivableBillInfo);
        } else {
            FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.ReceivableBill", null, (IObjectValue)this.editData);
        }
    }

    @Override
    protected void prmtinnerAccount_willShow(SelectorEvent e) throws Exception {
        System.out.println(true);
        EntityViewInfo eviInAccount = new EntityViewInfo();
        FilterInfo filterInAccount = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = this.currentCompany;
        if (companyInfo != null) {
            filterInAccount.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        } else {
            filterInAccount.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)"***"));
        }
        eviInAccount.setFilter(filterInAccount);
        this.prmtinnerAccount.getQueryAgent().resetRuntimeEntityView();
        this.prmtinnerAccount.setEntityViewInfo(eviInAccount);
    }

    @Override
    public void prmtdeliver_dataChanged(DataChangeEvent e) throws Exception {
        ObjectBaseInfo csInfo;
        this.prmtinnerAccount.setData(null);
        if (!this.chkisNoUsed.isSelected() && this.prmtdeliver.getData() instanceof CustomerInfo) {
            CustomerInfo custInfo = (CustomerInfo)this.prmtdeliver.getData();
            CustomerCompanyInfoInfo customerCompanyInfo = NTHelper.getCustomerCompanyByCustomer(custInfo.getId().toString(), this.currentCompany.getId().toString());
            if (customerCompanyInfo != null) {
                if (customerCompanyInfo.getAdminOrgUnit() != null) {
                    this.prmtdepartment.setData((Object)customerCompanyInfo.getAdminOrgUnit());
                }
                if (customerCompanyInfo.getOperationer() != null) {
                    this.prmtoperator.setData((Object)customerCompanyInfo.getOperationer());
                }
            }
        } else if (!this.chkisNoUsed.isSelected() && this.prmtdeliver.getData() instanceof String && (csInfo = NTHelper.getCSInfoByNumber((String)this.prmtdeliver.getData())) != null) {
            this.prmtdeliver.setData((Object)csInfo);
        }
    }

    private CompanyOrgUnitInfo getCompanyWithCS(Object objInfo) throws EASBizException, BOSException {
        if (objInfo instanceof CustomerInfo) {
            return ((CustomerInfo)objInfo).getInternalCompany();
        }
        if (objInfo instanceof SupplierInfo) {
            SupplierInfo suppInfo = (SupplierInfo)objInfo;
            if (suppInfo.getInternalCompany() == null) {
                SelectorItemCollection sel = new SelectorItemCollection();
                sel.add("internalCompany.id");
                suppInfo.setInternalCompany(SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(suppInfo.getId().toString()), sel).getInternalCompany());
            }
            return suppInfo.getInternalCompany();
        }
        return null;
    }

    private void setPeriod() {
        this.txtPeriod.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkissuesDate, (KDDatePicker)this.pkexpiredDate));
    }

    @Override
    protected void pkissuesDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setPeriod();
        NTTypeInfo nttypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        if (nttypeInfo.getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.pkacceptanceDate.setValue((Object)this.pkissuesDate.getSqlDate());
        }
    }

    @Override
    protected void pkexpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setPeriod();
    }

    @Override
    protected void pktakeDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscount();
    }

    private void calcDiscount() {
        if (this.txtPeriod.getBigDecimalValue() == null || this.pktakeDate.getValue() == null || this.pkexpiredDate.getValue() == null || this.txtDiscountRate.getBigDecimalValue() == null || this.txtbillAmt.getBigDecimalValue() == null) {
            return;
        }
        BigDecimal discount = null;
        if (this.txtPeriod.getBigDecimalValue().compareTo(new BigDecimal("3")) <= 0) {
            discount = Constants.ZERO;
        } else {
            long dateDiff = DateUtil.getDiffDays((Date)((Date)this.pktakeDate.getValue()), (Date)((Date)this.pkexpiredDate.getValue())) - 1;
            discount = new BigDecimal(dateDiff).multiply(this.txtDiscountRate.getBigDecimalValue()).multiply(this.txtbillAmt.getBigDecimalValue()).divide(new BigDecimal("30000"), 6, 4);
        }
        this.txtDiscount.setValue((Object)discount);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isCopy = true;
        this.checkModified();
        if (this.editData != null) {
            ReceivableBillInfo newEditData = this.editData.copy();
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            newEditData.setId(BOSUuid.create((BOSObjectType)newEditData.getBOSType()));
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    protected void txtPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscount();
    }

    @Override
    protected void txtDiscountRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcDiscount();
    }

    protected boolean isRpcCacheProcess() {
        return super.isRpcCacheProcess();
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    public int getHorizontalScrollPolicy() {
        return 30;
    }

    public boolean useScrollPane() {
        return true;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        ReceivableBillFactory.getRemoteInstance().audit(idSet);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"211_ChequeListUI"));
        this.actionEdit.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionCancelAudit.setEnabled(true);
    }

    @Override
    public void actionCancelAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        ReceivableBillFactory.getRemoteInstance().cancelAudit(idSet);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"212_ChequeListUI"));
        this.actionAudit.setEnabled(true);
        this.actionCancelAudit.setEnabled(false);
    }

    protected void disposeUIWindow() {
        String srcBillID = (String)this.getUIContext().get("srcBillID");
        if (!EmptyUtil.isEmpty((String)srcBillID)) {
            MutexUtils.releaseMutex((String)srcBillID);
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
            view.setFilter(filter);
            ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                IEndorseListing iEndorseListing = EndorseListingFactory.getRemoteInstance();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("head.id", (Object)this.editData.getId().toString()));
                iEndorseListing.delete(filterInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.disposeUIWindow();
    }

    @Override
    protected void prmtdrawerAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtdrawerAccount_willCommit(e);
        this.setDrawerAccount();
    }

    @Override
    protected void prmtdrawerAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtdrawerAccount_willShow(e);
        this.setDrawerAccount();
    }

    private void setDrawerAccount() throws BOSException, EASBizException {
        Object drawer = this.prmtdrawer.getValue();
        boolean isSupplier = false;
        boolean isCustomer = false;
        boolean isInnerSupplierOrCustomer = false;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (drawer instanceof SupplierInfo) {
            isSupplier = true;
            supplier = (SupplierInfo)drawer;
            if (supplier != null) {
                supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
            }
        } else if (drawer instanceof CustomerInfo) {
            isCustomer = true;
            customer = (CustomerInfo)drawer;
            if (customer != null) {
                customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()));
                isInnerSupplierOrCustomer = customer.isIsInternalCompany();
            }
        }
        if (isSupplier && !isInnerSupplierOrCustomer) {
            this.initSupplierCompanyInfoBank((DataBaseInfo)supplier, this.prmtdrawerAccount);
        } else if (isCustomer && !isInnerSupplierOrCustomer) {
            this.initCustomerCompanyInfoBank((DataBaseInfo)customer, this.prmtdrawerAccount);
        } else {
            this.initDrawerAccountASAcct();
        }
    }

    private void initSupplierCompanyInfoBank(DataBaseInfo supply, KDBizPromptBox prmtdrawerAccount) {
        prmtdrawerAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
        prmtdrawerAccount.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (supply != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        prmtdrawerAccount.setEntityViewInfo(view);
        prmtdrawerAccount.setEditFormat("$bankAccount$");
        prmtdrawerAccount.setDisplayFormat("$bankAccount$");
        prmtdrawerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initCustomerCompanyInfoBank(DataBaseInfo customer, KDBizPromptBox prmtdrawerAccount) {
        prmtdrawerAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
        prmtdrawerAccount.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (customer != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customer.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        prmtdrawerAccount.setEntityViewInfo(view);
        prmtdrawerAccount.setEditFormat("$bankAccount$");
        prmtdrawerAccount.setDisplayFormat("$bankAccount$");
        prmtdrawerAccount.setCommitFormat("$bankAccount$");
        prmtdrawerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initDrawerAccountASAcct() {
        AccountViewInfo oppAccount = null;
        if (this.prmtOppAccount.getValue() != null) {
            oppAccount = (AccountViewInfo)this.prmtOppAccount.getValue();
        }
        Object drawer = this.prmtdrawer.getData();
        if (oppAccount == null) {
            this.initDrawerAccountEV(oppAccount, false, drawer);
        } else if (oppAccount.isIsBank()) {
            this.initDrawerAccountEV(oppAccount, true, drawer);
        } else {
            this.initDrawerAccountEV(oppAccount, false, drawer);
        }
        this.prmtdrawerAccount.setEditFormat("$bankAccountNumber$");
        this.prmtdrawerAccount.setDisplayFormat("$bankAccountNumber$");
        this.prmtdrawerAccount.setCommitFormat("$simpleCode$;$id$;$number$;$name$;$bankAccountNumber$");
        this.prmtdrawerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initDrawerAccountEV(AccountViewInfo oppAccount, boolean isBank, Object drawer) {
        FilterInfo filterName;
        CurrentInfo current;
        SupplierInfo spi;
        SelectorItemCollection spSelector;
        DataBaseInfo dbi;
        this.prmtdrawerAccount.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        if (oppAccount != null && isBank) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)oppAccount.getId().toString()));
        }
        String realDrawer = "";
        if (drawer instanceof SupplierInfo && !EmptyUtil.isEmpty((Object)drawer)) {
            block17: {
                if (drawer instanceof DataBaseInfo) {
                    dbi = (DataBaseInfo)drawer;
                    try {
                        spSelector = new SelectorItemCollection();
                        spSelector.add("internalCompany.name");
                        spi = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(dbi.getId()), spSelector);
                        realDrawer = spi.getInternalCompany().getName();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        if (drawer instanceof SupplierInfo) {
                            SupplierInfo supplierInfo = (SupplierInfo)drawer;
                            realDrawer = supplierInfo.getName();
                        }
                        if (!(drawer instanceof CurrentInfo)) break block17;
                        current = (CurrentInfo)drawer;
                        realDrawer = current.getName();
                    }
                }
            }
            if (realDrawer != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realDrawer));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realDrawer));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realDrawer));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        if (drawer instanceof CustomerInfo && !EmptyUtil.isEmpty((Object)drawer)) {
            block18: {
                if (drawer instanceof DataBaseInfo) {
                    dbi = (DataBaseInfo)drawer;
                    try {
                        spSelector = new SelectorItemCollection();
                        spSelector.add("internalCompany.name");
                        spi = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(dbi.getId()), spSelector);
                        realDrawer = spi.getInternalCompany().getName();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        if (drawer instanceof CustomerInfo) {
                            CustomerInfo customerInfo = (CustomerInfo)drawer;
                            realDrawer = customerInfo.getName();
                        }
                        if (!(drawer instanceof CurrentInfo)) break block18;
                        current = (CurrentInfo)drawer;
                        realDrawer = current.getName();
                    }
                }
            }
            if (realDrawer != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realDrawer));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realDrawer));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realDrawer));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtdrawerAccount.setEntityViewInfo(evi);
        this.prmtdrawerAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtdrawerAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtdrawerAccount_dataChanged(e);
        if (e.getNewValue() != null && e.getNewValue() instanceof AccountBankInfo) {
            AccountBankInfo acctbank = (AccountBankInfo)e.getNewValue();
            this.editData.setDrawerAccount(acctbank);
            if (acctbank.getBank() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("bank.id");
                selector.add("bank.name");
                selector.add("bank.number");
                AccountBankInfo bank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctbank.getId()), selector);
                this.prmtdrawerBank.setData((Object)bank.getBank().toString());
            }
        } else if (e.getNewValue() != null && (e.getNewValue() instanceof SupplierCompanyBankInfo || e.getNewValue() instanceof CustomerCompanyBankInfo)) {
            CoreBaseInfo obj = (CoreBaseInfo)e.getNewValue();
            String bank = (String)obj.get("bank");
            this.prmtdrawerBank.setData((Object)bank);
        } else if (e.getNewValue() == null) {
            this.editData.setDrawerAccount(null);
            this.prmtdrawerBank.setData(null);
        } else {
            this.prmtdrawerBank.setData(null);
        }
    }

    @Override
    protected void prmtholder_dataChanged(DataChangeEvent e) throws Exception {
        String companyId = null;
        if (e.getNewValue() == null) {
            companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        } else {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
            companyId = company.getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.prmtholderAccount.setEntityViewInfo(viewInfo);
    }

    @Override
    protected void txtDraftPackageNumber_focusLost(FocusEvent e) throws Exception {
        String draftPackageNumber = this.txtDraftPackageNumber.getText();
        if (this.chkisSplit.isSelected() && !EmptyUtil.isEmpty((String)draftPackageNumber)) {
            this.txtDraftNumber.setText(draftPackageNumber + "-" + this.txtsubRegion.getText());
        } else {
            this.txtDraftNumber.setText(draftPackageNumber);
        }
    }

    @Override
    protected void chkisSplit_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkisSplit.isSelected()) {
            this.txtsubStartNumber.setEnabled(true);
            if (!EmptyUtil.isEmpty((Object)this.txtbillAmt.getBigDecimalValue())) {
                this.txtsubQuantity.setValue((Object)this.txtbillAmt.getBigDecimalValue().divide(this.editData.getStandardBillAmt()).stripTrailingZeros());
            }
            this.txtsubStartNumber.setValue((Object)1);
            this.txtsubStartNumber.setRequired(true);
        } else {
            this.txtsubStartNumber.setEnabled(false);
            this.txtsubQuantity.setValue((Object)0);
            this.txtsubRegion.setText("0-0");
            this.txtsubStartNumber.setValue((Object)0);
            this.txtsubEndNumber.setValue((Object)0);
            if (!EmptyUtil.isEmpty((String)this.txtDraftPackageNumber.getText())) {
                this.txtDraftNumber.setText(this.txtDraftPackageNumber.getText());
            }
            this.txtsubStartNumber.setRequired(false);
        }
    }

    @Override
    protected void txtsubStartNumber_dataChanged(DataChangeEvent e) throws Exception {
        this.setTxtsubRegion();
    }

    protected void setTxtsubRegion() {
        BigDecimal subQuantity = this.txtsubQuantity.getBigDecimalValue();
        BigDecimal subStartNumber = this.txtsubStartNumber.getBigDecimalValue();
        if (!EmptyUtil.isEmpty((Object)subQuantity) && !EmptyUtil.isEmpty((Object)subStartNumber) && subQuantity.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal subEndNumber = subQuantity.add(subStartNumber).subtract(BigDecimal.ONE);
            this.txtsubEndNumber.setValue((Object)subEndNumber);
            this.txtsubRegion.setText(subStartNumber.toString() + "-" + subEndNumber.toString());
            if (!EmptyUtil.isEmpty((String)this.txtDraftPackageNumber.getText())) {
                this.txtDraftNumber.setText(this.txtDraftPackageNumber.getText() + "-" + this.txtsubRegion.getText());
            }
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "takeDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionCancelAudit"};
    }

    public void setAdminAllCU(IUIObject ui, KDBizPromptBox prmtAdminOrgUnit, boolean fMultiSelection, boolean displayName, boolean isContainsSealUp) {
        prmtAdminOrgUnit.setEditable(true);
        prmtAdminOrgUnit.setEditFormat("$number$");
        prmtAdminOrgUnit.setDisplayFormat("$name$");
        if (displayName) {
            prmtAdminOrgUnit.setCommitFormat("$number$;$name$");
        } else {
            prmtAdminOrgUnit.setCommitFormat("$number$");
        }
        NewAdminF7 adminF7 = new NewAdminF7(ui);
        adminF7.setNeedAddOrgRange(false);
        adminF7.setNeedConsiderFaultTree(false);
        adminF7.setIsCUFilter(true);
        adminF7.showCheckBoxOfShowingAllOUs();
        adminF7.setMultiSelect(fMultiSelection);
        prmtAdminOrgUnit.setSelector((KDPromptSelector)adminF7);
        prmtAdminOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
    }
}

