/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableBillSplitUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReceivableBillSplitUI
extends AbstractReceivableBillSplitUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableBillSplitUI.class);
    private ReceivableBillInfo receivableBillInfo = new ReceivableBillInfo();
    private int precision = 2;
    private static final String DRAFTNUMBER = "draftNumber";
    private static final String BILLAMOUNT = "billAmount";
    private static final String SUBREGION = "subRegion";
    private static final String SUBSTARTNUMBER = "subStartNumber";
    private static final String SUBENDNUMBER = "subEndNumber";
    private static final String SUBQUANTITY = "subQuantity";
    private static BigDecimal standardBillAmt = new BigDecimal("0.01");
    private static String draftPackageNumber;
    private static BigDecimal subStartNumber;
    private static BigDecimal amount;

    public void onLoad() throws Exception {
        this.receivableBillInfo = (ReceivableBillInfo)this.getUIContext().get("ReceivableInfo");
        standardBillAmt = this.receivableBillInfo.getStandardBillAmt();
        draftPackageNumber = this.receivableBillInfo.getDraftPackageNumber();
        subStartNumber = this.receivableBillInfo.getSubStartNumber();
        amount = this.receivableBillInfo.getBillAmt();
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        if (this.receivableBillInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.contdrawcer.setVisible(false);
            this.contdrawerBank.setVisible(true);
        } else {
            this.contdrawcer.setVisible(true);
            this.contdrawerBank.setVisible(false);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceivingBillFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddBill.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveBill.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    protected IObjectValue createNewData() {
        ReceivableBillInfo objectValue = this.receivableBillInfo;
        return objectValue;
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        ExtendParser parser = new ExtendParser(this.prmtdrawerBank);
        this.prmtdrawerBank.setCommitParser((IParser)parser);
        Iterator iter = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.RECEIVABLE).iterator();
        while (iter.hasNext()) {
            NTTypeInfo element = (NTTypeInfo)iter.next();
            this.comboBillType.addItem((Object)element);
        }
        FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
        this.txtbillAmt.setHorizontalAlignment(4);
        this.txtnaturalAmt.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtnaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtbillAmt.setRemoveingZeroInDispaly(false);
    }

    @Override
    public void loadFields() {
        try {
            CurrencyInfo bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.editData.getCompany());
            this.precision = FMHelper.getPrecOfCurrency(null, (String)this.editData.getCurrency().getId().toString());
            this.txtbillAmt.setPrecision(this.precision);
            this.txtnaturalAmt.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)bassCurrency.getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (this.editData.getDrawer() != null) {
            this.prmtdrawer.setData((Object)this.editData.getDrawer());
        } else if (this.editData.getDrawerSupp() != null) {
            this.prmtdrawer.setData((Object)this.editData.getDrawerSupp());
        } else {
            this.prmtdrawer.setValue((Object)this.editData.getDrawerName());
        }
        if (this.editData.getDeliver() != null) {
            this.prmtdeliver.setData((Object)this.editData.getDeliver());
        } else if (this.editData.getDeliverSupp() != null) {
            this.prmtdeliver.setData((Object)this.editData.getDeliverSupp());
        } else {
            this.prmtdeliver.setValue((Object)this.editData.getDeliverName());
        }
        super.loadFields();
        this.prmtdrawerAccount.setData((Object)this.editData.getDrawerAccountName());
        this.prmtdrawerAccount.setText(this.editData.getDrawerAccountName());
        if (this.editData.getDrawerBank() != null) {
            this.prmtdrawerBank.setData((Object)this.editData.getDrawerBank());
        } else {
            this.prmtdrawerBank.setValue((Object)this.editData.getDrawerBankName());
        }
        if (this.editData.getAcceptanceCust() != null) {
            this.prmtdrawcer.setData((Object)this.editData.getAcceptanceCust());
        } else if (this.editData.getAcceptanceSupp() != null) {
            this.prmtdrawcer.setData((Object)this.editData.getAcceptanceSupp());
        } else {
            this.prmtdrawcer.setValue((Object)this.editData.getAcceptanceBankName());
        }
        if (this.editData.getPayee() != null) {
            this.prmtpayee.setData((Object)this.editData.getPayee());
        } else if (this.editData.getPayeeSupp() != null) {
            this.prmtpayee.setData((Object)this.editData.getPayeeSupp());
        } else {
            this.prmtpayee.setValue((Object)this.editData.getPayeeName());
        }
        if (this.editData.getPayeeAccount() != null) {
            this.prmtpayeeAccount.setData((Object)this.editData.getPayeeAccount());
        } else {
            this.prmtpayeeAccount.setValue((Object)this.editData.getPayeeAccountName());
        }
        if (this.editData.getPayeeBank() != null) {
            this.prmtpayeeBank.setData((Object)this.editData.getPayeeBank());
        } else {
            this.prmtpayeeBank.setValue((Object)this.editData.getPayeeBankName());
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)this.editData.getNtType());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.fillTable();
    }

    private void fillTable() {
        this.kdSplit.removeRows();
        this.kdSplit.checkParsed();
        IRow firstRow = this.kdSplit.addRow();
        String firstDraftNumber = null;
        if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            firstRow.getCell(SUBSTARTNUMBER).setValue((Object)subStartNumber);
            BigDecimal firstSubEndNumber = this.editData.getSubStartNumber();
            firstRow.getCell(SUBENDNUMBER).setValue((Object)firstSubEndNumber);
            String firstSubRegion = firstSubEndNumber + "-" + firstSubEndNumber;
            firstRow.getCell(SUBREGION).setValue((Object)firstSubRegion);
            firstDraftNumber = draftPackageNumber + "-" + firstSubRegion;
        } else {
            firstDraftNumber = draftPackageNumber;
        }
        BigDecimal firstSubQuantity = Constants.ONE;
        firstRow.getCell(SUBQUANTITY).setValue((Object)firstSubQuantity);
        firstRow.getCell(DRAFTNUMBER).setValue((Object)firstDraftNumber);
        BigDecimal firstBillAmount = standardBillAmt;
        firstRow.getCell(BILLAMOUNT).setValue((Object)firstBillAmount);
        IRow lastRow = this.kdSplit.addRow();
        String lastDraftNumber = null;
        if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            BigDecimal lastSsubStartNumber = subStartNumber.add(Constants.ONE);
            lastRow.getCell(SUBSTARTNUMBER).setValue((Object)lastSsubStartNumber);
            BigDecimal lastSubEndNumber = this.editData.getSubEndNumber();
            lastRow.getCell(SUBENDNUMBER).setValue((Object)lastSubEndNumber);
            String lastSubRegion = lastSsubStartNumber + "-" + lastSubEndNumber;
            lastRow.getCell(SUBREGION).setValue((Object)lastSubRegion);
            lastDraftNumber = draftPackageNumber + "-" + lastSubRegion;
        } else {
            lastDraftNumber = draftPackageNumber;
        }
        BigDecimal lastSubQuantity = this.editData.getSubQuantity();
        lastRow.getCell(SUBQUANTITY).setValue((Object)lastSubQuantity.subtract(Constants.ONE));
        lastRow.getCell(DRAFTNUMBER).setValue((Object)lastDraftNumber);
        BigDecimal lastBillAmount = amount.subtract(standardBillAmt);
        lastRow.getCell(BILLAMOUNT).setValue((Object)lastBillAmount);
        lastRow.getStyleAttributes().setLocked(true);
        lastRow.getStyleAttributes().setBackground(new Color(211, 211, 211));
        if (!BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            this.kdSplit.getColumn(SUBSTARTNUMBER).getStyleAttributes().setHided(true);
            this.kdSplit.getColumn(SUBENDNUMBER).getStyleAttributes().setHided(true);
            this.kdSplit.getColumn(SUBREGION).getStyleAttributes().setHided(true);
        } else {
            this.kdSplit.getHead().getRow(0).getCell(0).setValue((Object)"\u7968\u636e\u53f7\u7801");
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.initEntryFormat();
    }

    protected void initEntryFormat() throws Exception {
        String amtFtm = "%r-[ ]{###,###,##0.00}15.2n";
        String numberFtm = "%r-[ ]{###,###,##0}15.2n";
        this.kdSplit.getColumn(DRAFTNUMBER).setWidth(300);
        KDFormattedTextField billAmount = new KDFormattedTextField();
        billAmount.setDataType(1);
        billAmount.setPrecision(2);
        billAmount.setHorizontalAlignment(4);
        billAmount.setEditable(true);
        billAmount.setVisible(true);
        billAmount.setRequired(true);
        billAmount.setMinimumValue((Comparable)standardBillAmt);
        this.kdSplit.getColumn(BILLAMOUNT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)billAmount));
        this.kdSplit.getColumn(BILLAMOUNT).getStyleAttributes().setNumberFormat(amtFtm);
        this.kdSplit.getColumn(BILLAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdSplit.getColumn(BILLAMOUNT).setRequired(true);
        if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            KDFormattedTextField subStartNumber = new KDFormattedTextField();
            subStartNumber.setDataType(1);
            subStartNumber.setPrecision(0);
            subStartNumber.setHorizontalAlignment(4);
            subStartNumber.setEditable(false);
            subStartNumber.setVisible(true);
            this.kdSplit.getColumn(SUBSTARTNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)subStartNumber));
            this.kdSplit.getColumn(SUBSTARTNUMBER).getStyleAttributes().setNumberFormat(numberFtm);
            this.kdSplit.getColumn(SUBSTARTNUMBER).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            KDFormattedTextField subEndNumber = new KDFormattedTextField();
            subEndNumber.setDataType(1);
            subEndNumber.setPrecision(0);
            subEndNumber.setHorizontalAlignment(4);
            subEndNumber.setEditable(false);
            subEndNumber.setVisible(true);
            this.kdSplit.getColumn(SUBENDNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)subEndNumber));
            this.kdSplit.getColumn(SUBENDNUMBER).getStyleAttributes().setNumberFormat(numberFtm);
            this.kdSplit.getColumn(SUBENDNUMBER).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        KDFormattedTextField subQuantity = new KDFormattedTextField();
        subQuantity.setDataType(1);
        subQuantity.setPrecision(0);
        subQuantity.setHorizontalAlignment(4);
        subQuantity.setEditable(false);
        subQuantity.setVisible(true);
        this.kdSplit.getColumn(SUBQUANTITY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)subQuantity));
        this.kdSplit.getColumn(SUBQUANTITY).getStyleAttributes().setNumberFormat(numberFtm);
        this.kdSplit.getColumn(SUBQUANTITY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected void btnAddBill_actionPerformed(ActionEvent e) throws Exception {
        int size = this.kdSplit.getRowCount();
        BigDecimal lastAmount = (BigDecimal)this.kdSplit.getRow(size - 1).getCell(BILLAMOUNT).getValue();
        if (lastAmount.compareTo(standardBillAmt) <= 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"642_ReceivableBillSplitUI"));
            SysUtil.abort();
        }
        IRow row = this.kdSplit.addRow(size - 1);
        row.getCell(SUBQUANTITY).setValue((Object)Constants.ONE);
        row.getCell(BILLAMOUNT).setValue((Object)standardBillAmt);
        if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            BigDecimal startNumber = subStartNumber;
            if (size > 1) {
                startNumber = ((BigDecimal)this.kdSplit.getRow(size - 2).getCell(SUBENDNUMBER).getValue()).add(Constants.ONE);
            }
            row.getCell(SUBSTARTNUMBER).setValue((Object)startNumber);
            row.getCell(SUBENDNUMBER).setValue((Object)startNumber);
            String subRegion = startNumber + "-" + startNumber;
            row.getCell(SUBREGION).setValue((Object)subRegion);
            row.getCell(DRAFTNUMBER).setValue((Object)(draftPackageNumber + "-" + subRegion));
        } else {
            row.getCell(DRAFTNUMBER).setValue((Object)draftPackageNumber);
        }
        this.refreshTable(size - 1);
    }

    @Override
    protected void btnRemoveBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdSplit.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        KDTSelectManager selectManager = this.kdSplit.getSelectManager();
        int size = selectManager.size();
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        if (size > 1 && !this.confirmRemove()) {
            return;
        }
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (size == 1 && bottom - top > 0 && !this.confirmRemove()) {
                return;
            }
            if (bottom == this.kdSplit.getRowCount() - 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"643_ReceivableBillSplitUI"));
                return;
            }
            if (this.kdSplit.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        if (indexArr == null) {
            return;
        }
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            this.kdSplit.removeRow(rowIndex);
            this.refreshTable(rowIndex - 1);
        }
        if (this.kdSplit.getRow(0) != null) {
            this.kdSplit.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void kdSplit_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdSplit.getColumn(BILLAMOUNT).getColumnIndex()) {
            if (e != null && e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
                return;
            }
            ICell cell = this.kdSplit.getCell(rowIndex, colIndex);
            BigDecimal billAmount = standardBillAmt;
            if (cell.getValue() == null) {
                cell.setValue((Object)billAmount);
            }
            if (cell.getValue() instanceof BigDecimal) {
                billAmount = (BigDecimal)cell.getValue();
            }
            BigDecimal subQuantity = billAmount.divide(standardBillAmt).stripTrailingZeros();
            this.kdSplit.getRow(rowIndex).getCell(SUBQUANTITY).setValue((Object)subQuantity);
            if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
                BigDecimal startNumber;
                if (rowIndex != 0) {
                    startNumber = ((BigDecimal)this.kdSplit.getRow(rowIndex - 1).getCell(SUBENDNUMBER).getValue()).add(Constants.ONE);
                    this.kdSplit.getRow(rowIndex).getCell(SUBSTARTNUMBER).setValue((Object)startNumber);
                } else {
                    startNumber = (BigDecimal)this.kdSplit.getRow(rowIndex).getCell(SUBSTARTNUMBER).getValue();
                }
                BigDecimal subEndNumber = subQuantity.add(startNumber).subtract(Constants.ONE);
                this.kdSplit.getRow(rowIndex).getCell(SUBENDNUMBER).setValue((Object)subEndNumber);
                String subRegion = startNumber + "-" + subEndNumber;
                this.kdSplit.getRow(rowIndex).getCell(SUBREGION).setValue((Object)subRegion);
                this.kdSplit.getRow(rowIndex).getCell(DRAFTNUMBER).setValue((Object)(draftPackageNumber + "-" + subRegion));
            } else {
                this.kdSplit.getRow(rowIndex).getCell(DRAFTNUMBER).setValue((Object)draftPackageNumber);
            }
            this.refreshTable(rowIndex);
        }
    }

    protected void refreshTable(int rowIndex) {
        int i;
        BigDecimal splitAmount = BigDecimal.ZERO;
        int size = this.kdSplit.getRowCount();
        int lastIndex = this.kdSplit.getRowCount() - 1;
        for (i = 0; i <= rowIndex; ++i) {
            splitAmount = splitAmount.add((BigDecimal)this.kdSplit.getRow(i).getCell(BILLAMOUNT).getValue());
        }
        for (i = rowIndex + 1; i < size - 1; ++i) {
            BigDecimal billAmount = (BigDecimal)this.kdSplit.getRow(i).getCell(BILLAMOUNT).getValue();
            splitAmount = splitAmount.add(billAmount);
            if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
                BigDecimal subQuantity = (BigDecimal)this.kdSplit.getRow(i).getCell(SUBQUANTITY).getValue();
                BigDecimal startNumber = subStartNumber;
                if (i > 0) {
                    startNumber = ((BigDecimal)this.kdSplit.getRow(i - 1).getCell(SUBENDNUMBER).getValue()).add(Constants.ONE);
                }
                this.kdSplit.getRow(i).getCell(SUBSTARTNUMBER).setValue((Object)startNumber);
                BigDecimal subEndNumber = startNumber.add(subQuantity).subtract(Constants.ONE);
                this.kdSplit.getRow(i).getCell(SUBENDNUMBER).setValue((Object)subEndNumber);
                String subRegion = startNumber + "-" + subEndNumber;
                this.kdSplit.getRow(i).getCell(SUBREGION).setValue((Object)subRegion);
                String draftNumber = draftPackageNumber + "-" + subRegion;
                this.kdSplit.getRow(i).getCell(DRAFTNUMBER).setValue((Object)draftNumber);
                continue;
            }
            String draftNumber = draftPackageNumber;
            this.kdSplit.getRow(i).getCell(DRAFTNUMBER).setValue((Object)draftNumber);
        }
        BigDecimal billAmount = amount.subtract(splitAmount);
        this.kdSplit.getRow(lastIndex).getCell(BILLAMOUNT).setValue((Object)billAmount);
        BigDecimal subQuantity = billAmount.divide(standardBillAmt).stripTrailingZeros();
        this.kdSplit.getRow(lastIndex).getCell(SUBQUANTITY).setValue((Object)subQuantity);
        if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
            BigDecimal subStartNumber = this.editData.getSubStartNumber();
            if (size > 1) {
                subStartNumber = ((BigDecimal)this.kdSplit.getRow(lastIndex - 1).getCell(SUBENDNUMBER).getValue()).add(Constants.ONE);
            }
            this.kdSplit.getRow(lastIndex).getCell(SUBSTARTNUMBER).setValue((Object)subStartNumber);
            BigDecimal subEndNumber = (BigDecimal)this.kdSplit.getRow(lastIndex).getCell(SUBENDNUMBER).getValue();
            String subRegion = subStartNumber + "-" + subEndNumber;
            this.kdSplit.getRow(lastIndex).getCell(SUBREGION).setValue((Object)subRegion);
            this.kdSplit.getRow(lastIndex).getCell(DRAFTNUMBER).setValue((Object)(draftPackageNumber + "-" + subRegion));
        } else {
            this.kdSplit.getRow(lastIndex).getCell(DRAFTNUMBER).setValue((Object)draftPackageNumber);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ReceivableBillInfo rInfo;
        boolean rst = FMClientHelper.hasNumber((CoreBaseInfo)this.receivableBillInfo, (String)this.receivableBillInfo.getCompany().getId().toString());
        if (!rst) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"644_ReceivableBillSplitUI"));
            SysUtil.abort();
        }
        if (this.kdSplit.getRowCount() < 2) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"645_ReceivableBillSplitUI"));
            SysUtil.abort();
        }
        if (!EmptyUtil.isEmpty((Object)(rInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(this.receivableBillInfo.getId().toString()))).getLockAmt()) && rInfo.getLockAmt().compareTo(BigDecimal.ZERO) > 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1096_ReceivableBillSplitUI"));
            SysUtil.abort();
        }
        BigDecimal splitAmount = BigDecimal.ZERO;
        ReceivableBillCollection coll = new ReceivableBillCollection();
        for (int i = 0; i < this.kdSplit.getRowCount(); ++i) {
            ReceivableBillInfo info = (ReceivableBillInfo)rInfo.clone();
            if (i != this.kdSplit.getRowCount() - 1) {
                info.setId(null);
                info.setNumber(null);
                info.setSourceBillId(this.receivableBillInfo.getId().toString());
                info.setLockAmt(BigDecimal.ZERO);
                info.setIsPledge(false);
                info.setIsDisPledge(false);
                info.setDigest(null);
            }
            info.setSubStartNumber(null);
            info.setSubEndNumber(null);
            BigDecimal subQuantity = (BigDecimal)this.kdSplit.getRow(i).getCell(SUBQUANTITY).getValue();
            info.setSubQuantity(subQuantity);
            BigDecimal billAmount = (BigDecimal)this.kdSplit.getRow(i).getCell(BILLAMOUNT).getValue();
            if (billAmount.compareTo(BigDecimal.ZERO) <= 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"646_ReceivableBillSplitUI"));
                SysUtil.abort();
            }
            info.setBillAmt(billAmount);
            info.setNaturalAmt(info.getExchangeRate().multiply(billAmount));
            info.setAvailableAmt(billAmount);
            splitAmount = splitAmount.add(billAmount);
            String draftNumber = (String)this.kdSplit.getRow(i).getCell(DRAFTNUMBER).getValue();
            info.setDraftNumber(draftNumber);
            coll.add(info);
            if (BillSourceEnum.BYHAND.equals((Object)this.receivableBillInfo.getSource())) {
                BigDecimal subStartNumber = (BigDecimal)this.kdSplit.getRow(i).getCell(SUBSTARTNUMBER).getValue();
                info.setSubStartNumber(subStartNumber);
                BigDecimal subEndNumber = (BigDecimal)this.kdSplit.getRow(i).getCell(SUBENDNUMBER).getValue();
                info.setSubEndNumber(subEndNumber);
                String subRegion = (String)this.kdSplit.getRow(i).getCell(SUBREGION).getValue();
                info.setSubRegion(subRegion);
                continue;
            }
            info.setSubEndNumber(null);
            info.setSubStartNumber(null);
            info.setSubRegion(null);
            info.setOrigStartNo(this.receivableBillInfo.getOrigStartNo());
            info.setOrigEndNo(this.receivableBillInfo.getOrigEndNo());
        }
        if (splitAmount.compareTo(amount) != 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"647_ReceivableBillSplitUI"));
            SysUtil.abort();
        }
        ReceivableBillFactory.getRemoteInstance().saveSplitBill((IObjectCollection)coll, (IObjectValue)this.receivableBillInfo);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        this.releaseLockObject();
        return super.destroyWindow();
    }

    private void releaseLockObject() {
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.receivableBillInfo)) {
            return;
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseObjIDForUpdate(this.receivableBillInfo.getId().toString());
    }
}

