/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PledgeExchangeCondEnum;
import com.kingdee.eas.fm.nt.PledgeExchangeCondStrategy;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivablePledgeExChangeUI;
import com.kingdee.eas.fm.nt.client.PledgeExchangeCondFactory;
import com.kingdee.eas.fm.nt.client.PledgeExchangeFilterUI;
import com.kingdee.eas.fm.nt.client.ReceivableFilterParam;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeExChangeConditionUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class ReceivablePledgeExChangeUI
extends AbstractReceivablePledgeExChangeUI {
    private static final String NoRecord = "key_head:";
    private PledgeExchangeCondEnum exchangeCondEnum = PledgeExchangeCondEnum.OnlyAmountSame;
    private HashMap hmAccordList = new HashMap();
    private ReceivableFilterParam filterParam = null;
    PledgeExchangeCondStrategy pledgeExchangeCond = null;

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors1();
    }

    @Override
    protected void filldata() throws Exception {
        super.filldata();
        this.tblAccordBill.checkParsed();
        this.tblAccordBill.getColumn("selected").getStyleAttributes().setLocked(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        KDCheckBox chkSelected = new KDCheckBox();
        chkSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReceivablePledgeExChangeUI.this.chkSelected_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReceivablePledgeExChangeUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkSelected));
        this.initBuffer();
        this.exchangeCondEnum = this.editData.getExchangeCond();
        this.pledgeExchangeCond = PledgeExchangeCondFactory.getInstance(this.exchangeCondEnum, this.editData.getInstitution().getName());
    }

    protected void chkSelected_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        List arr = this.getBillsFromTable(this.tblMain, ((KDCheckBox)e.getSource()).isSelected(), rowIndex);
        this.fillAccordTable(arr);
    }

    private void fillAccordTable(List arrExchangeOut) throws BOSException {
        String key = this.makeUpkey(arrExchangeOut);
        ReceivableBillCollection coll = null;
        if (!FMHelper.isEmpty((String)key)) {
            coll = (ReceivableBillCollection)((Object)this.hmAccordList.get(this.makeUpkey(arrExchangeOut)));
        }
        if (coll == null || coll != null && coll.size() == 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(this.pledgeExchangeCond.getExchangeFindCond(arrExchangeOut));
            FilterInfo exchangeFilter = new FilterInfo();
            exchangeFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
            exchangeFilter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(NTHelper.getNTInitState(null, true))));
            exchangeFilter.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(0)));
            exchangeFilter.getFilterItems().add(new FilterItemInfo("isPledge", (Object)new Integer(0)));
            exchangeFilter.getFilterItems().add(new FilterItemInfo("source", (Object)new Integer(2), CompareType.NOTEQUALS));
            view.setFilter(exchangeFilter);
            SorterItemCollection sorterColl = new SorterItemCollection();
            SorterItemInfo sorter = new SorterItemInfo("expiredDate");
            sorter.setSortType(SortType.DESCEND);
            sorterColl.add(sorter);
            view.setSorter(sorterColl);
            view.getSelector().addObjectCollection((IObjectCollection)this.getReceivableSelector());
            coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
            this.hmAccordList.put(this.makeUpkey(arrExchangeOut), coll);
        }
        this.fillExchangoutBillbyColl(coll);
    }

    private void fillExchangoutBillbyColl(ReceivableBillCollection coll) {
        this.tblAccordBill.removeRows();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            CoreBaseInfo object = (CoreBaseInfo)iterator.next();
            IRow row = this.tblAccordBill.addRow();
            for (int j = 0; j < this.tblAccordBill.getColumnCount(); ++j) {
                if (this.tblAccordBill.getColumnKey(j).equals("selected")) continue;
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)object, (Field)new Field(this.tblAccordBill.getColumnKey(j))));
            }
            if (object instanceof ReceivableBillInfo) {
                ReceivableBillInfo info = (ReceivableBillInfo)object;
                row.getCell("number").setValue((Object)info.getDraftNumber());
            }
            row.getCell("selected").setValue((Object)new Boolean(false));
            FMClientHelper.setNumberFormat((IRow)row, (String)"billAmt", (String)((ReceivableBillInfo)object).getCurrency().getId().toString());
        }
    }

    private String makeUpkey(List arr) {
        String flag = NoRecord;
        for (int i = 0; i < arr.size(); ++i) {
            flag = flag + ((ReceivableBillInfo)arr.get(i)).getId().toString();
        }
        return flag;
    }

    private List getBillsFromTable(KDTable table) {
        ArrayList<ReceivableBillInfo> lstBill = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            boolean flag = false;
            if (row.getCell("selected").getValue() != null) {
                flag = new Boolean(row.getCell("selected").getValue().toString());
            }
            if (!flag) continue;
            ReceivableBillInfo billInfo = new ReceivableBillInfo();
            billInfo.setId((BOSUuid)row.getCell("id").getValue());
            billInfo.setNumber((String)row.getCell("number").getValue());
            billInfo.setBillAmt((BigDecimal)row.getCell("billAmt").getValue());
            billInfo.setAcceptanceBankName((String)row.getCell("acceptanceBankName").getValue());
            billInfo.setIsDisPledge((Boolean)row.getCell("isDisPledge").getValue());
            lstBill.add(billInfo);
        }
        return lstBill;
    }

    private List getBillsFromTable(KDTable table, boolean selected, int rowIndex) {
        ArrayList<ReceivableBillInfo> lstBill = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            ReceivableBillInfo billInfo;
            IRow row = table.getRow(i);
            if (i == rowIndex) {
                if (!selected) continue;
                billInfo = new ReceivableBillInfo();
                billInfo.setId((BOSUuid)row.getCell("id").getValue());
                billInfo.setNumber((String)row.getCell("number").getValue());
                billInfo.setBillAmt((BigDecimal)row.getCell("billAmt").getValue());
                billInfo.setAcceptanceBankName((String)row.getCell("acceptanceBankName").getValue());
                lstBill.add(billInfo);
                continue;
            }
            if (row.getCell("selected").getValue() == null || !(row.getCell("selected").getValue() instanceof Boolean) || !((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            billInfo = new ReceivableBillInfo();
            billInfo.setId((BOSUuid)row.getCell("id").getValue());
            billInfo.setNumber((String)row.getCell("number").getValue());
            billInfo.setBillAmt((BigDecimal)row.getCell("billAmt").getValue());
            lstBill.add(billInfo);
        }
        return lstBill;
    }

    @Override
    protected void cmdQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"filterParam", (Object)this.filterParam);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PledgeExchangeFilterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        FilterInfo filter = ((PledgeExchangeFilterUI)uiWindow.getUIObject()).getExchangeFilter();
        if (filter == null) {
            return;
        }
        this.filterParam = ((PledgeExchangeFilterUI)uiWindow.getUIObject()).getFilterParam();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("expiredDate");
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        view.setSorter(sorterColl);
        view.getSelector().addObjectCollection((IObjectCollection)this.getReceivableSelector());
        this.initBuffer();
        ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        this.fillExchangoutBillbyColl(coll);
    }

    @Override
    public void actionExChangeCondition_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"exchangeCondEnum", (Object)this.exchangeCondEnum);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivablePledgeExChangeConditionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.exchangeCondEnum = ((ReceivablePledgeExChangeConditionUI)uiWindow.getUIObject()).getExchangeCondEnum();
        this.pledgeExchangeCond = PledgeExchangeCondFactory.getInstance(this.exchangeCondEnum, this.editData.getInstitution().getName());
        this.initBuffer();
        this.fillAccordTable(this.getBillsFromTable(this.tblMain));
    }

    private void initBuffer() {
        this.hmAccordList.clear();
        this.hmAccordList.put(NoRecord, new ReceivableBillCollection());
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionExChange_actionPerformed(ActionEvent e) throws Exception {
        List arrExchangeOut = this.getBillsFromTable(this.tblMain);
        List arrExchangeIn = this.getBillsFromTable(this.tblAccordBill);
        if (arrExchangeOut.size() == 0) {
            throw new NTException(NTException.EXCHANGEOUTLISTEMPTY);
        }
        if (arrExchangeIn.size() == 0) {
            throw new NTException(NTException.EXCHANGEINLISTEMPTY);
        }
        this.pledgeExchangeCond.checkExchangeCond(arrExchangeOut, arrExchangeIn);
        this.editData.setExchangeCond(this.exchangeCondEnum);
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.dpPledgeDate.getValue()));
        ReceivableBillFactory.getRemoteInstance().pledgeExchange(arrExchangeOut, arrExchangeIn, this.editData, this.pledgeExchangeCond);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"368_ReceivablePledgeExChangeUI"));
        this.getUIWindow().close();
    }

    private SelectorItemCollection getReceivableSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        return sic;
    }
}

