/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivablePledgeUI;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReceivablePledgeUI
extends AbstractReceivablePledgeUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivablePledgeUI.class);
    private IObjectCollection receivableCol = null;
    private CompanyOrgUnitInfo curCompany = null;
    private Date expireDate = null;
    private BigDecimal exRate = Constants.ZERO;

    public ReceivablePledgeUI() throws Exception {
        this.curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public void onLoad() throws Exception {
        this.txtBillAmt.setPrecision(2);
        this.txtPledgeAmt.setPrecision(2);
        this.tblPledgeInfo.checkParsed();
        super.onLoad();
        this.dpPledgeDate.setSupportedEmpty(false);
        this.prmtCurrency.setEnabled(false);
        this.txtBillNumber.setEnabled(false);
        this.txtBillAmt.setEnabled(false);
        this.txtBillAmt.setHorizontalAlignment(4);
        this.txtPledgeAmt.setHorizontalAlignment(4);
        this.txtBillAmt.setRemoveingZeroInDispaly(false);
        this.txtPledgeAmt.setRemoveingZeroInDispaly(false);
        this.txtContract.setMaxLength(80);
        this.txtDigest.setMaxLength(200);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtInstitution, (Boolean)new Boolean(true), (boolean)true);
        this.tblPledgeInfo.getColumn("AccountAmount").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblPledgeInfo.getColumn("AccountAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblPledgeInfo.getColumn("Balance").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblPledgeInfo.getColumn("Balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblPledgeInfo.getColumn("realWage").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.tblPledgeInfo.getColumn("realWage").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.filldata();
    }

    protected void filldata() throws Exception {
        String state = (String)this.getUIContext().get("oprState");
        this.tblMain.checkParsed();
        if ("addnew".equals(state)) {
            this.actionSubmit.setVisible(true);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
            this.tblMain.getStyleAttributes().setLocked(true);
        } else if ("edit".equals(state)) {
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            this.f7OppAccountView.setEnabled(true);
            this.actionSubmit.setVisible(true);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
        } else if ("cancelPledge".equals(state)) {
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            this.actionSubmit.setVisible(false);
            this.actionCancelPledge.setVisible(true);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
            this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        } else if ("disPledge".equals(state)) {
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            this.actionSubmit.setVisible(false);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(true);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
            this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        } else if ("cancelDisPledge".equals(state)) {
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            this.actionSubmit.setVisible(false);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(true);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
            this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        } else if ("exchangePledge".equals(state)) {
            FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
            this.actionSubmit.setVisible(false);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(true);
            this.actionExChangeCondition.setVisible(true);
            this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        } else {
            this.actionSubmit.setVisible(false);
            this.actionCancelPledge.setVisible(false);
            this.actionDisPledge.setVisible(false);
            this.actionCancelDisPledge.setVisible(false);
            this.actionExChange.setVisible(false);
            this.actionExChangeCondition.setVisible(false);
        }
        String id = (String)this.getUIContext().get("ID");
        logger.error((Object)("\u5e94\u6536\u7968\u636eid" + id));
        if (id == null) {
            this.receivableCol = (IObjectCollection)this.getUIContext().get("receivableColl");
            ReceivableBillInfo recInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
            this.comboBillMedium.setSelectedItem((Object)recInfo.getBillMedium());
        } else {
            this.receivableCol = this.getReceivableList(id);
            ReceivableBillInfo recInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
            this.comboBillMedium.setSelectedItem((Object)recInfo.getBillMedium());
        }
        this.fillTable(this.receivableCol, state);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCancelPledge.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_delete"));
        this.actionDisPledge.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionCancelDisPledge.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionExChange.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_replace"));
        this.actionExChangeCondition.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.actionAttachment.setVisible(false);
        this.actionSubmit.setEnabled(true);
        this.actionCancelPledge.setEnabled(true);
        this.actionDisPledge.setEnabled(true);
        this.actionCancelDisPledge.setEnabled(true);
        this.actionExChangeCondition.setEnabled(true);
        this.actionExChange.setEnabled(true);
    }

    public boolean isModify() {
        return false;
    }

    private ReceivableBillInfo getReceivableBillInfo(Object objInfo) {
        ReceivableBillInfo vo = null;
        if (objInfo instanceof ReceivableBillInfo) {
            vo = (ReceivableBillInfo)objInfo;
        } else {
            ReceivablePledgeDetailInfo pledgeDetail = (ReceivablePledgeDetailInfo)objInfo;
            vo = pledgeDetail.getReceivable();
            vo.setIsDisPledge(pledgeDetail.isIsDisPledge());
            vo.setIsPledge(pledgeDetail.isIsPledge());
            vo.setClose(pledgeDetail.isIsClose());
            vo.setLastWageId(pledgeDetail.getLastWageId());
            vo.setPledgeDetailId(pledgeDetail.getId().toString());
        }
        return vo;
    }

    private void fillTable(IObjectCollection coll, String state) throws BOSException, UuidException {
        IRow row;
        if (coll == null) {
            return;
        }
        if (coll.size() == 0) {
            return;
        }
        this.tblMain.removeRows();
        BigDecimal amt = Constants.ZERO;
        if (coll == null) {
            return;
        }
        int precision = 2;
        StyleAttributes styleAttributes = null;
        String billNumber = "";
        for (int i = 0; i < coll.size(); ++i) {
            row = this.tblMain.addRow();
            ReceivableBillInfo vo = this.getReceivableBillInfo(coll.getObject(i));
            precision = vo.getCurrency().getPrecision();
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                if (this.tblMain.getColumnKey(j).equals("selected") || this.tblMain.getColumnKey(j).equals("isClose")) continue;
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
            }
            row.getCell("number").setValue((Object)vo.getDraftNumber());
            row.getCell("isClose").setValue((Object)new Boolean(vo.isClose()));
            if (vo.isIsDisPledge() && ("cancelPledge".equals(state) || "disPledge".equals(state) || "exchangePledge".equals(state)) || vo.isClose()) {
                row.getCell("selected").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(new Color(0xE8E8E3));
            }
            if (!vo.isIsDisPledge() && "cancelDisPledge".equals(state) || vo.isClose()) {
                row.getCell("selected").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(new Color(0xE8E8E3));
            }
            billNumber = billNumber + row.getCell("number").getValue().toString() + ",";
            amt = amt.add((BigDecimal)row.getCell("billAmt").getValue());
            styleAttributes = row.getCell("billAmt").getStyleAttributes();
            styleAttributes.setNumberFormat(FMClientHelper.getKDTNumFormat((int)precision));
            styleAttributes.setNumberFormat("%r-[ ]0.2n");
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.prmtCurrency.setValue((Object)((CurrencyInfo)row.getCell("currency").getValue()));
            this.txtBillAmt.setPrecision(((CurrencyInfo)row.getCell("currency").getValue()).getPrecision());
            this.txtPledgeAmt.setPrecision(((CurrencyInfo)row.getCell("currency").getValue()).getPrecision());
            this.expireDate = vo.getExpiredDate();
            this.exRate = vo.getExchangeRate();
            row.getCell("selected").setValue((Object)new Boolean(false));
            if (!this.getOprtState().equals(OprtState.ADDNEW)) continue;
            row.getCell("elecBillStatus").setValue(null);
            row.getCell("bankReturnStatus").setValue(null);
            row.getCell("bankReturnMsg").setValue(null);
            row.getCell("isNoteCancel").setValue((Object)new Boolean(false));
        }
        if ((billNumber = billNumber.substring(0, billNumber.length() - 1)).length() > 250) {
            billNumber = billNumber.substring(0, 246) + "...";
        }
        if (FMHelper.isEmpty((String)this.editData.getDescription())) {
            this.txtBillNumber.setText(billNumber);
            this.txtBillAmt.setValue((Object)amt);
            this.txtPledgeAmt.setValue((Object)amt);
        }
        this.ShowEntryUsedAmount();
        try {
            NTHelper.setF7AccountEvi((IUIObject)this, ((CurrencyInfo)this.prmtCurrency.getValue()).getId().toString(), this.curCompany, this.f7OppAccountView);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        Object owner = this.getUIContext().get("Owner");
        if ((owner.getClass().equals(ReceivablePledgeListUI.class) || owner.toString().contains("ReceivableBillList")) && this.tblMain.getColumn("elecBillStatus") != null) {
            this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
        }
        row = this.tblMain.addRow();
        row.getCell("selected").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("billAmt").setValue((Object)amt);
        row.getCell("billAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)precision));
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private IObjectCollection getReceivableList(String wageid) throws Exception {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("CU.id");
        sic.add("deliver.*");
        sic.add("endorsedSupplier.*");
        sic.add("endorsedCustomer.*");
        sic.add("receivableEntrys.*");
        sic.add("receivableEntrys.currency.*");
        sic.add("receivableEntrys.ntType.*");
        sic.add("billEntrys.elecBillStatus");
        sic.add("billEntrys.bankReturnStatus");
        sic.add("billEntrys.bankReturnMsg");
        sic.add("billEntrys.receivableBill.*");
        sic.add("billEntrys.receivableBill.ntType.*");
        sic.add("billEntrys.receivableBill.currency.*");
        sic.add("project.*");
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        sic.add("endorseeBank.id");
        sic.add("endorseeBank.number");
        sic.add("endorseeBank.name");
        sic.add("billEntrys.*");
        WageInfo wageInfo = WageFactory.getRemoteInstance().getWageInfo((IObjectPK)new ObjectUuidPK(wageid), sic);
        this.receivableCol = new ReceivableBillCollection();
        for (int i = 0; i < wageInfo.getBillEntrys().size(); ++i) {
            ReceivableBillInfo receivable = wageInfo.getBillEntrys().get(i).getReceivableBill();
            receivable.setElecBillStatus(wageInfo.getBillEntrys().get(i).getElecBillStatus());
            receivable.setBankReturnStatus(wageInfo.getBillEntrys().get(i).getBankReturnStatus());
            receivable.setBankReturnMsg(wageInfo.getBillEntrys().get(i).getBankReturnMsg());
            receivable.setIsNoteCancel(wageInfo.getBillEntrys().get(i).isIsNoteCancel());
            this.receivableCol.addObject((IObjectValue)wageInfo.getBillEntrys().get(i).getReceivableBill());
        }
        return this.receivableCol;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verify();
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.dpPledgeDate.getValue()));
        this.editData.setLocalCurExRate(this.exRate);
        this.editData.setAmountlocalcur(this.txtBillAmt.getBigDecimalValue().multiply(this.exRate));
        this.editData.setExpireddate(this.expireDate);
        this.editData.setBillMedium((BillMediumEnum)((Object)this.comboBillMedium.getSelectedItem()));
        ReceivableBillFactory.getRemoteInstance().pledge(this.receivableCol, this.editData);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        if (!EmptyUtil.isEmpty((Object)this.receivableCol)) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < this.receivableCol.size(); ++i) {
                iMutex.releaseObjIDForUpdate(((ReceivableBillInfo)this.receivableCol.getObject(i)).getId().toString());
            }
        }
        return super.destroyWindow();
    }

    protected void verify() throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtInstitution);
        for (Object obj : this.receivableCol) {
            if (!(obj instanceof ReceivableBillInfo)) continue;
            ReceivableBillInfo recBillInfo = (ReceivableBillInfo)obj;
            if (this.editData.getIssuedate().compareTo(recBillInfo.getIssuesDate()) < 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"370_ReceivablePledgeUI"));
                SysUtil.abort();
            }
            if (recBillInfo.getExpiredDate().compareTo(this.editData.getIssuedate()) >= 0) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"606_ReceivablePledgeUI"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        WageInfo info = new WageInfo();
        info.setIssuedate(new Date());
        Object owner = this.getUIContext().get("Owner");
        if (owner.getClass().getName().indexOf("4Elec") != -1) {
            info.setSource(BillSourceEnum.BYECDS);
        } else {
            info.setSource(BillSourceEnum.BYHAND);
        }
        return info;
    }

    private List getSelectorReceivableBill() {
        ArrayList<ReceivableBillInfo> idList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("selected").getValue() == null || !(row.getCell("selected").getValue() instanceof Boolean) || !((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            idList.add(this.getBill4Selector(((BOSUuid)row.getCell("id").getValue()).toString()));
        }
        if (idList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return idList;
    }

    private ReceivableBillInfo getBill4Selector(String id) {
        for (int i = 0; i < this.receivableCol.size(); ++i) {
            ReceivableBillInfo info = this.getReceivableBillInfo(this.receivableCol.getObject(i));
            if (!info.getId().toString().equals(id)) continue;
            return info;
        }
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getSelectors1();
    }

    protected SelectorItemCollection getSelectors1() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("exchangeCond"));
        sic.add(new SelectorItemInfo("Institution.*"));
        return sic;
    }

    protected void ShowEntryUsedAmount() throws BOSException, UuidException {
        BigDecimal depositAmt = null;
        BigDecimal balance = null;
        BigDecimal AccountAmount = Constants.ZERO;
        BigDecimal Balance = Constants.ZERO;
        BigDecimal realWage = Constants.ZERO;
        int n = this.tblPledgeInfo.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblPledgeInfo.getRow(i);
            String billid = row.getCell("billid").getValue().toString();
            FinancingBillInfo info = (FinancingBillInfo)DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.read((String)billid).getType(), (IObjectPK)new ObjectUuidPK(billid));
            depositAmt = info.getAmount();
            AccountAmount = AccountAmount.add(depositAmt);
            balance = info.getBalance();
            Balance = Balance.add(balance);
            row.getCell("AccountAmount").setValue((Object)depositAmt);
            row.getCell("Balance").setValue((Object)balance);
        }
        if (this.tblPledgeInfo.getRowCount() > 0) {
            IRow row = this.tblPledgeInfo.addRow();
            row.getCell("Type").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
            row.getCell("AccountAmount").setValue((Object)AccountAmount);
            row.getCell("AccountAmount").getStyleAttributes().setNumberFormat("%r-[ ]0.2n");
            row.getCell("Balance").setValue((Object)Balance);
            row.getCell("Balance").getStyleAttributes().setNumberFormat("%r-[ ]0.2n");
            row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WageFactory.getRemoteInstance();
    }

    @Override
    public void actionCancelPledge_actionPerformed(ActionEvent e) throws Exception {
        ReceivableBillFactory.getRemoteInstance().cancelPledge(this.getSelectorReceivableBill(), this.editData.getId().toString());
        this.getUIWindow().close();
    }

    @Override
    public void actionDisPledge_actionPerformed(ActionEvent e) throws Exception {
        ReceivableBillFactory.getRemoteInstance().disPledge(this.getSelectorReceivableBill(), this.editData.getId().toString());
        this.getUIWindow().close();
    }

    @Override
    public void actionCancelDisPledge_actionPerformed(ActionEvent e) throws Exception {
        ReceivableBillFactory.getRemoteInstance().cancelDisPledge(this.getSelectorReceivableBill(), this.editData.getId().toString());
        this.getUIWindow().close();
    }
}

