/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.nt.client.AbstractReceivableRecUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReceivableRecUI
extends AbstractReceivableRecUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableRecUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private UserInfo userInfo = null;

    @Override
    public void actionRec_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.userInfo == null) {
            this.userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        }
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.txtNumber.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBizDate((Date)this.pkDate.getValue());
        this.editData.setPayeeAccountBank((AccountBankInfo)this.prmtPayeeAccountBank.getData());
        this.editData.setPayeeBank((BankInfo)this.txtPayeeBank.getUserObject());
        this.editData.setNumber(this.editData.getSettlementNumber());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData != null) {
            this.txtNumber.setText(this.editData.getSettlementNumber());
            this.txtAmt.setValue((Object)this.editData.getActRecAmt());
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRec.setIcon(EASResource.getIcon((String)"imgTbtn_gathering"));
    }

    @Override
    protected void prmtPayeeAccountBank_willShow(SelectorEvent e) throws Exception {
        String companyId = this.currentCompany.getId().toString();
        this.prmtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = CasRecPayHandler.getAccountBankEvi((String)companyId, null);
        this.prmtPayeeAccountBank.setEntityViewInfo(evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtPayeeAccountBank.setSelectorCollection(selectors);
    }

    @Override
    protected void prmtPayeeAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        boolean isNotNull;
        boolean bl = isNotNull = e.getNewValue() != null;
        if (!isNotNull) {
            this.txtPayeeBank.setUserObject(null);
            this.txtPayeeBank.setText(null);
            return;
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtPayeeAccountBank.getValue();
        IBank iBank = BankFactory.getRemoteInstance();
        BankInfo bankInfo = iBank.getBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getBank().getId()));
        this.txtPayeeBank.setUserObject((Object)bankInfo);
        this.txtPayeeBank.setText(bankInfo.getName());
        this.editData.setPayeeAccount(accountBankInfo.getAccount());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivingBillFactory.getRemoteInstance();
    }
}

