/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.util.DateTimeUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class ReceivableTrustFilterParam
implements FilterParam {
    private static final long serialVersionUID = 8286793995702136922L;
    private Date beginDate;
    private Date endDate;
    protected String[] companyIds;
    private boolean dispTotal;
    private Set trusteeBankIdSet;
    private String currencyId;
    private int billstate1;

    public boolean isDispTotal() {
        return this.dispTotal;
    }

    public void setDispTotal(boolean dispTotal) {
        this.dispTotal = dispTotal;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public CurrencyInfo getCurrency() {
        if (this.currencyId != null) {
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)this.currencyId));
            return info;
        }
        return null;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currencyId = currency == null ? null : currency.getId().toString();
    }

    public Set getTrusteeBankIdSet() {
        return this.trusteeBankIdSet;
    }

    public void setTrusteeBankIdSet(Set trusteeBankIdSet) {
        this.trusteeBankIdSet = trusteeBankIdSet;
    }

    public BillStateEnum getBillstate() {
        return BillStateEnum.getEnum(this.billstate1);
    }

    public void setBillstate(BillStateEnum billstate) {
        this.billstate1 = billstate == null ? -1 : billstate.getValue();
    }

    public FilterInfo getFilter() {
        FilterInfo filterinfo = new FilterInfo();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filterinfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        if (this.beginDate != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("trustDate", (Object)DateTimeUtils.truncateDate((Date)this.beginDate), CompareType.GREATER_EQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("trustDate", (Object)DateTimeUtils.truncateDate((Date)this.endDate), CompareType.LESS_EQUALS));
        }
        if (!FMHelper.isEmpty((Collection)this.trusteeBankIdSet)) {
            filterinfo.getFilterItems().add(new FilterItemInfo("trusteeBank.id", (Object)this.trusteeBankIdSet, CompareType.INCLUDE));
        }
        if (this.getCurrency() != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId, CompareType.EQUALS));
        }
        if (this.getBillstate() != null) {
            filterinfo.getFilterItems().add(new FilterItemInfo("billstate", (Object)new Integer(this.billstate1)));
        }
        filterinfo.getFilterItems().add(new FilterItemInfo("isTrustee", (Object)new Integer(1)));
        return filterinfo;
    }

    public SorterItemCollection getSorterItems() {
        if (this.dispTotal) {
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("trusteeBank.id"));
            sorter.add(new SorterItemInfo("currency.id"));
            return sorter;
        }
        return null;
    }
}

