/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.nt.ReturnTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractReturnBillUI;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReturnBillUI
extends AbstractReturnBillUI {
    private static final Logger logger = CoreUIObject.getLogger(ReturnBillUI.class);
    private static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.NtResource";
    protected BillBaseInfo billInfo;
    private HashMap hmBillState = new HashMap();
    private int baseCurrencyPrecision = 2;
    protected CompanyOrgUnitInfo curCompany = null;
    static final String FROM_INFO = "fromInfo";
    ReturnTypeEnum returnType = null;

    public ReturnBillUI() throws Exception {
        this.initBillState();
        this.curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.curCompany);
        this.baseCurrencyPrecision = FMClientHelper.getPrecOfCurrency((BOSUuid)baseCurrency.getId());
    }

    public void onLoad() throws Exception {
        this.billInfo = (BillBaseInfo)this.getUIContext().get(FROM_INFO);
        super.onLoad();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        this.setCostCenterF7();
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setDataType(1);
        this.txtExRate.setDataType(1);
        this.txtExRate.setHorizontalAlignment(4);
        this.txtExRate.setDataType(1);
        this.txtLocAmount.setHorizontalAlignment(4);
        this.txtLocAmount.setDataType(1);
        if (this.getOprtState().equals(OprtState.VIEW) || this.billInfo == null) {
            this.txtExRate.setPrecision(4);
            this.loadViewData();
        } else {
            if (this.billInfo instanceof ReceivableBillInfo) {
                ReceivableBillInfo obj = (ReceivableBillInfo)this.billInfo;
                this.prmtCurrency.setData((Object)obj.getCurrency());
                this.txtAmount.setPrecision(obj.getCurrency().getPrecision());
                this.txtAmount.setValue((Object)obj.getBillAmt());
                this.txtNumber.setText(obj.getDraftNumber());
                this.setExchangRateAndLocAmt(obj.getCurrency().getId().toString(), obj.getBillAmt());
                this.returnType = ReturnTypeEnum.Receivable;
            } else if (this.billInfo instanceof PayableBillInfo) {
                PayableBillInfo obj = (PayableBillInfo)this.billInfo;
                this.prmtCurrency.setData((Object)obj.getCurrency());
                this.txtAmount.setPrecision(obj.getCurrency().getPrecision());
                this.txtAmount.setValue((Object)obj.getAmount());
                this.txtNumber.setText(obj.getDraftNumber());
                this.kDLabelContainer8.setVisible(false);
                this.kDLabelContainer9.setVisible(false);
                this.setBounds(new Rectangle(10, 10, 320, 250));
                this.kDLabelContainer5.setBounds(new Rectangle(5, 132, 310, 19));
                this.contBgItem.setBounds(new Rectangle(5, 156, 310, 19));
                this.contFundFlowItem.setBounds(new Rectangle(5, 156, 310, 19));
                this.contProject.setBounds(new Rectangle(5, 181, 310, 19));
                this.contCostCenter.setBounds(new Rectangle(5, 206, 310, 19));
                this.returnType = ReturnTypeEnum.Payable;
            } else if (this.billInfo instanceof ReturnBillInfo) {
                ReturnBillInfo obj = (ReturnBillInfo)this.billInfo;
                this.pkDate.setValue((Object)new Date());
                this.prmtCurrency.setData((Object)obj.getCurrency());
                this.txtNumber.setText(obj.getSrcNumber());
                this.txtAmount.setPrecision(obj.getCurrency().getPrecision());
                this.txtAmount.setValue((Object)obj.getAmount());
                this.prmtCostCenter.setValue((Object)obj.getConfirmer());
                this.setExchangRateAndLocAmt(obj.getCurrency().getId().toString(), obj.getAmount());
                if (this.getUIContext().get("isPayableConfirm") != null) {
                    Boolean type = (Boolean)this.getUIContext().get("isPayableConfirm");
                    this.returnType = type != false ? ReturnTypeEnum.Payable : ReturnTypeEnum.Receivable;
                }
            }
            this.setReturnBillState(this.billInfo);
        }
        this.txtNumber.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.pkDate.setSupportedEmpty(false);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionSubmit.setEnabled(true);
        }
        if (this.getOprtState().equals("FINDVIEW") || this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSubmit.setEnabled(false);
        }
        this.actionViewBgBalance.setEnabled(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocAmount);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.input}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
    }

    private void setExchangRateAndLocAmt(String currencyId, BigDecimal amount) throws BOSException, EASBizException {
        Date pikDate;
        String destCurrencyId;
        String srcCurrencyId;
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        ExchangeRateInfo exchangeInfo = FMClientHelper.getExRateInfo((String)companyId, (String)(srcCurrencyId = currencyId), (String)(destCurrencyId = this.curCompany.getBaseCurrency().getId().toString()), (Date)(pikDate = (Date)this.pkDate.getValue()));
        if (exchangeInfo != null) {
            this.txtExRate.setPrecision(exchangeInfo.getPrecision());
            this.txtExRate.setValue((Object)exchangeInfo.getConvertRate());
        } else {
            this.txtExRate.setPrecision(5);
            this.txtExRate.setValue((Object)Constants.ONE);
        }
        this.txtLocAmount.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.curCompany).getId()));
        this.txtLocAmount.setValue((Object)amount.multiply(this.txtExRate.getBigDecimalValue()));
        this.txtLocAmount.setEnabled(false);
        if (srcCurrencyId.equals(destCurrencyId)) {
            this.txtExRate.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.txtReturnBillState.setEnabled(false);
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.curCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    private void loadViewData() {
        if (this.editData == null) {
            return;
        }
        ReturnBillInfo info = this.editData;
        if (info.getType() == ReturnTypeEnum.Payable) {
            this.kDLabelContainer8.setVisible(false);
            this.kDLabelContainer9.setVisible(false);
            this.setBounds(new Rectangle(10, 10, 320, 250));
            this.kDLabelContainer5.setBounds(new Rectangle(5, 132, 310, 19));
            this.contBgItem.setBounds(new Rectangle(5, 156, 310, 19));
            this.contFundFlowItem.setBounds(new Rectangle(5, 156, 310, 19));
            this.contProject.setBounds(new Rectangle(5, 181, 310, 19));
            this.contCostCenter.setBounds(new Rectangle(5, 206, 310, 19));
        }
        this.txtAmount.setPrecision(info.getCurrency().getPrecision());
        this.txtLocAmount.setPrecision(info.getCurrency().getPrecision());
        this.txtNumber.setText(info.getSrcNumber());
        this.pkDate.setValue((Object)info.getReturnDate());
        this.prmtCurrency.setValue((Object)info.getCurrency());
        this.txtAmount.setValue((Object)info.getAmount());
        this.txtRemark.setText(info.getRemark());
        this.prmtBgItem.setValue((Object)info.getOutBgItemName());
        this.prmtProject.setValue((Object)info.getProject());
        try {
            if (FMHelper.isEmpty((CoreBaseInfo)info.getCostCenter())) {
                this.prmtCostCenter.setValue(null);
            } else {
                this.prmtCostCenter.setValue((Object)CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCostCenter().getId())));
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        this.txtExRate.setValue((Object)info.getExRate());
        this.txtLocAmount.setValue((Object)info.getLocAmount());
        this.setReturnBillState(info);
        this.menuFile.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        return sic;
    }

    private void initBillState() {
        for (IntEnum element : BillStateEnum.getEnumList()) {
            this.hmBillState.put(new Integer(element.getValue() + 100), element.getAlias());
        }
        for (IntEnum element : PayableBillStateEnum.getEnumList()) {
            this.hmBillState.put(new Integer(element.getValue() + 200), element.getAlias());
        }
    }

    private void setReturnBillState(Object billObj) {
        String str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"36_PayableBillControllerBean");
        if (billObj instanceof ReceivableBillInfo) {
            ReceivableBillInfo obj = (ReceivableBillInfo)billObj;
            this.txtReturnBillState.setText((String)this.hmBillState.get(new Integer(obj.getBillState().getValue() + 100)) + str);
        } else if (billObj instanceof PayableBillInfo) {
            PayableBillInfo obj = (PayableBillInfo)billObj;
            this.txtReturnBillState.setText((String)this.hmBillState.get(new Integer(obj.getBillState().getValue() + 200)) + str);
        } else if (billObj instanceof ReturnBillInfo) {
            ReturnBillInfo obj = (ReturnBillInfo)billObj;
            if (obj.getType() == ReturnTypeEnum.Receivable) {
                this.txtReturnBillState.setText((String)this.hmBillState.get(new Integer(obj.getSrcBillState() + 100)) + str);
            } else {
                this.txtReturnBillState.setText((String)this.hmBillState.get(new Integer(obj.getSrcBillState() + 200)) + str);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private ReturnTypeEnum getReturnType() {
        if (this.billInfo == null) {
            return null;
        }
        if (this.billInfo instanceof ReceivableBillInfo || this.billInfo instanceof ReturnBillInfo) {
            return ReturnTypeEnum.Receivable;
        }
        if (this.billInfo instanceof PayableBillInfo) {
            return ReturnTypeEnum.Payable;
        }
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setAmount(this.txtAmount.getBigDecimalValue());
        this.editData.setRemark(this.txtRemark.getText());
        this.editData.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        this.editData.setReturnDate((Date)this.pkDate.getValue());
        this.editData.setCompany(this.curCompany);
        this.editData.setExRate(this.txtExRate.getBigDecimalValue());
        this.editData.setProject((ProjectInfo)this.prmtProject.getValue());
        this.editData.setCostCenter((CostCenterOrgUnitInfo)this.prmtCostCenter.getValue());
        this.editData.setLocAmount(this.txtLocAmount.getBigDecimalValue());
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String rtnMsg;
        ReturnBillInfo returnbillInfo = this.editData;
        if (this.oprtState == OprtState.EDIT) {
            returnbillInfo.setId(null);
        }
        this.storeFields();
        returnbillInfo.setType(this.returnType);
        boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, "NT014", false);
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.pkDate.getValue()));
        if (returnbillInfo.getType() == ReturnTypeEnum.Receivable) {
            if (this.billInfo instanceof ReturnBillInfo) {
                boolean isCreateReceiving = false;
                if (isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTRESOURCE_PATH, (String)"isGenRPBill")) == 0) {
                    isCreateReceiving = true;
                }
                returnbillInfo.setCreateReceiving(new Boolean(isCreateReceiving));
                rtnMsg = ReturnBillFactory.getRemoteInstance().confirm((ReturnBillInfo)this.billInfo, returnbillInfo);
                if (!FMHelper.isEmpty((String)rtnMsg)) {
                    MsgBox.showInfo((Component)((Object)this), (String)rtnMsg);
                }
            } else {
                String rtnMsg2;
                ReceivableBillInfo recBillInfo = (ReceivableBillInfo)this.billInfo;
                boolean isSubmit = recBillInfo.getBillState() == BillStateEnum.SAVED || recBillInfo.getBillState() == BillStateEnum.Audit;
                boolean isEndorse = recBillInfo.getBillState() == BillStateEnum.INENDORSED || recBillInfo.getBillState() == BillStateEnum.OUTENDORSED;
                boolean isCreateReceiving = false;
                if (isSubmit && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTRESOURCE_PATH, (String)"isGenReceivingBill")) == 0) {
                    isCreateReceiving = true;
                }
                if (isEndorse && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTRESOURCE_PATH, (String)"isGenRPBill")) == 0) {
                    isCreateReceiving = true;
                }
                if (!FMHelper.isEmpty((String)(rtnMsg2 = ReceivableBillFactory.getRemoteInstance().returnBill(recBillInfo, returnbillInfo, isCreateReceiving)))) {
                    MsgBox.showInfo((Component)((Object)this), (String)rtnMsg2);
                }
            }
        }
        if (returnbillInfo.getType() == ReturnTypeEnum.Payable) {
            if (this.billInfo instanceof ReturnBillInfo) {
                boolean isCreatePayable = false;
                if (isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTRESOURCE_PATH, (String)"isGenRPBill")) == 0) {
                    isCreatePayable = true;
                }
                returnbillInfo.setCreatePayable(new Boolean(isCreatePayable));
                rtnMsg = ReturnBillFactory.getRemoteInstance().confirm((ReturnBillInfo)this.billInfo, returnbillInfo);
                if (!FMHelper.isEmpty((String)rtnMsg)) {
                    MsgBox.showInfo((Component)((Object)this), (String)rtnMsg);
                }
            } else {
                PayableBillInfo payBillInfo = (PayableBillInfo)this.billInfo;
                boolean isSubmit = payBillInfo.getBillState() == PayableBillStateEnum.SUBMIT || payBillInfo.getBillState() == PayableBillStateEnum.Audit;
                boolean isCreatePayment = false;
                if (isSubmit && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NTRESOURCE_PATH, (String)"isGenPaymentBill")) == 0) {
                    isCreatePayment = true;
                }
                PayableBillFactory.getRemoteInstance().returnBill((PayableBillInfo)this.billInfo, returnbillInfo, isCreatePayment);
            }
        }
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.billInfo) && this.billInfo instanceof PayableBillInfo) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            iMutex.releaseObjIDForUpdate(this.billInfo.getId().toString());
        }
        return super.destroyWindow();
    }

    public boolean isModify() {
        return false;
    }

    protected IObjectValue createNewData() {
        ReturnBillInfo info = new ReturnBillInfo();
        info.setCompany(this.curCompany);
        info.setReturnDate(DateUtil.getDayBegin());
        return info;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReturnBillFactory.getRemoteInstance();
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.ReturnBill", null, (IObjectValue)this.editData);
    }

    @Override
    protected void txtExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExRate_dataChanged(e);
        BigDecimal exRate = this.txtExRate.getBigDecimalValue();
        BigDecimal billAmount = this.txtAmount.getBigDecimalValue();
        this.txtLocAmount.setValue((Object)exRate.multiply(billAmount));
    }

    @Override
    protected void pkDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkDate_dataChanged(e);
        this.billInfo = (BillBaseInfo)this.getUIContext().get(FROM_INFO);
        if (this.getOprtState().equals(OprtState.VIEW) || this.billInfo == null) {
            this.loadViewData();
        } else {
            if (this.billInfo instanceof ReceivableBillInfo) {
                ReceivableBillInfo obj = (ReceivableBillInfo)this.billInfo;
                Date pikDate = (Date)this.pkDate.getValue();
                String companyId = this.curCompany.getId().toString();
                String srcCurrencyId = obj.getCurrency().getId().toString();
                String destCurrencyId = this.curCompany.getBaseCurrency().getId().toString();
                BigDecimal exRate = FMClientHelper.getExRate((String)companyId, (String)srcCurrencyId, (String)destCurrencyId, (Date)pikDate);
                this.txtExRate.setValue((Object)exRate);
                this.txtLocAmount.setValue((Object)exRate.multiply(this.txtAmount.getBigDecimalValue()));
            } else if (this.billInfo instanceof PayableBillInfo) {
                PayableBillInfo payableBillInfo = (PayableBillInfo)this.billInfo;
            } else if (this.billInfo instanceof ReturnBillInfo) {
                // empty if block
            }
            this.setReturnBillState(this.billInfo);
        }
    }
}

