/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReturnBill;
import com.kingdee.eas.fm.nt.NTFacadeFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.nt.ReturnTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractReturnReceivableBillListUI;
import com.kingdee.eas.fm.nt.client.ReturnBillFilterUI;
import com.kingdee.eas.fm.nt.client.ReturnBillUI;
import com.kingdee.eas.fm.nt.client.ReturnPayableBillListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReturnReceivableBillListUI
extends AbstractReturnReceivableBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReturnReceivableBillListUI.class);
    ReturnBillFilterUI filterUI;
    private boolean isConfirm4Return = false;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public ReturnReceivableBillListUI() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        this.isConfirm4Return = contextHelper.getBooleanParam("NT010", null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCancelReturnBil.setEnabled(true);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionConfirm.setVisible(this.isConfirm4Return);
        this.onshows();
    }

    private void onshows() {
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery() {
        FilterInfo filter;
        if (this.getBOTPViewStatus() == 1 && (filter = NTHelper.mergeFilter4RPCreateFrom(this.currentCompany, this.getUIContext(), "ReceivingBill")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("srcBillState", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("srcBillState", (Object)new Integer(8)));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.onshows();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        this.tblMain.getFootRow(0).getCell("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
        return row;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    protected String getEditUIName() {
        return ReturnBillUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionViewBgBalance.setEnabled(true);
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionCancelReturnBil.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelreturnticket"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReturnBillFilterUI();
            this.filterUI.getUIContext().put("returnbilltype", new Integer(1));
        }
        return this.filterUI;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(FMHelper.isEmpty((String)billInfo.getRpBillId()) && !billInfo.isFivouchered());
        this.actionDelVoucher.setEnabled(billInfo.isFivouchered());
        boolean isCanConfirmed = false;
        if (billInfo.getConfirmer() == null && billInfo.getEndorseCompany() != null && billInfo.getEndorseCompany().getId().toString().equals(this.currentCompany.getId().toString()) && !billInfo.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
            isCanConfirmed = true;
        }
        this.actionConfirm.setEnabled(isCanConfirmed);
        this.actionCancelReturnBil.setEnabled(!isCanConfirmed);
        this.actionBook.setEnabled(billInfo.getCashier() == null && FMHelper.isEmpty((String)billInfo.getRpBillId()));
        this.actionCancelBook.setEnabled(billInfo.getCashier() != null && FMHelper.isEmpty((String)billInfo.getRpBillId()));
    }

    public IUIObject getInstance(Map uiContext) {
        String targetBillType;
        Map botpCtx = (Map)uiContext.get("BTPEDITPARAMETER");
        if (botpCtx != null && (targetBillType = (String)botpCtx.get("TargetBillType")) != null && targetBillType.equals("PaymentBill")) {
            try {
                return new ReturnPayableBillListUI();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getInstance(uiContext);
    }

    @Override
    public void actionCancelReturnBil_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)billInfo.getReturnDate());
        ReceivableBillInfo sourceBill = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getSrcBillId())));
        ReceivableBillFactory.getRemoteInstance().cancelReturnBill(sourceBill);
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        String id = (String)idList.get(0);
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), sic);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"fromInfo", (Object)billInfo);
        uiContext.put((Object)"isPayableConfirm", (Object)new Boolean(false));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReturnBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReturnBillFactory.getRemoteInstance();
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().bookOppositeJournal(id);
        this.refreshList();
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().cancelBookJouranl(id);
        this.refreshList();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "billNumber"};
        return locateNames;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ReturnReceivableBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            Object styleAttributes = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("CurrencyID").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
                }
                if (row.getCell("billType") != null) {
                    if (row.getCell("srcBillType").getValue().toString().equals(ReturnTypeEnum.Receivable.toString())) {
                        row.getCell("billType").setValue((Object)BillStateEnum.getEnum((Integer)row.getCell("billType").getValue()));
                    } else {
                        row.getCell("billType").setValue((Object)PayableBillStateEnum.getEnum((Integer)row.getCell("billType").getValue()));
                    }
                }
                if (row.getCell("rpbillid").getValue() != null) {
                    row.getCell("rpbillid").setValue((Object)new Boolean(true));
                    continue;
                }
                row.getCell("rpbillid").setValue((Object)new Boolean(false));
            }
        }
    }
}

