/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.RptPayableBillFilterParam;
import com.kingdee.eas.fm.nt.client.AbstractRptPayableBillDetailFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class RptPayableBillDetailFilterUI
extends AbstractRptPayableBillDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptPayableBillDetailFilterUI.class);
    private final CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private final CurrencyInfo bassCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId().toString()));

    public Object getParam() {
        RptPayableBillFilterParam param = new RptPayableBillFilterParam();
        Object selectedBillmedium = this.billMedium.getSelectedItem();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setBankIdSet(this.getBankCompanyIdSet());
        param.setCurrencyIdSet(this.getIdSetFromF7(this.prmtCurrency));
        param.setTypeIdSet(this.getTypeIdSet());
        param.setAmount(this.txtAmount.getBigDecimalValue());
        param.setDateTo(this.pkExpiredDate.getSqlDate());
        param.setUnit((AmountUnitEnum)this.comboUnit.getSelectedItem());
        param.setDimType(this.kDButtonGroupCDDetail.getValue() + 1);
        if (FMSysDefinedEnum.SELECT_ALL.equals(selectedBillmedium)) {
            param.setBillMediumEnum(null);
        } else {
            param.setBillMediumEnum((BillMediumEnum)((Object)selectedBillmedium));
        }
        if (this.kDCheckBoxEntrustBill.isSelected()) {
            param.setContainEntrustBill(true);
        }
        return param;
    }

    protected Class getParamClass() {
        return RptPayableBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        RptPayableBillFilterParam loParam = (RptPayableBillFilterParam)param;
        this.setCompanyIdSet(loParam.getCompanyIdSet());
        this.txtAmount.setValue((Object)loParam.getAmount());
        try {
            this.prmtInstitution.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            CoreBaseInfo[] cc = RptFmClientUtil.getBaseInfoFromIdSet((Set)loParam.getCurrencyIdSet());
            this.prmtCurrency.setData((Object)cc);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.pkExpiredDate.setValue((Object)loParam.getDateTo());
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)loParam.getUnit());
        this.kDButtonGroupCDDetail.setValue(loParam.getDimType() - 1);
        if (loParam.getBillMediumEnum() != null) {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)((Object)loParam.getBillMediumEnum()));
        } else {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void doInit() throws Exception {
        this.initLastDayOfMonth(this.pkExpiredDate);
        this.pkExpiredDate.setValue((Object)new Date());
        this.txtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setValue((Object)Constants.TEN);
        this.prmtInstitution.setData(null);
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)AmountUnitEnum.wan_yuan);
        this.kDCheckBoxEntrustBill.setSelected(true);
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtInstitution, (Boolean)new Boolean(true));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.cdCompany.setEnabled(false);
            this.kDButtonGroupCDDetail.setValue(1);
            this.prmtCurrency.setData((Object)this.bassCurrency);
        } else {
            this.cdCompany.setEnabled(true);
            this.kDButtonGroupCDDetail.setValue(0);
        }
        this.initBillMediumComb();
    }

    private void initBillMediumComb() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        List list = BillMediumEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            model.addElement(list.get(i));
        }
        model.addElement(FMSysDefinedEnum.SELECT_ALL);
        this.billMedium.setModel(model);
        this.billMedium.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected void initCompanyState() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)currentCompany.getId().toString())) {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    protected Set getBankCompanyIdSet() {
        Set bankIdSet = this.getIdSetFromF7(this.prmtInstitution).size() < 0 ? this.getF7Bank() : this.getIdSetFromF7(this.prmtInstitution);
        if (this.kDCheckBoxCommercial.isSelected()) {
            return bankIdSet;
        }
        return bankIdSet;
    }

    private Set getF7Bank() {
        String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_NT_PayableBill AS \"COMMERCIALDRAFT\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"COMMERCIALDRAFT\".FInstitutionId = \"INSTITUTION\".FID";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        HashSet<String> companyIdSetToBankIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                companyIdSetToBankIdSet.add(rs.getString("Institution.id"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return companyIdSetToBankIdSet;
    }

    private Set getTypeIdSet() {
        HashSet typeIdSet = new HashSet();
        if (this.kDCheckBoxCommercial.isSelected()) {
            typeIdSet.clear();
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_CommerceAccept));
        } else {
            typeIdSet.clear();
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
        }
        return typeIdSet;
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void cdCompany_actionPerformed(ActionEvent e) throws Exception {
        super.cdCompany_actionPerformed(e);
        this.prmtCurrency.setValue((Object)this.bassCurrency);
    }

    @Override
    protected void cdCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cdCurrency_actionPerformed(e);
        this.prmtCurrency.setValue(null);
    }

    @Override
    protected void cdGaranteeType_actionPerformed(ActionEvent e) throws Exception {
        super.cdGaranteeType_actionPerformed(e);
        this.prmtCurrency.setValue((Object)this.bassCurrency);
    }

    @Override
    protected void cdInstitution_actionPerformed(ActionEvent e) throws Exception {
        super.cdInstitution_actionPerformed(e);
        this.prmtCurrency.setValue((Object)this.bassCurrency);
    }

    public boolean verify() {
        if (this.comboUnit.getSelectedItem() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)AmountUnitEnum.wan_yuan);
        }
        if (this.pkExpiredDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"371_RptPayableBillBalanceFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

