/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.RptPayableTransferFilterParam;
import com.kingdee.eas.fm.nt.TransferBillTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractRptPayableTransferDetailFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptPayableTransferDetailFilterUI
extends AbstractRptPayableTransferDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptPayableTransferDetailFilterUI.class);

    public RptPayableTransferDetailFilterUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtInstitution, (Boolean)new Boolean(true));
        this.comboTransferType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.initFirstDayOfMonth(this.pkFromDate);
        NTHelper.initCSF7Filter((IUIObject)this, this.prmtApply, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryWithDefaultStandardForVoucher");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE));
        this.prmtApplyCompany.setEntityViewInfo(view);
    }

    private Set getTypeIdSet() {
        HashSet typeIdSet = new HashSet();
        if (this.kDCheckBoxCommercial.isSelected()) {
            typeIdSet.clear();
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_CommerceAccept));
            return typeIdSet;
        }
        typeIdSet.clear();
        typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
        return typeIdSet;
    }

    protected Set getBankCompanyIdSet() {
        Set bankIdSet = this.getIdSetFromF7(this.prmtInstitution).size() < 0 ? this.getF7Bank() : this.getIdSetFromF7(this.prmtInstitution);
        if (this.kDCheckBoxCommercial.isSelected()) {
            return bankIdSet;
        }
        return bankIdSet;
    }

    private Set getF7Bank() {
        String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_NT_PayableBill AS \"COMMERCIALDRAFT\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"COMMERCIALDRAFT\".FInstitutionId = \"INSTITUTION\".FID";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        HashSet<String> companyIdSetToBankIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                companyIdSetToBankIdSet.add(rs.getString("Institution.id"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return companyIdSetToBankIdSet;
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public Object getParam() {
        RptPayableTransferFilterParam param = new RptPayableTransferFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setBankIdSet(this.getBankCompanyIdSet());
        param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        param.setCurrencyName(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName());
        param.setTypeIdSet(this.getTypeIdSet());
        param.setDateFrom((Date)this.pkFromDate.getValue());
        param.setDateTo((Date)this.pkToDate.getValue());
        if (!(this.comboTransferType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setTransferType((TransferBillTypeEnum)((Object)this.comboTransferType.getSelectedItem()));
            if (this.kDLabelCS.isVisible()) {
                param.setApplyCompanyNames(this.getF7Names(this.prmtApply));
            } else {
                param.setApplyCompanyNames(this.getF7Names(this.prmtApplyCompany));
            }
        } else {
            param.setTransferType(null);
            param.setApplyCompanyNames(null);
        }
        return param;
    }

    private Set getF7Names(KDBizPromptBox box) {
        Object value = box.getData();
        Object[] data = value instanceof Object[] ? (Object[])value : new Object[]{value};
        if (FMHelper.isEmpty((Object[])data)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(data.length);
        for (int i = 0; i < data.length; ++i) {
            set.add(data[i].toString());
        }
        return set;
    }

    protected Class getParamClass() {
        return RptPayableTransferFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        RptPayableTransferFilterParam loParam = (RptPayableTransferFilterParam)param;
        this.setCompanyIdSet(loParam.getCompanyIdSet());
        try {
            this.prmtInstitution.setData((Object)this.getBaseInfoFromIdSet(loParam.getBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            if (loParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(loParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.pkFromDate.setValue((Object)loParam.getDateFrom());
        this.pkToDate.setValue((Object)loParam.getDateTo());
        if (loParam.getTransferType() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboTransferType, (Object)((Object)loParam.getTransferType()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboTransferType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (loParam.getApplyCompanyNames() != null) {
            if (this.kDLabelCS.isVisible()) {
                this.prmtApply.setValue((Object)loParam.getApplyCompanyNames().toArray());
            } else {
                this.prmtApplyCompany.setValue((Object)loParam.getApplyCompanyNames().toArray());
            }
        }
        if (loParam.getTypeIdSet() != null && loParam.getTypeIdSet().contains(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_CommerceAccept))) {
            this.kDCheckBoxCommercial.setSelected(true);
        } else {
            this.kDCheckBoxCommercial.setSelected(false);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.kDLabelCS.setVisible(false);
        this.kDLabelCompany.setVisible(true);
        this.initFirstDayOfMonth(this.pkFromDate);
        this.pkToDate.setValue((Object)new Date());
        this.prmtInstitution.setData(null);
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtApply.setData(null);
        this.prmtApplyCompany.setData(null);
        this.comboTransferType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initCompanyState() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)currentCompany.getId().toString())) {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(2, 1);
        lastDay.add(5, -date.getDate());
        kdDate.setValue((Object)lastDay.getTime());
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    @Override
    protected void comboTransferType_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null) {
            super.comboTransferType_itemStateChanged(e);
            if (e.getStateChange() == 2) {
                return;
            }
        }
        if (!(this.comboTransferType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            TransferBillTypeEnum billType = (TransferBillTypeEnum)((Object)this.comboTransferType.getSelectedItem());
            if (billType == TransferBillTypeEnum.In) {
                this.kDLabelCS.setVisible(false);
                this.prmtApply.setEnabled(false);
                this.kDLabelCompany.setVisible(true);
                this.prmtApplyCompany.setEnabled(true);
            } else {
                this.kDLabelCS.setVisible(true);
                this.prmtApply.setEnabled(true);
                this.kDLabelCompany.setVisible(false);
                this.prmtApplyCompany.setEnabled(false);
            }
        } else {
            this.prmtApply.setEnabled(false);
            this.prmtApplyCompany.setEnabled(false);
            this.prmtApply.setData(null);
            this.prmtApplyCompany.setData(null);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.pkFromDate.getValue(), (Date)this.pkToDate.getValue());
        return super.verify();
    }
}

