/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class RptPayableTransferDetailHandler
extends FMDetailRptBaseHandler {
    public RptPayableTransferDetailHandler(FilterInfo filterInfo, KDTable kdt, AmountUnitEnum uni) {
        super(filterInfo, kdt);
    }

    public RptPayableTransferDetailHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.nt.app.RptPayableTransferDetailQuery";
    }

    public void initHeader() {
        super.initHeader();
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        KDTColumns column = this.kdt.getColumns();
        int columnCount = column.size();
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            for (int i = 0; i < columnCount; ++i) {
                row.getCell(i).setValue(rs.getObject(column.getColumnKey(i)));
            }
            row.getCell("number").setValue((Object)rs.getString("draftNumber"));
            row.getCell("transfer.amount").setValue((Object)rs.getBigDecimal("Amount"));
            String currencyID = row.getCell("Currency.id").getValue().toString();
            String format = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyID));
            row.getCell("transfer.amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("transfer.amount").getStyleAttributes().setNumberFormat(format);
        }
    }

    public void setTableStateRow() {
        String subTotalTxt = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"subTotal");
        String totalTxt = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"total");
        this.kdt.getColumn("company.name").setStat(true);
        this.kdt.getColumn("company.name").setGroup(true);
        this.kdt.getColumn("transfer.applyName").setStat(true);
        this.kdt.getColumn("transfer.applyName").setGroup(true);
        this.kdt.getGroupManager().setTotalize(true);
        IRow row0 = this.kdt.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getCell(5).setExpressions("SUM");
        row0.getCell(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(1).setValue((Object)totalTxt);
        row0 = this.kdt.getGroupManager().getStatRowTemplate(0);
        row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getCell(5).setExpressions("SUM");
        row0.getCell(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(1).setValue((Object)subTotalTxt);
        row0 = this.kdt.getGroupManager().getStatRowTemplate(1);
        row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getCell(5).setExpressions("SUM");
        row0.getCell(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell(1).setValue((Object)subTotalTxt);
        this.kdt.getColumn("transfer.amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

