/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ft.RptFundTransferConstants;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTRptRcvBillFilterParam;
import com.kingdee.eas.fm.nt.client.AbstractRptReceivableBillAnalyseFilterUI;
import com.kingdee.eas.fm.nt.client.CSF7MutiSelector;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class RptReceivableBillAnalyseFilterUI
extends AbstractRptReceivableBillAnalyseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptReceivableBillAnalyseFilterUI.class);
    protected CurrencyInfo bassCurrency;

    public RptReceivableBillAnalyseFilterUI() throws Exception {
        this.bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
        EntityViewInfo entityView = NTHelper.getCSF7ViewInfoStr();
        ExtendParser parser = new ExtendParser(this.prmtdeliver);
        this.prmtdeliver.setCommitParser((IParser)parser);
        this.prmtdeliver.setEditable(true);
        this.prmtdeliver.setDisplayFormat("$name$");
        this.prmtdeliver.setEditFormat("$name$");
        this.prmtdeliver.setCommitFormat("$name$");
        this.prmtdeliver.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign");
        CSF7MutiSelector arg0 = new CSF7MutiSelector((IUIObject)this, this.prmtdeliver);
        this.prmtdeliver.setSelector((KDPromptSelector)arg0);
        this.prmtdeliver.setEntityViewInfo(entityView);
        this.prmtdeliver.setEnabledMultiSelection(true);
        this.initBillMediumComb();
    }

    private void initBillMediumComb() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        List list = BillMediumEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            model.addElement(list.get(i));
        }
        model.addElement(FMSysDefinedEnum.SELECT_ALL);
        this.billMedium.setModel(model);
        this.billMedium.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public void clear() {
        super.clear();
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    private void resetPrmtDeliver() {
        try {
            ObjectBaseInfo csInfo;
            if (this.prmtdeliver.getValue() instanceof String && (csInfo = NTHelper.getCSInfoByNumber(this.prmtdeliver.getText())) != null) {
                this.prmtdeliver.setValue((Object)csInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        Object selectedBillmedium;
        NTRptRcvBillFilterParam filterParam = new NTRptRcvBillFilterParam();
        if (this.getCompanyIds() != null && this.getCompanyIds().length > 0) {
            filterParam.setCompanyIds(this.getCompanyIds());
        }
        filterParam.setBeginDate(this.dtpFromDate.getSqlDate());
        filterParam.setEndDate(this.dtpToDate.getSqlDate());
        this.resetPrmtDeliver();
        String[] delivers = null;
        if (!FMHelper.isEmpty((Object)this.prmtdeliver.getValue())) {
            Object rs = this.prmtdeliver.getData();
            if (!FMHelper.isEmpty((Object)rs) && rs instanceof Object[]) {
                Object[] deliverObjects = (Object[])rs;
                delivers = new String[deliverObjects.length];
                for (int i = 0; i < deliverObjects.length; ++i) {
                    delivers[i] = deliverObjects[i].toString();
                }
            } else if (!FMHelper.isEmpty((Object)rs)) {
                delivers = rs.toString().split(";");
            }
        }
        filterParam.setDelivers(delivers);
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            if (!FMHelper.isEmpty((Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId())) {
                filterParam.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
            }
        } else {
            filterParam.setCurrencyId(null);
        }
        if (FMSysDefinedEnum.SELECT_ALL.equals(selectedBillmedium = this.billMedium.getSelectedItem())) {
            filterParam.setBillMediumEnum(null);
        } else {
            filterParam.setBillMediumEnum((BillMediumEnum)((Object)selectedBillmedium));
        }
        return filterParam;
    }

    public void setParam(Object param) {
        NTRptRcvBillFilterParam filterParam = (NTRptRcvBillFilterParam)param;
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < filterParam.getCompanyIds().length; ++i) {
            companyIdSet.add(filterParam.getCompanyIds()[i]);
        }
        if (filterParam.getCurrencyId() != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)filterParam.getCurrencyId()));
            currency.setName(filterParam.getCurrencyName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (filterParam != null) {
            this.setCompanyIdSet(companyIdSet);
            this.dtpFromDate.setValue((Object)filterParam.getBeginDate());
            this.dtpToDate.setValue((Object)filterParam.getEndDate());
            if (!FMHelper.isEmpty((Object[])filterParam.getDelivers())) {
                this.prmtdeliver.setValue((Object)filterParam.getDelivers());
            }
        }
        if (filterParam.getBillMediumEnum() != null) {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)filterParam.getBillMedium());
        } else {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    public boolean verify() {
        super.verify();
        if (this.dtpFromDate.getValue() != null) {
            if (this.dtpFromDate.getSqlDate().after(this.dtpToDate.getSqlDate())) {
                MsgBox.showWarning((String)RptFundTransferConstants.REOURCE_READER.getKeyValue("enddate_error"));
                Date d = new Date();
                this.dtpFromDate.setValue((Object)this.getStartDate(d));
                this.dtpFromDate.setFocusable(true);
                return false;
            }
        } else {
            this.dtpFromDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
            if (this.dtpFromDate.getSqlDate().after(this.dtpToDate.getSqlDate())) {
                MsgBox.showWarning((String)RptFundTransferConstants.REOURCE_READER.getKeyValue("enddate_error"));
                Date d = new Date();
                this.dtpFromDate.setValue((Object)this.getStartDate(d));
                this.dtpFromDate.setFocusable(true);
                return false;
            }
        }
        return true;
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.dtpFromDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dtpFromDate.setSupportedEmpty(false);
        this.dtpToDate.setValue((Object)DateUtil.getDayBegin());
        this.dtpToDate.setSupportedEmpty(false);
        this.prmtdeliver.setEnabledMultiSelection(true);
        this.prmtdeliver.setValue(null);
        this.companyIds = new String[]{this.currentCompany.getId().toString()};
    }

    protected void initCompanyState() {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected Class getParamClass() {
        return NTRptRcvBillFilterParam.class;
    }
}

