/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.client.AbstractRptReceivableMatureFilterUI;
import com.kingdee.eas.framework.report.util.RptParams;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;

public class RptReceivableMatureFilterUI
extends AbstractRptReceivableMatureFilterUI {
    private final CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private final CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.company);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
    }

    private void initControl() throws Exception {
        this.dpDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpDateFrom.setSupportedEmpty(false);
        this.dpDateTo.setValue((Object)new Date());
        this.dpDateTo.setSupportedEmpty(false);
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        this.initBillMediumComb();
    }

    private void initBillMediumComb() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        List list = BillMediumEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            model.addElement(list.get(i));
        }
        model.addElement(FMSysDefinedEnum.SELECT_ALL);
        this.billMedium.setModel(model);
        this.billMedium.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.dpDateFrom, (KDDatePicker)this.dpDateTo);
        return super.verify();
    }

    public void clear() {
        super.clear();
        this.txtBank.setText(null);
        this.dpDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpDateTo.setValue((Object)new Date());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.currency);
    }

    public RptParams getCustomCondition() {
        RptParams param = new RptParams();
        param.setObject("companyIdSet", (Object)this.companyIdSet);
        param.setObject("dateFrom", (Object)DateUtil.getSQLBegin((Date)((Date)this.dpDateFrom.getValue())));
        param.setObject("dateTo", (Object)DateUtil.getSQLEnd((Date)((Date)this.dpDateTo.getValue())));
        Object val = this.comboCurrency.getSelectedItem();
        if (val instanceof CurrencyInfo) {
            param.setObject("currency", val);
        } else {
            param.setObject("currency", null);
        }
        String[] banks = this.txtBank.getText().split(";");
        if (banks.length == 1 && banks[0].length() == 0) {
            banks = null;
        }
        param.setObject("bank", (Object)FMHelper.asSet((String[])banks));
        Object selectedBillmedium = this.billMedium.getSelectedItem();
        if (!FMSysDefinedEnum.SELECT_ALL.equals(selectedBillmedium)) {
            BillMediumEnum billMedium = (BillMediumEnum)((Object)this.billMedium.getSelectedItem());
            param.setObject("billMedium", (Object)billMedium.getValue());
        }
        return param;
    }

    public void setCustomCondition(RptParams params) {
        Set banks;
        this.dpDateFrom.setValue(params.getObject("dateFrom"));
        this.dpDateTo.setValue(params.getObject("dateTo"));
        Object val = params.getObject("currency");
        if (val instanceof CurrencyInfo) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)val);
        }
        if ((banks = (Set)params.getObject("bank")) != null && banks.size() > 0) {
            Iterator it = banks.iterator();
            StringBuffer bankNames = new StringBuffer();
            bankNames.append(it.next());
            while (it.hasNext()) {
                bankNames.append(";");
                bankNames.append(it.next());
            }
            this.txtBank.setText(bankNames.toString());
        } else {
            this.txtBank.setText(null);
        }
    }
}

