/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.IChequeAssosicateProvider;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class SettlementChequeAssociateProvider
implements IChequeAssosicateProvider {
    @Override
    public void writeAssosicateCheque(ChequeInfo cheque, String[] ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        view.getSelector().add("*");
        view.getSelector().add("currency.*");
        view.getSelector().add("settleType.*");
        view.getSelector().add("creator.*");
        view.getSelector().add("creator.person.*");
        view.getSelector().add("auditor.*");
        view.getSelector().add("auditor.person.*");
        SettlementBillCollection coll = SettlementBillFactory.getRemoteInstance().getSettlementBillCollection(view);
        BigDecimal totalAmount = Constants.ZERO;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            totalAmount = totalAmount.add(info.getAmount());
            sb.append(info.getNumber());
            sb.append(",");
        }
        if (totalAmount == null || totalAmount.compareTo(Constants.ZERO) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        cheque.setAmount(totalAmount);
        cheque.setDescription(sb.toString().substring(0, sb.toString().length() - 1));
        SettlementBillInfo firstBill = coll.get(0);
        CurrencyInfo payerCurrency = null;
        payerCurrency = cheque.getCurrency() == null ? firstBill.getCurrency() : cheque.getCurrency();
        cheque.setCurrency(payerCurrency);
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo settlementBill = coll.get(i);
            settlementBill.setOuterSettleNumber(cheque.getNumber());
        }
        String iso = payerCurrency.getIsoCode();
        NTNumberFormat f = NTNumberFormat.getInstance(iso);
        String amountString = f.format(totalAmount);
        cheque.setCapitalization(amountString);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayBegin());
        cheque.setIssueDate(cal.getTime());
        cal.add(5, 10);
        cheque.setExpiredDate(cal.getTime());
        if (!FMHelper.isEmpty((String)firstBill.getDescription())) {
            cheque.setUsage(firstBill.getDescription());
        }
        PersonInfo creator = firstBill.getCreator().getPerson();
        if (cheque.getState().equals((Object)ChequeStatusEnum.NEW)) {
            ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
            if (creator != null) {
                recInfo.setApplicant(creator);
                IPerson iPerson = PersonFactory.getRemoteInstance();
                AdminOrgUnitInfo admin = iPerson.getPrimaryAdminOrgUnit(creator.getId());
                recInfo.setDepartment(admin);
            }
            cheque.setApplyRec(recInfo);
        }
        cheque.getApplyRec().setReimburser(creator);
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        cheque.getApplyRec().setCreator(userInfo);
        cheque.setPayeeName(firstBill.getPayeeFullName());
        cheque.setPayeeAcctBank(firstBill.getPayeeBank());
        cheque.setPayeeAcctNumber(firstBill.getPayeeBankAcctNum());
    }

    @Override
    public void fillBilllist(KDTable table, String[] ids) throws BOSException, EASBizException, SQLException {
        if (FMHelper.isEmpty((Object[])ids)) {
            return;
        }
        ISettlementBill stt = SettlementBillFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("payerBankAcct.*");
        view.getSelector().add("currency.*");
        view.getSelector().add("settleType.*");
        view.getSelector().add("settleType.ntType.*");
        SettlementBillCollection coll = stt.getSettlementBillCollection(view);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        BOSUuid currencyId = coll.get(0).getCurrency().getId();
        table.getColumn("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currencyId));
        for (int i = 0; i < coll.size(); ++i) {
            SettlementBillInfo info = coll.get(i);
            IRow row = table.addRow();
            row.getCell("billNumber").setValue((Object)info.getNumber());
            row.getCell("bankAccount").setValue((Object)info.getPayerBankAcct().getBankAccountNumber());
            row.getCell("bankAccountId").setValue((Object)info.getPayerBankAcct().getId().toString());
            row.getCell("currency").setValue((Object)info.getCurrency().getName());
            row.getCell("currencyId").setValue((Object)info.getCurrency().getId().toString());
            row.getCell("amount").setValue((Object)info.getAmount());
            row.getCell("settleType").setValue((Object)info.getSettleType().getName());
            row.getCell("settleTypeId").setValue((Object)info.getSettleType().getNtType().getId().toString());
            row.getCell("settleNumber").setValue((Object)info.getOuterSettleNumber());
        }
    }

    @Override
    public void saveAssosicateCheque(ChequeInfo cheque, String[] ids) throws BOSException, EASBizException {
        if (cheque == null) {
            return;
        }
        ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();
        iSettleFacade.writeOff(FMHelper.asSet((String[])ids), cheque);
    }
}

