/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.client.ChequeListUI;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ChequeListHandler {
    public static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.NtResource";
    IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private CompanyOrgUnitInfo cur = this.contextHelper.getCurrentCompany();
    private PersonInfo curPerson = this.contextHelper.getCurrentUser().getPerson();
    private boolean operateAll = false;

    public ChequeListHandler(boolean isTreeView, boolean operateAll) {
        this.operateAll = operateAll;
    }

    public void initUIContentLayout(ChequeListUI listUI) {
    }

    public void checkKeeper(PersonInfo keeper) throws Exception {
        String personId;
        if (this.operateAll) {
            return;
        }
        String string = personId = this.curPerson != null ? this.curPerson.getId().toString() : "";
        if (this.curPerson == null) {
            MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"OPRTPERMIT"));
            SysUtil.abort();
        }
        if (keeper == null || keeper.getId() != null && !personId.equals(keeper.getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"SAMEPERSON"));
            SysUtil.abort();
        }
    }

    public void checkKeeper(ChequeCollection coll) throws Exception {
        String personId;
        String string = personId = this.curPerson != null ? this.curPerson.getId().toString() : "";
        if (this.operateAll) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            ChequeInfo core = coll.get(i);
            PersonInfo person = core.getKeeper();
            if (this.curPerson == null) {
                MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"OPRTPERMIT"));
                SysUtil.abort();
            }
            if (person != null && person.getId() != null && personId.equals(person.getId().toString())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"SAMEPERSON"));
            SysUtil.abort();
        }
    }

    public TreeModel getTree(EntityViewInfo mainQuery) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("COMPANY.ID", (Object)this.cur.getId().toString()));
        view.setFilter(filter);
        FilterItemCollection coll = mainQuery.getFilter().getFilterItems();
        for (FilterItemInfo item : coll) {
            if (!item.getPropertyName().equals("bank.id")) continue;
            view.getFilter().getFilterItems().add(item);
        }
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        AccountBankCollection accouts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"");
        DefaultKingdeeTreeNode nodeCheque = new DefaultKingdeeTreeNode((Object)new Integer(1));
        DefaultKingdeeTreeNode nodeTeleOrder = new DefaultKingdeeTreeNode((Object)new Integer(11));
        nodeCheque.setText(NTTypeGroupEnum.CHEQUE.toString());
        nodeTeleOrder.setText(NTTypeGroupEnum.TELE_ORDER.toString());
        root.add((MutableTreeNode)nodeCheque);
        root.add((MutableTreeNode)nodeTeleOrder);
        BankCollection banks = this.getBanks(accouts);
        this.buildBankTree(nodeCheque, accouts, banks);
        this.buildBankTree(nodeTeleOrder, accouts, banks);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        return model;
    }

    private void buildBankTree(DefaultKingdeeTreeNode parent, AccountBankCollection accouts, BankCollection banks) {
        for (BankInfo bankInfo : banks) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)bankInfo);
            parent.add((MutableTreeNode)node);
            AccountBankCollection acctBanks = this.getAcctBanksByBank(accouts, bankInfo);
            for (AccountBankInfo acctbankInfo : acctBanks) {
                DefaultKingdeeTreeNode subNode = new DefaultKingdeeTreeNode((Object)acctbankInfo.getBankAccountNumber());
                subNode.setUserObject((Object)acctbankInfo);
                node.add((MutableTreeNode)subNode);
            }
        }
    }

    private BankCollection getBanks(AccountBankCollection accouts) {
        BankCollection banks = new BankCollection();
        HashMap<String, String> mapAcct = new HashMap<String, String>();
        for (AccountBankInfo acctBank : accouts) {
            if (mapAcct.containsKey(acctBank.getBank().getId().toString())) continue;
            banks.add(acctBank.getBank());
            mapAcct.put(acctBank.getBank().getId().toString(), acctBank.getBank().getId().toString());
        }
        return banks;
    }

    private AccountBankCollection getAcctBanksByBank(AccountBankCollection accouts, BankInfo bank) {
        AccountBankCollection acctbanks = new AccountBankCollection();
        for (AccountBankInfo acctBank : accouts) {
            if (!acctBank.getBank().getId().toString().equals(bank.getId().toString())) continue;
            acctbanks.add(acctBank);
        }
        return acctbanks;
    }

    public void checkCanAntiReimburse(ChequeCollection coll) throws BOSException, EASBizException {
        for (int i = 0; i < coll.size(); ++i) {
            ChequeInfo cheque = coll.get(i);
            if (cheque.isIsVC()) {
                MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"HASVC_CAN_NOT_ANTI"));
                SysUtil.abort();
            }
            if (cheque.getPaymentBillNum() != null) {
                MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"LINK_CAN_NOT_ANTI"));
                SysUtil.abort();
            }
            if (!cheque.getState().equals((Object)ChequeStatusEnum.WRITTEN_OFF)) {
                MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"AntiRemburse_Wrong"));
                SysUtil.abort();
            }
            if (cheque.isFiVouchered()) {
                MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"VOUCHAR_CAN_NOT_ANTI"));
                SysUtil.abort();
            }
            if (ChequeUtil.checkCurCompanyIsValid(cheque)) continue;
            MsgBox.showInfo((String)new NTException(NTException.NOT_CURRENT_COMPANY_CQ).getCauseClassName());
            SysUtil.abort();
        }
    }

    public FilterInfo buildFilter(Object objFilter, KDTree treeBank) {
        FilterInfo filerinfo = new FilterInfo();
        FilterItemInfo bankfilterItem = null;
        FilterItemInfo nttypeFilterItem = null;
        if (objFilter instanceof AccountBankInfo) {
            AccountBankInfo acctbankInfo = (AccountBankInfo)objFilter;
            bankfilterItem = new FilterItemInfo("BANKACCT.id", (Object)acctbankInfo.getId().toString());
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)treeBank.getSelectionPath().getLastPathComponent()).getParent().getParent();
            int nttype = Integer.parseInt(node.getUserObject().toString());
            nttypeFilterItem = 11 == nttype ? new FilterItemInfo("ntType.group", (Object)new Integer(1), CompareType.NOTEQUALS) : new FilterItemInfo("ntType.group", (Object)new Integer(1), CompareType.EQUALS);
        } else if (objFilter instanceof BankInfo) {
            BankInfo bankInfo = (BankInfo)objFilter;
            bankfilterItem = new FilterItemInfo("BANK.id", (Object)bankInfo.getId().toString());
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)treeBank.getSelectionPath().getLastPathComponent()).getParent();
            int nttype = Integer.parseInt(node.getUserObject().toString());
            nttypeFilterItem = 11 == nttype ? new FilterItemInfo("ntType.group", (Object)new Integer(11), CompareType.EQUALS) : new FilterItemInfo("ntType.group", (Object)new Integer(1), CompareType.EQUALS);
        } else {
            bankfilterItem = new FilterItemInfo("BANK.id", null, CompareType.NOTEQUALS);
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeBank.getSelectionPath().getLastPathComponent();
            int nttype = Integer.parseInt(node.getUserObject().toString());
            nttypeFilterItem = 11 == nttype ? new FilterItemInfo("ntType.group", (Object)new Integer(11), CompareType.EQUALS) : new FilterItemInfo("ntType.group", (Object)new Integer(1), CompareType.EQUALS);
        }
        filerinfo.getFilterItems().add(bankfilterItem);
        filerinfo.getFilterItems().add(nttypeFilterItem);
        return filerinfo;
    }

    public void builderHeader(int nttype, KDTable tblMain) {
        if (11 == nttype) {
            this.buildTeleOrderHead(tblMain);
        } else {
            this.buildChequeHead(tblMain);
        }
    }

    public void buildChequeHead(KDTable tblMain) {
        IRow head = tblMain.getHeadRow(0);
        tblMain.getColumn("remitInAddr1.name").getStyleAttributes().setHided(true);
        tblMain.getColumn("remitInAddr2.name").getStyleAttributes().setHided(true);
        tblMain.getColumn("remitOutAddr1.name").getStyleAttributes().setHided(true);
        tblMain.getColumn("remitOutAddr2.name").getStyleAttributes().setHided(true);
        tblMain.getColumn("isVC").getStyleAttributes().setHided(false);
        tblMain.getColumn("PaymentBillNum").getStyleAttributes().setHided(false);
        tblMain.getColumn("feeType").getStyleAttributes().setHided(false);
        tblMain.getColumn("isQuota").getStyleAttributes().setHided(false);
        tblMain.getColumn("ApplyRec.ceiling").getStyleAttributes().setHided(false);
        tblMain.getColumn("ExpiredDate").getStyleAttributes().setHided(false);
        tblMain.getColumn("descb").getStyleAttributes().setHided(true);
        head.getCell("BankAcct").setValue((Object)this.getString("bankAcct"));
        head.getCell("Bank").setValue((Object)this.getString("bank"));
        head.getCell("istransfer").setValue((Object)this.getString("isTransCheque"));
    }

    public void buildTeleOrderHead(KDTable tblMain) {
        IRow head = tblMain.getHeadRow(0);
        tblMain.getColumn("remitInAddr1.name").getStyleAttributes().setHided(false);
        tblMain.getColumn("remitInAddr2.name").getStyleAttributes().setHided(false);
        tblMain.getColumn("remitOutAddr1.name").getStyleAttributes().setHided(false);
        tblMain.getColumn("remitOutAddr2.name").getStyleAttributes().setHided(false);
        tblMain.getColumn("isVC").getStyleAttributes().setHided(true);
        tblMain.getColumn("PaymentBillNum").getStyleAttributes().setHided(true);
        tblMain.getColumn("feeType").getStyleAttributes().setHided(true);
        tblMain.getColumn("isQuota").getStyleAttributes().setHided(true);
        tblMain.getColumn("ApplyRec.ceiling").getStyleAttributes().setHided(true);
        tblMain.getColumn("ExpiredDate").getStyleAttributes().setHided(true);
        tblMain.getColumn("descb").getStyleAttributes().setHided(false);
        head.getCell("BankAcct").setValue((Object)this.getString("remitBankAccount"));
        head.getCell("Bank").setValue((Object)this.getString("remitBank"));
        head.getCell("istransfer").setValue((Object)this.getString("isTransTeleOrder"));
    }

    private String getString(String name) {
        String chequeResource = "com.kingdee.eas.fm.nt.ChequeResource";
        return EASResource.getString((String)chequeResource, (String)name);
    }
}

