/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.client.AuxActTypeListUI;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.INTType;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.client.util.ChequeCollEqulsVerifier;
import com.kingdee.eas.fm.nt.client.util.MyVOComparator;
import com.kingdee.eas.fm.nt.client.util.ResultInfomation;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JComponent;

public class ChequeUtil {
    public static final Locale L1 = LocaleUtils.locale_l1;
    public static final Locale L2 = LocaleUtils.locale_l2;
    public static final Locale L3 = LocaleUtils.locale_l3;
    public static final String CHEQUEIDS = "CHEQUEIDS";
    public static final String ISEDIT = "EDIT";
    public static final String FOR_DISTRIBUTE_ACTION = "DISTRIBUTE";
    public static final String FOR_APPLY_ACTION = "APPLY";
    public static final String FOR_WRITEOFF_ACTION = "WRITEOFF";
    public static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.NtResource";

    public static void initPrmtNumber(KDBizPromptBox prmtNumber, String oprtName, boolean needAudit) throws Exception {
        boolean oprtAll;
        prmtNumber.setEnabledMultiSelection(true);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        PersonInfo currentPerson = null;
        if (currentUser != null) {
            currentPerson = currentUser.getPerson();
        }
        if (currentPerson == null) {
            MsgBox.showInfo((String)EASResource.getString((String)NTRESOURCE_PATH, (String)"OPRTPERMIT"));
            SysUtil.abort();
        }
        FilterItemInfo filterState = null;
        if (oprtName.equals(FOR_APPLY_ACTION)) {
            filterState = new FilterItemInfo("state", (Object)new Integer(1));
        } else {
            HashSet<Integer> stateSet = new HashSet<Integer>();
            stateSet.add(new Integer(1));
            if (!needAudit) {
                stateSet.add(new Integer(2));
            }
            filterState = new FilterItemInfo("state", stateSet, CompareType.INCLUDE);
        }
        FilterItemInfo filterNtType = new FilterItemInfo("ntType.group", (Object)new Integer(1));
        FilterItemInfo fiterAbadon = new FilterItemInfo("isAbandon", (Object)new Integer(0));
        FilterItemInfo filterCurCompany = new FilterItemInfo("company.id", (Object)currentCompany.getId().toString());
        FilterItemInfo filterKeepCompany = new FilterItemInfo("keepCompany.id", (Object)currentCompany.getId().toString());
        FilterItemInfo filterBACompany = new FilterItemInfo("bankAcct.company.id", (Object)currentCompany.getId().toString());
        FilterUtil.mergerFilterItem((KDBizPromptBox)prmtNumber, (FilterItemInfo)filterState);
        FilterUtil.mergerFilterItem((KDBizPromptBox)prmtNumber, (FilterItemInfo)filterNtType);
        FilterUtil.mergerFilterItem((KDBizPromptBox)prmtNumber, (FilterItemInfo)fiterAbadon);
        FilterInfo filterCompany = new FilterInfo();
        filterCompany.getFilterItems().add(filterCurCompany);
        filterCompany.getFilterItems().add(filterKeepCompany);
        filterCompany.getFilterItems().add(filterBACompany);
        filterCompany.setMaskString("(#0 or #1 or #2)");
        FilterInfo filterAudit = new FilterInfo();
        if (needAudit) {
            FilterItemInfo itemAudit = new FilterItemInfo("isAudit", (Object)Constants.TRUE);
            FilterItemInfo itemState = new FilterItemInfo("state", (Object)new Integer(2));
            filterAudit.getFilterItems().add(itemAudit);
            filterAudit.getFilterItems().add(itemState);
            filterAudit.getFilterItems().add(filterNtType);
        }
        boolean viewAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT004", (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
        boolean bl = oprtAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT005", (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
        if (!viewAll || !oprtAll) {
            FilterItemInfo item = new FilterItemInfo("keeper.id", (Object)currentPerson.getId().toString());
            FilterUtil.mergerFilterItem((KDBizPromptBox)prmtNumber, (FilterItemInfo)item);
            if (needAudit) {
                filterAudit.getFilterItems().add(item);
            }
        }
        EntityViewInfo view = new EntityViewInfo(prmtNumber.getEntityViewInfo().toString());
        view.getFilter().mergeFilter(filterCompany, "and");
        if (needAudit) {
            filterAudit.mergeFilter(filterCompany, "and");
            view.getFilter().mergeFilter(filterAudit, "or");
        }
        prmtNumber.setEntityViewInfo(view);
    }

    public static void setAsstActSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, String sCompanyId) throws Exception {
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$name$");
        bizPromptBox.setSelector(null);
        bizPromptBox.setEntityViewInfo(null);
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
        bizPromptBox.setQueryInfo(queryInfo);
        FilterInfo filter = new FilterInfo();
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
        selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
        ChequeUtil.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterSupplier);
        bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterSupplier);
    }

    public static void setSupplierF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, CompanyOrgUnitInfo company) {
        bizPromptBox.setEntityViewInfo(null);
        bizPromptBox.setHasCUDefaultFilter(false);
        bizPromptBox.setIsDefaultFilterFieldsEnabled(false);
        String groupStandardId = "00000000-0000-0000-0000-000000000001BC122A7F";
        try {
            ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        bizPromptBox.setRefresh(false);
        bizPromptBox.setCurrentCtrlUnit(company.getCU());
        bizPromptBox.getQueryAgent().resetRuntimeEntityView();
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$name$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("COMORG.ID", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        view.setFilter(filter);
        bizPromptBox.setEntityViewInfo(view);
        String queryInfo = "com.kingdee.eas.fm.nt.app.PSupplierQueryForCheque";
        bizPromptBox.setQueryInfo(queryInfo);
        GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
        try {
            selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
            selectorLisenterSupplier.setCUId(company.getCU().getId().toString());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        ChequeUtil.assignSelector((KDPromptBox)bizPromptBox, selectorLisenterSupplier);
        bizPromptBox.addSelectorListener(selectorLisenterSupplier);
    }

    public static void setSupplierTreeViewF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, CompanyOrgUnitInfo company) {
        try {
            AsstActTypeCollection coll = ChequeUtil.getAsstActTypeColl(company.getId().toString());
            if (coll.size() > 0) {
                GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)coll.get(0), (CoreUIObject)ui);
                bizPromptBox.setHasCUDefaultFilter(false);
                bizPromptBox.setIsDefaultFilterFieldsEnabled(false);
                bizPromptBox.setEditable(true);
                bizPromptBox.setCurrentCtrlUnit(company.getCU());
            } else {
                bizPromptBox.setHasCUDefaultFilter(false);
                bizPromptBox.setIsDefaultFilterFieldsEnabled(false);
                bizPromptBox.setEditable(true);
                bizPromptBox.setCurrentCtrlUnit(company.getCU());
                bizPromptBox.setDisplayFormat("$name$");
                bizPromptBox.setEditFormat("$name$");
                String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
                bizPromptBox.setQueryInfo(queryInfo);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static AsstActTypeCollection getAsstActTypeColl(String cuID) throws BOSException, EASBizException {
        FilterInfo filter = ChequeUtil.getAsstActTypeFilter(cuID);
        filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)"T_BD_Supplier"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    public static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private static FilterInfo getAsstActTypeFilter(String cuId) throws BOSException, EASBizException {
        AsstActTypeCollection asstActTypeCollection;
        if (FMHelper.isEmpty((String)cuId)) {
            cuId = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit().getId().toString();
        }
        if ((asstActTypeCollection = AuxActTypeListUI.getAsstActTypeCollection()) != null) {
            asstActTypeCollection.addObjectCollection((IObjectCollection)AuxActTypeListUI.getCurrentAssign());
            asstActTypeCollection.addObjectCollection((IObjectCollection)AuxActTypeListUI.getParentAssign());
        } else {
            asstActTypeCollection = AuxActTypeListUI.getCurrentAssign();
            asstActTypeCollection.addObjectCollection((IObjectCollection)AuxActTypeListUI.getParentAssign());
        }
        FilterInfo filter = new FilterInfo();
        if (asstActTypeCollection == null || asstActTypeCollection.size() == 0) {
            return filter;
        }
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            ids.add(asstActTypeCollection.get(i).getId().toString());
        }
        HashSet<String> set = new HashSet<String>();
        set.add("T_BD_Supplier");
        filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and FControlUnitID='" + cuId + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    public static ResultInfomation checkChequeApplyValid(ChequeCollection cqCollection) throws Exception {
        boolean isApplied;
        if (cqCollection == null || cqCollection.size() == 0) {
            return new ResultInfomation(true, "ok");
        }
        CompanyOrgUnitInfo cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PersonInfo Person = ContextHelperFactory.getRemoteInstance().getCurrentUser().getPerson();
        boolean operateAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT005", (IObjectPK)new ObjectUuidPK(cur.getId().toString()));
        String[] properties = new String[]{"state", "bank", "bankAcct", "ntType", "currency"};
        MyVOComparator comparator = new MyVOComparator(properties);
        ChequeCollEqulsVerifier verifier = new ChequeCollEqulsVerifier(comparator);
        ResultInfomation result = verifier.verifyEquals(cqCollection);
        if (!result.isEqual()) {
            return result;
        }
        ChequeInfo cheque0 = cqCollection.get(0);
        boolean isCheque = cheque0.getNtType().getGroup() == NTTypeGroupEnum.CHEQUE;
        boolean bl = isApplied = cheque0.getState() == ChequeStatusEnum.APPLIED;
        if (cqCollection.size() == 1 && isApplied && isCheque) {
            result = new ResultInfomation();
            return result;
        }
        if (cqCollection.size() == 1 && isApplied && !isCheque) {
            result = new ResultInfomation();
            return result;
        }
        for (int i = 0; i < cqCollection.size(); ++i) {
            ChequeInfo info = cqCollection.get(i);
            if (Person != null) {
                ChequeUtil.checkKeeper(info, operateAll, Person.getId().toString());
            }
            if (info.getState() != ChequeStatusEnum.NEW && isCheque) {
                result = new ResultInfomation(false, new NTException(NTException.SELECT_BLANK_CHEQUE).getMessage());
                return result;
            }
            if (info.getState() != ChequeStatusEnum.NEW && !isCheque) {
                result = new ResultInfomation(false, new NTException(NTException.SELECT_BLANK_TELEORDER).getMessage());
                return result;
            }
            if (info.isIsVC() || info.isFiVouchered()) {
                result = new ResultInfomation(false, new NTException(NTException.CHEQUE_CANNOT_WRITEOFF).getMessage());
                return result;
            }
            if (info.getPaymentBillNum() != null) {
                result = new ResultInfomation(false, new NTException(NTException.REFTOPMTCANTDO).getMessage());
                return result;
            }
            if (ChequeUtil.checkCurCompanyIsValid(info)) continue;
            result = new ResultInfomation(false, new NTException(NTException.NOT_CURRENT_COMPANY_CQ).getMessage());
            return result;
        }
        return new ResultInfomation();
    }

    public static ResultInfomation checkChequeWriteOffValid(ChequeCollection cqCollection) throws EASBizException, BOSException, Exception {
        if (cqCollection == null || cqCollection.size() == 0) {
            return new ResultInfomation(true, "ok");
        }
        CompanyOrgUnitInfo cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PersonInfo Person = ContextHelperFactory.getRemoteInstance().getCurrentUser().getPerson();
        boolean operateAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT005", (IObjectPK)new ObjectUuidPK(cur.getId().toString()));
        String[] properties = new String[]{"isApply", "state", "bank", "bankAcct", "ntType", "currency", "project", "projectManager"};
        MyVOComparator comparator = new MyVOComparator(properties);
        ChequeCollEqulsVerifier verifier = new ChequeCollEqulsVerifier(comparator);
        ResultInfomation result = verifier.verifyEquals(cqCollection);
        if (!result.isEqual()) {
            return result;
        }
        ChequeInfo cheque0 = cqCollection.get(0);
        String tempNTTypeId = cheque0.getNtType().getId().toString();
        NTTypeGroupEnum enumGroup = NTTypeFactory.getRemoteInstance().getGroup(tempNTTypeId);
        if (enumGroup.getValue() != 1) {
            result = new ResultInfomation(false, new NTException(NTException.NOTENOTAPPLIED).getMessage());
            return result;
        }
        if (cqCollection.size() == 1 && !cheque0.getState().equals((Object)ChequeStatusEnum.STORE) && !cheque0.getState().equals((Object)ChequeStatusEnum.Canceled)) {
            FilterInfo pfa = new FilterInfo();
            ChequeInfo info = cqCollection.get(0);
            pfa.getFilterItems().add(new FilterItemInfo("cheque.id", (Object)info.getId().toString()));
            if (PaymentBillFactory.getRemoteInstance().exists(pfa)) {
                result = new ResultInfomation(false, new NTException(NTException.CHEQUELOCKED).getMessage());
                return result;
            }
            return new ResultInfomation(true, "ok");
        }
        for (int i = 0; i < cqCollection.size(); ++i) {
            ChequeInfo info = cqCollection.get(i);
            if (Person != null) {
                ChequeUtil.checkKeeper(info, operateAll, Person.getId().toString());
            }
            if (info.getState() != ChequeStatusEnum.APPLIED && info.getState() != ChequeStatusEnum.NEW) {
                result = new ResultInfomation(false, new NTException(NTException.NOTENOTAPPLIED).getMessage());
                return result;
            }
            if (info.isIsVC() || info.isFiVouchered()) {
                result = new ResultInfomation(false, new NTException(NTException.CHEQUE_CANNOT_WRITEOFF).getMessage());
                return result;
            }
            if (info.getPaymentBillNum() != null) {
                result = new ResultInfomation(false, new NTException(NTException.REFTOPMTCANTDO).getMessage());
                return result;
            }
            if (!ChequeUtil.checkCurCompanyIsValid(info)) {
                result = new ResultInfomation(false, new NTException(NTException.NOT_CURRENT_COMPANY_CQ).getMessage());
                return result;
            }
            FilterInfo pf = new FilterInfo();
            pf.getFilterItems().add(new FilterItemInfo("cheque.id", (Object)info.getId().toString()));
            if (!PaymentBillFactory.getRemoteInstance().exists(pf)) continue;
            result = new ResultInfomation(false, new NTException(NTException.CHEQUELOCKED).getMessage());
            return result;
        }
        return new ResultInfomation(true, "ok");
    }

    public static void checkKeeper(ChequeInfo info, boolean operateAll, String personId) throws Exception {
        if (operateAll) {
            return;
        }
        if (info.getKeeper() == null || !info.getKeeper().getId().toString().equals(personId)) {
            throw new NTException(NTException.CURRUSERISNOTKEEPER);
        }
    }

    public static void initComboNttype(KDComboBox comboNTType, boolean includeTeleOrder) throws BOSException {
        INTType iINTType = NTTypeFactory.getRemoteInstance();
        NTTypeCollection nTTypeCollection = null;
        EntityViewInfo ntViewInfo = new EntityViewInfo();
        ntViewInfo.getSelector().add(new SelectorItemInfo("id"));
        ntViewInfo.getSelector().add(new SelectorItemInfo("number"));
        ntViewInfo.getSelector().add(new SelectorItemInfo("name"));
        ntViewInfo.getSelector().add(new SelectorItemInfo("group"));
        ntViewInfo.getSelector().add(new SelectorItemInfo("isCash"));
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        if (includeTeleOrder) {
            set.add(new Integer(11));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isUsed", (Object)new Boolean(true)));
        filterInfo.getFilterItems().add(new FilterItemInfo("group", set, CompareType.INCLUDE));
        ntViewInfo.setFilter(filterInfo);
        ntViewInfo.getSorter().add(new SorterItemInfo("number"));
        nTTypeCollection = iINTType.getNTTypeCollection(ntViewInfo);
        if (nTTypeCollection != null && nTTypeCollection.size() > 0) {
            int size = nTTypeCollection.size();
            for (int i = 0; i < size; ++i) {
                comboNTType.addItem((Object)nTTypeCollection.get(i));
            }
            comboNTType.setSelectedIndex(0);
        }
    }

    public static void initPerson(IUIObject ui, KDBizPromptBox box) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        map.put("0", "2");
        PersonPromptBox select = new PersonPromptBox(ui, map);
        select.setHasCUDefaultFilter(false);
        select.setIsDefaultFilterFieldsEnabled(false);
        box.setSelector((KDPromptSelector)select);
        box.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
    }

    public static void initAdminOrgUnit(IUIObject coreui, KDBizPromptBox prmtDepartment) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        NewAdminF7 f7 = new NewAdminF7(coreui);
        f7.setNeedAddOrgRange(false);
        prmtDepartment.setSelector((KDPromptSelector)f7);
    }

    public static void initPrmtBankAcct(IUIObject ui, KDBizPromptBox box, CompanyOrgUnitInfo company, BankInfo bank, SelectorItemCollection sic) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE, CompareType.EQUALS));
        if (company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId()));
        }
        if (bank != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bank.getId()));
        }
        evi.setFilter(filter);
        box.setEntityViewInfo(evi);
        if (sic != null) {
            box.setSelectorCollection(sic);
        } else {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add("*");
            sc.add("bank.*");
            sc.add("currency.*");
            box.setSelectorCollection(sc);
        }
        box.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        box.setDisplayFormat("$number$ $name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$;$name$");
    }

    public static void initChequeF7(IUIObject ui, KDBizPromptBox box) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("State", (Object)Constants.FALSE, CompareType.EQUALS));
        evi.setFilter(filter);
        box.setEntityViewInfo(evi);
        box.setEnabledMultiSelection(true);
        box.setQueryInfo("com.kingdee.eas.fm.nt.app.ChequeQuery");
        box.setDisplayFormat("$number$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
    }

    public static void initTeleOrderF7(IUIObject ui, KDBizPromptBox box, SelectorItemCollection sic) throws Exception {
        boolean applyAll;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("ntType.group", (Object)new Integer(11)));
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)Constants.FALSE));
        FilterItemInfo filterCurCompany = new FilterItemInfo("company.id", (Object)currentCompany.getId().toString());
        FilterItemInfo filterKeepCompany = new FilterItemInfo("keepCompany.id", (Object)currentCompany.getId().toString());
        FilterItemInfo filterBACompany = new FilterItemInfo("bankAcct.company.id", (Object)currentCompany.getId().toString());
        FilterInfo filterCompany = new FilterInfo();
        filterCompany.getFilterItems().add(filterCurCompany);
        filterCompany.getFilterItems().add(filterBACompany);
        filterCompany.getFilterItems().add(filterKeepCompany);
        filterCompany.setMaskString("#0 or #1 or #2");
        boolean viewAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT004", (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
        boolean bl = applyAll = !ContextHelperFactory.getRemoteInstance().getBooleanParam("NT005", (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()));
        if (!(viewAll && applyAll || SysContext.getSysContext().getCurrentUserInfo().getPerson() == null)) {
            filter.getFilterItems().add(new FilterItemInfo("keeper.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
        }
        evi.setFilter(filter);
        evi.getFilter().mergeFilter(filterCompany, "and");
        box.setEntityViewInfo(evi);
        box.setSelectorCollection(sic);
        box.setQueryInfo("com.kingdee.eas.fm.nt.app.TeleQuery");
        box.setDisplayFormat("$number$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
    }

    public static void initPrmtNttype(KDBizPromptBox prmtNttype) {
        prmtNttype.setQueryInfo("com.kingdee.eas.fm.nt.app.NTTypeQuery");
        EntityViewInfo view = prmtNttype.getEntityViewInfo();
        view = view == null ? new EntityViewInfo() : view;
        FilterInfo filter = view.getFilter();
        filter = filter == null ? new FilterInfo() : filter;
        HashSet<Integer> nttypeSet = new HashSet<Integer>();
        nttypeSet.add(new Integer(1));
        nttypeSet.add(new Integer(11));
        filter.getFilterItems().add(new FilterItemInfo("group", nttypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        view.setFilter(filter);
        prmtNttype.setEntityViewInfo(view);
    }

    public static void initCompanyOrgF7(IUIObject ui, KDBizPromptBox box) {
        box.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        NewCompanyF7 f7 = new NewCompanyF7(ui);
        f7.setNeedAddOrgRange(false);
        box.setSelector((KDPromptSelector)f7);
    }

    public static boolean checkCurCompanyIsValid(ChequeInfo info) throws EASBizException, BOSException {
        boolean isBARalatedCompany = true;
        boolean isKCRalatedCompany = true;
        boolean isCCRalatedCompany = true;
        CompanyOrgUnitInfo cur = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (info.getBankAcct() != null && info.getBankAcct().getCompany() != null) {
            if (!cur.getId().equals((Object)info.getBankAcct().getCompany().getId())) {
                isBARalatedCompany = false;
            }
        } else if (info.getBankAcct() != null && info.getBankAcct().getCompany() == null) {
            AccountBankInfo bankAcct = info.getBankAcct();
            bankAcct = (AccountBankInfo)ChequeUtil.getDetailVO((CoreBaseInfo)bankAcct);
            if (info.getBankAcct().getCompany() != null && !cur.getId().equals((Object)bankAcct.getCompany().getId())) {
                return false;
            }
        }
        if (info.getKeepCompany() == null || !cur.getId().toString().equals(info.getKeepCompany().getId().toString())) {
            isKCRalatedCompany = false;
        }
        if (!cur.getId().toString().equals(info.getCompany().getId().toString())) {
            isCCRalatedCompany = false;
        }
        return isBARalatedCompany || isKCRalatedCompany || isCCRalatedCompany;
    }

    public static CoreBaseInfo getDetailVO(CoreBaseInfo info) throws BOSException, EASBizException {
        BOSUuid bosUUid = info.getId();
        ICoreBase bizCtrl = EJBAccessFactory.createRemoteInstance().getEntityBizInterface(info);
        CoreBaseInfo infoDetail = bizCtrl.getValue((IObjectPK)new ObjectUuidPK(bosUUid.toString()));
        return infoDetail;
    }

    public static void initOppAccoutF7(IUIObject ui, KDBizPromptBox f7OppAccountView, CurrencyInfo currencyInfo, CompanyOrgUnitInfo applyCompany) throws EASBizException, BOSException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = applyCompany.getId().toString();
        String cuId = applyCompany.getCU().getId().toString();
        f7OppAccountView.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        AccountPromptBox opseelect = new AccountPromptBox(ui, applyCompany, treeevi.getFilter(), false, true);
        f7OppAccountView.setSelector((KDPromptSelector)opseelect);
        f7OppAccountView.setEntityViewInfo(evi);
    }

    public static ChequeCollection getChequeCollection(ArrayList list) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)ChequeUtil.getSelectors());
        view.setSelector(ChequeUtil.getSelectors());
        view.getSorter().add(new SorterItemInfo("number"));
        ChequeCollection cqCollection = null;
        try {
            cqCollection = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return cqCollection;
    }

    public static void setComponentsValueNull(IKDComponent[] components) {
        for (int i = 0; i < components.length; ++i) {
            IKDComponent c = components[i];
            if (c instanceof KDTextField) {
                ((KDTextField)c).setText(null);
                continue;
            }
            if (c instanceof KDDatePicker) {
                ((KDDatePicker)c).setValue(null);
                continue;
            }
            if (c instanceof KDFormattedTextField) {
                ((KDFormattedTextField)c).setValue(null);
                continue;
            }
            if (c instanceof KDBizPromptBox) {
                ((KDBizPromptBox)c).setValue(null);
                continue;
            }
            if (!(c instanceof KDCheckBox)) continue;
            ((KDCheckBox)c).setSelected(false);
        }
    }

    public static void setComponentsValueNull(ICell[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i].setValue(null);
        }
    }

    public static void initPayBankAccount(KDBizPromptBox prmtPayAccountBank, CompanyOrgUnitInfo company, BankInfo bank) throws Exception {
        if (bank != null) {
            FilterItemInfo filterBank = new FilterItemInfo("bank.id", (Object)bank.getId().toString());
            FilterUtil.mergerFilterItem((KDBizPromptBox)prmtPayAccountBank, (FilterItemInfo)filterBank);
        }
        FilterItemInfo filterClosed = new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS);
        FilterUtil.mergerFilterItem((KDBizPromptBox)prmtPayAccountBank, (FilterItemInfo)filterClosed);
    }

    public static void setPrecision(KDTable table, String[] columns, CurrencyInfo ci) {
        int pre = FMClientHelper.getPrecOfCurrency((BOSUuid)ci.getId());
        for (int i = 0; i < columns.length; ++i) {
            StyleAttributes attrDebit = table.getColumn(columns[i]).getStyleAttributes();
            attrDebit.setNumberFormat(CslRptUIUtil.getFmtStr((CurrencyInfo)ci));
            attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            KDFormattedTextField editor = (KDFormattedTextField)table.getColumn(columns[i]).getEditor().getComponent();
            editor.setPrecision(pre);
        }
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("ntType.id");
        sic.add("ntType.name");
        sic.add("ntType.group");
        sic.add("keeper.id");
        sic.add("keeper.name");
        sic.add("bankAcct.id");
        sic.add("bankAcct.name");
        sic.add("bankAcct.number");
        sic.add("bankAcct.account.id");
        sic.add("bankAcct.bankAccountNumber");
        sic.add("bankAcct.isClosed");
        sic.add("bankAcct.isReckoning");
        sic.add("bankAcct.bank.id");
        sic.add("bankAcct.bank.name");
        sic.add("bankAcct.company.id");
        sic.add("bankAcct.company.CU.id");
        sic.add("bankAcct.currency.id");
        sic.add("bankAcct.company.name");
        sic.add("Bank.id");
        sic.add("Bank.name");
        sic.add("keepCompany.id");
        sic.add("keepCompany.name");
        sic.add("keepCompany.cu");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("project.id");
        sic.add("project.name");
        sic.add("projectManager.id");
        sic.add("projectManager.name");
        sic.add("feeTypeID.id");
        sic.add("feeTypeID.name");
        sic.add("oppAccount.id");
        sic.add("oppAccount.name");
        sic.add("turnInAcctBank.id");
        sic.add("turnInAcctBank.name");
        sic.add("feeTypeID.id");
        sic.add("feeTypeID.name");
        sic.add("applyRec.*");
        sic.add("applyRec.department.id");
        sic.add("applyRec.department.name");
        sic.add("applyRec.applicant.id");
        sic.add("applyRec.applicant.name");
        sic.add("applyRec.auditor.id");
        sic.add("applyRec.auditor.name");
        sic.add("applyRec.reimburser.id");
        sic.add("applyRec.reimburser.name");
        sic.add("applyRec.applyCompany.id");
        sic.add("applyRec.applyCompany.name");
        sic.add("applyRec.applyCompany.CU.id");
        sic.add(new SelectorItemInfo("actualBankAcct.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.name"));
        sic.add(new SelectorItemInfo("actualBankAcct.bankAccountNumber"));
        return sic;
    }

    public static EntityViewInfo getOppAcctEV(CompanyOrgUnitInfo company, String currencyID, boolean isMe, boolean isCash, boolean isLeaf) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isMe && isCash) {
            filter.getFilterItems().add(new FilterItemInfo("iscash", (Object)Constants.TRUE));
        }
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        ev.setFilter(filter);
        EntityViewInfo evi = FMHelper.getAccountViewEvi((String)company.getId().toString(), (String)currencyID, (EntityViewInfo)ev);
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        return evi;
    }

    public static CompanyOrgUnitInfo getRightCompany(KDBizPromptBox prmtApplyCompany) {
        CompanyOrgUnitInfo applyCompany = null;
        if (prmtApplyCompany.getValue() == null) {
            applyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        } else {
            applyCompany = (CompanyOrgUnitInfo)prmtApplyCompany.getValue();
            try {
                applyCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(applyCompany.getId()));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return applyCompany;
    }

    public static boolean checkApplyCompanyNotNull(KDBizPromptBox prmtApplyCompany, EventObject evt) {
        if (prmtApplyCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"377_ChequeUtil"));
            if (evt instanceof SelectorEvent) {
                ((SelectorEvent)evt).setCanceled(true);
            } else if (evt instanceof CommitEvent) {
                ((CommitEvent)evt).setCanceled(true);
            }
            return false;
        }
        return true;
    }

    public static void setColumnEnabled(KDTable table, String[] comps, boolean enable) {
        for (int i = 0; i < comps.length; ++i) {
            table.getColumn(comps[i]).getStyleAttributes().setLocked(!enable);
        }
    }

    public static void updateEditUITitle(CoreUIObject ui, String title, boolean isEdit) {
        String resPath = "com.kingdee.eas.fm.common.FMResource";
        String strTitle = title;
        if (ui.getOprtState().equals(OprtState.VIEW) || ui.getOprtState().equals("FINDVIEW")) {
            ui.setUITitle(strTitle + " - " + EASResource.getString((String)resPath, (String)"view"));
        } else if (ui.getOprtState().equals(OprtState.EDIT) && isEdit) {
            ui.setUITitle(strTitle + " - " + EASResource.getString((String)resPath, (String)"edit"));
        } else if (ui.getOprtState().equals(OprtState.EDIT) && !isEdit) {
            ui.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"378_ChequeUtil"));
        } else {
            ui.setUITitle(strTitle);
        }
    }

    public static EntityViewInfo getInAcctBank(boolean isme, boolean isCash, String chequeBankAcctId, String compayID) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!isCash && isme) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)chequeBankAcctId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compayID));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compayID));
        }
        ev.setFilter(filter);
        return ev;
    }

    public static SelectorItemCollection getAppliedDetailChequeSIC() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bank.id");
        sic.add("bank.name");
        sic.add("bankAcct.id");
        sic.add("bankAcct.name");
        sic.add("bankAcct.company.id");
        sic.add("bankAcct.company.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("keepCompany.name");
        sic.add("keepCompany.id");
        return sic;
    }

    public static void setComponentEnable(JComponent source, boolean enable) {
        for (int i = 0; i < source.getComponentCount(); ++i) {
            Component c = source.getComponent(i);
            if (c instanceof JComponent && ((JComponent)c).getComponentCount() > 0) {
                if (c instanceof KDBizPromptBox) {
                    ((KDBizPromptBox)c).setEnabled(enable);
                }
                if (c instanceof KDDatePicker) {
                    ((KDDatePicker)c).setEnabled(enable);
                }
                if (c instanceof KDComboBox) {
                    ((KDComboBox)c).setEnabled(enable);
                }
                if (c instanceof KDTable) {
                    ((KDTable)c).getStyleAttributes().setLocked(!enable);
                }
                ChequeUtil.setComponentEnable((JComponent)c, enable);
                continue;
            }
            if (c instanceof KDFormattedTextField) {
                ((KDFormattedTextField)c).setEnabled(enable);
            }
            if (c instanceof KDTextField) {
                ((KDTextField)c).setEnabled(enable);
            }
            if (c instanceof KDWorkButton) {
                ((KDWorkButton)c).setEnabled(enable);
            }
            if (!(c instanceof KDCheckBox)) continue;
            ((KDCheckBox)c).setEnabled(enable);
        }
    }
}

