/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.fm.nt.client.util.FMCellTextIconRender;
import com.kingdee.eas.fm.nt.client.util.FMToolTip;
import com.kingdee.eas.fm.nt.client.util.FMToolTipManager;
import com.kingdee.eas.fm.nt.vo.FMToolTipInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;

public class FMToolTipUtil {
    public static void setToolTipInfo(JComponent component, FMToolTipInfo info) {
        ArrayList<FMToolTipInfo> infoList = new ArrayList<FMToolTipInfo>();
        infoList.add(info);
        FMToolTipUtil.setToolTipInfo(component, infoList);
    }

    public static JToolTip createToolTip(JComponent component, String toolTipTxt, String url) {
        FMToolTip tip = new FMToolTip(toolTipTxt, url);
        tip.setComponent(component);
        return tip;
    }

    public static void setToolTipInfo(JComponent component, final List<FMToolTipInfo> infoList) {
        if (infoList.size() == 0) {
            return;
        }
        if (component instanceof KDLabelContainer) {
            KDLabelContainer container = (KDLabelContainer)component;
            FMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                FMToolTipUtil.setToolTipText(container.getBoundLabel(), text);
                JButton btn = FMToolTipUtil.createToolTipButton();
                container.add((Component)btn, (Object)"button");
                if ("contRemark".equals(container.getName())) {
                    btn.setBounds(FMToolTipUtil.getStringlength(container.getBoundLabelText()), container.getBounds().height - 20, 20, 20);
                } else {
                    btn.setBounds(FMToolTipUtil.getStringlength(container.getBoundLabelText()), 0, 20, 20);
                }
                container.repaint();
            } else {
                FMToolTipUtil.setToolTipText(container.getBoundLabel(), null);
            }
        } else if (component instanceof KDTable) {
            final KDTable table = (KDTable)component;
            final KDTView headView = (KDTView)table.getViewManager().getView(2);
            final HashMap<String, FMToolTipInfo> toolTipInfoMap = new HashMap<String, FMToolTipInfo>();
            FMToolTipInfo TMToolTipInfo = null;
            KDTCell cell = null;
            int size = infoList.size();
            block0: for (int i = 0; i < size; ++i) {
                TMToolTipInfo = infoList.get(i);
                toolTipInfoMap.put(TMToolTipInfo.getName(), TMToolTipInfo);
                cell = table.getHead().getRow(0).getCell(table.getColumnIndex(TMToolTipInfo.getName()));
                if (cell == null) {
                    ArrayList cells = table.getHead().getRow(0).getCells();
                    for (int j = 0; j < cells.size(); ++j) {
                        if (!(cells.get(j) instanceof KDTCell) || !TMToolTipInfo.getName().equals(((KDTCell)cells.get(j)).getValue())) continue;
                        ((KDTCell)cells.get(j)).setRenderer((IBasicRender)new FMCellTextIconRender());
                        continue block0;
                    }
                    continue;
                }
                cell.setRenderer((IBasicRender)new FMCellTextIconRender());
            }
            headView.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    FMToolTipInfo info;
                    KDTCellPosition cellPosition = headView.getCellPosition(e.getX(), e.getY());
                    String fieldName = table.getColumnKey(cellPosition.colIndex);
                    if (fieldName == null) {
                        fieldName = (String)table.getHead().getRow(cellPosition.rowIndex).getCell(cellPosition.colIndex).getValue();
                    }
                    if ((info = (FMToolTipInfo)toolTipInfoMap.get(fieldName)) != null) {
                        String text = JSON.toJSONString((Object)info);
                        FMToolTipUtil.setToolTipText((JComponent)headView, text);
                    } else {
                        FMToolTipUtil.setToolTipText((JComponent)headView, null);
                    }
                }
            });
            table.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 1 && e.getType() == 0) {
                        FMToolTipInfo TMToolTipInfo = null;
                        KDTCell cell = null;
                        int index = -1;
                        int size = infoList.size();
                        for (int i = 0; i < size; ++i) {
                            TMToolTipInfo = (FMToolTipInfo)infoList.get(i);
                            toolTipInfoMap.put(TMToolTipInfo.getName(), TMToolTipInfo);
                            index = table.getColumnIndex(TMToolTipInfo.getName());
                            if (table.getColumn(index).isSortable() && index == e.getColIndex()) continue;
                            cell = table.getHead().getRow(0).getCell(table.getColumnIndex(TMToolTipInfo.getName()));
                            cell.setRenderer((IBasicRender)new FMCellTextIconRender());
                        }
                        table.repaint();
                    }
                }
            });
        } else if (component instanceof KDCheckBox) {
            FMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                FMToolTipUtil.setToolTipText(component, text);
            } else {
                FMToolTipUtil.setToolTipText(component, null);
            }
        } else if (component instanceof KDButton) {
            FMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                FMToolTipUtil.setToolTipText(component, text);
            } else {
                FMToolTipUtil.setToolTipText(component, null);
            }
        } else if (component instanceof KDMenuItem) {
            FMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                FMToolTipUtil.setToolTipText(component, text);
            } else {
                FMToolTipUtil.setToolTipText(component, null);
            }
        } else {
            FMToolTipInfo info = infoList.get(0);
            if (info != null) {
                String text = JSON.toJSONString((Object)info);
                FMToolTipUtil.setToolTipText(component, text);
            } else {
                FMToolTipUtil.setToolTipText(component, null);
            }
        }
    }

    public static JButton createToolTipButton() {
        JButton btn = new JButton();
        Icon icon = FMToolTipUtil.findIconByPath("image/" + FMToolTipUtil.getUserColorName() + "/Help.png");
        btn.setIcon(icon);
        btn.setBorderPainted(false);
        btn.setBounds(0, 0, 30, 30);
        btn.setFocusable(false);
        return btn;
    }

    private static String getUserColorName() {
        int colorStyle = UIConfig.getUiColorStyle();
        String color = "blue";
        switch (colorStyle) {
            case 2: {
                color = "orange";
                break;
            }
            case 0: {
                color = "green";
                break;
            }
            case 4: {
                color = "red";
            }
        }
        return color;
    }

    private static Icon findIconByPath(String relativePath) {
        ImageIcon icon = null;
        URL url = FMToolTip.class.getResource(relativePath);
        if (url != null) {
            icon = new ImageIcon(url);
            icon.setImage(icon.getImage().getScaledInstance(icon.getIconWidth() * 4 / 5, icon.getIconHeight() * 4 / 5, 4));
        } else {
            icon = new ImageIcon(EASResource.getImage((String)"imgTbtn_help").getScaledInstance(15, 15, 4));
        }
        return icon;
    }

    public static void setToolTipText(JComponent component, String text) {
        String oldText = component.getToolTipText();
        component.setToolTipText(null);
        MouseListener[] mouseListeners = component.getMouseListeners();
        int size = mouseListeners.length;
        for (int j = 0; j < size; ++j) {
            if (!(mouseListeners[j] instanceof ToolTipManager)) continue;
            component.removeMouseListener(mouseListeners[j]);
        }
        component.putClientProperty("ToolTipText", text);
        FMToolTipManager toolTipManager = FMToolTipManager.sharedInstance();
        if (text != null) {
            if (oldText == null || !FMToolTipUtil.isCustomToolTip(oldText)) {
                toolTipManager.registerComponent(component);
            }
        } else {
            toolTipManager.unregisterComponent(component);
        }
    }

    public static boolean isCustomToolTip(String text) {
        return FMToolTipUtil.getToolTipInfo(text) != null;
    }

    public static FMToolTipInfo getToolTipInfo(String text) {
        FMToolTipInfo info = null;
        try {
            JSONObject json = new JSONObject(text);
            info = new FMToolTipInfo();
            info.setName(json.getString("name"));
            info.setText(json.getString("text"));
            info.setUrl(json.getString("url"));
        }
        catch (JSONException e) {
            return null;
        }
        return info;
    }

    public static int getStringlength(String value) {
        float valueLength = 5.0f;
        String chinese = "[\u4e00-\u9fa5]|\u3002|\uff1f|\uff01|\u3010|\u3011|\uff0c|\u3001|\uff1b|\uff1a|\u300c|\u300d|\u300e|\u300f|\u2019|\u201c|\u201d|\u2018|\uff08|\uff09|\u3014|\u3015|\u2026|\u2013|\uff0e|\u2014|\u300a|\u300b|\u3008|\u3009";
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                String temp = value.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    valueLength = (float)((double)valueLength + 11.5);
                    continue;
                }
                valueLength += 8.0f;
            }
        }
        return (int)valueLength;
    }
}

