/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.IAddress;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.NoteKindEnum;
import com.kingdee.eas.fm.nt.ReceiptBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;

public class ReceiptBillUtil {
    public static void initF7BankAccount(KDBizPromptBox prmtBankAcct) {
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtBankAcct.setEntityViewInfo(evi);
        prmtBankAcct.setDisplayFormat("$bankAccountNumber$ $name$");
        prmtBankAcct.setEditFormat("$number$");
        prmtBankAcct.setCommitFormat("$number$;$name$;$bankaccountnumber$");
    }

    public static void setBankAcctBySupplier(SupplierInfo supplier, KDBizPromptBox txtBankAcct, KDTextField txtBank) throws BOSException, EASBizException {
        if (supplier != null) {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)currentCompany.getId().toString());
            if (bankInfo != null) {
                txtBankAcct.setText(bankInfo.getBankAccount());
                txtBank.setText(bankInfo.getBank());
            } else {
                txtBankAcct.setText(null);
                txtBank.setText(null);
            }
            txtBankAcct.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
            txtBankAcct.setHasCUDefaultFilter(false);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplier.getId()));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)currentCompany.getId()));
            view.setFilter(filter);
            txtBankAcct.setEntityViewInfo(view);
            txtBankAcct.setEditFormat("$bankAccount$");
            txtBankAcct.setDisplayFormat("$bankAccount$");
            txtBankAcct.getQueryAgent().resetRuntimeEntityView();
        }
    }

    public static Object[] getAddressByAdminOrgId(String adminOrgId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("address.*"));
        AdminOrgUnitInfo comInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId), sic);
        if (comInfo == null) {
            return null;
        }
        AddressInfo address = comInfo.getAddress();
        if (address != null) {
            IAddress a = AddressFactory.getRemoteInstance();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("provinceId.*"));
            selector.add(new SelectorItemInfo("cityId.*"));
            AddressInfo addressInfo = a.getAddressInfo((IObjectPK)new ObjectUuidPK(address.getId()), selector);
            ProvinceInfo province = addressInfo.getProvinceId();
            CityInfo city = addressInfo.getCityId();
            Object[] values = new Object[]{province, city};
            return values;
        }
        return null;
    }

    public static void setAddressBySupplier(SupplierInfo supplier, KDPromptBox prmtProvince, KDPromptBox prmtCity) throws BOSException, EASBizException {
        if (supplier != null) {
            CityInfo city;
            CityInfo c;
            ProvinceInfo province;
            ProvinceInfo p = supplier.getProvince();
            if (p != null && (province = ProvinceFactory.getRemoteInstance().getProvinceInfo((IObjectPK)new ObjectUuidPK(p.getId()))) != null) {
                prmtProvince.setValue((Object)province);
            }
            if ((c = supplier.getCity()) != null && (city = CityFactory.getRemoteInstance().getCityInfo((IObjectPK)new ObjectUuidPK(c.getId()))) != null) {
                prmtCity.setValue((Object)city);
            }
        }
    }

    public static void enableTxtInput(final KDPromptBox prmtBox) {
        prmtBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                prmtBox.setData((Object)e.getText());
            }
        });
    }

    public static void setAutoNumber(ReceiptBillInfo data, NoteKindEnum enumeration) {
        String sysNumber;
        if (data.getNumber() == null && (sysNumber = ReceiptBillUtil.getNextNumber(ReceiptBillUtil.getLastNumber(enumeration))) != null && sysNumber.trim().length() > 0) {
            data.setNumber(sysNumber);
        }
    }

    private static String getLastNumber(NoteKindEnum enumeration) {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        StringBuffer sql = new StringBuffer(128);
        sql.append("select top 1 fnumber from t_nt_receiptbill ");
        sql.append(" where fcompanyId='");
        sql.append(companyInfo.getId().toString());
        sql.append("' and fnotekind =" + enumeration.getValue() + "  order by fcreatetime desc");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        try {
            IRowSet rs = sqlExe.executeSQL();
            if (rs != null && rs.next()) {
                return rs.getString("fnumber");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return null;
    }

    private static String getNextNumber(String number) {
        if (number == null || number.length() == 0) {
            return null;
        }
        int i = number.length() - 1;
        if (number.charAt(i) > '9' || number.charAt(i) < '0') {
            StringBuffer sb = new StringBuffer();
            char nextChar = (char)(number.charAt(i) + '\u0001');
            sb.append(number.substring(0, i)).append(nextChar);
            return sb.toString();
        }
        int value = 0;
        StringBuffer sb = new StringBuffer();
        boolean flag = false;
        while (i >= 0 && number.charAt(i) <= '9' && number.charAt(i) >= '0') {
            value = number.charAt(i) - 48 + 1;
            if (value < 9) {
                sb.append(value);
                flag = false;
                break;
            }
            sb.append("0");
            flag = true;
            --i;
        }
        if (flag) {
            sb.append("1");
        }
        if (i == -1) {
            return sb.reverse().toString();
        }
        return number.substring(0, i) + sb.reverse().toString();
    }
}

