/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.client.PayableBillUpdateStateUI;
import com.kingdee.eas.fm.ntp.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ntp.DraftSignInCollection;
import com.kingdee.eas.fm.ntp.DraftSignInFactory;
import com.kingdee.eas.fm.ntp.DraftSignInInfo;
import com.kingdee.eas.fm.ntp.ElecBackCollection;
import com.kingdee.eas.fm.ntp.ElecBackFactory;
import com.kingdee.eas.fm.ntp.ElecBackInfo;
import com.kingdee.eas.fm.ntp.IDraftSignIn;
import com.kingdee.eas.fm.ntp.OperateStatusEnum;
import com.kingdee.eas.fm.ntp.ReplyOpinionEnum;
import com.kingdee.eas.fm.ntp.client.AbstractDraftSignInEditUI;
import com.kingdee.eas.fm.ntp.client.DraftSignInFrontUI;
import com.kingdee.eas.fm.ntp.client.ElecBackListUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DraftSignInEditUI
extends AbstractDraftSignInEditUI {
    private static final long serialVersionUID = -513949109766137933L;
    private static final Logger logger = CoreUIObject.getLogger(DraftSignInEditUI.class);
    private static String resourcePath = "com.kingdee.eas.fi.cas.RecPayResource";
    Map paramValue = new HashMap();
    private CurrencyInfo currency;

    @Override
    public void loadFields() {
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtoverduePayAmt);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtpayAmt);
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
        this.txtoverduePayAmt.setPrecision(prec);
        this.txtpayAmt.setPrecision(prec);
        super.loadFields();
        this.prmtreply.setData((Object)this.currentCompany);
        if (this.editData.getReplyType() == DraftReplyTypeEnum.YUQITISHIFUKUAN) {
            this.txtoverduePayAmt.setValue((Object)this.editData.getOverduePayAmt());
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TISHIFUKUAN) {
            this.txtpayAmt.setValue((Object)this.editData.getElecDraft().getDraftAmount());
        }
        AccountBankInfo acctBankInfo = (AccountBankInfo)this.prmtreplyAccount.getValue();
        if (null != acctBankInfo && acctBankInfo.isIsSetBankInterface()) {
            this.actionBEbalanceValue.setEnabled(true);
        } else {
            this.actionBEbalanceValue.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getReplyType() == DraftReplyTypeEnum.YUQITISHIFUKUAN) {
            this.editData.setOverduePayAmt(this.txtoverduePayAmt.getBigDecimalValue());
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TISHIFUKUAN) {
            this.editData.setOverduePayAmt(this.txtpayAmt.getBigDecimalValue());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        NTHelper.initAccountBankPromt((KDBizPromptBox)this.prmtreplyAccount);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtreplyBank, (Boolean)new Boolean(true));
        this.chkisTransfer.setEnabled(false);
        this.txtBalance.setHorizontalAlignment(4);
        this.preProcess();
    }

    private void preProcess() throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CS132", null);
        this.paramValue.put("param", param);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("isFirtTime", Boolean.TRUE);
        resultMap.put("ui_name", "DraftSignInEditUI");
        resultMap.put("PermissionItem", null);
        resultMap.put("ID", this.getUIContext().get("ID"));
        resultMap.put("param", (Map)this.paramValue.get("param"));
        if (this.editData != null && this.editData.getCompany() != null) {
            this.currentCompany = this.editData.getCompany();
        }
        resultMap.put("currentCompany", this.currentCompany);
        resultMap.put("oprState", this.getOprtState());
        resultMap = BatchFetchParamFacadeFactory.getRemoteInstance().fetchParam(resultMap);
        this.paramValue.putAll(resultMap);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        boolean isBizUnit = false;
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            isBizUnit = true;
        }
        this.actionEdit.setEnabled(isBizUnit);
        this.actionSubmit.setEnabled(isBizUnit);
        this.actionAudit.setEnabled(isBizUnit);
        this.actionUnAudit.setEnabled(isBizUnit);
        this.actionCommitToBE.setEnabled(isBizUnit);
        this.actionSyncBeStatus.setEnabled(isBizUnit);
        this.actionEditBeStatus.setEnabled(isBizUnit);
        this.actionAgreeSign.setEnabled(isBizUnit);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        DraftSignInInfo info = (DraftSignInInfo)this.getDataObject();
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(false);
        this.actionCommitToBE.setEnabled(false);
        this.actionSyncBeStatus.setEnabled(false);
        this.actionEditBeStatus.setEnabled(false);
        this.actionAgreeSign.setEnabled(false);
        boolean isBizUnit = info.getCompany().isIsBizUnit();
        if (isBizUnit) {
            if (info.getOperateState() == OperateStatusEnum.SAVE) {
                this.actionEdit.setEnabled(this.oprtState == OprtState.VIEW);
                this.actionSave.setEnabled(true);
                if (info.getReplyOpinion() == ReplyOpinionEnum.WAITINGREPLY) {
                    this.actionAgreeSign.setEnabled(true);
                } else {
                    this.actionSubmit.setEnabled(true);
                }
            } else if (info.getOperateState() == OperateStatusEnum.SUBMIT) {
                this.actionEdit.setEnabled(this.oprtState == OprtState.VIEW);
                if (info.getReplyOpinion() != ReplyOpinionEnum.WAITINGREPLY) {
                    this.actionSubmit.setEnabled(true);
                    this.actionAudit.setEnabled(true);
                }
            } else if (info.getOperateState() == OperateStatusEnum.AUDITED) {
                this.actionCommitToBE.setEnabled(true);
                if (EmptyUtil.isEmpty((Object)((Object)info.getTraceDownBillType()))) {
                    this.actionUnAudit.setEnabled(true);
                }
            } else if (info.getOperateState() == OperateStatusEnum.COMMITTOBE) {
                if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) {
                    this.actionCommitToBE.setEnabled(true);
                }
                this.actionSyncBeStatus.setEnabled(true);
                this.actionEditBeStatus.setEnabled(info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION);
            }
        }
        this.initUIStatus();
    }

    private void setBalanceValue(KDTextField txtBalance, AccountViewInfo acctView, AccountBankInfo acctBank, CurrencyInfo currency) throws EASBizException, BOSException {
        if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            txtBalance.setText("");
            return;
        }
        BigDecimal totalBalance = Constants.ZERO;
        String balance = null;
        String strValue = (String)this.paramValue.get("CS132");
        if (acctBank != null && acctBank.isIsSetBankInterface() && !"1".equals(strValue)) {
            String acctBankID = acctBank.getId().toString();
            String currencyID = currency.getId().toString();
            totalBalance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBankID, currencyID);
            totalBalance = totalBalance.setScale(currency.getPrecision(), 4);
            balance = totalBalance.toString() + " (" + EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"175_BE_BALANCE") + ")";
        } else {
            totalBalance = RecPayHelper.getTotalBalance(null, (CompanyOrgUnitInfo)this.currentCompany, (AccountViewInfo)acctView, (AccountBankInfo)acctBank, (CurrencyInfo)currency);
            if (EmptyUtil.isEmpty((Object)totalBalance)) {
                totalBalance = Constants.ZERO;
            }
            totalBalance = totalBalance.setScale(currency.getPrecision(), 4);
            balance = totalBalance.toString() + " (" + EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"174_JOURNAL_BALANCE") + ")";
        }
        if (!EmptyUtil.isEmpty((Object)totalBalance)) {
            txtBalance.setStringValue(balance);
        }
    }

    private void initUIStatus() {
        this.prmtreply.setEnabled(false);
        this.prmtreplyAccount.setEnabled(false);
        this.prmtreplyBank.setEnabled(false);
        this.prmtreplyBankNum.setEnabled(false);
        this.pkreqDate.setEnabled(false);
        this.txtreqRemark.setEnabled(false);
        this.txtreqRemark.setEnabled(false);
        this.txtoverduePayAmt.setEnabled(false);
        this.txtpayAmt.setEnabled(false);
        this.txtoverdueReason.setEnabled(false);
        this.chkacptPrmsUncndPayFlg.setEnabled(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("elecDraft.draftAmount"));
        return sic;
    }

    @Override
    public void onShow() throws Exception {
        this.hiddenAllUI();
        if (this.editData.getReplyType() == DraftReplyTypeEnum.SHOUPIAO || this.editData.getReplyType() == DraftReplyTypeEnum.BEISHU || this.editData.getReplyType() == DraftReplyTypeEnum.ZHIYAJIECHU) {
            this.initLayout_Rec();
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.CHENGDUI) {
            this.initLayout_Acpt();
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TISHIFUKUAN) {
            this.initLayout_Pay();
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.YUQITISHIFUKUAN) {
            this.initLayout_OverDuePay();
        }
        super.onShow();
        this.setBalanceValue();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.pkreplyDate.requestFocusInWindow();
        }
    }

    private void setBalanceValue() throws EASBizException, BOSException {
        AccountBankInfo accBankInfo = (AccountBankInfo)this.prmtreplyAccount.getValue();
        AccountViewInfo settlAccViewInfo = null;
        this.txtBalance.setEnabled(false);
        if (accBankInfo != null) {
            CurrencyInfo ci;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("currency.*"));
            sic.add(new SelectorItemInfo("account.*"));
            accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId()), sic);
            settlAccViewInfo = accBankInfo.getAccount();
            this.currency = ci = accBankInfo.getCurrency();
            this.setBalanceValue(this.txtBalance, settlAccViewInfo, accBankInfo, ci);
        }
    }

    @Override
    public void actionBEbalanceValue_actionPerformed(ActionEvent e) throws Exception {
        String strValue;
        super.actionBEbalanceValue_actionPerformed(e);
        AccountBankInfo acctBank = (AccountBankInfo)this.prmtreplyAccount.getValue();
        if (acctBank == null || EmptyUtil.isEmpty((CoreBaseInfo)acctBank)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"PayerAccountBankCanNotBeNull"));
            SysUtil.abort();
        }
        if (!acctBank.isIsSetBankInterface()) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"PAYERACCTBANK_NOT_BE"));
            SysUtil.abort();
        }
        if ("1".equals(strValue = (String)this.paramValue.get("CS132"))) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CS132_NOT_BE"));
            SysUtil.abort();
        }
        HashMap balanceMap = new HashMap();
        String[] accountBankIds = new String[]{acctBank.getId().toString()};
        Map result = BankFacadeFactory.getRemoteInstance().getBalance(this.currency.getId().toString(), accountBankIds, new Date(), new Date());
        if (!result.get("successCount").equals("1")) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"176_BALANCE_ERROR"), (String)((String)result.get("detailMsg")), (int)1);
            SysUtil.abort();
        }
        BigDecimal currentBalance = PaymentBillFactory.getRemoteInstance().getBalanceValue(acctBank.getId().toString(), this.currency.getId().toString());
        currentBalance = currentBalance.setScale(this.currency.getPrecision(), 4);
        String balance = currentBalance.toString() + " (" + EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"175_BE_BALANCE") + ")";
        if (!EmptyUtil.isEmpty((Object)currentBalance)) {
            this.txtBalance.setStringValue(balance);
        }
    }

    private void initLayout_Acpt() {
        boolean visible = true;
        this.panelReply.setVisible(visible);
        this.panelReply.setBounds(new Rectangle(2, 180, 882, 48));
        this.add((Component)this.panelReply, new KDLayout.Constraints(2, 180, 882, 48, 261));
        this.panelAcceptor.setVisible(visible);
        this.panelAcceptor.setBounds(new Rectangle(2, 232, 882, 74));
        this.add((Component)this.panelAcceptor, new KDLayout.Constraints(2, 232, 882, 74, 261));
        this.contrfuCod.setVisible(visible);
        this.contrfuCod.setBounds(new Rectangle(308, 310, 270, 19));
        this.add((Component)this.contrfuCod, new KDLayout.Constraints(308, 310, 270, 19, 385));
        this.labelreplyRemark.setBounds(new Rectangle(7, 310, 80, 19));
        this.add((Component)this.labelreplyRemark, new KDLayout.Constraints(7, 310, 80, 19, 261));
        this.txtreplyRemark.setBounds(new Rectangle(7, 330, 871, 60));
        this.add((Component)this.txtreplyRemark, new KDLayout.Constraints(7, 330, 871, 60, 261));
        this.contBalance.setBounds(new Rectangle(1311, 310, 583, 19));
        this.add((Component)this.contBalance, new KDLayout.Constraints(1311, 310, 583, 19, 5));
        this.contCreator.setBounds(new Rectangle(7, 410, 270, 19));
        this.add((Component)this.contCreator, new KDLayout.Constraints(7, 410, 270, 19, 261));
        this.contCreateTime.setBounds(new Rectangle(308, 410, 270, 19));
        this.add((Component)this.contCreateTime, new KDLayout.Constraints(308, 410, 270, 19, 385));
        this.contcreateComp.setBounds(new Rectangle(608, 410, 270, 19));
        this.add((Component)this.contcreateComp, new KDLayout.Constraints(608, 410, 270, 19, 137));
    }

    private void initLayout_Rec() {
        boolean visible = true;
        this.contreqDate.setVisible(visible);
        this.chkisTransfer.setVisible(visible);
        this.contreqRemark.setVisible(visible);
        this.btnBEbalanceValue.setVisible(false);
        this.contBalance.setVisible(false);
        this.contreqRemark.setBounds(new Rectangle(7, 208, 871, 19));
        this.add((Component)this.contreqRemark, new KDLayout.Constraints(7, 208, 871, 19, 261));
        this.panelReply.setVisible(visible);
        this.panelReply.setBounds(new Rectangle(2, 238, 882, 48));
        this.add((Component)this.panelReply, new KDLayout.Constraints(2, 238, 882, 48, 261));
        this.contrfuCod.setVisible(visible);
        this.contrfuCod.setBounds(new Rectangle(308, 290, 270, 19));
        this.add((Component)this.contrfuCod, new KDLayout.Constraints(308, 290, 270, 19, 385));
        this.labelreplyRemark.setBounds(new Rectangle(7, 290, 80, 19));
        this.add((Component)this.labelreplyRemark, new KDLayout.Constraints(7, 290, 80, 19, 261));
        this.txtreplyRemark.setBounds(new Rectangle(7, 310, 871, 60));
        this.add((Component)this.txtreplyRemark, new KDLayout.Constraints(7, 310, 871, 60, 261));
        this.contCreator.setBounds(new Rectangle(7, 390, 270, 19));
        this.add((Component)this.contCreator, new KDLayout.Constraints(7, 390, 270, 19, 261));
        this.contCreateTime.setBounds(new Rectangle(308, 390, 270, 19));
        this.add((Component)this.contCreateTime, new KDLayout.Constraints(308, 390, 270, 19, 385));
        this.contcreateComp.setBounds(new Rectangle(608, 390, 270, 19));
        this.add((Component)this.contcreateComp, new KDLayout.Constraints(608, 390, 270, 19, 137));
    }

    private void initLayout_Pay() {
        boolean visible = true;
        this.contreqDate.setVisible(visible);
        this.contpayAmt.setVisible(visible);
        this.contreqRemark.setVisible(visible);
        this.contreqRemark.setBounds(new Rectangle(7, 208, 871, 19));
        this.add((Component)this.contreqRemark, new KDLayout.Constraints(7, 208, 871, 19, 261));
        this.panelReply.setVisible(visible);
        this.panelReply.setBounds(new Rectangle(2, 238, 882, 48));
        this.add((Component)this.panelReply, new KDLayout.Constraints(2, 238, 882, 48, 261));
        this.contrfuCod.setVisible(visible);
        this.contrfuCod.setBounds(new Rectangle(308, 290, 270, 19));
        this.add((Component)this.contrfuCod, new KDLayout.Constraints(308, 290, 270, 19, 385));
        this.labelreplyRemark.setBounds(new Rectangle(7, 290, 80, 19));
        this.add((Component)this.labelreplyRemark, new KDLayout.Constraints(7, 290, 80, 19, 261));
        this.txtreplyRemark.setBounds(new Rectangle(7, 310, 871, 60));
        this.add((Component)this.txtreplyRemark, new KDLayout.Constraints(7, 310, 871, 60, 261));
        this.contCreator.setBounds(new Rectangle(7, 390, 270, 19));
        this.add((Component)this.contCreator, new KDLayout.Constraints(7, 390, 270, 19, 261));
        this.contCreateTime.setBounds(new Rectangle(308, 390, 270, 19));
        this.add((Component)this.contCreateTime, new KDLayout.Constraints(308, 390, 270, 19, 385));
        this.contcreateComp.setBounds(new Rectangle(608, 390, 270, 19));
        this.add((Component)this.contcreateComp, new KDLayout.Constraints(608, 390, 270, 19, 137));
    }

    @Override
    public void actionEndorseView_actionPerformed(ActionEvent e) throws Exception {
        String draftNumber = this.editData.getNumber();
        UIContext ctx = new UIContext((Object)this);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("NoteNo", (Object)draftNumber));
        evi.setFilter(filterInfo);
        CoreBaseCollection coll = ElecBackFactory.getRemoteInstance().getCollection(evi);
        RealModeIDList idList1 = new RealModeIDList();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                ElecBackInfo elecBackInfo = (ElecBackInfo)coll.get(i);
                idList1.add(elecBackInfo.getId().toString());
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"157_NoElecBack"));
            SysUtil.abort();
        }
        ctx.put((Object)"IDList", (Object)idList1);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ElecBackListUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
        uiWindow.getUIObject();
    }

    private void initLayout_OverDuePay() {
        boolean visible = true;
        this.contreqDate.setVisible(visible);
        this.contoverduePayAmt.setVisible(visible);
        this.contoverdueReason.setVisible(visible);
        this.contreqRemark.setVisible(visible);
        this.panelReply.setVisible(visible);
        this.contrfuCod.setVisible(visible);
        this.contrfuCod.setBounds(new Rectangle(308, 315, 270, 19));
        this.add((Component)this.contrfuCod, new KDLayout.Constraints(308, 315, 270, 19, 385));
        this.labelreplyRemark.setBounds(new Rectangle(7, 315, 80, 19));
        this.add((Component)this.labelreplyRemark, new KDLayout.Constraints(7, 315, 80, 19, 261));
        this.txtreplyRemark.setBounds(new Rectangle(7, 335, 871, 60));
        this.add((Component)this.txtreplyRemark, new KDLayout.Constraints(7, 335, 871, 60, 261));
        this.contCreator.setBounds(new Rectangle(7, 415, 270, 19));
        this.add((Component)this.contCreator, new KDLayout.Constraints(7, 415, 270, 19, 261));
        this.contCreateTime.setBounds(new Rectangle(308, 415, 270, 19));
        this.add((Component)this.contCreateTime, new KDLayout.Constraints(308, 415, 270, 19, 385));
        this.contcreateComp.setBounds(new Rectangle(608, 415, 270, 19));
        this.add((Component)this.contcreateComp, new KDLayout.Constraints(608, 415, 270, 19, 137));
    }

    private void hiddenAllUI() {
        boolean visible = false;
        this.contreqDate.setVisible(visible);
        this.chkisTransfer.setVisible(visible);
        this.contoverduePayAmt.setVisible(visible);
        this.contpayAmt.setVisible(visible);
        this.contoverdueReason.setVisible(visible);
        this.contreqRemark.setVisible(visible);
        this.panelReply.setVisible(visible);
        this.panelAcceptor.setVisible(visible);
        this.contrfuCod.setVisible(visible);
    }

    @Override
    protected void replyOpinion_itemStateChanged(ItemEvent e) throws Exception {
        if (this.replyOpinion.getSelectedItem() == null) {
            return;
        }
        ReplyOpinionEnum opinionEnum = (ReplyOpinionEnum)((Object)this.replyOpinion.getSelectedItem());
        boolean required = false;
        required = opinionEnum == ReplyOpinionEnum.REJECT;
        if (ReplyOpinionEnum.SIGN.equals((Object)opinionEnum)) {
            this.chkacptPrmsUncndPayFlg.setSelected(true);
        } else {
            this.chkacptPrmsUncndPayFlg.setSelected(false);
        }
        this.rfuCod.setRequired(required);
        this.txtreplyRemark.setRequired(required);
        if (this.editData.getOperateState() == OperateStatusEnum.SAVE) {
            if (opinionEnum == ReplyOpinionEnum.WAITINGREPLY) {
                this.actionSubmit.setEnabled(false);
                this.actionAgreeSign.setEnabled(true);
            } else {
                this.actionSubmit.setEnabled(true);
                this.actionAgreeSign.setEnabled(false);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.editData.getReplyType() == DraftReplyTypeEnum.YUQITISHIFUKUAN) {
            ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtoverduePayAmt);
        } else if (this.editData.getReplyType() == DraftReplyTypeEnum.TISHIFUKUAN) {
            ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtpayAmt);
        }
        if (this.txtreplyRemark.isRequired() && this.txtreplyRemark.getText().length() >= 256) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"remarkBeyond"));
            this.txtreplyRemark.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionDraftView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        DraftSignInInfo info = DraftSignInFactory.getRemoteInstance().getDraftSignInInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        uiContext.put((Object)"ID", (Object)info.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftSignInFrontUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isBack;
        this.editData.setOperateState(OperateStatusEnum.SUBMIT);
        if (this.replyOpinion.getSelectedItem() == ReplyOpinionEnum.WAITINGREPLY) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"NotSubmit"));
            SysUtil.abort();
        }
        if (this.replyOpinion.getSelectedItem() == ReplyOpinionEnum.SIGN && (isBack = this.checkIsBack(this.editData)) && MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"186_DraftSignIn"), (String)(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"188_DraftSignIn") + "\n" + this.editData.getNumber())) != 0) {
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    private boolean checkIsBack(DraftSignInInfo info) throws Exception {
        boolean isBack = false;
        EntityViewInfo dEvi = new EntityViewInfo();
        FilterInfo dFilterInfo = new FilterInfo();
        dFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
        dEvi.setFilter(dFilterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("reply.name"));
        dEvi.setSelector(sic);
        DraftSignInCollection colls = DraftSignInFactory.getRemoteInstance().getDraftSignInCollection(dEvi);
        DraftSignInInfo draftSignInInfo = colls.get(0);
        if (draftSignInInfo.isIsBack()) {
            isBack = true;
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("NoteNo", (Object)draftSignInInfo.getNumber()));
            evi.setFilter(filterInfo);
            ElecBackCollection coll = ElecBackFactory.getRemoteInstance().getElecBackCollection(evi);
            if (coll.size() > 0) {
                HashSet<String> initiatorNameSet = new HashSet<String>();
                initiatorNameSet.add(info.getReply().getName());
                for (int a = 0; a < coll.size(); ++a) {
                    ElecBackInfo elecBackInfo = coll.get(a);
                    if (elecBackInfo.getBusinessCode().equals(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"168_ElecBack")) && initiatorNameSet.contains(elecBackInfo.getInitiatorName())) {
                        isBack = true;
                        continue;
                    }
                    initiatorNameSet.add(elecBackInfo.getInitiatorName());
                }
            }
        }
        return isBack;
    }

    @Override
    public void actionAgreeSign_actionPerformed(ActionEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.editData.getId())) {
            return;
        }
        boolean isBack = this.checkIsBack(this.editData);
        if (isBack && MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"186_DraftSignIn"), (String)(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"188_DraftSignIn") + "\n" + this.editData.getNumber())) != 0) {
            SysUtil.abort();
        }
        String id = this.editData.getId().toString();
        IDraftSignIn iSignIn = DraftSignInFactory.getRemoteInstance();
        try {
            iSignIn.sign((IObjectPK)new ObjectUuidPK(id));
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)ex.getMessage());
            SysUtil.abort();
        }
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.showSucessMsg(e);
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(true);
        this.actionAgreeSign.setEnabled(false);
        this.actionAudit.setEnabled(true);
        this.actionUnAudit.setEnabled(false);
        this.actionCommitToBE.setEnabled(false);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (String)this.editData.getId().toString());
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            DraftSignInFactory.getRemoteInstance().audit(idSet);
        }
        this.showSucessMsg(e);
        this.actionSubmit.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(true);
        this.actionCommitToBE.setEnabled(true);
        this.replyOpinion.setEnabled(false);
    }

    private void showSucessMsg(ActionEvent e) {
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)component);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        DraftSignInFactory.getRemoteInstance().unAudit(idSet);
        this.showSucessMsg(e);
        this.actionSubmit.setEnabled(true);
        this.actionUnAudit.setEnabled(false);
        this.actionCommitToBE.setEnabled(false);
        this.replyOpinion.setEnabled(true);
    }

    @Override
    public void actionCommitToBE_actionPerformed(ActionEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.editData.getId())) {
            return;
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
        IDraftSignIn iSignIn = DraftSignInFactory.getRemoteInstance();
        try {
            iSignIn.commitToBE((IObjectPK)pk);
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)ex.getMessage());
            SysUtil.abort();
        }
        FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        this.actionUnAudit.setEnabled(false);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        DraftSignInInfo info = iSignIn.getDraftSignInInfo((IObjectPK)pk, sic);
        if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) {
            this.actionCommitToBE.setEnabled(true);
        } else {
            this.actionCommitToBE.setEnabled(false);
        }
        this.actionSyncBeStatus.setEnabled(true);
        this.actionEditBeStatus.setEnabled(info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION);
    }

    @Override
    public void actionSyncBeStatus_actionPerformed(ActionEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.editData.getId())) {
            return;
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
        IDraftSignIn iSignIn = DraftSignInFactory.getRemoteInstance();
        try {
            iSignIn.syncBeStatus((IObjectPK)pk);
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)ex.getMessage());
            SysUtil.abort();
        }
        FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        DraftSignInInfo info = iSignIn.getDraftSignInInfo((IObjectPK)pk, sic);
        if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) {
            this.actionCommitToBE.setEnabled(true);
        } else {
            this.actionCommitToBE.setEnabled(false);
        }
        this.actionSyncBeStatus.setEnabled(true);
        this.actionEditBeStatus.setEnabled(info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION);
    }

    @Override
    public void actionEditBeStatus_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
        IDraftSignIn iSignIn = DraftSignInFactory.getRemoteInstance();
        DraftSignInInfo info = iSignIn.getDraftSignInInfo((IObjectPK)pk);
        if (info.getOperateState() == OperateStatusEnum.COMMITTOBE && info.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"072_CANNOT_UPDATESTATUS"));
            SysUtil.abort();
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        String uiName = PayableBillUpdateStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        BankReturnStatusEnum updateStatus = ((PayableBillUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (updateStatus == null) {
            return;
        }
        if (updateStatus == BankReturnStatusEnum.BANK_FAIL && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"41_BankAgentPayBillListUI"))) == 2) {
            SysUtil.abort();
        }
        iSignIn.updateBeStatus((IObjectPK)pk, updateStatus);
        FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        info = iSignIn.getDraftSignInInfo((IObjectPK)pk, sic);
        if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) {
            this.actionCommitToBE.setEnabled(true);
        } else {
            this.actionCommitToBE.setEnabled(false);
        }
        this.actionSyncBeStatus.setEnabled(true);
        this.actionEditBeStatus.setEnabled(info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION);
    }
}

