/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.ntp.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ntp.OperateStatusEnum;
import com.kingdee.eas.fm.ntp.client.AbstractDraftSignInFilterUI;
import com.kingdee.eas.fm.ntp.client.DraftSignInFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class DraftSignInFilterUI
extends AbstractDraftSignInFilterUI {
    private static final long serialVersionUID = -2205776413295239609L;
    private static final Logger logger = CoreUIObject.getLogger(DraftSignInFilterUI.class);
    private String bizType;

    public DraftSignInFilterUI() throws Exception {
    }

    public DraftSignInFilterUI(String bizType) throws Exception {
        this.bizType = bizType;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.cmbreplyType.removeAllItems();
        this.cmbreplyType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        if (this.bizType != null && this.bizType.equals("REC")) {
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.SHOUPIAO);
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.BEISHU);
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.ZHIYAJIECHU);
        } else if (this.bizType != null && this.bizType.equals("PAY")) {
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.CHENGDUI);
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.TISHIFUKUAN);
            this.cmbreplyType.addItem((Object)DraftReplyTypeEnum.YUQITISHIFUKUAN);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -19);
        Date fromDate = cal.getTime();
        this.pkreplyDateFrom.setValue((Object)fromDate);
        this.pkreplyDateTo.setValue((Object)new Date());
        this.cmboperateState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        CompanyOrgUnitInfo companyif = SysContext.getSysContext().getCurrentFIUnit();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyif)) {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
        this.cmbreplyType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmboperateState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    @Override
    protected void rdbIsOnline_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdbIsOnline.isSelected()) {
            this.rdbIsOffline.setSelected(false);
            this.cmbreplyType.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
            if (this.bizType.equals("REC")) {
                this.cmbreplyType.setSelectedItem((Object)DraftReplyTypeEnum.SHOUPIAO);
            } else if (this.bizType.equals("PAY")) {
                this.cmbreplyType.setSelectedItem((Object)DraftReplyTypeEnum.CHENGDUI);
            }
        } else {
            this.rdbIsOnline.setSelected(false);
            this.cmbreplyType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            FMClientHelper.setSelectObject((KDComboBox)this.cmbreplyType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    public Object getParam() {
        DraftSignInFilterParam param = new DraftSignInFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.bizType != null) {
            param.setBizType(this.bizType);
        }
        if (this.cmbreplyType.getSelectedItem() != null) {
            if (this.cmbreplyType.getSelectedItem() instanceof DraftReplyTypeEnum) {
                param.setReplyType(((DraftReplyTypeEnum)((Object)this.cmbreplyType.getSelectedItem())).getValue());
            } else {
                param.setReplyType(-1);
            }
        }
        param.setReplyDateFrom((Date)this.pkreplyDateFrom.getValue());
        param.setReplyDateTo((Date)this.pkreplyDateTo.getValue());
        if (this.cmboperateState.getSelectedItem() != null) {
            if (this.cmboperateState.getSelectedItem() instanceof OperateStatusEnum) {
                param.setOperateState(((OperateStatusEnum)((Object)this.cmboperateState.getSelectedItem())).getValue());
            } else {
                param.setOperateState(-1);
            }
        }
        if (this.rdbIsOnline.isSelected()) {
            param.setIsOnLine(true);
        } else {
            param.setIsOnLine(false);
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        DraftSignInFilterParam filterParam = (DraftSignInFilterParam)((Object)param);
        DraftReplyTypeEnum replyType = DraftReplyTypeEnum.getEnum(filterParam.getReplyType());
        if (replyType == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbreplyType, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbreplyType, (Object)((Object)replyType));
        }
        this.pkreplyDateFrom.setValue((Object)filterParam.getReplyDateFrom());
        this.pkreplyDateTo.setValue((Object)filterParam.getReplyDateTo());
        OperateStatusEnum operateState = OperateStatusEnum.getEnum(filterParam.getOperateState());
        if (operateState == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmboperateState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmboperateState, (Object)((Object)operateState));
        }
        if (filterParam.isIsOnLine()) {
            this.rdbIsOnline.setSelected(true);
        } else {
            this.rdbIsOnline.setSelected(false);
        }
    }

    public boolean verify() {
        long diff;
        int days;
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkreplyDateFrom);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkreplyDateTo);
        Date fromDate = (Date)this.pkreplyDateFrom.getValue();
        Date toDate = (Date)this.pkreplyDateTo.getValue();
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)fromDate, (Date)toDate);
        if (this.rdbIsOnline.isSelected() && (days = (int)(diff = (toDate.getTime() - fromDate.getTime()) / 86400000L) + 1) > 20) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"draftSignIn_comDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        this.cmbreplyType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getDayBegin());
        ((Calendar)cal).add(5, -19);
        Date fromDate = cal.getTime();
        this.pkreplyDateFrom.setValue((Object)fromDate);
        this.pkreplyDateTo.setValue((Object)new Date());
        this.cmboperateState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected Class getParamClass() {
        return DraftSignInFilterParam.class;
    }
}

