/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.ntp.ElecDraftInfo;
import com.kingdee.eas.fm.ntp.client.AbstractDraftSignInFrontUI;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DraftSignInFrontUI
extends AbstractDraftSignInFrontUI {
    private static final long serialVersionUID = 1803133935749814401L;
    private static final Logger logger = CoreUIObject.getLogger(DraftSignInFrontUI.class);

    @Override
    public void loadFields() {
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftTime);
        this.txtdraftTime.setPrecision(1);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftAmount);
        this.txtdraftAmount.setPrecision(2);
        super.loadFields();
        this.draftMedium.setSelectedItem((Object)BillMediumEnum.ELECTRONIC);
        this.chkisAcceptor.setSelected(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAuditResult.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    private void initData() throws EASBizException, BOSException {
        ElecDraftInfo draftInfo = this.editData.getElecDraft();
        this.prmtdrawerName.setText(draftInfo.getDrawerName());
        this.prmtdrawerAccount.setText(draftInfo.getDrawerAccountNumber());
        if (!EmptyUtil.isEmpty((String)draftInfo.getDrawerBankName())) {
            this.prmtdrawerBank.setText(draftInfo.getDrawerBankName());
        } else {
            this.prmtdrawerBank.setData((Object)this.findBankInfoByAccount(draftInfo.getDrawerAccountNumber()));
        }
        this.prmtdrawerBankNumber.setText(draftInfo.getDrawerBankNumber());
        this.prmtpayeeName.setText(draftInfo.getPayeeName());
        this.prmtpayAccount.setText(draftInfo.getPayeeAccountNumber());
        if (!EmptyUtil.isEmpty((String)draftInfo.getPayeeBankName())) {
            this.prmtpayeeBank.setText(draftInfo.getPayeeBankName());
        } else {
            this.prmtpayeeBank.setData((Object)this.findBankInfoByAccount(draftInfo.getPayeeAccountNumber()));
        }
        this.prmtpayeeBankNumber.setText(draftInfo.getPayeeBankNumber());
        this.txtdraftAmountToUpper.setText(GlUtils.getChineseFormat((BigDecimal)draftInfo.getDraftAmount(), (boolean)true, (Locale)SysContext.getSysContext().getLocale()));
        this.prmtaccpetorBank.setText(draftInfo.getAcceptorName());
        this.prmtaccpetorAccount.setText(draftInfo.getAcceptorAccountNumber());
        this.prmtaccpetorBankName.setText(draftInfo.getAcceptorBankName());
        this.prmtaccpetorBankNumber.setText(draftInfo.getAcceptorBankNumber());
        this.pkIssueDate.setValue((Object)draftInfo.getIssueDate());
        this.pkacceptorDate.setValue((Object)draftInfo.getIssueDate());
        this.combSettleMethod.setSelectedItem((Object)draftInfo.getSettleMethod());
    }

    private BankInfo findBankInfoByAccount(String BankAccount) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)BankAccount));
        ev.setFilter(filter);
        AccountBankCollection accountBank = AccountBankFactory.getRemoteInstance().getAccountBankCollection(ev);
        if (accountBank.size() > 0) {
            String id = accountBank.get(0).getBank().getId().toString();
            BankInfo info = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(id));
            return info;
        }
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("elecDraft.drawerName"));
        selectors.add(new SelectorItemInfo("elecDraft.drawerAccountNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.drawerBankName"));
        selectors.add(new SelectorItemInfo("elecDraft.drawerBankNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.payeeName"));
        selectors.add(new SelectorItemInfo("elecDraft.payeeAccountNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.payeeBankName"));
        selectors.add(new SelectorItemInfo("elecDraft.payeeBankNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.acceptorName"));
        selectors.add(new SelectorItemInfo("elecDraft.acceptorAccountNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.acceptorBankName"));
        selectors.add(new SelectorItemInfo("elecDraft.acceptorBankNumber"));
        selectors.add(new SelectorItemInfo("elecDraft.settleMethod"));
        return selectors;
    }

    private BigDecimal getHorizon(KDDatePicker dpBegin, KDDatePicker dpEnd) {
        if (dpBegin == null || dpEnd == null) {
            return Constants.ZERO;
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)dpBegin.getSqlDate());
        Date endDate = DateTimeUtils.truncateDate((Date)dpEnd.getSqlDate());
        BigDecimal months = new BigDecimal("0");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(beginDate);
        BigDecimal year1 = new BigDecimal(String.valueOf(c1.get(1)));
        BigDecimal month1 = new BigDecimal(String.valueOf(c1.get(2)));
        BigDecimal day1 = new BigDecimal(String.valueOf(c1.get(5)));
        Calendar c2 = Calendar.getInstance();
        c2.setTime(endDate);
        BigDecimal year2 = new BigDecimal(String.valueOf(c2.get(1)));
        BigDecimal month2 = new BigDecimal(String.valueOf(c2.get(2)));
        BigDecimal day2 = new BigDecimal(String.valueOf(c2.get(5)));
        BigDecimal begainDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year1.intValue(), (int)(month1.intValue() + 1))));
        BigDecimal endDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year2.intValue(), (int)(month2.intValue() + 1))));
        if (beginDate.getTime() < endDate.getTime()) {
            if (day2.equals(day1) && begainDaysOfMonth.compareTo(endDaysOfMonth) > 0) {
                months = year2.subtract(year1).multiply(new BigDecimal("12"));
                months = months.add(month2.subtract(month1));
            } else {
                months = FinHorizon.getHorizon((Date)beginDate, (Date)endDate);
            }
        }
        return months;
    }
}

