/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.PledgeBillEntryInfo;
import com.kingdee.eas.fm.ntp.PledgeBillFactory;
import com.kingdee.eas.fm.ntp.PledgeBillInfo;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.PledgeTypeEnum;
import com.kingdee.eas.fm.ntp.client.AbstractPledgeBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class PledgeBillEditUI
extends AbstractPledgeBillEditUI {
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private static final Logger logger = CoreUIObject.getLogger(PledgeBillEditUI.class);
    private IObjectCollection receivableCol = null;
    private PledgeBillInfo info = null;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void onShow() throws Exception {
        this.btnAttachment.setVisible(false);
    }

    protected void initWorkButton() {
        this.btnAddNew.setVisible(false);
        this.btnCloud.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnXunTong.setVisible(false);
        this.btnReset.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnSignature.setVisible(false);
        this.btnViewSignature.setVisible(false);
        this.btnNumberSign.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.toolBar.remove((Component)this.btnAuditResult);
        this.btnMultiapprove.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnSave.setVisible(false);
        this.kdtEntrys.getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("currency").getStyleAttributes().setHided(true);
        this.kdtEntrys.getColumn("billAmt").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setVisible(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
        this.txtamount.setHorizontalAlignment(4);
        this.kdtEntrys.setVisible(true);
        super.initWorkButton();
    }

    @Override
    protected IObjectValue createNewData() {
        PledgeBillInfo objectValue = new PledgeBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        SysContext ctx = SysContext.getSysContext();
        Map map = this.getUIContext();
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        this.info = new PledgeBillInfo();
        this.info.setPledgeType(PledgeTypeEnum.INPOOL);
        this.info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        this.info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        this.info.setCreateCompany(ctx.getSysContext().getCurrentFIUnit());
        this.info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        this.info.setAuditor(ctx.getSysContext().getCurrentUserInfo());
        this.prmtcreateCompany.setEnabled(false);
        this.receivableCol = (IObjectCollection)this.getUIContext().get("receivableColl");
        ReceivableBillInfo receivableInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
        this.info.setBillStatus(PledgeBillStatusEnum.SUBMIT);
        this.info.setBillMedium(receivableInfo.getBillMedium());
        this.info.setCount(this.receivableCol.size());
        this.info.setCurrency(receivableInfo.getCurrency());
        this.info.setNtType(receivableInfo.getNtType());
        this.billMedium.setEnabled(false);
        this.billMedium.setSelectedItem((Object)receivableInfo.getBillMedium(), false);
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(receivableInfo.getCurrency().getId()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        this.txtamount.setPrecision(currencyInfo.getPrecision());
        this.txtamount.setRemoveingZeroInDispaly(false);
        this.txtamount.setEnabled(false);
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < this.receivableCol.size(); ++i) {
            ReceivableBillInfo receivableInfo2 = (ReceivableBillInfo)this.receivableCol.getObject(i);
            PledgeBillEntryInfo billEntryInfo = new PledgeBillEntryInfo();
            billEntryInfo.setDraftNumber(receivableInfo2.getDraftNumber());
            billEntryInfo.setBillMedium(receivableInfo2.getBillMedium());
            billEntryInfo.setNtType(receivableInfo2.getNtType());
            billEntryInfo.setBillAmt(receivableInfo2.getBillAmt());
            billEntryInfo.setIssuesDate(receivableInfo2.getIssuesDate());
            billEntryInfo.setExpiredDate(receivableInfo2.getExpiredDate());
            billEntryInfo.setAcceptance(receivableInfo2.getAcceptorName());
            billEntryInfo.setCurrency(receivableInfo2.getCurrency());
            billEntryInfo.setReceivableBill(receivableInfo2);
            try {
                if (receivableInfo2.getDrawer() != null) {
                    billEntryInfo.setDrawer(CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(receivableInfo2.getDrawer().getId())));
                } else {
                    CustomerInfo cusInfo = new CustomerInfo();
                    cusInfo.setName(receivableInfo2.getDrawerName());
                    billEntryInfo.setDrawer(cusInfo);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (i == 0) {
                totalAmount = receivableInfo2.getBillAmt();
            } else if (receivableInfo2.getBillAmt() != null) {
                totalAmount = totalAmount.add(receivableInfo2.getBillAmt());
            }
            this.info.setAmount(totalAmount);
            this.info.getEntrys().add(billEntryInfo);
        }
        return this.info;
    }

    public void onLoad() throws Exception {
        PledgeBillInfo info;
        super.onLoad();
        this.prmtpledgee.setRequired(true);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtpledgee.setEntityViewInfo(evi);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtpledgee, (Boolean)new Boolean(true));
        if (this.getOprtState().equals(OprtState.VIEW) && (info = PledgeBillFactory.getRemoteInstance().getPledgeBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()))).getPledgeType() != null && info.getPledgeType() == PledgeTypeEnum.OUTPOOL) {
            this.kDLabelContainer1.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"pledgeRemoveDate"));
        }
        this.kDDatePledgeDate.setValue((Object)new Date());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setPledgeDate(this.kDDatePledgeDate.getSqlDate());
        this.verifyInput(e);
        if (this.getBizInterface().exists("where number = '" + this.txtNumber.getText() + "'")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"009_NUMBER_DUPLICATE"));
            SysUtil.abort();
        }
        this.storeFields();
        PledgeBillInfo info = this.editData;
        IObjectPK pk = PledgeBillFactory.getRemoteInstance().submit((CoreBaseInfo)info);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        if (!EmptyUtil.isEmpty((Object)this.receivableCol)) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < this.receivableCol.size(); ++i) {
                iMutex.releaseObjIDForUpdate(((ReceivableBillInfo)this.receivableCol.getObject(i)).getId().toString());
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtpledgee);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDDatePledgeDate);
        this.verifyPledgeDate(this.receivableCol, this.editData.getPledgeDate());
    }

    private void verifyPledgeDate(IObjectCollection receivableCol, Date pledgeDate) {
        ReceivableBillCollection coll = (ReceivableBillCollection)receivableCol;
        ReceivableBillInfo info = null;
        Date miniDate = null;
        Date maxDate = null;
        if (coll.size() < 1) {
            return;
        }
        if (coll.size() == 1) {
            info = coll.get(0);
            miniDate = info.getIssuesDate();
            maxDate = info.getExpiredDate();
            if (pledgeDate.before(miniDate) || pledgeDate.after(maxDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"checkPledgeDate", (Object[])new String[]{DATE_FORMAT.format(miniDate), DATE_FORMAT.format(maxDate)}));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (i == 0) {
                    miniDate = info.getIssuesDate();
                    maxDate = info.getExpiredDate();
                    continue;
                }
                if (info.getIssuesDate().after(miniDate)) {
                    miniDate = info.getIssuesDate();
                }
                if (!info.getExpiredDate().before(maxDate)) continue;
                maxDate = info.getExpiredDate();
            }
            if (pledgeDate.before(miniDate) || pledgeDate.after(maxDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"checkPledgeDate1", (Object[])new String[]{DATE_FORMAT.format(miniDate), DATE_FORMAT.format(maxDate)}));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PledgeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }
}

