/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.TrusteeInBillFactory;
import com.kingdee.eas.fm.ntp.TrusteeInBillInfo;
import com.kingdee.eas.fm.ntp.client.AbstractTrusteeInBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TrusteeInBillEditUI
extends AbstractTrusteeInBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrusteeInBillEditUI.class);
    private IObjectCollection receivableCol = null;
    private CompanyOrgUnitInfo curCompany = null;
    private CurrencyInfo curCurrency = null;
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private TrusteeInBillInfo trusteeInBill = null;
    private int curCurrencyPrecision = 2;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public TrusteeInBillEditUI() throws Exception {
        this.curCompany = this.contextHelper.getCurrentCompany();
    }

    public void onLoad() throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            super.onLoad();
            String id = this.editData.getId().toString();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("receivableEntrys.draftNumber");
            selector.add("receivableEntrys.id");
            selector.add("receivableEntrys.ntType.id");
            selector.add("receivableEntrys.billState");
            selector.add("receivableEntrys.billMedium");
            selector.add(new SelectorItemInfo("receivableEntrys.ntType.name"));
            selector.add(new SelectorItemInfo("receivableEntrys.billAmt"));
            selector.add(new SelectorItemInfo("receivableEntrys.issuesDate"));
            selector.add(new SelectorItemInfo("receivableEntrys.expiredDate"));
            selector.add(new SelectorItemInfo("receivableEntrys.drawerName"));
            selector.add(new SelectorItemInfo("receivableEntrys.acceptorName"));
            selector.add(new SelectorItemInfo("receivableEntrys.holder.name"));
            selector.add(new SelectorItemInfo("receivableEntrys.currency.precision"));
            TrusteeInBillInfo info = TrusteeInBillFactory.getRemoteInstance().getTrusteeInBillInfo((IObjectPK)new ObjectUuidPK(id), selector);
            this.receivableCol = info.getReceivableEntrys();
            this.fillTable(this.receivableCol);
            this.menuBar.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.btnAttachment.setVisible(false);
            this.btnPageSetup.setVisible(false);
            this.toolBar.setVisible(false);
        } else {
            this.receivableCol = (IObjectCollection)this.getUIContext().get("receivableColl");
            super.onLoad();
            this.tblMain.getSelectManager().setSelectMode(2);
            this.setCurCurrencyPrecision();
            this.initUI();
            this.fillTable(this.receivableCol);
        }
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmttrustee, (Boolean)new Boolean(true));
    }

    private void initUI() {
        if (this.receivableCol == null || this.receivableCol.size() == 0) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < this.receivableCol.size(); ++i) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(i);
            totalAmount = totalAmount.add(billInfo.getBillAmt());
        }
        this.txttotalAmout.setValue((Object)totalAmount);
        this.txttotalAmout.setPrecision(this.curCurrencyPrecision);
        this.txttotalAmout.setRemoveingZeroInDispaly(false);
        this.txttotalAmout.setEnabled(false);
        this.pktrusteeDate.setValue((Object)new Date());
        this.kDDateCreateTime.setDatePattern(FMHelper.getDateFormatString());
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
    }

    private void setCurCurrencyPrecision() {
        if (this.receivableCol == null || this.receivableCol.size() == 0) {
            return;
        }
        ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
        this.curCurrencyPrecision = billInfo.getCurrency().getPrecision();
        this.curCurrency = billInfo.getCurrency();
    }

    private void fillTable(IObjectCollection coll) throws EASBizException, BOSException {
        String numberFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.curCurrencyPrecision);
        this.tblMain.getColumn("billAmt").getStyleAttributes().setNumberFormat(numberFormat_AMT);
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        if (coll == null) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setTrusteeDate(this.pktrusteeDate.getSqlDate());
        this.verifyInput(e);
        if (this.getBizInterface().exists("where number = '" + this.txtNumber.getText() + "'")) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"009_NUMBER_DUPLICATE"));
            SysUtil.abort();
        }
        this.storeFields();
        TrusteeInBillInfo info = this.editData;
        info.setCurrency(this.curCurrency);
        info.setBillState(PledgeBillStatusEnum.SUBMIT);
        info.setCount(this.receivableCol.size());
        ReceivableBillInfo recInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
        info.setNtType(recInfo.getNtType());
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("id") == null) continue;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("draftNumber");
            selector.add("holder.id");
            selector.add("trusteeInBill.id");
            selector.add("trusteeOutBill.id");
            ReceivableBillInfo receivableInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()), selector);
            if (receivableInfo == null) continue;
            info.getReceivableEntrys().add(receivableInfo);
        }
        this.getBizInterface().submit((CoreBaseInfo)info);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        boolean b;
        if (!EmptyUtil.isEmpty((Object)this.receivableCol)) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < this.receivableCol.size(); ++i) {
                iMutex.releaseObjIDForUpdate(((ReceivableBillInfo)this.receivableCol.getObject(i)).getId().toString());
            }
        }
        if (b = true) {
            super.disposeUIWindow();
        }
        return b;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pktrusteeDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmttrustee);
        this.verifyTrusteeDate(this.receivableCol, this.editData.getTrusteeDate());
    }

    private void verifyTrusteeDate(IObjectCollection receivableCol, Date trusteeDate) {
        ReceivableBillCollection coll = (ReceivableBillCollection)receivableCol;
        ReceivableBillInfo info = null;
        Date miniDate = null;
        Date maxDate = null;
        if (coll.size() < 1) {
            return;
        }
        if (coll.size() == 1) {
            info = coll.get(0);
            miniDate = info.getIssuesDate();
            maxDate = info.getExpiredDate();
            if (trusteeDate.before(miniDate) || trusteeDate.after(maxDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"checkTrusteeDate", (Object[])new String[]{DATE_FORMAT.format(miniDate), DATE_FORMAT.format(maxDate)}));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (i == 0) {
                    miniDate = info.getIssuesDate();
                    maxDate = info.getExpiredDate();
                    continue;
                }
                if (info.getIssuesDate().after(miniDate)) {
                    miniDate = info.getIssuesDate();
                }
                if (!info.getExpiredDate().before(maxDate)) continue;
                maxDate = info.getExpiredDate();
            }
            if (trusteeDate.before(miniDate) || trusteeDate.after(maxDate)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"checkTrusteeDate1", (Object[])new String[]{DATE_FORMAT.format(miniDate), DATE_FORMAT.format(maxDate)}));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TrusteeInBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        this.trusteeInBill = new TrusteeInBillInfo();
        this.trusteeInBill.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        this.trusteeInBill.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        this.trusteeInBill.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.trusteeInBill;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }
}

