/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.ps.DecomposeBillEntryInfo;
import com.kingdee.eas.fm.ps.DecomposeBillInfo;
import com.kingdee.eas.fm.ps.DimensionInfo;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryInfo;
import com.kingdee.eas.fm.ps.PayPlanSumaryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumaryInfo;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingCollection;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingFactory;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingCollection;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingInfo;
import com.kingdee.eas.fm.ps.SummaryDimensionSettingCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PSUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.utils.PSUtils");
    private static final String webResourcePath = "com.kingdee.eas.fm.ps.PsResource";
    public static final String AUTO_SCHEDULE_RULE_DEFLT_ID = "9Updm/V1TPiN3jWhBrLQbtL/X/A=";

    public static void verifyOrgAdjust(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)company)) {
            throw new RuntimeException(PSUtils.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
        }
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)webResourcePath, (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    public static boolean isInWorkFlow(Context ctx, String selectId) {
        try {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
            return procInsts != null && procInsts.length != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean requestMutexLock(Context ctx, String selectId) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(selectId);
    }

    public static boolean releaseMutexLock(Context ctx, String selectId) throws BOSException {
        MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(selectId);
        return true;
    }

    public static List<SettlementCategoryInfo> getSettleCategoryList(Context ctx, String cuId) throws BOSException, EASBizException {
        ArrayList<SettlementCategoryInfo> list = new ArrayList<SettlementCategoryInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isBySettleType"));
        sic.add(new SelectorItemInfo("settlePriorityEntrys.category.id"));
        sic.add(new SelectorItemInfo("settlePriorityEntrys.category.name"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)now, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("settlePriorityEntrys.priority"));
        view.setSorter(sort);
        PaymentScheduleSettingCollection colls = PaymentScheduleSettingFactory.getLocalInstance(ctx).getPaymentScheduleSettingCollection(view);
        logger.error((Object)("CUID=" + cuId + ",effectiveDate=" + now));
        if (colls != null && colls.size() > 0) {
            logger.error((Object)("size=" + colls.size()));
            PaymentScheduleSettingInfo scheduleInfo = colls.get(0);
            if (((Boolean)scheduleInfo.get("isBySettleType")).booleanValue()) {
                logger.error((Object)"isBySettleType=true");
                SettlementPrioritySettingCollection settleColls = colls.get(0).getSettlePriorityEntrys();
                if (settleColls != null && settleColls.size() > 0) {
                    for (int i = 0; i < settleColls.size(); ++i) {
                        list.add(settleColls.get(i).getCategory());
                    }
                    return list;
                }
                return null;
            }
            logger.error((Object)"isBySettleType=false");
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
        if (company != null && company.getParent() != null) {
            PSUtils.getSettleCategoryList(ctx, company.getParent().getId().toString());
        }
        throw new BOSException(PSUtils.getResource(ctx, "136_NO_SCHEDULE", null));
    }

    public static List<DimensionInfo> getSummaryDimensionList(Context ctx, String cuId) throws BOSException, EASBizException {
        ArrayList<DimensionInfo> list = new ArrayList<DimensionInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("summaryDimensionEntrys.dimension.id"));
        sic.add(new SelectorItemInfo("summaryDimensionEntrys.dimension.name"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("summaryDimensionEntrys.isGrounpSummary", (Object)true));
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)now, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("summaryDimensionEntrys.priority"));
        view.setSorter(sort);
        PaymentScheduleSettingCollection colls = PaymentScheduleSettingFactory.getLocalInstance(ctx).getPaymentScheduleSettingCollection(view);
        if (colls != null && colls.size() > 0) {
            SummaryDimensionSettingCollection dimensionColls = colls.get(0).getSummaryDimensionEntrys();
            if (dimensionColls != null && dimensionColls.size() > 0) {
                for (int i = 0; i < dimensionColls.size(); ++i) {
                    list.add(dimensionColls.get(i).getDimension());
                }
            }
            return list;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
        if (company != null && company.getParent() != null) {
            PSUtils.getSummaryDimensionList(ctx, company.getParent().getId().toString());
        }
        throw new BOSException(PSUtils.getResource(ctx, "136_NO_SCHEDULE", null));
    }

    public static List<String> listId2List(List<PayPlanSumaryInfo> infoList) {
        ArrayList<String> idList = new ArrayList<String>();
        for (PayPlanSumaryInfo info : infoList) {
            idList.add(info.getId().toString());
        }
        return idList;
    }

    public static String initNumber(Context ctx, BillBaseInfo info, String companyId) throws BOSException {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            number = codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    public static String idListToInClause(List<String> idList) {
        StringBuffer sb = new StringBuffer();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append("'" + idList.get(0) + "'");
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append("'" + it.next() + "'").append(", ");
            }
            sb.append("'" + it.next() + "'");
        }
        return sb.toString();
    }

    public static List<String> getSumDemList(Context ctx, String cuId) throws BOSException, EASBizException {
        ArrayList<String> demList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  dim.FPayPlanColumnName as payPlanColumnNmae  FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" INNER JOIN T_PS_SummaryDimensionSetting sumdiemSetting  ON sumdiemSetting.FPaymentScheduleSettingID = setting.FID");
        sql.append(" INNER JOIN T_PS_DIMENSION dim  ON dim.FID = sumdiemSetting.FDimensionID  ");
        sql.append(" WHERE setting.FControlUnitID = '" + cuId + "'");
        sql.append(" AND sumdiemSetting.FIsGrounpSummary = 1  ");
        sql.append("  order by sumdiemSetting.FPriority");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null) {
                while (rs.next()) {
                    demList.add(rs.getString("payPlanColumnNmae"));
                }
                return demList;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("parent.id"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
            if (company != null && company.getParent() != null) {
                PSUtils.getSumDemList(ctx, company.getParent().getId().toString());
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return demList;
    }

    public static PaymentScheduleSettingInfo getPaymentScheduleInfo(Context ctx, String cuId) throws BOSException, EASBizException {
        PaymentScheduleSettingInfo info = null;
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)now, CompareType.LESS_EQUALS));
        entityViewInfo.setFilter(filter);
        PaymentScheduleSettingCollection colls = PaymentScheduleSettingFactory.getLocalInstance(ctx).getPaymentScheduleSettingCollection(entityViewInfo);
        if (colls != null && colls.size() > 0) {
            info = colls.get(0);
            return info;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
        if (company != null && company.getParent() != null) {
            PSUtils.getPaymentScheduleInfo(ctx, company.getParent().getId().toString());
        }
        throw new BOSException(PSUtils.getResource(ctx, "136_NO_SCHEDULE", null));
    }

    public static SettlementPrioritySettingCollection getSettlePriColls(Context ctx, String payScheduleId) throws PSException {
        SettlementPrioritySettingCollection coll = new SettlementPrioritySettingCollection();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT settlePri.fid AS settlePriId,settleCate.fid AS settleCateId, settlePri.FDefaultSettleType  as defaultSettleTypeId   FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" INNER JOIN T_PS_SettlementPrioritySetting settlePri ON settlePri.FPaySchdlSettingID = setting.fid");
        sql.append(" INNER JOIN T_PS_SettlementCategory  settleCate  ON   settleCate.fid = settlePri.FCategoryid");
        sql.append(" where setting.Fid = '" + payScheduleId + "'");
        sql.append(" ORDER BY settlePri.FPriority");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null) {
                while (rs.next()) {
                    SettlementPrioritySettingInfo settlePri = new SettlementPrioritySettingInfo();
                    SettlementCategoryInfo categoryInfo = new SettlementCategoryInfo();
                    categoryInfo.setId(BOSUuid.read((String)rs.getString("settleCateId")));
                    settlePri.setId(BOSUuid.read((String)rs.getString("settlePriId")));
                    settlePri.setCategory(categoryInfo);
                    if (rs.getString("defaultSettleTypeId") != null) {
                        SettlementTypeInfo settType = new SettlementTypeInfo();
                        settType.setId(BOSUuid.read((String)rs.getString("defaultSettleTypeId")));
                        settlePri.setDefaultSettleType(settType);
                    }
                    coll.add(settlePri);
                }
                return coll;
            }
        }
        catch (Exception e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return null;
    }

    public static int getCurWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekOfMonth = calendar.get(4);
        return weekOfMonth;
    }

    public static Date getNextWeekMonday(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        int dayWeek = 0;
        int dayOfWeek = c.get(7) - 1;
        dayWeek = dayOfWeek == 1 ? 0 : 1 - dayOfWeek;
        ((Calendar)c).add(5, dayWeek == 1 ? dayWeek : dayWeek + 7);
        return c.getTime();
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static DecomposeBillInfo sumaryToDecomposeInfo(PayPlanSumaryCollection sumColls) {
        DecomposeBillInfo info = new DecomposeBillInfo();
        Date startDecomposeDate = null;
        Date endDecompseDate = null;
        for (int i = 0; i < sumColls.size(); ++i) {
            PayPlanSumaryInfo payPlanSumInfo = sumColls.get(i);
            DecomposeBillEntryInfo entryInfo = new DecomposeBillEntryInfo();
            entryInfo.setSumNumber(payPlanSumInfo.getNumber());
            entryInfo.setReportType(payPlanSumInfo.getReportType());
            entryInfo.setDepartment(payPlanSumInfo.getDepartment());
            entryInfo.setAsstActType(payPlanSumInfo.getAsstActType());
            entryInfo.setAsstActID(payPlanSumInfo.getAsstActID());
            entryInfo.setAsstActName(payPlanSumInfo.getAsstActName());
            entryInfo.setAsstActNumber(payPlanSumInfo.getAsstActNumber());
            entryInfo.setFundFlowItem(payPlanSumInfo.getFundFlowItem());
            entryInfo.setFundProperty(payPlanSumInfo.getFundProperty());
            entryInfo.setCurrency(payPlanSumInfo.getCurrency());
            entryInfo.setApplyPayAmt(payPlanSumInfo.getApplyPayAmt());
            entryInfo.setApprovedAmt(payPlanSumInfo.getApprovedAmt());
            entryInfo.setNotIssuedAmt(payPlanSumInfo.getNotIssuedAmt());
            entryInfo.setIssuedAmt(payPlanSumInfo.getIssuedAmt());
            entryInfo.setLimitStartDate(payPlanSumInfo.getLimitStartDate());
            entryInfo.setLimitExpiredDate(payPlanSumInfo.getLimitExpiredDate());
            entryInfo.setSummary(payPlanSumInfo);
            entryInfo.setPayerAccountBank(payPlanSumInfo.getPayerAccountBank());
            if (payPlanSumInfo.getSettlementType() != null) {
                entryInfo.setSettlementType(payPlanSumInfo.getSettlementType());
                entryInfo.setSettleTypeName(payPlanSumInfo.getSettlementType().getName());
            }
            entryInfo.setSettleCate1(payPlanSumInfo.getSettleCate1());
            entryInfo.setSettleCate2(payPlanSumInfo.getSettleCate2());
            entryInfo.setSettleCate3(payPlanSumInfo.getSettleCate3());
            entryInfo.setApproveAmt1(payPlanSumInfo.getApproveAmt1());
            entryInfo.setApproveAmt2(payPlanSumInfo.getApproveAmt2());
            entryInfo.setApproveAmt3(payPlanSumInfo.getApproveAmt3());
            entryInfo.setNotIssueAmt1(payPlanSumInfo.getNotIssuedAmt1());
            entryInfo.setNotIssueAmt2(payPlanSumInfo.getNotIssuedAmt2());
            entryInfo.setNotIssueAmt3(payPlanSumInfo.getNotIssuedAmt3());
            entryInfo.setCurrentIssueAmt1(payPlanSumInfo.getCurrentIssuedAmt1());
            entryInfo.setCurrentIssueAmt2(payPlanSumInfo.getCurrentIssuedAmt2());
            entryInfo.setCurrentIssueAmt3(payPlanSumInfo.getCurrentIssuedAmt3());
            if (payPlanSumInfo.getSettleEntries().size() > 0) {
                BigDecimal totalCurIssueAmt = BigDecimal.ZERO;
                for (int m = 0; m < payPlanSumInfo.getSettleEntries().size(); ++m) {
                    PayPlanSumSettleEntryInfo entry = payPlanSumInfo.getSettleEntries().get(m);
                    String categoryId = entry.getSettleCategory().getId().toString();
                    if (entryInfo.getSettleCate1() != null && categoryId.equals(entryInfo.getSettleCate1().getId().toString())) {
                        entryInfo.setSettleType1(entry.getSettleType());
                        entryInfo.setPayerAccBank1(entry.getPayerAccountBank());
                        entryInfo.setNotIssueAmt1(payPlanSumInfo.getNotIssuedAmt1());
                        entryInfo.setCurrentIssueAmt1(entryInfo.getNotIssueAmt1());
                        totalCurIssueAmt = totalCurIssueAmt.add(entryInfo.getCurrentIssueAmt1());
                    }
                    if (entryInfo.getSettleCate2() != null && categoryId.equals(entryInfo.getSettleCate2().getId().toString())) {
                        entryInfo.setSettleType2(entry.getSettleType());
                        entryInfo.setPayerAccBank2(entry.getPayerAccountBank());
                        entryInfo.setNotIssueAmt2(payPlanSumInfo.getNotIssuedAmt2());
                        entryInfo.setCurrentIssueAmt2(entryInfo.getNotIssueAmt2());
                        totalCurIssueAmt = totalCurIssueAmt.add(entryInfo.getCurrentIssueAmt2());
                    }
                    if (entryInfo.getSettleCate3() == null || !categoryId.equals(entryInfo.getSettleCate3().getId().toString())) continue;
                    entryInfo.setSettleType3(entry.getSettleType());
                    entryInfo.setPayerAccBank3(entry.getPayerAccountBank());
                    entryInfo.setNotIssueAmt3(payPlanSumInfo.getNotIssuedAmt3());
                    entryInfo.setCurrentIssueAmt3(entryInfo.getNotIssueAmt3());
                    totalCurIssueAmt = totalCurIssueAmt.add(entryInfo.getCurrentIssueAmt3());
                }
                entryInfo.setCurrentIssueAmt(totalCurIssueAmt);
            } else {
                entryInfo.setCurrentIssueAmt(payPlanSumInfo.getNotIssuedAmt());
            }
            if (startDecomposeDate == null) {
                startDecomposeDate = entryInfo.getLimitStartDate();
            }
            if (endDecompseDate == null) {
                endDecompseDate = entryInfo.getLimitExpiredDate();
            }
            info.getEntrys().add(entryInfo);
        }
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        if (startDecomposeDate != null && startDecomposeDate.before(now)) {
            info.setDecompStartDate(now);
        } else {
            info.setDecompStartDate(startDecomposeDate);
        }
        if (endDecompseDate != null && endDecompseDate.before(now)) {
            info.setDecompEndDate(now);
        } else {
            info.setDecompEndDate(endDecompseDate);
        }
        return info;
    }
}

