/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.recon.FmSettleResultFactory;
import com.kingdee.eas.fm.recon.SipgFmReconPeriodFactory;
import com.kingdee.eas.fm.recon.client.AbstractFmSettlementCenterUI;
import com.kingdee.eas.fm.recon.client.FMSettleCenterFilterParam;
import com.kingdee.eas.fm.recon.client.FmSettlementFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FmSettlementCenterUI
extends AbstractFmSettlementCenterUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmSettleResource";
    private static final Logger logger = CoreUIObject.getLogger(FmSettlementCenterUI.class);
    private FmSettlementFilterUI filterUI = null;
    private CommonQueryDialog queryDlg = null;
    private CompanyOrgUnitInfo currentCompany;
    private Color settledColor = new Color(192, 255, 62);
    private Color unSettledColor = new Color(255, 255, 0);

    public FmSettlementCenterUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("companyName").setGroup(true);
        this.init();
    }

    private void init() {
        this.actionSettle.setEnabled(true);
        this.actionSettle.setVisible(true);
        this.actionUnSettle.setEnabled(true);
        this.actionUnSettle.setVisible(true);
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.actionUnSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        FMSettleCenterFilterParam param = this.filterUI.getFilterParam();
        this.txtPeriodStart.setText(param.getBeginYear() + com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"19_YEAR") + param.getBeginMonth() + com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"20_PERIOD"));
        this.txtPeriodEnd.setText(param.getEndYear() + com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"19_YEAR") + param.getEndMonth() + com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"20_PERIOD"));
        this.txtPeriodStart.setEnabled(false);
        this.txtPeriodEnd.setEnabled(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
    }

    private void rebuildTree() throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("isLeaf");
        sic.add("isUnion");
        sic.add("isCompanyOrgUnit");
        sic.add("accountTable.id");
        sic.add("accountTable.number");
        sic.add("parent");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)this.currentCompany.getId(), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.getSorter().add(new SorterItemInfo("longnumber"));
        evi.setFilter(filter);
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companyCol = company.getCompanyOrgUnitCollection(evi);
        if (companyCol == null || companyCol.size() != 0) {
            // empty if block
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SipgFmReconPeriodFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg == null) {
            try {
                this.filterUI = (FmSettlementFilterUI)this.getFilterUI();
                this.filterUI.setListUI((IUIObject)this);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            this.queryDlg = super.initCommonQueryDialog();
            this.queryDlg.addUserPanel((KDPanel)this.filterUI);
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        }
        return this.queryDlg;
    }

    protected void initListener() {
        super.initListener();
    }

    public void fillColor() {
        IRow row = null;
        for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
            row = this.tblMain.getRow(j);
            ICell cell = row.getCell("settleStatus");
            BizEnumValueDTO settleStatus = (BizEnumValueDTO)cell.getValue();
            if (0 == Integer.valueOf(settleStatus.getValue().toString())) {
                cell.getStyleAttributes().setBackground(this.unSettledColor);
                continue;
            }
            cell.getStyleAttributes().setBackground(this.settledColor);
            row.getCell("settleTime").getStyleAttributes().setBackground(this.settledColor);
        }
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        String[] keys = new String[2];
        for (int i = 0; i < 2; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected void execQuery() {
        super.execQuery();
        this.fillColor();
        this.init();
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        List msgList = FmSettleResultFactory.getRemoteInstance().settleBatch(new HashSet(idList));
        if (msgList.size() > 0) {
            StringBuffer detail = new StringBuffer();
            for (int i = 0; i < msgList.size(); ++i) {
                detail.append(msgList.get(i) + "\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"34_SETTLE_DETAIL"), (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"21_SETTLED"));
        }
        this.refreshList();
    }

    @Override
    public void actionUnSettle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        List msgList = FmSettleResultFactory.getRemoteInstance().unSettleBatch(new HashSet(idList));
        if (msgList.size() > 0) {
            StringBuffer detail = new StringBuffer();
            for (int i = 0; i < msgList.size(); ++i) {
                detail.append(msgList.get(i) + "\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"35_UNSETTLE_DETAIL"), (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)com.kingdee.bos.util.EASResource.getString((String)RESOURCE_PATH, (String)"22_UNSETTLED"));
        }
        this.refreshList();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionSendSmsMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendSmsMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actoinViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actoinViewSignature_actionPerformed(e);
    }

    public void actionNumberSign_actionPerformed(ActionEvent e) throws Exception {
        super.actionNumberSign_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBdgBalance_actionPerformed(e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FmSettlementFilterUI();
            this.filterUI.onLoad();
        }
        return this.filterUI;
    }
}

