/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpa;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.rpa.RPAException;
import com.kingdee.eas.fm.rpa.RPALogCollection;
import com.kingdee.eas.fm.rpa.RPALogFactory;
import com.kingdee.eas.fm.rpa.RPALogInfo;
import com.kingdee.eas.fm.rpa.RPAStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class RPALogDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)RPALogDataImport.class.getName());
    private CompanyOrgUnitInfo currentCompany;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return RPALogFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        RPALogInfo info = new RPALogInfo();
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String solutionSettingNumber = (String)this.getData(hsData, "FSolutionSetting_number");
        if (solutionSettingNumber == null) {
            throw new RPAException(RPAException.NOT_SOLUTIONSETTINGNUMBER);
        }
        String ukeyName = (String)this.getData(hsData, "FUkey_name");
        if (ukeyName == null) {
            throw new RPAException(RPAException.NOT_UKEYNAME);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionSetting.number", (Object)solutionSettingNumber.trim()));
        filter.getFilterItems().add(new FilterItemInfo("ukey.name", (Object)ukeyName.trim()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPALogCollection coll = RPALogFactory.getLocalInstance(ctx).getRPALogCollection(view);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            throw new RPAException(RPAException.NOT_FIND);
        }
        info = coll.get(0);
        info = (RPALogInfo)this.parseHead(ctx, hsData, info);
        info.setExecuteEndTime(new Date());
        return info;
    }

    private CoreBaseInfo parseHead(Context ctx, Hashtable hsData, RPALogInfo info) throws BOSException {
        Object data = null;
        data = this.getData(hsData, "FState");
        if (data != null && data.toString().trim().length() > 0) {
            RPAStatusEnum state = RPAStatusEnum.getEnum(Integer.parseInt((String)data));
            info.setState(state);
        }
        if ((data = this.getData(hsData, "FFailedCause")) != null && data.toString().trim().length() > 0) {
            info.setFailedCause((String)data);
        }
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
        String solutionSettingId = ((RPALogInfo)coreBaseInfo).getSolutionSetting().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionSetting.id", (Object)solutionSettingId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        RPALogCollection coll = RPALogFactory.getLocalInstance(ctx).getRPALogCollection(view);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            String sql = "update T_RPA_SolutionSetting set fsolutionStatus=2 where Fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{solutionSettingId});
        }
    }
}

