/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.client.ApVerifyCommonUI;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.FundFlowItemPromptBox;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.rpm.BillClaimStatusEnum;
import com.kingdee.eas.fm.rpm.PayBillClaimCollection;
import com.kingdee.eas.fm.rpm.PayBillClaimFactory;
import com.kingdee.eas.fm.rpm.PayBillClaimInfo;
import com.kingdee.eas.fm.rpm.PayClaimBillTypeEnum;
import com.kingdee.eas.fm.rpm.client.AbstractPayBillClaimListUI;
import com.kingdee.eas.fm.rpm.client.ClaimBatchEditUI;
import com.kingdee.eas.fm.rpm.client.PayBillClaimFilterUI;
import com.kingdee.eas.fm.rpm.client.RPMClaimQueryProcessor;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PayBillClaimListUI
extends AbstractPayBillClaimListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayBillClaimListUI.class);
    private PayBillClaimFilterUI filterUI;

    protected CommonQueryProcessor getQueryProcessor() {
        return new RPMClaimQueryProcessor((IUIObject)this);
    }

    protected void initTableParams() {
        super.initTableParams();
        this.tblMain.getViewManager().setFreezeView(0, 2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.actionSum.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("selected").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.payType.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.payType.name").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.payClaimBillType").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.payClaimBillType").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.fundFlowItem.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.fundFlowItem.name").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.srcBillNumber").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.srcBillNumber").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.oppAccount.name").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.oppAccount.name").getStyleAttributes().setBackground(Color.WHITE);
        this.tblMain.getColumn("payBillClaim.interest").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("payBillClaim.interest").getStyleAttributes().setBackground(Color.WHITE);
        String format = FMClientHelper.getNumberFtm((int)2);
        this.tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("localAmt").getStyleAttributes().setNumberFormat(format);
        this.initF7AndComboBoxUI();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayBillClaimFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        Context ctx = new Context();
        if (this.orgContextManager != null) {
            ctx = this.orgContextManager.getMainOrgContext();
        }
        return PayBillClaimFactory.getRemoteInstanceWithObjectContext(ctx);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (EmptyUtil.isEmpty((Object)row)) {
            return;
        }
        boolean isSelect = (Boolean)row.getCell("selected").getValue();
        if (!isSelect) {
            row.getStyleAttributes().setBackground(new Color(207, 226, 243));
        }
        row.getCell("selected").setValue((Object)true);
        if (colIndex == this.tblMain.getColumnIndex("payBillClaim.interest")) {
            if (row.getCell("payBillClaim.payClaimBillType").getValue() == null) {
                row.getCell("payBillClaim.interest").getStyleAttributes().setLocked(true);
                row.getCell("payBillClaim.interest").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                return;
            }
            if (row.getCell("payBillClaim.payClaimBillType").getValue().equals((Object)PayClaimBillTypeEnum.Repayment)) {
                row.getCell("payBillClaim.interest").getStyleAttributes().setLocked(false);
                row.getCell("payBillClaim.interest").getStyleAttributes().setBackground(Color.WHITE);
                KDFormattedTextField txt = new KDFormattedTextField();
                txt.setDataType(1);
                txt.setVisible(true);
                txt.setPrecision(2);
                KDTDefaultCellEditor txt_CellEditor = new KDTDefaultCellEditor((JTextField)txt);
                row.getCell("payBillClaim.interest").setEditor((ICellEditor)txt_CellEditor);
            } else {
                row.getCell("payBillClaim.interest").getStyleAttributes().setLocked(true);
                row.getCell("payBillClaim.interest").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
        }
    }

    protected void bill_PromptBox_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo bill = (CoreBillBaseInfo)e.getNewValue();
            int rowIndex = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
            this.tblMain.getRow(rowIndex).getCell("payBillClaim.srcBillID").setValue((Object)bill.getId().toString());
            this.tblMain.getRow(rowIndex).getCell("payBillClaim.srcBillNumber").setValue((Object)bill.getNumber());
        } else if (e.getNewValue() == null) {
            int rowIndex = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
            this.tblMain.getRow(rowIndex).getCell("payBillClaim.srcBillID").setValue(null);
            this.tblMain.getRow(rowIndex).getCell("payBillClaim.srcBillNumber").setValue(null);
        }
    }

    public String getMainBizOrgColumnName() {
        return "company.id";
    }

    public String getMainBizOrgPropertyName() {
        return "company";
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    protected void initF7AndComboBoxUI() {
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            IRow row = this.tblMain.getRow(i);
            this.initClaimStatus_ComboBox(row);
            this.initPayType_PromptBox(row);
            this.initClaimBillType_ComboBox(row);
            this.initSrcBill_PromptBox(row);
            this.initFundFlowItem_PromptBox(row);
            this.initOppAccount_PromptBox(row);
        }
    }

    protected void initClaimBillType_ComboBox(IRow row) {
        KDComboBox claimBillType_ComboBox = new KDComboBox();
        claimBillType_ComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.rpm.PayClaimBillTypeEnum").toArray());
        claimBillType_ComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PayBillClaimListUI.this.claimBillType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    PayBillClaimListUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor claimBillType_ComboBox_CellEditor = new KDTDefaultCellEditor((JComboBox)claimBillType_ComboBox);
        row.getCell("payBillClaim.payClaimBillType").setEditor((ICellEditor)claimBillType_ComboBox_CellEditor);
    }

    protected void claimBillType_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        KDComboBox srcBill = (KDComboBox)e.getSource();
        int rowid = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
        IRow row = this.tblMain.getRow(rowid);
        if (e.getItem().equals(row.getCell("payBillClaim.payClaimBillType").getValue())) {
            return;
        }
        row.getCell("payBillClaim.srcBillID").setValue(null);
        row.getCell("payBillClaim.srcBillNumber").setValue(null);
    }

    protected void initSrcBill_PromptBox(IRow row) {
        KDBizPromptBox bill_PromptBox = new KDBizPromptBox();
        bill_PromptBox.setVisible(true);
        bill_PromptBox.setEditable(true);
        bill_PromptBox.setDisplayFormat("$number$");
        bill_PromptBox.setEditFormat("$number$");
        bill_PromptBox.setCommitFormat("$number$");
        bill_PromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PayBillClaimListUI.this.srcBill_willShow(e);
                }
                catch (Exception exc) {
                    PayBillClaimListUI.this.handUIException(exc);
                }
            }
        });
        bill_PromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PayBillClaimListUI.this.bill_PromptBox_dataChanged(e);
                }
                catch (Exception exc) {
                    PayBillClaimListUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor bill_CellEditor = new KDTDefaultCellEditor((IKDEditor)bill_PromptBox);
        row.getCell("payBillClaim.srcBillNumber").setEditor((ICellEditor)bill_CellEditor);
        ObjectValueRender bill_OVR = new ObjectValueRender();
        bill_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell("payBillClaim.srcBillNumber").setRenderer((IBasicRender)bill_OVR);
    }

    protected void initPayType_PromptBox(IRow row) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("sourceSysType", (Object)101, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        KDBizPromptBox payType_PromptBox = new KDBizPromptBox();
        payType_PromptBox.setQueryInfo("com.kingdee.eas.fi.cas.F7PaymentBillTypeQuery");
        payType_PromptBox.setVisible(true);
        payType_PromptBox.setEditable(true);
        payType_PromptBox.setEntityViewInfo(evi);
        payType_PromptBox.setDisplayFormat("$name$");
        payType_PromptBox.setEditFormat("$name$");
        payType_PromptBox.setCommitFormat("$name$");
        KDTDefaultCellEditor payType_CellEditor = new KDTDefaultCellEditor((IKDEditor)payType_PromptBox);
        row.getCell("payBillClaim.payType.name").setEditor((ICellEditor)payType_CellEditor);
        ObjectValueRender payType_OVR = new ObjectValueRender();
        payType_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        row.getCell("payBillClaim.payType.name").setRenderer((IBasicRender)payType_OVR);
    }

    protected void initClaimStatus_ComboBox(IRow row) {
        KDComboBox ClaimStatus_ComboBox = new KDComboBox();
        ClaimStatus_ComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.rpm.BillClaimStatusEnum").toArray());
        KDTDefaultCellEditor ClaimStatus_ComboBox_CellEditor = new KDTDefaultCellEditor((JComboBox)ClaimStatus_ComboBox);
        row.getCell("billClaimStatus").setEditor((ICellEditor)ClaimStatus_ComboBox_CellEditor);
    }

    protected void initFundFlowItem_PromptBox(IRow row) {
        KDBizPromptBox fundFlowItem_PromptBox = new KDBizPromptBox();
        fundFlowItem_PromptBox.setQueryInfo("com.kingdee.eas.fi.cas.F7FundFlowItemQuery");
        FundFlowItemPromptBox selector = new FundFlowItemPromptBox((IUIObject)this, FundFlowDirection.OUT);
        selector.setMultiSelect(false);
        fundFlowItem_PromptBox.setSelector((KDPromptSelector)selector);
        fundFlowItem_PromptBox.setVisible(true);
        fundFlowItem_PromptBox.setEditable(true);
        fundFlowItem_PromptBox.setDisplayFormat("$name$");
        fundFlowItem_PromptBox.setEditFormat("$name$");
        fundFlowItem_PromptBox.setCommitFormat("$name$");
        KDTDefaultCellEditor fundFlowItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)fundFlowItem_PromptBox);
        row.getCell("payBillClaim.fundFlowItem.name").setEditor((ICellEditor)fundFlowItem_CellEditor);
        ObjectValueRender fundFlowItem_OVR = new ObjectValueRender();
        fundFlowItem_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        row.getCell("payBillClaim.fundFlowItem.name").setRenderer((IBasicRender)fundFlowItem_OVR);
    }

    protected void initOppAccount_PromptBox(IRow row) {
        KDBizPromptBox oppAccount_PromptBox = new KDBizPromptBox();
        oppAccount_PromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        oppAccount_PromptBox.setVisible(true);
        oppAccount_PromptBox.setEditable(true);
        oppAccount_PromptBox.setDisplayFormat("$name$");
        oppAccount_PromptBox.setEditFormat("$name$");
        oppAccount_PromptBox.setCommitFormat("$name$");
        oppAccount_PromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PayBillClaimListUI.this.prmtOppAccount_willShow(e);
                }
                catch (Exception exc) {
                    PayBillClaimListUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor oppAccount_CellEditor = new KDTDefaultCellEditor((IKDEditor)oppAccount_PromptBox);
        row.getCell("payBillClaim.oppAccount.name").setEditor((ICellEditor)oppAccount_CellEditor);
        ObjectValueRender kdtEntries_oppAccount_OVR = new ObjectValueRender();
        kdtEntries_oppAccount_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        row.getCell("payBillClaim.oppAccount.name").setRenderer((IBasicRender)kdtEntries_oppAccount_OVR);
    }

    protected Map getF7InfoByBillType(PayClaimBillTypeEnum billType, String companyid, String amount, String currencyId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String queryInfo = "";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int type = billType.getValue();
        switch (type) {
            case 10: {
                queryInfo = "com.kingdee.eas.fm.fin.app.RepaymentQuery";
                filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("isPayCompleted", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.IS));
                evi.setFilter(filter);
                break;
            }
            case 20: {
                queryInfo = "com.kingdee.eas.fm.cl.app.ConsignmenBillQuery";
                filter.getFilterItems().add(new FilterItemInfo("operationType", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)2));
                filter.getFilterItems().add(new FilterItemInfo("isCreateCPayment", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                evi.setFilter(filter);
                break;
            }
            case 30: {
                queryInfo = "com.kingdee.eas.fm.ft.app.FundTransferBillQuery";
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
                filter.getFilterItems().add(new FilterItemInfo("paymentBill.id", null, CompareType.IS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.IS));
                evi.setFilter(filter);
                break;
            }
            case 40: {
                queryInfo = "com.kingdee.eas.fm.nt.app.PayableBillQuery";
                filter.getFilterItems().add(new FilterItemInfo("billState", (Object)0));
                filter.getFilterItems().add(new FilterItemInfo("billState", (Object)5));
                filter.getFilterItems().add(new FilterItemInfo("Amount", (Object)amount, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.setMaskString("(#0 or #1) and #2 and #3");
                evi.setFilter(filter);
                break;
            }
            case 50: {
                queryInfo = "com.kingdee.eas.fm.ivt.app.FinancingAccountQuery";
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)3));
                filter.getFilterItems().add(new FilterItemInfo("isBook", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("isGenePayBill", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("financeAmount", (Object)amount, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                evi.setFilter(filter);
                break;
            }
            case 60: {
                queryInfo = "com.kingdee.eas.cp.bc.app.BizAccountQuery";
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)65));
                filter.getFilterItems().add(new FilterItemInfo("amountNotPaid", (Object)0, CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.setMaskString("(#0 or #1) and #2 and #3");
                evi.setFilter(filter);
                break;
            }
            case 61: {
                queryInfo = "com.kingdee.eas.cp.bc.app.DailyLoanBillQuery";
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)65));
                filter.getFilterItems().add(new FilterItemInfo("amountNotPaid", (Object)0, CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.setMaskString("(#0 or #1) and #2 and #3");
                evi.setFilter(filter);
                break;
            }
            case 70: {
                queryInfo = "com.kingdee.eas.fm.fin.app.RepaymentQuery";
                filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("isPayCompleted", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)3));
                filter.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.IS));
                evi.setFilter(filter);
                break;
            }
            case 80: {
                queryInfo = "com.kingdee.eas.fm.fin.app.RepaymentQuery";
                filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("isPayCompleted", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)4));
                evi.setFilter(filter);
                break;
            }
            case 90: {
                queryInfo = "com.kingdee.eas.cp.bc.app.BillListBizAccountOutSharingQuery";
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)65));
                filter.getFilterItems().add(new FilterItemInfo("amountNotPaid", (Object)0, CompareType.GREATER));
                filter.setMaskString("(#0 or #1) and #2");
                evi.setFilter(filter);
                break;
            }
            case 100: {
                queryInfo = "com.kingdee.eas.fm.fin.app.LoanInterestQuery";
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.IS));
                filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)1));
                filter.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)false));
                filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)4));
                filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)2));
                filter.getFilterItems().add(new FilterItemInfo("realInterest", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("punishInterest", (Object)BigDecimal.ZERO, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("intCurrencyAmt", (Object)amount));
                filter.setMaskString(" #0 and #1 and #2 and #3 and #4 and (#5 or #6) and (#7 or #8) and #9 ");
                evi.setFilter(filter);
            }
        }
        result.put("queryInfo", queryInfo);
        result.put("evi", (String)evi);
        return result;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.initF7AndComboBoxUI();
    }

    protected void srcBill_willShow(SelectorEvent e) {
        KDBizPromptBox srcBill = (KDBizPromptBox)e.getSource();
        int rowid = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
        IRow row = this.tblMain.getRow(rowid);
        if (row.getCell("payBillClaim.payClaimBillType").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"117_PayBillClaimListUI"));
            return;
        }
        PayClaimBillTypeEnum billType = (PayClaimBillTypeEnum)((Object)row.getCell("payBillClaim.payClaimBillType").getValue());
        String companyid = row.getCell("company.id").getValue().toString();
        String amount = row.getCell("amount").getValue() == null ? "0" : row.getCell("amount").getValue().toString();
        String currencyId = row.getCell("currency.id").getValue().toString();
        Map result = this.getF7InfoByBillType(billType, companyid, amount, currencyId);
        EntityViewInfo evi = (EntityViewInfo)result.get("evi");
        String queryinfo = result.get("queryInfo").toString();
        srcBill.setQueryInfo(queryinfo);
        srcBill.setEntityViewInfo(evi);
        srcBill.getQueryAgent().resetRuntimeEntityView();
    }

    protected void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        KDBizPromptBox prmtOppAccount = (KDBizPromptBox)e.getSource();
        int rowid = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getTop();
        IRow row = this.tblMain.getRow(rowid);
        String companyid = row.getCell("company.id").getValue() == null ? "" : row.getCell("company.id").getValue().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        String CUid = row.getCell("company.CU.id").getValue() == null ? "" : row.getCell("company.CU.id").getValue().toString();
        String currencyid = row.getCell("currency.id").getValue() == null ? "" : row.getCell("currency.id").getValue().toString();
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)CUid, (String)companyid, (String)currencyid, (boolean)true, (boolean)true);
        prmtOppAccount.setEntityViewInfo(evi);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, company, evi.getFilter(), false, true);
        prmtOppAccount.setSelector((KDPromptSelector)opseelect);
        prmtOppAccount.getQueryAgent().resetRuntimeEntityView();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                int value;
                if (!EmptyUtil.isEmpty((Object)((BizEnumValueDTO)rowSet.getObject("payBillClaim.payClaimBillType")))) {
                    value = Integer.parseInt(((BizEnumValueDTO)rowSet.getObject("payBillClaim.payClaimBillType")).getValue().toString());
                    rowSet.updateObject("payBillClaim.payClaimBillType", (Object)PayClaimBillTypeEnum.getEnum(value));
                }
                if (!EmptyUtil.isEmpty((Object)((BizEnumValueDTO)rowSet.getObject("billClaimStatus")))) {
                    value = Integer.parseInt(((BizEnumValueDTO)rowSet.getObject("billClaimStatus")).getValue().toString());
                    rowSet.updateObject("billClaimStatus", (Object)BillClaimStatusEnum.getEnum(value));
                }
                if (rowSet.getObject("payBillClaim.id") != null) continue;
                if (rowSet.getObject("payBillType.id") != null) {
                    rowSet.updateObject("payBillClaim.payType.name", rowSet.getObject("payBillType.name"));
                    rowSet.updateObject("payBillClaim.payType.id", rowSet.getObject("payBillType.id"));
                }
                if (rowSet.getObject("oppAccount.id") != null) {
                    rowSet.updateObject("payBillClaim.oppAccount.id", rowSet.getObject("oppAccount.id"));
                    rowSet.updateObject("payBillClaim.oppAccount.name", rowSet.getObject("oppAccount.name"));
                }
                if (rowSet.getObject("fundFlowItem.id") == null) continue;
                rowSet.updateObject("payBillClaim.fundFlowItem.id", rowSet.getObject("fundFlowItem.id"));
                rowSet.updateObject("payBillClaim.fundFlowItem.name", rowSet.getObject("fundFlowItem.name"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    protected PayBillClaimInfo getPayBillClaimInfo(IRow row) throws EASBizException, BOSException {
        PayBillClaimInfo info = new PayBillClaimInfo();
        if (row.getCell("id").getValue() != null) {
            info.setPaymentBillID(row.getCell("id").getValue().toString());
            info.setNumber(row.getCell("number").getValue().toString());
        }
        if (row.getCell("payBillClaim.id").getValue() != null) {
            info.setId(BOSUuid.read((String)row.getCell("payBillClaim.id").getValue().toString()));
        }
        if (row.getCell("payBillClaim.payType.name").getValue() != null) {
            if (row.getCell("payBillClaim.payType.name").getValue() instanceof PaymentBillTypeInfo) {
                info.setPayType((PaymentBillTypeInfo)row.getCell("payBillClaim.payType.name").getValue());
            } else if (row.getCell("payBillClaim.payType.name").getValue() instanceof String) {
                String payTypeID = row.getCell("payBillClaim.payType.id").getValue().toString();
                PaymentBillTypeInfo payType = PaymentBillTypeFactory.getRemoteInstance().getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(payTypeID));
                info.setPayType(payType);
            }
        } else {
            info.setPayType(null);
        }
        if (row.getCell("payBillClaim.payClaimBillType").getValue() != null) {
            info.setPayClaimBillType((PayClaimBillTypeEnum)((Object)row.getCell("payBillClaim.payClaimBillType").getValue()));
        } else {
            info.setPayClaimBillType(null);
        }
        if (row.getCell("payBillClaim.fundFlowItem.name").getValue() != null) {
            if (row.getCell("payBillClaim.fundFlowItem.name").getValue() instanceof FundFlowItemInfo) {
                info.setFundFlowItem((FundFlowItemInfo)row.getCell("payBillClaim.fundFlowItem.name").getValue());
            } else if (row.getCell("payBillClaim.fundFlowItem.name").getValue() instanceof String) {
                String fundFlowItemID = row.getCell("payBillClaim.fundFlowItem.id").getValue().toString();
                FundFlowItemInfo fundFlowItem = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(fundFlowItemID));
                info.setFundFlowItem(fundFlowItem);
            }
        } else {
            info.setFundFlowItem(null);
        }
        if (row.getCell("payBillClaim.srcBillNumber").getValue() != null) {
            if (row.getCell("payBillClaim.srcBillNumber").getValue() instanceof CoreBillBaseInfo) {
                info.setSrcBillNumber(((CoreBillBaseInfo)row.getCell("payBillClaim.srcBillNumber").getValue()).getNumber());
            } else {
                info.setSrcBillNumber(row.getCell("payBillClaim.srcBillNumber").getValue().toString());
            }
        } else {
            info.setSrcBillNumber(null);
        }
        if (row.getCell("payBillClaim.srcBillID").getValue() != null) {
            info.setSrcBillID(row.getCell("payBillClaim.srcBillID").getValue().toString());
        } else {
            info.setSrcBillID(null);
        }
        if (row.getCell("payBillClaim.oppAccount.name").getValue() != null) {
            if (row.getCell("payBillClaim.oppAccount.name").getValue() instanceof AccountViewInfo) {
                info.setOppAccount((AccountViewInfo)row.getCell("payBillClaim.oppAccount.name").getValue());
            } else if (row.getCell("payBillClaim.oppAccount.name").getValue() instanceof String) {
                String oppAccountID = row.getCell("payBillClaim.oppAccount.id").getValue().toString();
                AccountViewInfo accountView = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(oppAccountID));
                info.setOppAccount(accountView);
            }
        } else {
            info.setOppAccount(null);
        }
        if (row.getCell("payBillClaim.interest").getValue() != null) {
            info.setInterest(new BigDecimal(row.getCell("payBillClaim.interest").getValue().toString()));
        } else {
            info.setInterest(null);
        }
        return info;
    }

    protected PayBillClaimInfo getSimplePayBillClaimInfo(IRow row) throws EASBizException, BOSException {
        PayBillClaimInfo info = new PayBillClaimInfo();
        if (row.getCell("id").getValue() != null) {
            info.setPaymentBillID(row.getCell("id").getValue().toString());
            info.setNumber(row.getCell("number").getValue().toString());
        }
        if (row.getCell("payBillClaim.id").getValue() != null) {
            info.setId(BOSUuid.read((String)row.getCell("payBillClaim.id").getValue().toString()));
        }
        if (row.getCell("payBillClaim.srcBillID").getValue() != null) {
            info.setSrcBillID(row.getCell("payBillClaim.srcBillID").getValue().toString());
        }
        return info;
    }

    protected Map getSelectedRowIndex(KDTable table) {
        HashMap<String, AbstractCollection> result = new HashMap<String, AbstractCollection>();
        HashSet<String> companyAndCurrency = new HashSet<String>();
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        for (int i = 0; i < table.getRowCount3(); ++i) {
            IRow row = table.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String companyid = row.getCell("company.id").getValue() == null ? "" : row.getCell("company.id").getValue().toString();
            String currencyid = row.getCell("currency.id").getValue() == null ? "" : row.getCell("currency.id").getValue().toString();
            String cuid = row.getCell("company.CU.id").getValue() == null ? "" : row.getCell("company.CU.id").getValue().toString();
            companyAndCurrency.add(companyid + "@" + currencyid + "@" + cuid);
            rowList.add(row.getRowIndex());
        }
        result.put("companyAndCurrency", companyAndCurrency);
        result.put("rowList", rowList);
        return result;
    }

    protected Map getSelectedData(Boolean isSimple) {
        HashMap<String, Object> selectedResult = new HashMap<String, Object>();
        PayBillClaimCollection all = new PayBillClaimCollection();
        HashSet<String> companyAndCurrency = new HashSet<String>();
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            try {
                PayBillClaimInfo info;
                String companyid = row.getCell("company.id").getValue() == null ? "" : row.getCell("company.id").getValue().toString();
                String currencyid = row.getCell("currency.id").getValue() == null ? "" : row.getCell("currency.id").getValue().toString();
                String cuid = row.getCell("company.CU.id").getValue() == null ? "" : row.getCell("company.CU.id").getValue().toString();
                companyAndCurrency.add(companyid + "@" + currencyid + "@" + cuid);
                rowList.add(row.getRowIndex());
                BillClaimStatusEnum status = (BillClaimStatusEnum)((Object)row.getCell("billClaimStatus").getValue());
                if (status.equals((Object)BillClaimStatusEnum.UNCLAIM)) {
                    info = this.getPayBillClaimInfo(row);
                    all.add(info);
                    continue;
                }
                if (status.equals((Object)BillClaimStatusEnum.SUBMIT)) {
                    info = isSimple != false ? this.getSimplePayBillClaimInfo(row) : this.getPayBillClaimInfo(row);
                    all.add(info);
                    continue;
                }
                if (!status.equals((Object)BillClaimStatusEnum.AUDIT)) continue;
                info = this.getSimplePayBillClaimInfo(row);
                all.add(info);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        selectedResult.put("all", (Object)all);
        selectedResult.put("rowList", rowList);
        selectedResult.put("companyAndCurrency", companyAndCurrency);
        return selectedResult;
    }

    @Override
    public void actionSubmitClaim_actionPerformed(ActionEvent e) throws Exception {
        int success;
        Map result;
        int all;
        Map selected = this.getSelectedData(false);
        PayBillClaimCollection allCol = (PayBillClaimCollection)((Object)selected.get("all"));
        if (allCol.size() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((all = Integer.parseInt((result = PayBillClaimFactory.getRemoteInstance().submitClaim(allCol)).get("all").toString())) == (success = ((Set)result.get("success")).size())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"118_PayBillClaimListUI"));
        } else {
            String failDetail = result.get("failDetail").toString();
            String failTitle = String.format(EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"119_PayBillClaimListUI"), all, success, all - success);
            MsgBox.showDetailAndOK(null, (String)failTitle, (String)failDetail, (int)8188);
        }
        this.refresh(e);
    }

    @Override
    public void actionAuditClaim_actionPerformed(ActionEvent e) throws Exception {
        int success;
        Map result;
        int all;
        Map selected = this.getSelectedData(true);
        PayBillClaimCollection allCol = (PayBillClaimCollection)((Object)selected.get("all"));
        if (allCol.size() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((all = Integer.parseInt((result = PayBillClaimFactory.getRemoteInstance().auditClaim(allCol)).get("all").toString())) == (success = ((Set)result.get("success")).size())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"120_PayBillClaimListUI"));
        } else {
            String failDetail = result.get("failDetail").toString();
            String failTitle = String.format(EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"119_PayBillClaimListUI"), all, success, all - success);
            MsgBox.showDetailAndOK(null, (String)failTitle, (String)failDetail, (int)8188);
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAuditClaim_actionPerformed(ActionEvent e) throws Exception {
        int success;
        Map result;
        int all;
        Map selected = this.getSelectedData(true);
        PayBillClaimCollection allCol = (PayBillClaimCollection)((Object)selected.get("all"));
        if (allCol.size() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((all = Integer.parseInt((result = PayBillClaimFactory.getRemoteInstance().antiAuditClaim(allCol)).get("all").toString())) == (success = ((Set)result.get("success")).size())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"121_PayBillClaimListUI"));
        } else {
            String failDetail = result.get("failDetail").toString();
            String failTitle = String.format(EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"119_PayBillClaimListUI"), all, success, all - success);
            MsgBox.showDetailAndOK(null, (String)failTitle, (String)failDetail, (int)8188);
        }
        this.refresh(e);
    }

    @Override
    public void actionTrans_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType bostype;
        IMetaDataLoader loader;
        BTPBillListImpl billList = new BTPBillListImpl((CoreBillListUI)this);
        Map selected = this.getSelectedData(true);
        PayBillClaimCollection all = (PayBillClaimCollection)((Object)selected.get("all"));
        if (all.size() > 0) {
            loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            bostype = null;
            if (EmptyUtil.isEmpty((String)all.get(0).getSrcBillID())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RPMAutoResource", (String)"122_PayBillClaimListUI"));
                return;
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        bostype = BOSUuid.getBOSObjectType((String)all.get(0).getSrcBillID(), (boolean)true);
        EntityObjectInfo entity = loader.getEntity(bostype);
        String popUi = entity.getExtendedProperty("editUI");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"company", (Object)this.currentCompanyCommon);
        uiContext.put((Object)OrgType.Company, (Object)this.currentCompanyCommon);
        uiContext.put((Object)"ID", (Object)all.get(0).getSrcBillID());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(popUi, (Map)uiContext, null, "VIEW");
        uiWindow.show();
    }

    @Override
    public void actionBatchEdit_actionPerformed(ActionEvent e) throws Exception {
        Map selected = this.getSelectedRowIndex(this.tblMain);
        Set companyAndCurrency = (Set)selected.get("companyAndCurrency");
        List rowList = (List)selected.get("rowList");
        if (rowList.size() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        Map map = this.getUIContext();
        map.put("recOrPay", "pay");
        if (companyAndCurrency.size() == 1) {
            map.put("companyAndCurrency", companyAndCurrency.toArray()[0].toString());
        } else {
            map.put("companyAndCurrency", null);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.fm.rpm.client.ClaimBatchEditUI", map, null);
        CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
        ClaimBatchEditUI batchEditUI = (ClaimBatchEditUI)window.getUIObject();
        window.show();
        if (batchEditUI.isOK()) {
            Map result = batchEditUI.getResult();
            PaymentBillTypeInfo payType = (PaymentBillTypeInfo)result.get("type");
            PayClaimBillTypeEnum billType = (PayClaimBillTypeEnum)((Object)result.get("billType"));
            FundFlowItemInfo fundFlowItem = (FundFlowItemInfo)result.get("fundFlowItem");
            AccountViewInfo oppAccount = (AccountViewInfo)result.get("oppAccount");
            for (int i = 0; i < rowList.size(); ++i) {
                int rowIndex = Integer.parseInt(rowList.get(i).toString());
                if (payType != null) {
                    this.tblMain.getRow(rowIndex).getCell("payBillClaim.payType.name").setValue((Object)payType);
                }
                if (billType != null) {
                    this.tblMain.getRow(rowIndex).getCell("payBillClaim.payClaimBillType").setValue((Object)billType);
                }
                if (fundFlowItem != null) {
                    this.tblMain.getRow(rowIndex).getCell("payBillClaim.fundFlowItem.name").setValue((Object)fundFlowItem);
                }
                if (oppAccount == null) continue;
                this.tblMain.getRow(rowIndex).getCell("payBillClaim.oppAccount.name").setValue((Object)oppAccount);
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)true);
            this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(207, 226, 243));
        }
    }

    @Override
    public void actionDisSellected_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)false);
            this.setUnselectColor(this.tblMain.getRow(i));
        }
    }

    @Override
    public void actionAp2Pay_actionPerformed(ActionEvent e) throws Exception {
        String param = "com.kingdee.eas.fi.ap.config.Ap2PayVerifyConfig";
        this.openApVerifyCommonUI(param);
    }

    @Override
    public void actionPrePay2PreRec_actionPerformed(ActionEvent e) throws Exception {
        String param = "com.kingdee.eas.fi.ap.config.PrePay2PreRecVerifyConfig";
        this.openApVerifyCommonUI(param);
    }

    @Override
    public void actionProPay2ProRec_actionPerformed(ActionEvent e) throws Exception {
        String param = "com.kingdee.eas.fi.ap.config.ProPay2ProRecVerifyConfig";
        this.openApVerifyCommonUI(param);
    }

    private void openApVerifyCommonUI(String param) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"UIClassParam", (Object)param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ApVerifyCommonUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        int index = e.getRowIndex();
        IRow row = this.tblMain.getRow(index);
        if (e.getColIndex() == this.tblMain.getColumn("selected").getColumnIndex()) {
            Object value = e.getValue();
            if (value != null && ((Boolean)value).booleanValue()) {
                row.getStyleAttributes().setBackground(new Color(207, 226, 243));
                logger.error((Object)"");
            } else {
                this.setUnselectColor(row);
            }
        }
    }

    private void setUnselectColor(IRow row) {
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        row.getCell("selected").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.payType.name").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.payClaimBillType").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.fundFlowItem.name").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.srcBillNumber").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.oppAccount.name").getStyleAttributes().setBackground(Color.WHITE);
        row.getCell("payBillClaim.interest").getStyleAttributes().setBackground(Color.WHITE);
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        PaymentBillInfo info = (PaymentBillInfo)DynamicUtils.getInfo((Object[])new Object[]{id, ConvertUtils.SIC((Object[])new Object[]{"company.baseCurrency.precision"})});
        String msg = this.sumList(this.tblMain, info.getCompany().getBaseCurrency().getPrecision());
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    public String sumList(KDTable tblMain, int prec) {
        StringBuffer msg = new StringBuffer();
        BigDecimal sumMoney = BigDecimal.ZERO;
        int sumCount = 0;
        for (int i = 0; i < tblMain.getRowCount3(); ++i) {
            IRow row = tblMain.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String rowAmount = row.getCell("amount").getValue() == null ? "0" : row.getCell("amount").getValue().toString();
            sumMoney = sumMoney.add(new BigDecimal(rowAmount));
            ++sumCount;
        }
        NumberFormat fm = NumberFormat.getInstance();
        fm.setMaximumFractionDigits(prec);
        fm.setGroupingUsed(true);
        msg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"381_RecPayHandler")).append(fm.format(sumMoney)).append("        ").append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"382_RecPayHandler")).append(sumCount).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"383_RecPayHandler"));
        return msg.toString();
    }
}

