/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.rpm.PayDetailMatchFilterParam;
import com.kingdee.eas.fm.rpm.client.AbstractPayDetailMatchFilterUI;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PayDetailMatchFilterUI
extends AbstractPayDetailMatchFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PayDetailMatchFilterUI.class);
    private Context mainOrgContext;
    AsstActTypeCollection asstActTypeColl;
    String PERMISSIONITEM = "rpm_payDetail_01view";
    private static final String resourcePath = "com.kingdee.eas.fm.rpm.RpmResources";

    public PayDetailMatchFilterUI() throws Exception {
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.mainOrgContext = new Context();
        this.mainOrgContext.put((Object)"UserInfo", (Object)user);
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setVisible(false);
        this.customInit();
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            logger.info((Object)e);
            logger.error((Object)e);
        }
    }

    private void customInit() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.cbxCurrency, (boolean)false);
        this.cbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
        Date date = new Date();
        this.dpDetailStartDate.setValue((Object)date);
        this.dpDetailEndDate.setValue((Object)date);
        this.dpPayStartDate.setValue((Object)date);
        this.dpPayEndDate.setValue((Object)date);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)this.asstActTypeColl)) {
            this.asstActTypeColl = CasRecPayHandler.getAsstActTypeColl(null, (boolean)false, (boolean)false);
        }
        this.initAsstActType();
    }

    private void initAsstActType() {
        this.cbxPayeeType.setEnabled(true);
        if (this.asstActTypeColl != null) {
            this.cbxPayeeType.removeAllItems();
            this.cbxPayeeType.addItems(this.asstActTypeColl.toArray());
            this.cbxPayeeType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.cbxPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.cbxPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)this.PERMISSIONITEM, (FilterInfo)filter);
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getPermissionItem() {
        return this.PERMISSIONITEM;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    @Override
    protected void cbxPayeeType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayee.setValue(null);
        if (this.cbxPayeeType.getSelectedItem() == null || !(this.cbxPayeeType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayee.setEnabled(false);
            return;
        }
        if (this.prmtPayee.isEnabled() && this.prmtPayee.getData() != null) {
            return;
        }
        this.prmtPayee.setEnabled(true);
        this.prmtPayee.setData(null);
        this.prmtPayee.setSelector(null);
        this.prmtPayee.setFilterInfoProducer(null);
        AsstActTypeInfo info = (AsstActTypeInfo)this.cbxPayeeType.getSelectedItem();
        this.prmtPayee.setFilterInfoProducer(null);
        this.prmtPayee.setSelector(null);
        CasRecPayHandler handler = new CasRecPayHandler();
        CompanyOrgUnitInfo company = this.getMainOrgColl().get(0);
        if (company == null) {
            company = this.currentCompany;
        }
        handler.setAsstActSelectorByCU((CoreUIObject)this, this.prmtPayee, info, company, false);
        if (info.getAsstHGAttribute().equalsIgnoreCase("innerAccount")) {
            info.setIsForCompany(false);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtPayee.setEntityViewInfo(evi);
        }
        this.prmtPayee.setDisplayFormat("$number$ $name$");
        this.prmtPayee.setCommitFormat("$number$;$name$");
        this.prmtPayee.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", this.prmtPayee));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        int i;
        HashSet<String> idSet;
        CompanyOrgUnitCollection coll;
        PayDetailMatchFilterParam param = new PayDetailMatchFilterParam();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            coll = this.getMainOrgColl();
            idSet = new HashSet<String>();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setCompanyIdSet(idSet);
        }
        if (FMSysDefinedEnum.ALL_ITEMS.equals(this.cbxCurrency.getSelectedItem())) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getAcctBanks())) {
            coll = this.getAcctBanks();
            idSet = new HashSet();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setAccountBankIdSet(idSet);
        }
        param.setDetailStartDate((Date)this.dpDetailStartDate.getValue());
        param.setDetailEndDate((Date)this.dpDetailEndDate.getValue());
        param.setIncludeTranceup(this.isIncludeTranceup.isSelected());
        param.setPayStartDate((Date)this.dpPayStartDate.getValue());
        param.setPayEndDate((Date)this.dpPayEndDate.getValue());
        if (this.cbxPayeeType.getSelectedItem() != null && !this.cbxPayeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            if (this.cbxPayeeType.getSelectedItem() == FMSysDefinedEnum.OTHER) {
                param.setPayeeTypeId("null");
            } else {
                param.setPayeeTypeId(((DataBaseInfo)this.cbxPayeeType.getSelectedItem()).getId().toString());
            }
        }
        if (this.prmtPayee.getData() != null) {
            if (this.prmtPayee.getData() instanceof InnerAccountInfo) {
                param.setPayeeId(((InnerAccountInfo)this.prmtPayee.getData()).getId().toString());
                param.setPayeeName(((InnerAccountInfo)this.prmtPayee.getData()).getName());
            } else {
                param.setPayeeId(((DataBaseInfo)this.prmtPayee.getData()).getId().toString());
                param.setPayeeName(((DataBaseInfo)this.prmtPayee.getData()).getName());
            }
        }
        param.setAudit(this.kDAudit.isSelected());
        param.setPay(this.kDPay.isSelected());
        param.setAuditAndPay(this.kDAuditAndPay.isSelected());
        param.setIncludeBankPay(this.isIncludeBankPay.isSelected());
        param.setDealNegative(this.isDealNegative.isSelected());
        return param;
    }

    public void setParam(Object param) {
        CompanyOrgUnitCollection coll;
        FilterInfo filter;
        EntityViewInfo view;
        if (param == null) {
            return;
        }
        if (!(param instanceof PayDetailMatchFilterParam)) {
            return;
        }
        PayDetailMatchFilterParam para = (PayDetailMatchFilterParam)param;
        if (!EmptyUtil.isEmpty(para.getCompanyIdSet())) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getCompanyIdSet(), CompareType.INCLUDE));
            try {
                coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
        try {
            if (para.getCurrencyId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(para.getCurrencyId());
                this.cbxCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)pk));
            } else {
                this.cbxCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (!EmptyUtil.isEmpty(para.getAccountBankIdSet())) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getAccountBankIdSet(), CompareType.INCLUDE));
            try {
                coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.prmtAcctBank.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtAcctBank.setValue(null);
        }
        this.dpDetailStartDate.setValue((Object)para.getDetailStartDate());
        this.dpDetailEndDate.setValue((Object)para.getDetailEndDate());
        this.isIncludeTranceup.setSelected(para.isIncludeTranceup());
        this.dpPayStartDate.setValue((Object)para.getPayStartDate());
        this.dpPayEndDate.setValue((Object)para.getPayEndDate());
        if (para.getPayeeTypeId() == null) {
            this.cbxPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            int selectIndex = BookNotifyClientHelper.getSelectIndex((KDComboBox)this.cbxPayeeType, (String)para.getPayeeTypeId());
            this.cbxPayeeType.setSelectedIndex(selectIndex);
        }
        String payeeId = para.getPayeeId();
        String payeeName = para.getPayeeName();
        CasRecPayHandler handler = new CasRecPayHandler();
        handler.fillPayeeOrPayer(this.prmtPayee, payeeId, null, payeeName);
        this.kDAudit.setSelected(para.isAudit());
        this.kDPay.setSelected(para.isPay());
        this.kDAuditAndPay.setSelected(para.isAuditAndPay());
        this.isIncludeBankPay.setSelected(para.isIncludeBankPay());
        this.isDealNegative.setSelected(para.isDealNegative());
    }

    protected Class getParamClass() {
        return PayDetailMatchFilterParam.class;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmtCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    private AccountBankCollection getAcctBanks() {
        AccountBankCollection coll = new AccountBankCollection();
        Object acctBanks = this.prmtAcctBank.getValue();
        if (acctBanks instanceof Object[]) {
            Object[] arrays = (Object[])acctBanks;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((AccountBankInfo)arrays[i]);
            }
        } else if (acctBanks instanceof AccountBankInfo) {
            coll.add((AccountBankInfo)acctBanks);
        }
        return coll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.setAcctBank();
        if (e.getNewValue() == null) {
            this.cbxPayeeType.removeAllItems();
            this.cbxPayeeType.setEnabled(false);
            return;
        }
        CompanyOrgUnitInfo company = null;
        if (e.getNewValue() instanceof Object[]) {
            Object[] companys = (Object[])e.getNewValue();
            if (companys.length > 1) {
                this.cbxPayeeType.removeAllItems();
                this.cbxPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
                this.cbxPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
                this.cbxPayeeType.setEnabled(false);
                return;
            }
            if (companys.length != 1) return;
            company = (CompanyOrgUnitInfo)companys[0];
        } else {
            company = (CompanyOrgUnitInfo)e.getNewValue();
        }
        try {
            this.asstActTypeColl = CasRecPayHandler.getAsstActTypeColl((String)company.getId().toString(), (boolean)false, (boolean)false);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
            logger.error((Object)ex);
        }
        this.initAsstActType();
    }

    @Override
    protected void cbxCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.setAcctBank();
    }

    private void setAcctBank() {
        this.prmtAcctBank.setValue(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0));
        if (!FMSysDefinedEnum.ALL_ITEMS.equals(this.cbxCurrency.getSelectedItem()) && !EmptyUtil.isEmpty((Object)this.cbxCurrency.getSelectedItem())) {
            String currencyId = ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.IS));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
        }
        view.setFilter(filter);
        this.prmtAcctBank.setEntityViewInfo(view);
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtAcctBank);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.cbxPayeeType);
        if (this.dpDetailStartDate.getValue() == null || this.dpDetailEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"2_DetailDateError"));
            SysUtil.abort();
        }
        if (this.dpPayStartDate.getValue() == null || this.dpPayEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"3_RecDateError"));
            SysUtil.abort();
        }
        Date detaiStart = DateTimeUtils.truncateDate((Date)((Date)this.dpDetailStartDate.getValue()));
        Date detaiEnd = DateTimeUtils.truncateDate((Date)((Date)this.dpDetailEndDate.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)detaiStart, (Date)detaiEnd);
        Date payStart = DateTimeUtils.truncateDate((Date)((Date)this.dpPayStartDate.getValue()));
        Date payEnd = DateTimeUtils.truncateDate((Date)((Date)this.dpPayEndDate.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)payStart, (Date)payEnd);
        return super.verify();
    }
}

