/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.rpm.PayDetailMatchResultFilterParam;
import com.kingdee.eas.fm.rpm.client.AbstractPayDetailMatchResultFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PayDetailMatchResultFilterUI
extends AbstractPayDetailMatchResultFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PayDetailMatchResultFilterUI.class);
    String PERMISSIONITEM = "rpm_payDetail_01view";
    private static final String resourcePath = "com.kingdee.eas.fm.rpm.RpmResources";

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setVisible(false);
        this.customInit();
    }

    private void customInit() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.cbxCurrency, (boolean)false);
        this.cbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
        Date date = new Date();
        this.dpStartDate.setValue((Object)date);
        this.dpEndDate.setValue((Object)date);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)this.PERMISSIONITEM, (FilterInfo)filter);
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getPermissionItem() {
        return this.PERMISSIONITEM;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmtCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    private AccountBankCollection getAcctBanks() {
        AccountBankCollection coll = new AccountBankCollection();
        Object acctBanks = this.prmtAcctBank.getValue();
        if (acctBanks instanceof Object[]) {
            Object[] arrays = (Object[])acctBanks;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((AccountBankInfo)arrays[i]);
            }
        } else if (acctBanks instanceof AccountBankInfo) {
            coll.add((AccountBankInfo)acctBanks);
        }
        return coll;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.setAcctBank(true);
    }

    @Override
    protected void cbxCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.setAcctBank(true);
    }

    private void setAcctBank(Boolean flag) {
        if (flag.booleanValue()) {
            this.prmtAcctBank.setValue(null);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        if (FMSysDefinedEnum.ALL_ITEMS.equals(this.cbxCurrency.getSelectedItem())) {
            if (!this.cbIsAllAcct.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0));
            }
        } else {
            String currencyId = ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.IS));
            if (!this.cbIsAllAcct.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0));
                filter.setMaskString("#0 and (#1 or #2) and #3)");
            } else {
                filter.setMaskString("#0 and (#1 or #2)");
            }
        }
        view.setFilter(filter);
        this.prmtAcctBank.setEntityViewInfo(view);
    }

    @Override
    protected void cbIsAllAcct_itemStateChanged(ItemEvent e) throws Exception {
        Boolean flag = true;
        if (this.cbIsAllAcct.isSelected()) {
            flag = false;
        }
        this.setAcctBank(flag);
    }

    public Object getParam() {
        int i;
        HashSet<String> idSet;
        CompanyOrgUnitCollection coll;
        PayDetailMatchResultFilterParam param = new PayDetailMatchResultFilterParam();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            coll = this.getMainOrgColl();
            idSet = new HashSet<String>();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setCompanyIdSet(idSet);
        }
        if (FMSysDefinedEnum.ALL_ITEMS.equals(this.cbxCurrency.getSelectedItem())) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getAcctBanks())) {
            coll = this.getAcctBanks();
            idSet = new HashSet();
            for (i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setAccountBankIdSet(idSet);
        }
        param.setStartDate((Date)this.dpStartDate.getValue());
        param.setEndDate((Date)this.dpEndDate.getValue());
        param.setIsAllAcct(this.cbIsAllAcct.isSelected());
        return param;
    }

    public void setParam(Object param) {
        CompanyOrgUnitCollection coll;
        FilterInfo filter;
        EntityViewInfo view;
        if (param == null) {
            return;
        }
        if (!(param instanceof PayDetailMatchResultFilterParam)) {
            return;
        }
        PayDetailMatchResultFilterParam para = (PayDetailMatchResultFilterParam)param;
        if (!EmptyUtil.isEmpty(para.getCompanyIdSet())) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getCompanyIdSet(), CompareType.INCLUDE));
            try {
                coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
        try {
            if (para.getCurrencyId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(para.getCurrencyId());
                this.cbxCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)pk));
            } else {
                this.cbxCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.cbIsAllAcct.setSelected(para.getIsAllAcct().booleanValue());
        if (!EmptyUtil.isEmpty(para.getAccountBankIdSet())) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getAccountBankIdSet(), CompareType.INCLUDE));
            try {
                coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.prmtAcctBank.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtAcctBank.setValue(null);
        }
        this.dpStartDate.setValue((Object)para.getStartDate());
        this.dpEndDate.setValue((Object)para.getEndDate());
    }

    protected Class getParamClass() {
        return PayDetailMatchResultFilterParam.class;
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtAcctBank);
        if (this.dpStartDate.getValue() == null || this.dpEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"11_DateError"));
            SysUtil.abort();
        }
        Date start = DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue()));
        Date end = DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)start, (Date)end);
        return super.verify();
    }
}

