/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.rpm.CommonHelper;
import com.kingdee.eas.fm.rpm.client.AbstractRPDMatchSettingFilterUI;
import com.kingdee.eas.fm.rpm.client.RPDMatchSettingFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPDMatchSettingFilterUI
extends AbstractRPDMatchSettingFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RPDMatchSettingFilterUI.class);
    private Context mainOrgContext;
    private CommonHelper helper = new CommonHelper();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setVisible(false);
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CompanyOrgUnitCollection orgRang = this.getUserOrgRangesWithRange(this.getPermissionItem());
        if (orgRang == null || orgRang.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)this.getPermissionItem()));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany)) {
            this.prmCompany.setValue((Object)orgRang.get(0));
        } else {
            if (!orgRang.contains(currentCompany)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)this.getPermissionItem()));
                SysUtil.abort();
            }
            this.prmCompany.setValue((Object)currentCompany);
        }
        this.txName.setText(null);
        this.txNumber.setText(null);
        this.CBIsEnable.setSelected(true);
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        RPDMatchSettingFilterParam filterParam = (RPDMatchSettingFilterParam)param;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterParam.getMainOrgCollIDSet(), CompareType.INCLUDE));
        try {
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            this.prmCompany.setValue((Object)coll.toArray());
        }
        catch (BOSException e) {
            this.handUIException(e);
            logger.error((Object)e);
        }
        this.txName.setText(filterParam.getName());
        this.txNumber.setText(filterParam.getNumber());
        this.CBIsEnable.setSelected(filterParam.isEnable());
    }

    public Object getParam() {
        RPDMatchSettingFilterParam filterParam = new RPDMatchSettingFilterParam();
        filterParam.setName(this.txName.getText());
        filterParam.setNumber(this.txNumber.getText());
        filterParam.setEnable(this.CBIsEnable.isSelected());
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            filterParam.setMainOrgCollIDSet(idSet);
        }
        return filterParam;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmCompany);
        return true;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmCompany;
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    protected Class getParamClass() {
        return RPDMatchSettingFilterParam.class;
    }

    private CompanyOrgUnitCollection getUserOrgRangesWithRange(String permissionItem) {
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        try {
            UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            Set orgPermSet = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
            if (orgPermSet == null || orgPermSet.size() <= 0) {
                return null;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
            filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgPermSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("accountTable.id", null, CompareType.NOTEQUALS));
            view.setFilter(filter);
            orgColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgColl;
    }
}

