/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.rpm.RPDMatchSettingFactory;
import com.kingdee.eas.fm.rpm.RPDMatchSettingInfo;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.fm.rpm.client.AbstractRPDMatchSettingListUI;
import com.kingdee.eas.fm.rpm.client.RPDMatchSettingFilterUI;
import com.kingdee.eas.fm.rpm.client.RPDMatchSettingUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RPDMatchSettingListUI
extends AbstractRPDMatchSettingListUI {
    private static final Logger logger = CoreUIObject.getLogger(RPDMatchSettingListUI.class);

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RPDMatchSettingFactory.getRemoteInstance();
    }

    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstEntityID", (Object)this.getAsstObjectID()));
        try {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        super.execQuery();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"asstEntityID", (Object)this.getAsstObjectID());
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return RPDMatchSettingUI.class.getName();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        String id = (String)row.getCell("id").getValue();
        RPDMatchSettingInfo info = RPDMatchSettingFactory.getRemoteInstance().getRPDMatchSettingInfo((IObjectPK)new ObjectUuidPK(id));
        if (info != null && info.isIsEnable()) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"25_IsEnable_NotEdit")});
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        String id = (String)row.getCell("id").getValue();
        RPDMatchSettingInfo info = RPDMatchSettingFactory.getRemoteInstance().getRPDMatchSettingInfo((IObjectPK)new ObjectUuidPK(id));
        if (info != null && info.isIsEnable()) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"24_IsEnable_NotRemove")});
        }
        super.actionRemove_actionPerformed(e);
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        boolean isEnable;
        this.checkSelected();
        int[] selectIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> numberSet = new HashSet<String>();
        for (int i = 0; i < selectIndex.length; ++i) {
            numberSet.add((String)this.tblMain.getRow(selectIndex[i]).getCell("number").getValue());
        }
        if (numberSet.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"26_SelectOne"));
            SysUtil.abort();
        }
        if (isEnable = ((Boolean)(row = this.tblMain.getRow(selectIndex[0])).getCell("isEnable").getValue()).booleanValue()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"27_HasEnable"));
            SysUtil.abort();
        }
        String number = (String)numberSet.iterator().next();
        RPDMatchSettingFactory.getRemoteInstance().enable(number, this.getAsstObjectID());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"31_EnableSuccess"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionDisEnable_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        boolean isEnable;
        this.checkSelected();
        int[] selectIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> numberSet = new HashSet<String>();
        for (int i = 0; i < selectIndex.length; ++i) {
            numberSet.add((String)this.tblMain.getRow(selectIndex[i]).getCell("number").getValue());
        }
        if (numberSet.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"26_SelectOne"));
            SysUtil.abort();
        }
        if (!(isEnable = ((Boolean)(row = this.tblMain.getRow(selectIndex[0])).getCell("isEnable").getValue()).booleanValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"29_HasDisEnable"));
            SysUtil.abort();
        }
        String number = (String)numberSet.iterator().next();
        RPDMatchSettingFactory.getRemoteInstance().disEnable(number, this.getAsstObjectID());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"30_DisableSuccess"));
        this.actionRefresh_actionPerformed(e);
    }

    public String getAsstObjectID() {
        return "";
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return new RPDMatchSettingFilterUI();
    }
}

