/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasRecPayUtil;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMBillBaseListUI;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.rpm.client.PayBillClaimListUI;
import com.kingdee.eas.fm.rpm.client.RecBillClaimListUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RPMClaimQueryProcessor
extends FMDefaultQueryProcessor {
    private static Logger logger = Logger.getLogger((String)RPMClaimQueryProcessor.class.getName());
    protected IUIObject owner;
    protected FMFilterBaseUI filter;

    public RPMClaimQueryProcessor(IUIObject owner) {
        this.owner = owner;
        try {
            this.filter = owner instanceof PayBillClaimListUI ? ((PayBillClaimListUI)owner).getFilterUI() : (owner instanceof RecBillClaimListUI ? ((RecBillClaimListUI)owner).getFilterUI() : ((FMBillBaseListUI)owner).getFilterUI());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
    }

    private Object getMainOrgUnit() throws Exception {
        if (this.filter instanceof IMultiOrgSupport && this.filter.getMainOrg() != null) {
            FMFilterBaseUI multiSupportFilter = this.filter;
            Object values = multiSupportFilter.getMainOrg().getValue();
            if (values != null) {
                return values;
            }
        } else {
            return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        MsgBox.showInfo((String)CasRecPayUtil.getMainOrgNullMsg((OrgType)OrgType.Company));
        this.filter.getMainOrg().requestFocus();
        SysUtil.abort();
        return null;
    }

    public void process() throws Exception {
        super.process();
        String field = this.getField();
        Object editor = this.getEditor();
        if (editor instanceof KDBizPromptBox) {
            KDBizPromptBox prmtBox = (KDBizPromptBox)editor;
            String query = prmtBox.getQueryInfo();
            if (FMHelper.isEmpty((String)query)) {
                return;
            }
            Object orgs = this.getMainOrgUnit();
            if (orgs == null) {
                return;
            }
            HashSet<String> cuIdSet = new HashSet<String>();
            HashSet<String> accountTableIdSet = new HashSet<String>();
            if (orgs instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)orgs;
                cuIdSet.add(curCompany.getId().toString());
                accountTableIdSet.add(curCompany.getAccountTable().getId().toString());
            } else if (orgs instanceof Object[]) {
                Object[] coms = (Object[])orgs;
                for (int i = 0; i < coms.length; ++i) {
                    CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)coms[i];
                    cuIdSet.add(curCompany.getId().toString());
                    accountTableIdSet.add(curCompany.getAccountTable().getId().toString());
                }
            }
            EntityViewInfo evi = null;
            if (field.equalsIgnoreCase("oppAccount.name") || field.equalsIgnoreCase("oppAccount.id")) {
                this.setEntryOppAcctEvi(prmtBox, null);
            }
            if (field.equalsIgnoreCase("payeeAccount.name")) {
                evi = CasRecPayHandler.getCustomAcctEvi(cuIdSet, accountTableIdSet, (boolean)true);
                prmtBox.setEntityViewInfo(evi);
            }
            if (field.equalsIgnoreCase("payerAccount.name")) {
                evi = CasRecPayHandler.getCustomAcctEvi(cuIdSet, accountTableIdSet, (boolean)true);
                prmtBox.setEntityViewInfo(evi);
            }
            if (field.equalsIgnoreCase("acctView.number")) {
                evi = CasRecPayHandler.getCustomAcctEvi(cuIdSet, accountTableIdSet, (boolean)true);
                prmtBox.setEntityViewInfo(evi);
            }
            if ("com\\kingdee\\eas\\basedata\\assistant\\app\\F7AccountBankQuery".equalsIgnoreCase(query)) {
                if (!field.equalsIgnoreCase("actRecAccountBank.bankAccountNumber")) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("company.id", cuIdSet, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    prmtBox.setEntityViewInfo(ev);
                } else {
                    EntityViewInfo ev = new EntityViewInfo();
                    prmtBox.setEntityViewInfo(ev);
                }
                return;
            }
        } else if (editor instanceof KDDatePicker && field.equalsIgnoreCase("expectDealTime")) {
            ((KDDatePicker)editor).setTimeEnabled(false);
            ((KDDatePicker)editor).setMilliSecondEnable(false);
        }
    }

    private void setEntryOppAcctEvi(KDBizPromptBox prmtOppAccountEntry, String currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String companyId = currentCompany.getId().toString();
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)companyId, (String)companyId, (String)currencyId, (boolean)false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)companyId, (String)companyId, (String)currencyId, (boolean)true);
        AccountPromptBox opseelect = new AccountPromptBox(this.owner, currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }
}

