/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.rpm.CommonHelper;
import com.kingdee.eas.fm.rpm.client.AbstractRecBillClaimFilterUI;
import com.kingdee.eas.fm.rpm.client.RecBillClaimFilterParam;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RecBillClaimFilterUI
extends AbstractRecBillClaimFilterUI
implements ISharedOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(RecBillClaimFilterUI.class);
    private boolean isSharedOrg = true;
    private CommonHelper helper = new CommonHelper();

    public Object getParam() {
        RecBillClaimFilterParam param = new RecBillClaimFilterParam();
        param.setBillDateFrom((Date)this.pkDateFrom.getValue());
        param.setBillDateTo((Date)this.pkDateTo.getValue());
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setMainOrgCollIDSet(idSet);
        }
        if (this.comboCurrency.getSelectedItem() == null || this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.comboBillStatus.getSelectedItem() == null || this.comboBillStatus.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setBillStatus(999);
        } else {
            param.setBillStatus(((BillStatusEnum)this.comboBillStatus.getSelectedItem()).getValue());
        }
        if (this.comboPayerType.getSelectedItem() != null && !this.comboPayerType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            if (this.comboPayerType.getSelectedItem() == FMSysDefinedEnum.OTHER) {
                param.setPayerTypeId("null");
            } else {
                param.setPayerTypeId(((DataBaseInfo)this.comboPayerType.getSelectedItem()).getId().toString());
            }
        }
        if (this.prmtPayer.getData() != null) {
            if (this.prmtPayer.getData() instanceof InnerAccountInfo) {
                param.setPayerId(((InnerAccountInfo)this.prmtPayer.getData()).getId().toString());
                param.setPayerName(((InnerAccountInfo)this.prmtPayer.getData()).getName());
            } else {
                param.setPayerId(((DataBaseInfo)this.prmtPayer.getData()).getId().toString());
                param.setPayerName(((DataBaseInfo)this.prmtPayer.getData()).getName());
            }
        }
        HashSet<Integer> status = new HashSet<Integer>();
        if (this.ckbStatus1.isSelected()) {
            status.add(10);
        }
        if (this.ckbStatus2.isSelected()) {
            status.add(20);
        }
        if (this.ckbStatus3.isSelected()) {
            status.add(30);
        }
        param.setBillClaimStatus(status);
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        RecBillClaimFilterParam filterParam = (RecBillClaimFilterParam)param;
        if (!EmptyUtil.isEmpty((Collection)filterParam.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterParam.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
        this.pkDateFrom.setValue((Object)filterParam.getBillDateFrom());
        this.pkDateTo.setValue((Object)filterParam.getBillDateTo());
        try {
            if (filterParam.getCurrencyId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(filterParam.getCurrencyId());
                this.comboCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)pk));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filterParam.getBillStatus() == 999) {
            this.comboBillStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillStatus.setSelectedItem((Object)BillStatusEnum.getEnum((int)filterParam.getBillStatus()));
        }
        if (filterParam.getPayerTypeId() == null) {
            this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            int selectIndex = BookNotifyClientHelper.getSelectIndex((KDComboBox)this.comboPayerType, (String)filterParam.getPayerTypeId());
            this.comboPayerType.setSelectedIndex(selectIndex);
        }
        String payerId = filterParam.getPayerId();
        String payerName = filterParam.getPayerName();
        CasRecPayHandler handler = new CasRecPayHandler();
        handler.fillPayeeOrPayer(this.prmtPayer, payerId, null, payerName);
        if (filterParam.getBillClaimStatus() != null) {
            if (filterParam.getBillClaimStatus().contains(String.valueOf(10))) {
                this.ckbStatus1.setSelected(true);
            } else {
                this.ckbStatus1.setSelected(false);
            }
            if (filterParam.getBillClaimStatus().contains(String.valueOf(20))) {
                this.ckbStatus2.setSelected(true);
            } else {
                this.ckbStatus2.setSelected(false);
            }
            if (filterParam.getBillClaimStatus().contains(String.valueOf(30))) {
                this.ckbStatus3.setSelected(true);
            } else {
                this.ckbStatus3.setSelected(false);
            }
        }
    }

    protected Class getParamClass() {
        return RecBillClaimFilterParam.class;
    }

    protected void init() throws Exception {
        super.init();
        this.customInit();
    }

    private void customInit() throws Exception {
        Date date = new Date();
        this.pkDateFrom.setValue((Object)date);
        this.pkDateTo.setValue((Object)date);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            CompanyOrgUnitCollection orgRang = this.helper.getUserOrgRangesWithRange(null, "rpm_recClaim_01view");
            if (orgRang == null) {
                this.prmtCompany.setValue((Object)this.currentCompany);
                return;
            }
            for (int i = 0; i < orgRang.size(); ++i) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                if (!company.isIsBizUnit() || company.isIsOUSealUp()) continue;
                this.prmtCompany.setValue((Object)company);
                break;
            }
        } else {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        CurrencyCollection currencyColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        if (currencyColl == null) {
            CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        } else {
            CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (CurrencyCollection)currencyColl, (boolean)false);
        }
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initBillStatus(this.comboBillStatus);
        AsstActTypeCollection asstActTypeColl = this.helper.getAsstActTypeColl(this.currentCompany.getId().toString(), false, false);
        if (asstActTypeColl.size() < 1) {
            asstActTypeColl = CasRecPayHandler.getAsstActTypeColl(null, (boolean)false, (boolean)false);
        }
        if (asstActTypeColl != null) {
            int i;
            ActionListener[] actionListener = this.comboPayerType.getActionListeners();
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayerType.removeActionListener(actionListener[i]);
            }
            this.comboPayerType.removeAllItems();
            this.comboPayerType.addItems(asstActTypeColl.toArray());
            this.comboPayerType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayerType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayerType.addActionListener(actionListener[i]);
            }
        }
        this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.ckbStatus1.setSelected(true);
        this.ckbStatus2.setSelected(true);
        this.ckbStatus3.setSelected(false);
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)BillStatusEnum.SAVE);
        combo.addItem((Object)BillStatusEnum.SUBMIT);
        combo.addItem((Object)BillStatusEnum.AUDITED);
        combo.addItem((Object)BillStatusEnum.RECED);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.getNewOrg() == null) {
            this.comboPayerType.removeAllItems();
            return;
        }
        CompanyOrgUnitInfo company = null;
        Boolean mulCompany = false;
        if (chgVo.getNewOrg() instanceof Object[]) {
            Object[] companys = (Object[])chgVo.getNewOrg();
            if (companys.length > 1) {
                this.comboPayerType.setEnabled(false);
            } else {
                this.comboPayerType.setEnabled(true);
            }
            if (companys.length == 0) return;
            company = (CompanyOrgUnitInfo)companys[0];
            if (companys.length > 1) {
                mulCompany = true;
            }
        } else {
            this.comboPayerType.setEnabled(true);
            company = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        }
        AsstActTypeCollection asstActTypeColl = null;
        try {
            asstActTypeColl = mulCompany.booleanValue() ? new AsstActTypeCollection() : this.helper.getAsstActTypeColl(company.getId().toString(), false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (asstActTypeColl.size() > 1) {
            int i;
            ActionListener[] actionListener = this.comboPayerType.getActionListeners();
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayerType.removeActionListener(actionListener[i]);
            }
            this.comboPayerType.removeAllItems();
            this.comboPayerType.addItems(asstActTypeColl.toArray());
            this.comboPayerType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayerType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayerType.addActionListener(actionListener[i]);
            }
        } else {
            this.comboPayerType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    protected void comboPayerType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayer.setValue(null);
        if (this.comboPayerType.getSelectedItem() == null || !(this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayer.setEnabled(false);
            this.prmtPayer.setData(null);
            return;
        }
        if (this.prmtPayer.isEnabled() && this.prmtPayer.getData() != null) {
            return;
        }
        this.prmtPayer.setEnabled(true);
        this.prmtPayer.setData(null);
        this.prmtPayer.setSelector(null);
        this.prmtPayer.setFilterInfoProducer(null);
        AsstActTypeInfo info = (AsstActTypeInfo)this.comboPayerType.getSelectedItem();
        this.prmtPayer.setSelector(null);
        this.prmtPayer.setFilterInfoProducer(null);
        CasRecPayHandler handler = new CasRecPayHandler();
        CompanyOrgUnitInfo company = this.getMainOrgColl().get(0);
        if (company == null) {
            company = this.currentCompany;
        }
        handler.setAsstActSelectorByCU((CoreUIObject)this, this.prmtPayer, info, company, false);
        if (info.getAsstHGAttribute().equalsIgnoreCase("innerAccount")) {
            info.setIsForCompany(false);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtPayer.setEntityViewInfo(evi);
        }
        this.prmtPayer.setDisplayFormat("$number$ $name$");
        this.prmtPayer.setCommitFormat("$number$;$name$");
        this.prmtPayer.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", this.prmtPayer));
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmtCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        if (this.pkDateFrom.getValue() == null || this.pkDateTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"327_CasPaymentFilterUI"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.pkDateFrom.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.pkDateTo.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            logger.info((Object)e);
            logger.error((Object)e);
        }
    }

    public String getPermissionItem() {
        return "rpm_recClaim_01view";
    }

    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }

    public boolean isSupportMultiOrgs() {
        return this.isSharedOrg();
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }
}

