/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.rpm.IRPDMatchResult;
import com.kingdee.eas.fm.rpm.RPDMatchResultFactory;
import com.kingdee.eas.fm.rpm.RecDetailMatchFacadeFactory;
import com.kingdee.eas.fm.rpm.RecDetailMatchResultFilterParam;
import com.kingdee.eas.fm.rpm.client.AbstractRecDetailMatchResultUI;
import com.kingdee.eas.fm.rpm.client.RecDetailMatchResultFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecDetailMatchResultUI
extends AbstractRecDetailMatchResultUI {
    private static final Logger logger = CoreUIObject.getLogger(RecDetailMatchResultUI.class);
    boolean isDirectShow = false;
    private final String SELECT = "selected";
    private static final String TRANSDETAIL = "com.kingdee.eas.fm.be.app.TransDetail";
    private static final String RECBILL = "com.kingdee.eas.fi.cas.app.ReceivingBill";
    private static final String resourcePath = "com.kingdee.eas.fm.rpm.RpmResources";
    private CurrencyInfo currency = this.currentCompanyCommon.getBaseCurrency();
    private RecDetailMatchResultFilterUI filter = null;
    private static final String RecDetailFiterParam = "PARAM_RPD_FILTER_PARAM";
    Map<String, String> keyComMap = new HashMap<String, String>();
    Set<String> idSet = new HashSet<String>();
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.actionAntiMatch.setEnabled(true);
        this.actionSelectAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionClearAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionAntiMatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            this.filter = new RecDetailMatchResultFilterUI();
        }
        return this.filter;
    }

    protected IRPDMatchResult getBizInterface() throws Exception {
        return RPDMatchResultFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public static void showMatchResultUI(CoreUIObject ui, Set<String> matchResultKeys, CurrencyInfo currency) {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"METADATA.PK", (Object)new MetaDataPK("com.kingdee.eas.fm.rpm.client", "RecDetailMatchResultUI"));
        uiContext.put((Object)"currency", (Object)currency);
        if (!EmptyUtil.isEmpty(matchResultKeys)) {
            uiContext.put((Object)"matchResultKeys", matchResultKeys);
            uiContext.put((Object)"isDirectShow", (Object)true);
        }
        try {
            IUIWindow listUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RecDetailMatchResultUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            listUI.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SysUtil.abort();
        }
    }

    protected boolean isDirectShow() {
        if (!EmptyUtil.isEmpty(this.getUIContext().get("isDirectShow"))) {
            this.isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
        }
        return this.isDirectShow;
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void execQuery() {
        if (this.isDirectShow) {
            if (this.getUIContext().get("currency") != null) {
                this.prmtCurrency.setValue(this.getUIContext().get("currency"));
            } else {
                this.prmtCurrency.setValue((Object)EASResource.getString((String)resourcePath, (String)"4_ALL"));
            }
            FilterInfo filter = new FilterInfo();
            if (!EmptyUtil.isEmpty(this.getUIContext().get("matchResultKeys"))) {
                filter.getFilterItems().add(new FilterItemInfo("key", this.getUIContext().get("matchResultKeys"), CompareType.INCLUDE));
            }
            try {
                if (this.mainQuery.getFilter() == null) {
                    this.mainQuery.setFilter(filter);
                } else {
                    this.mainQuery.getFilter().mergeFilter(filter, "AND");
                }
                RecDetailMatchResultFilterParam filterParam = new RecDetailMatchResultFilterParam();
                SorterItemCollection sort = filterParam.getSorterItems();
                this.mainQuery.setSorter(sort);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            this.actionQuery.setVisible(false);
            this.actionRefresh.setVisible(false);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            try {
                Set keySet = this.getBizInterface().getKeysByFilterInfo(this.mainQuery.getFilter(), RECBILL);
                if (keySet.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("key", (Object)keySet, CompareType.INCLUDE));
                    this.mainQuery.setFilter(filterInfo);
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("resultType", (Object)-1));
                    this.mainQuery.setFilter(filterInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
        this.idSet.clear();
        this.keyComMap.clear();
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
        RecDetailMatchResultFilterParam params = (RecDetailMatchResultFilterParam)param;
        try {
            if (params.getCurrencyId() != null) {
                this.currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(params.getCurrencyId()));
                this.prmtCurrency.setValue((Object)this.currency);
            } else {
                this.prmtCurrency.setValue((Object)EASResource.getString((String)resourcePath, (String)"4_ALL"));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException();
        }
        Date startDate = params.getStartDate();
        Date endDate = params.getEndDate();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.txtStartDate.setText(df.format(startDate));
        this.txtEndDate.setText(df.format(endDate));
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        this.idSet.clear();
        this.keyComMap.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)Boolean.TRUE);
            String key = (String)this.tblMain.getRow(i).getCell("key").getValue();
            this.idSet.add(key);
            String companyId = (String)this.tblMain.getRow(i).getCell("company.id").getValue();
            this.keyComMap.put(key, companyId);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    protected Set<String> getResultSetSelected() throws Exception {
        return this.idSet;
    }

    protected Map<String, String> getSelectedKeyComMap() throws Exception {
        return this.keyComMap;
    }

    @Override
    public void actionAntiMatch_actionPerformed(ActionEvent e) throws Exception {
        Set<String> idSet = this.getResultSetSelected();
        Map<String, String> keyComMap = this.getSelectedKeyComMap();
        if (idSet.size() > 0) {
            Map map = RecDetailMatchFacadeFactory.getRemoteInstance().antiMatch(idSet, keyComMap);
            String summaryMsg = map.get("summaryMsg").toString();
            String detailMsgList = "";
            if (map.get("detailMsgList") != null) {
                ArrayList list = (ArrayList)map.get("detailMsgList");
                for (int i = 0; i < list.size(); ++i) {
                    detailMsgList = detailMsgList + (String)list.get(i) + "\n";
                }
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)summaryMsg, (String)detailMsgList, (int)2);
            this.refresh(e);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"SelectCheckoutMsg"));
            SysUtil.abort();
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        Object value;
        int index = e.getRowIndex();
        if (e.getColIndex() == this.tblMain.getColumn("selected").getColumnIndex() && (value = e.getValue()) != null) {
            String key = (String)this.tblMain.getRow(index).getCell("key").getValue();
            String companyId = (String)this.tblMain.getRow(index).getCell("company.id").getValue();
            if (((Boolean)value).booleanValue()) {
                this.idSet.add(key);
                this.keyComMap.put(key, companyId);
            } else {
                this.idSet.remove(key);
                this.keyComMap.remove(key);
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.executeQuery(this.getFilterParam());
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                IRow row = RecDetailMatchResultUI.this.tblMain.getRow(i);
                row.getCell("selected").setValue((Object)false);
                row.getCell("selected").getStyleAttributes().setLocked(false);
                if (row.getCell("bizObjectFullName").getValue().equals(RecDetailMatchResultUI.TRANSDETAIL)) {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)RecDetailMatchResultUI.resourcePath, (String)"10_TransDeatil"));
                } else {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)RecDetailMatchResultUI.resourcePath, (String)"8_RecBill"));
                }
                String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)RecDetailMatchResultUI.this.currency.getId());
                RecDetailMatchResultUI.this.tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(numberFmt);
                RecDetailMatchResultUI.this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

