/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.CasReceivingBillListUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.be.client.TransDetailListUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.rpm.RPDMatchResultCollection;
import com.kingdee.eas.fm.rpm.RPDMatchSettingHelper;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.fm.rpm.RecDetailMatchFacadeFactory;
import com.kingdee.eas.fm.rpm.RecDetailMatchFilterParam;
import com.kingdee.eas.fm.rpm.client.AbstractRecDetailMatchUI;
import com.kingdee.eas.fm.rpm.client.RPDMatchQueryProcessor;
import com.kingdee.eas.fm.rpm.client.RecDetailMatchFilterUI;
import com.kingdee.eas.fm.rpm.client.RecDetailMatchResultUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecDetailMatchUI
extends AbstractRecDetailMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(RecDetailMatchUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.rpm.RpmResources";
    private int scale = 4;
    private static final String SELECT = "select";
    private CommonQueryDialog queryDialog;
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "CasReceivingBillQuery");
    private RecDetailMatchFilterUI filterUI;
    private RecDetailMatchFilterParam filterParam;
    private BigDecimal detailAmt = BigDecimal.ZERO;
    private BigDecimal recAmt = BigDecimal.ZERO;
    private BigDecimal detailTotalAmt = BigDecimal.ZERO;
    private BigDecimal recTotalAmt = BigDecimal.ZERO;
    private final String DETAILAMTCOL = "creditAmount";
    private final String RECAMTCOL = "actRecAmt";
    private Map<String, Map<String, List<String>>> mapAll = new HashMap<String, Map<String, List<String>>>();
    private Map<String, Map<String, List<String>>> idListMap = new HashMap<String, Map<String, List<String>>>();
    private Set<String> selCompanyIdSet = new HashSet<String>();
    private Set<String> acctBankIdSet = new HashSet<String>();
    private final String TRANSDETAIL = "com.kingdee.eas.fm.be.app.TransDetail";
    private final String RECBILL = "com.kingdee.eas.fi.cas.app.ReceivingBill";
    private boolean isFristSortTable_Detial = true;
    private boolean isFristSortTable_Rec = true;
    private ISortManager sm_Detail = null;
    private ISortManager sm_Rec = null;
    private int sort_Detail = 0;
    private int sort_Rec = 0;
    private SorterItemInfo pre_order_Detail = new SorterItemInfo("company.name");
    private SorterItemInfo pre_order_Rec = new SorterItemInfo("company.name");
    private SorterItemInfo current_order_Detail = (SorterItemInfo)this.pre_order_Detail.clone();
    private SorterItemInfo current_order_Rec = (SorterItemInfo)this.pre_order_Rec.clone();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.showFilterUI(this.mainQueryPK.getFullName());
        this.handlerRecDetailEntityView(false);
        this.initTable();
        this.initUI();
        this.initAmt();
    }

    public void showFilterUI(String queryName) throws Exception {
        if (this.filterParam != null) {
            return;
        }
        if (this.getUIContext().containsKey("isDirectShow") && ((Boolean)this.getUIContext().get("isDirectShow")).booleanValue()) {
            this.getFilterUI();
            this.getQueryDialog();
            this.filterParam = (RecDetailMatchFilterParam)this.getUIContext().get("filterParam");
            FMFilterBaseUI fui = this.getFilterUI();
            if (fui != null) {
                fui.onLoad();
                try {
                    fui.setParam((Object)this.filterParam);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
        if (ds != null) {
            QueryPanelCollection queryPanelInfo = ds.getQueryPanelInfo();
            this.getFilterUI();
            this.getQueryDialog();
            if (queryPanelInfo.size() > 0) {
                for (int i = 0; i < queryPanelInfo.size(); ++i) {
                    String filterUICName = this.filterUI.getMetaDataPK().getFullName();
                    if (!filterUICName.equals(queryPanelInfo.get(i).getPanelClassName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.get(i).getCustomerParams());
                    if (cp == null) break;
                    this.filterParam = (RecDetailMatchFilterParam)this.filterUI.getFilterParamFromCP(cp);
                }
            }
            if (this.filterParam == null) {
                this.filterParam = this.getDefaultQueryParam();
            }
        } else if (!this.getQueryDialog().show()) {
            SysUtil.abort();
        }
    }

    private RecDetailMatchFilterParam getDefaultQueryParam() {
        RecDetailMatchFilterParam param = (RecDetailMatchFilterParam)this.filterUI.getParam();
        return param;
    }

    private void initUI() throws EASBizException, BOSException {
        String end;
        String start;
        if (!EmptyUtil.isEmpty((String)this.filterParam.getCurrencyId())) {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.filterParam.getCurrencyId()));
            this.prmtCurrency.setValue((Object)currency);
            this.scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currency.getId());
        } else {
            this.prmtCurrency.setValue((Object)EASResource.getString((String)resourcePath, (String)"4_ALL"));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getDetailStartDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getDetailEndDate())) {
            start = df.format(this.filterParam.getDetailStartDate());
            end = df.format(this.filterParam.getDetailEndDate());
            this.txtTransDetailDate.setText(start + EASResource.getString((String)resourcePath, (String)"5_TO") + end);
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getRecStartDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getRecEndDate())) {
            start = df.format(this.filterParam.getRecStartDate());
            end = df.format(this.filterParam.getRecEndDate());
            this.txtRecBizDate.setText(start + EASResource.getString((String)resourcePath, (String)"5_TO") + end);
        }
    }

    private void handlerRecDetailEntityView(boolean isCustomize) throws BOSException {
        Date end;
        Date start;
        this.transDetailQuery = new EntityViewInfo();
        this.recBillQuery = new EntityViewInfo();
        FilterInfo recFilter = new FilterInfo();
        FilterInfo detailFilter = new FilterInfo();
        detailFilter.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)0, CompareType.NOTEQUALS));
        detailFilter.getFilterItems().add(new FilterItemInfo("isReced", (Object)0));
        detailFilter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)0));
        detailFilter.getFilterItems().add(new FilterItemInfo("isBankWithHolding", (Object)0));
        detailFilter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)0));
        this.filterParam = (RecDetailMatchFilterParam)this.filterUI.getParam();
        if (!EmptyUtil.isEmpty(this.filterParam.getCompanyIdSet())) {
            Set<String> companyIdSet = this.filterParam.getCompanyIdSet();
            detailFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
            recFilter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        }
        if (this.filterParam.getCurrencyId() != null) {
            String currencyId = this.filterParam.getCurrencyId();
            detailFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
            recFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!EmptyUtil.isEmpty(this.filterParam.getAccountBankIdSet())) {
            Set<String> acctBankIdSet = this.filterParam.getAccountBankIdSet();
            detailFilter.getFilterItems().add(new FilterItemInfo("bankAccount.id", acctBankIdSet, CompareType.INCLUDE));
            recFilter.getFilterItems().add(new FilterItemInfo("payeeAccountBank.id", acctBankIdSet, CompareType.INCLUDE));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getDetailStartDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getDetailEndDate())) {
            start = DateHelper.truncateDate((Date)this.filterParam.getDetailStartDate());
            end = DateHelper.truncateDate((Date)this.filterParam.getDetailEndDate());
            end = DateHelper.getAfterDay((Date)end);
            detailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)start, CompareType.GREATER_EQUALS));
            detailFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)end, CompareType.LESS));
        }
        if (!this.filterParam.isIncludeTrancedown()) {
            detailFilter.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)0));
        }
        if (!EmptyUtil.isEmpty((Object)this.filterParam.getRecStartDate()) && !EmptyUtil.isEmpty((Object)this.filterParam.getRecEndDate())) {
            start = DateHelper.truncateDate((Date)this.filterParam.getRecStartDate());
            end = DateHelper.truncateDate((Date)this.filterParam.getRecEndDate());
            end = DateHelper.getAfterDay((Date)end);
            recFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)start, CompareType.GREATER_EQUALS));
            recFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)end, CompareType.LESS));
        }
        if (this.filterParam.getPayerTypeId() != null) {
            if (this.filterParam.getPayerTypeId().equals("null")) {
                recFilter.getFilterItems().add(new FilterItemInfo("payerType.id", null, CompareType.IS));
            } else if (!EmptyUtil.isEmpty((String)this.filterParam.getPayerTypeId())) {
                String payerTypeId = this.filterParam.getPayerTypeId();
                recFilter.getFilterItems().add(new FilterItemInfo("payerType.id", (Object)payerTypeId));
            }
        }
        if (!EmptyUtil.isEmpty((String)this.filterParam.getPayerId())) {
            recFilter.getFilterItems().add(new FilterItemInfo("payerid", (Object)this.filterParam.getPayerId()));
        }
        if (!EmptyUtil.isEmpty((String)this.filterParam.getPayerName())) {
            recFilter.getFilterItems().add(new FilterItemInfo("payername", (Object)this.filterParam.getPayerName()));
        }
        FilterInfo statusFilter = new FilterInfo();
        if (this.filterParam.isAudit()) {
            statusFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)12));
        } else if (this.filterParam.isRec()) {
            statusFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)14));
        } else {
            statusFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)12));
            statusFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)14));
            statusFilter.setMaskString("#0 or #1");
        }
        recFilter.mergeFilter(statusFilter, "AND");
        EntityViewInfo entity = this.queryDialog.getEntityViewInfoResult();
        FilterInfo comFilter = entity.getFilter();
        recFilter.mergeFilter(comFilter, "AND");
        this.transDetailQuery.setFilter(detailFilter);
        this.recBillQuery.setFilter(recFilter);
        this.transDetailQuery.setSorter(this.transDetailSort(isCustomize));
        this.recBillQuery.setSorter(this.recBillSort(isCustomize));
    }

    protected SorterItemCollection transDetailSort(boolean isCustomize) {
        SorterItemCollection sort = new SorterItemCollection();
        if (isCustomize) {
            sort.add(this.current_order_Detail);
            if (this.pre_order_Detail != null && !this.pre_order_Detail.getPropertyName().equals(this.current_order_Detail.getPropertyName())) {
                sort.add(this.pre_order_Detail);
            }
        } else {
            SorterItemInfo comSort = new SorterItemInfo("company.name");
            comSort.setSortType(SortType.DESCEND);
            SorterItemInfo acctSort = new SorterItemInfo("bankAccount.bankAccountNumber");
            acctSort.setSortType(SortType.DESCEND);
            SorterItemInfo timeSort = new SorterItemInfo("bizTime");
            timeSort.setSortType(SortType.DESCEND);
            sort.add(comSort);
            sort.add(acctSort);
            sort.add(timeSort);
        }
        return sort;
    }

    protected SorterItemCollection recBillSort(boolean isCustomize) {
        SorterItemCollection sort = new SorterItemCollection();
        if (isCustomize) {
            sort.add(this.current_order_Rec);
            if (this.pre_order_Rec != null && !this.pre_order_Rec.getPropertyName().equals(this.current_order_Rec.getPropertyName())) {
                sort.add(this.pre_order_Rec);
            }
        } else {
            SorterItemInfo comSort = new SorterItemInfo("company.name");
            comSort.setSortType(SortType.DESCEND);
            SorterItemInfo acctSort = new SorterItemInfo("payeeAccountBank.bankAccountNumber");
            acctSort.setSortType(SortType.DESCEND);
            SorterItemInfo timeSort = new SorterItemInfo("bizDate");
            timeSort.setSortType(SortType.DESCEND);
            SorterItemInfo actRecAmtSort = new SorterItemInfo("actRecAmt");
            actRecAmtSort.setSortType(SortType.DESCEND);
        }
        return sort;
    }

    protected void initTable() {
        this.tblRec.checkParsed();
        this.tblDetail.checkParsed();
        this.tblDetail.getStyleAttributes().setLocked(true);
        this.tblRec.getStyleAttributes().setLocked(true);
        this.tblDetail.getSelectManager().setSelectMode(2);
        this.tblRec.getSelectManager().setSelectMode(2);
        this.tblDetail.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                RecDetailMatchUI.this.afterFillDetailTable(e);
            }
        });
        this.tblRec.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                RecDetailMatchUI.this.afterFillRecTable(e);
            }
        });
        this.splitRD.setDividerLocation(this.getHeight() / 2 + 50);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionSelectAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionClearAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionSet.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.actionManualMatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionAutoMatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.actionQueryMatchResult.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.actionViewBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected void afterFillRecTable(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblRec.getRow(i);
            row.getCell(SELECT).setValue((Object)false);
        }
        this.tblRec.getColumn("actRecAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblRec.getColumn("actRecAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblRec.getColumn("actRecLocAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblRec.getColumn("actRecLocAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void afterFillDetailTable(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblDetail.getRow(i);
            row.getCell("bizType").setValue((Object)BizTypeEnum.getEnum((int)((Integer)row.getCell("bizType").getValue())));
            row.getCell(SELECT).setValue((Object)false);
        }
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblDetail.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected String[] getNotOrderColumns_Detail() {
        return null;
    }

    protected String[] getNotOrderColumns_Rec() {
        return null;
    }

    private void orderByForTable_Detail(KDTMouseEvent e) throws Exception {
        String columnName;
        if (this.isFristSortTable_Detial) {
            this.sm_Detail = new KDTSortManager(this.tblDetail);
            this.isFristSortTable_Detial = false;
        }
        if ((columnName = this.tblDetail.getColumn(e.getColIndex()).getFieldName()) == null) {
            return;
        }
        if (this.getNotOrderColumns_Detail() != null && this.getNotOrderColumns_Detail().length > 0) {
            for (int i = 0; i < this.getNotOrderColumns_Detail().length; ++i) {
                if (!this.getNotOrderColumns_Detail()[i].equalsIgnoreCase(columnName) && columnName.indexOf("attacheMentId") < 0) continue;
                return;
            }
        }
        this.sort_Detail = this.sort_Detail == 0 ? 1 : 0;
        this.sm_Detail.sort(e.getColIndex(), this.sort_Detail);
        SorterItemInfo sortName = new SorterItemInfo(this.tblDetail.getColumn(e.getColIndex()).getFieldName());
        sortName.setSortType(this.sort_Detail == 0 ? SortType.ASCEND : SortType.DESCEND);
        if (this.pre_order_Detail == null) {
            this.pre_order_Detail = (SorterItemInfo)sortName.clone();
            this.current_order_Detail = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Detail != null && !this.current_order_Detail.getPropertyName().equals(sortName.getPropertyName())) {
            this.pre_order_Detail = (SorterItemInfo)this.current_order_Detail.clone();
            this.current_order_Detail = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Detail != null && this.current_order_Detail.getPropertyName().equals(sortName.getPropertyName())) {
            this.current_order_Detail = (SorterItemInfo)sortName.clone();
        }
        this.handlerRecDetailEntityView(true);
        this.refreshDetailTable();
    }

    private void orderByForTable_Rec(KDTMouseEvent e) throws Exception {
        String columnName;
        if (this.isFristSortTable_Rec) {
            this.sm_Rec = new KDTSortManager(this.tblRec);
            this.isFristSortTable_Rec = false;
        }
        if ((columnName = this.tblRec.getColumn(e.getColIndex()).getFieldName()) == null) {
            return;
        }
        if (this.getNotOrderColumns_Rec() != null && this.getNotOrderColumns_Rec().length > 0) {
            for (int i = 0; i < this.getNotOrderColumns_Rec().length; ++i) {
                if (!this.getNotOrderColumns_Rec()[i].equalsIgnoreCase(columnName) && columnName.indexOf("attacheMentId") < 0) continue;
                return;
            }
        }
        this.sort_Rec = this.sort_Rec == 0 ? 1 : 0;
        this.sm_Rec.sort(e.getColIndex(), this.sort_Rec);
        SorterItemInfo sortName = new SorterItemInfo(this.tblRec.getColumn(e.getColIndex()).getFieldName());
        sortName.setSortType(this.sort_Rec == 0 ? SortType.ASCEND : SortType.DESCEND);
        if (this.pre_order_Rec == null) {
            this.pre_order_Rec = (SorterItemInfo)sortName.clone();
            this.current_order_Rec = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Rec != null && !this.current_order_Rec.getPropertyName().equals(sortName.getPropertyName())) {
            this.pre_order_Rec = (SorterItemInfo)this.current_order_Rec.clone();
            this.current_order_Rec = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Rec != null && this.current_order_Rec.getPropertyName().equals(sortName.getPropertyName())) {
            this.current_order_Rec = (SorterItemInfo)sortName.clone();
        }
        this.handlerRecDetailEntityView(true);
        this.refreshRecTable();
    }

    @Override
    protected void tblDetail_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.orderByForTable_Detail(e);
            return;
        }
        int selectColumn = this.tblDetail.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblDetail.getColumnIndex(SELECT))) {
            return;
        }
        int activeRowIndex = this.tblDetail.getSelectManager().getActiveRowIndex();
        IRow row = this.tblDetail.getRow(activeRowIndex);
        boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
        row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
        this.calDetailAmt(true, row, !isSelected);
    }

    @Override
    protected void tblRec_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.orderByForTable_Rec(e);
            return;
        }
        int selectColumn = this.tblRec.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblRec.getColumnIndex(SELECT))) {
            return;
        }
        int activeRowIndex = this.tblRec.getSelectManager().getActiveRowIndex();
        IRow row = this.tblRec.getRow(activeRowIndex);
        boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
        row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
        this.calRecAmt(true, row, !isSelected);
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this.queryDialog == null) {
            IMetaDataPK mockQuery = this.mainQueryPK;
            this.queryDialog = new CommonQueryDialog();
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setShowFilter(true);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setQueryObjectPK(mockQuery);
            this.queryDialog.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDialog.setTitle(EASResource.getString((String)resourcePath, (String)"1_FilterTitle"));
            this.queryDialog.setHeight(320);
            this.queryDialog.setWidth(450);
            this.queryDialog.setProcessor((IProcessor)this.getQueryProcessor());
            if (this.queryDialog.getWindow() == null) {
                this.queryDialog.init();
            }
            this.queryDialog.getCommonQueryParam().setDirty(false);
            this.queryDialog.getCommonqueryPanel().disVisiableRowCount();
        }
        return this.queryDialog;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new RPDMatchQueryProcessor((IUIObject)this);
    }

    protected FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RecDetailMatchFilterUI();
            this.filterUI.onLoad();
        }
        return this.filterUI;
    }

    protected KDTable getDetailTable() {
        return this.tblDetail;
    }

    protected KDTable getRecTable() {
        return this.tblRec;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int delRowCount = this.tblDetail.getRowCount3();
        int recRowCount = this.tblRec.getRowCount3();
        if (delRowCount <= 0 && recRowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        for (i = 0; i < delRowCount; ++i) {
            if (this.tblDetail.getRow2(i) == null) continue;
            this.tblDetail.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        for (i = 0; i < recRowCount; ++i) {
            if (this.tblRec.getRow2(i) == null) continue;
            this.tblRec.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        if (this.detailTotalAmt.compareTo(BigDecimal.ZERO) == 0 && this.recTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.recTotalAmt = this.getPageTotalAmt(this.tblRec, this.tblRec.getColumnIndex("actRecAmt"));
            this.detailTotalAmt = this.getPageTotalAmt(this.tblDetail, this.tblDetail.getColumnIndex("creditAmount"));
        }
        this.detailAmt = this.detailTotalAmt;
        this.recAmt = this.recTotalAmt;
        this.calDetailAmt(false, null, false);
        this.calRecAmt(false, null, false);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int bankRowCount = this.tblDetail.getRowCount3();
        int journalRowCount = this.tblRec.getRowCount3();
        if (bankRowCount <= 0 && journalRowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        for (i = 0; i < bankRowCount; ++i) {
            if (this.tblDetail.getRow2(i) == null) continue;
            this.tblDetail.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        for (i = 0; i < journalRowCount; ++i) {
            if (this.tblRec.getRow2(i) == null) continue;
            this.tblRec.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        this.detailAmt = BigDecimal.ZERO;
        this.recAmt = BigDecimal.ZERO;
        this.calDetailAmt(false, null, false);
        this.calRecAmt(false, null, false);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    private void refresh() throws BOSException {
        this.refreshDetailTable();
        this.refreshRecTable();
        this.initAmt();
    }

    private void updateMapAll() {
        this.mapAll.clear();
        this.acctBankIdSet.clear();
        Set<String> companyIdSet = this.filterParam.getCompanyIdSet();
        for (String companyId : companyIdSet) {
            HashMap mapIdList = new HashMap();
            mapIdList.put("com.kingdee.eas.fi.cas.app.ReceivingBill", new ArrayList());
            mapIdList.put("com.kingdee.eas.fm.be.app.TransDetail", new ArrayList());
            this.mapAll.put(companyId, mapIdList);
        }
        int recRowCount = this.tblRec.getRowCount3();
        for (int r = 0; r < recRowCount; ++r) {
            Object valueAcct;
            ICell cellId = this.tblRec.getCell(r, "id");
            ICell cellCom = this.tblRec.getCell(r, "company.id");
            ICell cellAcct = this.tblRec.getCell(r, "payeeAcctBankId");
            Object valueId = cellId == null ? null : cellId.getValue();
            Object valueCom = cellCom == null ? null : cellCom.getValue();
            Object object = valueAcct = cellAcct == null ? null : cellAcct.getValue();
            if (valueId != null && valueId instanceof String && valueCom != null && valueCom instanceof String) {
                this.mapAll.get(valueCom).get("com.kingdee.eas.fi.cas.app.ReceivingBill").add((String)valueId);
            }
            if (valueAcct == null || !(valueAcct instanceof String)) continue;
            this.acctBankIdSet.add((String)valueAcct);
        }
        int detailRowCount = this.tblDetail.getRowCount3();
        for (int r = 0; r < detailRowCount; ++r) {
            Object valueAcct;
            ICell cellId = this.tblDetail.getCell(r, "id");
            ICell cellCom = this.tblDetail.getCell(r, "company.id");
            ICell cellAcct = this.tblDetail.getCell(r, "bankAcctId");
            Object valueId = cellId == null ? null : cellId.getValue();
            Object valueCom = cellCom == null ? null : cellCom.getValue();
            Object object = valueAcct = cellAcct == null ? null : cellAcct.getValue();
            if (valueId != null && valueId instanceof String && valueCom != null && valueCom instanceof String) {
                this.mapAll.get(valueCom).get("com.kingdee.eas.fm.be.app.TransDetail").add((String)valueId);
            }
            if (valueAcct == null || !(valueAcct instanceof String)) continue;
            this.acctBankIdSet.add((String)valueAcct);
        }
    }

    private void updateIdListMapAndCompanySet() {
        this.idListMap.clear();
        this.selCompanyIdSet.clear();
        this.acctBankIdSet.clear();
        int recRowCount = this.tblRec.getRowCount3();
        for (int r = 0; r < recRowCount; ++r) {
            Object valueCur;
            if (!((Boolean)this.tblRec.getCell(r, SELECT).getValue()).booleanValue()) continue;
            ICell cellId = this.tblRec.getCell(r, "id");
            ICell cellCom = this.tblRec.getCell(r, "company.id");
            ICell cellAcct = this.tblRec.getCell(r, "payeeAcctBankId");
            ICell cellCur = this.tblRec.getCell(r, "currency.id");
            Object valueId = cellId == null ? null : cellId.getValue();
            Object valueCom = cellCom == null ? null : cellCom.getValue();
            Object valueAcct = cellAcct == null ? null : cellAcct.getValue();
            Object object = valueCur = cellCur == null ? null : cellCur.getValue();
            if (valueId == null || !(valueId instanceof String) || valueCom == null || !(valueCom instanceof String) || valueAcct == null || !(valueAcct instanceof String) || valueCur == null || !(valueCur instanceof String)) continue;
            this.selCompanyIdSet.add((String)valueCom);
            this.acctBankIdSet.add((String)valueAcct);
            String key = valueCom + "-" + valueAcct + "-" + valueCur;
            if (!this.idListMap.containsKey(key)) {
                HashMap map = new HashMap();
                map.put("com.kingdee.eas.fm.be.app.TransDetail", new ArrayList());
                map.put("com.kingdee.eas.fi.cas.app.ReceivingBill", new ArrayList());
                this.idListMap.put(key, map);
            }
            this.idListMap.get(key).get("com.kingdee.eas.fi.cas.app.ReceivingBill").add((String)valueId);
        }
        int detailRowCount = this.tblDetail.getRowCount3();
        for (int r = 0; r < detailRowCount; ++r) {
            Object valueCur;
            if (!((Boolean)this.tblDetail.getCell(r, SELECT).getValue()).booleanValue()) continue;
            ICell cellId = this.tblDetail.getCell(r, "id");
            ICell cellCom = this.tblDetail.getCell(r, "company.id");
            ICell cellAcct = this.tblDetail.getCell(r, "bankAcctId");
            ICell cellCur = this.tblDetail.getCell(r, "currency.id");
            Object valueId = cellId == null ? null : cellId.getValue();
            Object valueCom = cellCom == null ? null : cellCom.getValue();
            Object valueAcct = cellAcct == null ? null : cellAcct.getValue();
            Object object = valueCur = cellCur == null ? null : cellCur.getValue();
            if (valueId == null || !(valueId instanceof String) || valueCom == null || !(valueCom instanceof String) || valueAcct == null || !(valueAcct instanceof String) || valueCur == null || !(valueCur instanceof String)) continue;
            this.selCompanyIdSet.add((String)valueCom);
            this.acctBankIdSet.add((String)valueAcct);
            String key = valueCom + "-" + valueAcct + "-" + valueCur;
            if (!this.idListMap.containsKey(key)) {
                HashMap map = new HashMap();
                map.put("com.kingdee.eas.fm.be.app.TransDetail", new ArrayList());
                map.put("com.kingdee.eas.fi.cas.app.ReceivingBill", new ArrayList());
                this.idListMap.put(key, map);
            }
            this.idListMap.get(key).get("com.kingdee.eas.fm.be.app.TransDetail").add((String)valueId);
        }
    }

    private void refreshRecTable() throws BOSException {
        this.tblRec.repaint();
        this.tblRec.removeRows();
    }

    private void refreshDetailTable() throws BOSException {
        this.tblDetail.repaint();
        this.tblDetail.removeRows();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getQueryDialog().show()) {
            SysUtil.abort();
        }
        this.handlerRecDetailEntityView(false);
        this.refresh();
        this.initUI();
    }

    private void initAmt() {
        this.detailAmt = BigDecimal.ZERO;
        this.recAmt = BigDecimal.ZERO;
        this.detailTotalAmt = BigDecimal.ZERO;
        this.recTotalAmt = BigDecimal.ZERO;
        this.calDetailAmt(false, null, false);
        this.calRecAmt(false, null, false);
    }

    private BigDecimal getPageTotalAmt(KDTable table, int colIndex) {
        BigDecimal result = new BigDecimal(0.0);
        int rowCount = table.getRowCount3();
        for (int r = 0; r < rowCount; ++r) {
            Object value;
            ICell cell = table.getCell(r, colIndex);
            Object object = value = cell == null ? null : cell.getValue();
            if (value == null || !(value instanceof Number)) continue;
            result = value instanceof BigDecimal ? result.add((BigDecimal)value) : result.add(new BigDecimal(((Number)value).doubleValue()));
        }
        return result;
    }

    private void calDetailAmt(boolean noCal, IRow row, boolean select) {
        if (noCal && row != null) {
            this.detailAmt = select ? FMHelper.add((BigDecimal)this.detailAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue())) : FMHelper.subtract((BigDecimal)this.detailAmt, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"6_DetailTitle"), ClientUtils.formatDecimal((BigDecimal)this.detailAmt.setScale(this.scale, 4)));
        this.contDetail.setTitle(msgStr);
    }

    private void calRecAmt(boolean noCal, IRow row, boolean select) {
        if (noCal && row != null) {
            this.recAmt = select ? FMHelper.add((BigDecimal)this.recAmt, (BigDecimal)((BigDecimal)row.getCell("actRecAmt").getValue())) : FMHelper.subtract((BigDecimal)this.recAmt, (BigDecimal)((BigDecimal)row.getCell("actRecAmt").getValue()));
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"7_RecTitle"), ClientUtils.formatDecimal((BigDecimal)this.recAmt.setScale(this.scale, 4)));
        this.contRec.setTitle(msgStr);
    }

    @Override
    public void actionSet_actionPerformed(ActionEvent e) throws Exception {
        String permItemName = "rpm_recDetail_02set";
        String curUserId = ContextHelperFactory.getRemoteInstance().getCurrentUser().getId().toString();
        Set authorizedOrgIds = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(curUserId), OrgType.Company, null, permItemName);
        String companyId = null;
        if (this.filterParam.getCompanyIdSet().size() == 1) {
            Set<String> set = this.filterParam.getCompanyIdSet();
            for (String id : set) {
                if (!authorizedOrgIds.contains(id)) continue;
                companyId = id;
            }
        } else if (this.filterParam.getCompanyIdSet().size() > 1) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                Set<String> set = this.filterParam.getCompanyIdSet();
                for (String id : set) {
                    if (!authorizedOrgIds.contains(id)) continue;
                    companyId = id;
                    break;
                }
            } else if (authorizedOrgIds.contains(company.getId().toString())) {
                companyId = company.getId().toString();
            } else {
                Set<String> set = this.filterParam.getCompanyIdSet();
                for (String id : set) {
                    if (!authorizedOrgIds.contains(id)) continue;
                    companyId = id;
                    break;
                }
            }
        }
        if (companyId == null) {
            throw new RPMException(RPMException.NOSETAUTH);
        }
    }

    @Override
    public void actionAutoMacth_actionPerformed(ActionEvent e) throws Exception {
        this.updateMapAll();
        Map matchSettingMap = RPDMatchSettingHelper.verifyEnable(new HashSet<String>(this.mapAll.keySet()), new ReceivingBillInfo().getBOSType().toString());
        RPDMatchResultCollection matchResultColl = (RPDMatchResultCollection)RecDetailMatchFacadeFactory.getRemoteInstance().autoMatch(this.mapAll, this.acctBankIdSet, matchSettingMap, true);
        if (matchResultColl.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"No_Match"));
            SysUtil.abort();
        }
        this.displayRPDMatchResult(matchResultColl);
        this.refresh();
    }

    @Override
    public void actionManualMatch_actionPerformed(ActionEvent e) throws Exception {
        this.updateIdListMapAndCompanySet();
        if (this.idListMap.keySet() != null && this.idListMap.keySet().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"SelectCheckoutMsg"));
            SysUtil.abort();
        }
        Map matchSettingMap = RPDMatchSettingHelper.verifyEnable(this.selCompanyIdSet, new ReceivingBillInfo().getBOSType().toString());
        this.verifyM2M();
        RPDMatchResultCollection matchResultColl = (RPDMatchResultCollection)RecDetailMatchFacadeFactory.getRemoteInstance().manualMatch(this.idListMap, this.selCompanyIdSet, this.acctBankIdSet, matchSettingMap);
        if (matchResultColl.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"No_Match"));
            SysUtil.abort();
        }
        this.displayRPDMatchResult(matchResultColl);
        this.refresh();
    }

    private void verifyM2M() throws RPMException {
        if (!EmptyUtil.isEmpty(this.idListMap)) {
            for (String key : this.idListMap.keySet()) {
                Map<String, List<String>> map = this.idListMap.get(key);
                if (EmptyUtil.isEmpty(map) || EmptyUtil.isEmpty((Collection)map.get("com.kingdee.eas.fm.be.app.TransDetail")) || EmptyUtil.isEmpty((Collection)map.get("com.kingdee.eas.fi.cas.app.ReceivingBill")) || map.get("com.kingdee.eas.fm.be.app.TransDetail").size() <= 1 || map.get("com.kingdee.eas.fi.cas.app.ReceivingBill").size() <= 1) continue;
                throw new RPMException(RPMException.MULTOMULMATCH);
            }
        }
    }

    @Override
    public void actionQueryMatchResult_actionPerformed(ActionEvent e) throws Exception {
        this.displayRPDMatchResult(null);
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.updateIdListMapAndCompanySet();
        if (this.idListMap.keySet() != null && this.idListMap.keySet().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"SelectCheckoutMsg"));
            SysUtil.abort();
        }
        Iterator<Map.Entry<String, Map<String, List<String>>>> iterator = this.idListMap.entrySet().iterator();
        ArrayList recBillIdList = new ArrayList();
        ArrayList detailIdList = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, List<String>>> entry = iterator.next();
            if (entry.getValue() == null) continue;
            recBillIdList.addAll(entry.getValue().get("com.kingdee.eas.fi.cas.app.ReceivingBill"));
            detailIdList.addAll(entry.getValue().get("com.kingdee.eas.fm.be.app.TransDetail"));
        }
        if (!EmptyUtil.isEmpty(recBillIdList) && !EmptyUtil.isEmpty(detailIdList)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"47_DetailAndRec_both"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"company", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        String uiName = null;
        if (!EmptyUtil.isEmpty(recBillIdList)) {
            uiName = CasReceivingBillListUI.class.getName();
            uiContext.put((Object)"IDList", (Object)recBillIdList.toArray(new String[0]));
        } else {
            uiName = TransDetailListUI.class.getName();
            uiContext.put((Object)"IDList", (Object)detailIdList.toArray(new String[0]));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null);
        uiWindow.show();
    }

    private void displayRPDMatchResult(RPDMatchResultCollection matchResultColl) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (!EmptyUtil.isEmpty((String)this.filterParam.getCurrencyId())) {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.filterParam.getCurrencyId()));
        }
        HashSet<String> keySet = new HashSet<String>();
        for (int index = 0; matchResultColl != null && index < matchResultColl.size(); ++index) {
            keySet.add(matchResultColl.get(index).getKey());
        }
        RecDetailMatchResultUI.showMatchResultUI((CoreUIObject)this, keySet, currency);
    }
}

